/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug675BeansInDesignTimeAWT
extends UITestCase {
    static boolean waitForKey = false;
    static long durationPerTest = 200L;

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        Beans.setDesignTime(true);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Dimension dimension = new Dimension(400, 200);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setSize(dimension);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2());
        final JFrame jFrame = new JFrame(this.getSimpleTestName(" - "));
        ((Container)jFrame).setLayout(new BorderLayout());
        jFrame.add((Component)gLCanvas, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.pack();
                jFrame.validate();
                jFrame.setVisible(true);
            }
        });
        Assert.assertTrue((String)"GLCanvas didn't become displayable", (boolean)gLCanvas.isDisplayable());
        if (!Beans.isDesignTime()) {
            Assert.assertTrue((String)"GLCanvas didn't become realized", (boolean)gLCanvas.isRealized());
        }
        Thread.sleep(durationPerTest);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.dispose();
            }
        });
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            UITestCase.waitForKey((String)"Start");
        }
        JUnitCore.main((String[])new String[]{TestBug675BeansInDesignTimeAWT.class.getName()});
    }
}

