/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLJPanelReadd01Bug1310AWT
extends UITestCase {
    static final Dimension gljPanelSize = new Dimension(800, 600);
    static GLCapabilitiesImmutable caps = null;
    static long duration = 500L;
    final int[] exp_gl_viewport = new int[]{-1, -1, -1, -1};
    final int[] has_gl_viewport = new int[]{-1, -1, -1, -1};

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLEventListener gLEventListener) {
        final JFrame[] jFrameArray = new JFrame[]{null};
        final JPanel[] jPanelArray = new JPanel[]{null};
        final GLJPanel[] gLJPanelArray = new GLJPanel[]{null};
        final FPSAnimator fPSAnimator = new FPSAnimator(60);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GLJPanel gLJPanel;
                    JPanel jPanel;
                    JFrame jFrame;
                    jFrameArray[0] = jFrame = new JFrame("Testing");
                    jFrame.setDefaultCloseOperation(2);
                    Container container = jFrame.getContentPane();
                    container.setLayout(new BorderLayout());
                    JToolBar jToolBar = new JToolBar();
                    jPanelArray[0] = jPanel = new JPanel();
                    jPanel.setLayout(new GridLayout(1, 1));
                    gLJPanelArray[0] = gLJPanel = new GLJPanel(gLCapabilitiesImmutable);
                    gLJPanel.addGLEventListener(gLEventListener);
                    gLJPanel.setPreferredSize(gljPanelSize);
                    jPanel.add((Component)gLJPanel);
                    fPSAnimator.add((GLAutoDrawable)gLJPanel);
                    jToolBar.add(new AbstractAction("Remove and add"){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            System.err.println("XXX: Remove");
                            jPanel.removeAll();
                            System.err.println("XXX: ReAdd.0: glJPanel-Size: " + gLJPanelArray[0].getSize());
                            jPanel.add((Component)gLJPanel);
                            gLJPanel.invalidate();
                            gLJPanel.repaint();
                            System.err.println("XXX: ReAdd.X: glJPanel-Size: " + gLJPanelArray[0].getSize());
                        }
                    });
                    container.add((Component)jToolBar, "North");
                    container.add((Component)jPanel, "Center");
                    jFrame.pack();
                    jFrame.setLocationRelativeTo(null);
                    jFrame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        fPSAnimator.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    System.err.println("XXX: Remove");
                    jPanelArray[0].removeAll();
                    System.err.println("XXX: ReAdd.0: glJPanel-Size: " + gLJPanelArray[0].getSize());
                    jPanelArray[0].add((Component)gLJPanelArray[0]);
                    gLJPanelArray[0].invalidate();
                    gLJPanelArray[0].repaint();
                    System.err.println("XXX: ReAdd.X: glJPanel-Size: " + gLJPanelArray[0].getSize());
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrameArray[0].dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Test
    public void test00() throws InterruptedException, InvocationTargetException {
        this.test((GLCapabilitiesImmutable)new GLCapabilities(null), new MyRotTriangle());
        System.err.println("Exp GL_Viewport: " + Arrays.toString(this.exp_gl_viewport));
        System.err.println("Has GL_Viewport: " + Arrays.toString(this.has_gl_viewport));
        Assert.assertArrayEquals((int[])this.exp_gl_viewport, (int[])this.has_gl_viewport);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestGLJPanelReadd01Bug1310AWT.class.getName()});
    }

    class MyRotTriangle
    implements GLEventListener {
        private final GLReadBufferUtil screenshot = new GLReadBufferUtil(true, false);
        private int sn = 0;
        private double theta = 0.0;
        private double s = 0.0;
        private double c = 0.0;
        private boolean doScreenshot = false;

        public void display(GLAutoDrawable gLAutoDrawable) {
            this.update();
            this.render(gLAutoDrawable);
            if (this.doScreenshot) {
                TestGLJPanelReadd01Bug1310AWT.this.snapshot(this.sn++, null, gLAutoDrawable.getGL(), this.screenshot, "png", null);
                this.doScreenshot = false;
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            System.err.println("GLEL dispose");
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            System.err.println("GLEL init: Surface " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceWidth() + ", " + gLAutoDrawable.getClass().getSimpleName() + ", swap-ival " + gLAutoDrawable.getGL().getSwapInterval());
            this.theta = 0.0;
            this.s = 0.0;
            this.c = 0.0;
            this.doScreenshot = true;
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            TestGLJPanelReadd01Bug1310AWT.this.exp_gl_viewport[0] = n;
            TestGLJPanelReadd01Bug1310AWT.this.exp_gl_viewport[1] = n2;
            TestGLJPanelReadd01Bug1310AWT.this.exp_gl_viewport[2] = n3;
            TestGLJPanelReadd01Bug1310AWT.this.exp_gl_viewport[3] = n4;
            System.err.println("GLEL reshape: Surface " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceWidth() + ", reshape " + n + "/" + n2 + " " + n3 + "x" + n4);
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glGetIntegerv(2978, TestGLJPanelReadd01Bug1310AWT.this.has_gl_viewport, 0);
        }

        private void update() {
            this.theta += 0.01;
            this.s = Math.sin(this.theta);
            this.c = Math.cos(this.theta);
        }

        private void render(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClear(16384);
            gL2.glBegin(4);
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glVertex2d(-this.c, -this.c);
            gL2.glColor3f(0.0f, 1.0f, 0.0f);
            gL2.glVertex2d(0.0, this.c);
            gL2.glColor3f(0.0f, 0.0f, 1.0f);
            gL2.glVertex2d(this.s, -this.s);
            gL2.glEnd();
        }
    }
}

