/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.junit.util.SingletonJunitCase;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestIdentOfCapabilitiesNEWT
extends SingletonJunitCase {
    public static void main(String[] stringArray) {
        String string = TestIdentOfCapabilitiesNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    @Test
    public void test01DesktopCapsEquals() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)false);
        if (null == gLDrawableFactory) {
            System.err.println("No desktop factory available, bailing out");
            return;
        }
        this.testEquals(gLDrawableFactory);
    }

    @Test
    public void test02EGLCapsEquals() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)true);
        if (null == gLDrawableFactory) {
            System.err.println("No EGL factory available, bailing out");
            return;
        }
        this.testEquals(gLDrawableFactory);
    }

    private static List<GLCapabilitiesImmutable> getEquals(GLCapabilitiesImmutable gLCapabilitiesImmutable, List<GLCapabilitiesImmutable> list) {
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        for (GLCapabilitiesImmutable gLCapabilitiesImmutable2 : list) {
            if (!gLCapabilitiesImmutable2.equals((Object)gLCapabilitiesImmutable)) continue;
            arrayList.add(gLCapabilitiesImmutable2);
        }
        return arrayList;
    }

    private void testEquals(GLDrawableFactory gLDrawableFactory) {
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        Assert.assertNotNull((Object)abstractGraphicsDevice);
        try {
            List list = gLDrawableFactory.getAvailableCapabilities(abstractGraphicsDevice);
            if (null != list) {
                for (int i = 0; i < list.size(); ++i) {
                    GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list.get(i);
                    List<GLCapabilitiesImmutable> list2 = TestIdentOfCapabilitiesNEWT.getEquals(gLCapabilitiesImmutable, list);
                    if (1 != list2.size()) {
                        System.err.println("Error: " + gLCapabilitiesImmutable + " matches more than one in list, not unique:");
                        list2.forEach(System.err::println);
                    }
                    Assert.assertEquals((long)1L, (long)list2.size());
                    System.err.printf("#%3d/%d: %s%n", i + 1, list.size(), gLCapabilitiesImmutable);
                }
            }
        }
        catch (GLException gLException) {
            // empty catch block
        }
    }
}

