/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es1;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.ImmModeSink;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;

public class OlympicES1
implements GLEventListener {
    private boolean debugFFPEmu = false;
    private boolean verboseFFPEmu = false;
    private boolean traceFFPEmu = false;
    private boolean forceFFPEmu = false;
    private boolean debug = false;
    private boolean trace = false;
    private static final double M_2PI = Math.PI * 2;
    private static final int RINGS = 5;
    private static final int BLUERING = 0;
    private static final int BLACKRING = 1;
    private static final int REDRING = 2;
    private static final int YELLOWRING = 3;
    private static final int GREENRING = 4;
    private static final int BLACK = 0;
    private static final int RED = 1;
    private static final int GREEN = 2;
    private static final int YELLOW = 3;
    private static final int BLUE = 4;
    private byte[][] rgb_colors;
    private int[] mapped_colors;
    private float[][] dests;
    private float[][] offsets;
    private float[] angs;
    private float[][] rotAxis;
    private int[] iters;
    private ImmModeSink theTorus;
    private final float[] lmodel_ambient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] lmodel_twoside = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] light0_ambient = new float[]{0.1f, 0.1f, 0.1f, 1.0f};
    private final float[] light0_diffuse = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    private final float[] light0_position = new float[]{0.8660254f, 0.5f, 1.0f, 0.0f};
    private final float[] light0_specular = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    private final float[] bevel_mat_ambient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] bevel_mat_shininess = new float[]{40.0f, 0.0f, 0.0f, 0.0f};
    private final float[] bevel_mat_specular = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    private final float[] bevel_mat_diffuse = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    private final int swapInterval;
    private GLU glu;
    long t0;
    long tL;

    public OlympicES1() {
        this.swapInterval = 1;
    }

    public OlympicES1(int n) {
        this.swapInterval = n;
    }

    public void setForceFFPEmu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.forceFFPEmu = bl;
        this.verboseFFPEmu = bl2;
        this.debugFFPEmu = bl3;
        this.traceFFPEmu = bl4;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        if (this.debugFFPEmu) {
            gL = gL.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", GL2ES2.class, (GL)gL, null));
            this.debug = false;
        }
        if (this.traceFFPEmu) {
            gL = gL.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", GL2ES2.class, (GL)gL, (Object[])new Object[]{System.err}));
            this.trace = false;
        }
        GL2ES1 gL2ES1 = FixedFuncUtil.wrapFixedFuncEmul((GL)gL, (ShaderSelectionMode)ShaderSelectionMode.AUTO, null, (boolean)this.forceFFPEmu, (boolean)this.verboseFFPEmu);
        if (this.debug) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", GL2ES1.class, (GL)gL2ES1, null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.trace) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", GL2ES1.class, (GL)gL2ES1, (Object[])new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.err.println("OlympicES1 init on " + Thread.currentThread());
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL2ES1.getClass().getName());
        System.err.println("GL_VENDOR: " + gL2ES1.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL2ES1.glGetString(7937));
        System.err.println("GL_VERSION: " + gL2ES1.glGetString(7938));
        System.err.println("GL GLSL: " + gL2ES1.hasGLSL() + ", has-compiler-func: " + gL2ES1.isFunctionAvailable("glCompileShader") + ", version " + (gL2ES1.hasGLSL() ? gL2ES1.glGetString(35724) : "none"));
        System.err.println("GL FBO: basic " + gL2ES1.hasBasicFBOSupport() + ", full " + gL2ES1.hasFullFBOSupport());
        System.err.println("GL Profile: " + gL2ES1.getGLProfile());
        System.err.println("GL:" + gL2ES1 + ", " + gL2ES1.getContext().getGLVersion());
        this.glu = GLU.createGLU((GL)gL2ES1);
        System.err.println("GLU:" + this.glu.getClass().getName());
        this.rgb_colors = new byte[5][3];
        this.mapped_colors = new int[5];
        this.dests = new float[5][3];
        this.offsets = new float[5][3];
        this.angs = new float[5];
        this.rotAxis = new float[5][3];
        this.iters = new int[5];
        for (int i = 0; i < 5; ++i) {
            this.rgb_colors[i][2] = 0;
            this.rgb_colors[i][1] = 0;
            this.rgb_colors[i][0] = 0;
        }
        this.rgb_colors[0][2] = -1;
        this.rgb_colors[2][0] = -1;
        this.rgb_colors[4][1] = -1;
        this.rgb_colors[3][0] = -1;
        this.rgb_colors[3][1] = -1;
        this.mapped_colors[0] = 4;
        this.mapped_colors[2] = 1;
        this.mapped_colors[4] = 2;
        this.mapped_colors[3] = 3;
        this.mapped_colors[1] = 0;
        this.dests[0][0] = -2.5f;
        this.dests[0][1] = 1.0f;
        this.dests[0][2] = 0.15f;
        this.dests[1][0] = 0.0f;
        this.dests[1][1] = 1.0f;
        this.dests[1][2] = 0.15f;
        this.dests[2][0] = 2.5f;
        this.dests[2][1] = 1.0f;
        this.dests[2][2] = 0.15f;
        this.dests[3][0] = -1.25f;
        this.dests[3][1] = 0.0f;
        this.dests[3][2] = 0.69f;
        this.dests[4][0] = 1.25f;
        this.dests[4][1] = 0.0f;
        this.dests[4][2] = 0.69f;
        this.theTorus = ImmModeSink.createFixed((int)40, (int)3, (int)5126, (int)0, (int)5126, (int)3, (int)5126, (int)0, (int)5126, (int)35044);
        OlympicES1.FillTorus((GL)gL2ES1, this.theTorus, 0.1f, 8, 1.0f, 25);
        gL2ES1.glEnable(2884);
        gL2ES1.glCullFace(1029);
        gL2ES1.glEnable(2929);
        gL2ES1.glClearDepth(1.0);
        gL2ES1.glLightfv(16384, 4608, this.light0_ambient, 0);
        gL2ES1.glLightfv(16384, 4609, this.light0_diffuse, 0);
        gL2ES1.glLightfv(16384, 4610, this.light0_specular, 0);
        gL2ES1.glLightfv(16384, 4611, this.light0_position, 0);
        gL2ES1.glEnable(16384);
        gL2ES1.glLightModelfv(2898, this.lmodel_twoside, 0);
        gL2ES1.glLightModelfv(2899, this.lmodel_ambient, 0);
        gL2ES1.glEnable(2896);
        gL2ES1.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
        gL2ES1.glMaterialfv(1028, 4608, this.bevel_mat_ambient, 0);
        gL2ES1.glMaterialfv(1028, 5633, this.bevel_mat_shininess, 0);
        gL2ES1.glMaterialfv(1028, 4610, this.bevel_mat_specular, 0);
        gL2ES1.glMaterialfv(1028, 4609, this.bevel_mat_diffuse, 0);
        gL2ES1.glEnable(2903);
        gL2ES1.glShadeModel(7425);
        this.ReInit();
        this.tL = this.t0 = System.currentTimeMillis();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.glu = null;
        this.theTorus.destroy(gLAutoDrawable.getGL());
        this.theTorus = null;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.setSwapInterval(this.swapInterval);
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        this.glu.gluPerspective(45.0f, (float)n3 / (float)n4, 0.1f, 100.0f);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        this.glu.gluLookAt(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glClear(16640);
        gL2ES1.glPushMatrix();
        for (int i = 0; i < 5; ++i) {
            gL2ES1.glColor4ub(this.rgb_colors[i][0], this.rgb_colors[i][1], this.rgb_colors[i][2], (byte)1);
            gL2ES1.glPushMatrix();
            gL2ES1.glTranslatef(this.dests[i][0] + this.offsets[i][0], this.dests[i][1] + this.offsets[i][1], this.dests[i][2] + this.offsets[i][2]);
            gL2ES1.glRotatef(this.angs[i], this.rotAxis[i][0], this.rotAxis[i][1], this.rotAxis[i][2]);
            this.theTorus.draw((GL)gL2ES1, true);
            gL2ES1.glPopMatrix();
        }
        gL2ES1.glPopMatrix();
        this.animationCalc();
    }

    protected void animationCalc() {
        long l = System.currentTimeMillis();
        if (l - this.tL < 50L) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.iters[i] == 0) continue;
            for (int j = 0; j < 3; ++j) {
                this.offsets[i][j] = this.Clamp(this.iters[i], this.offsets[i][j]);
            }
            this.angs[i] = this.Clamp(this.iters[i], this.angs[i]);
            int n = i;
            this.iters[n] = this.iters[n] - 1;
        }
        if (this.iters[0] == 0) {
            this.ReInit();
        }
        this.tL = l;
    }

    protected void ReInit() {
        float f = this.MyRand() / 2.0f;
        f *= f;
        for (int i = 0; i < 5; ++i) {
            this.offsets[i][0] = this.MyRand();
            this.offsets[i][1] = this.MyRand();
            this.offsets[i][2] = this.MyRand();
            this.angs[i] = (float)(260.0 * (double)this.MyRand());
            this.rotAxis[i][0] = this.MyRand();
            this.rotAxis[i][1] = this.MyRand();
            this.rotAxis[i][2] = this.MyRand();
            this.iters[i] = (int)((double)(f * this.MyRand()) + 60.0);
        }
    }

    protected static void FillTorus(GL gL, ImmModeSink immModeSink, float f, int n, float f2, int n2) {
        for (int i = 0; i < n; ++i) {
            immModeSink.glBegin(8);
            for (int j = 0; j <= n2; ++j) {
                for (int k = 1; k >= 0; --k) {
                    double d = (double)((i + k) % n) + 0.5;
                    double d2 = j % n2;
                    float f3 = (float)Math.cos(d2 * (Math.PI * 2) / (double)n2) * (float)Math.cos(d * (Math.PI * 2) / (double)n);
                    float f4 = (float)Math.sin(d2 * (Math.PI * 2) / (double)n2) * (float)Math.cos(d * (Math.PI * 2) / (double)n);
                    float f5 = (float)Math.sin(d * (Math.PI * 2) / (double)n);
                    immModeSink.glNormal3f(f3, f4, f5);
                    f3 = (f2 + f * (float)Math.cos(d * (Math.PI * 2) / (double)n)) * (float)Math.cos(d2 * (Math.PI * 2) / (double)n2);
                    f4 = (f2 + f * (float)Math.cos(d * (Math.PI * 2) / (double)n)) * (float)Math.sin(d2 * (Math.PI * 2) / (double)n2);
                    f5 = f * (float)Math.sin(d * (Math.PI * 2) / (double)n);
                    immModeSink.glVertex3f(f3, f4, f5);
                }
            }
            immModeSink.glEnd(gL, false);
        }
    }

    protected float Clamp(int n, float f) {
        if (n < 3) {
            return 0.0f;
        }
        return (float)(n - 2) * f / (float)n;
    }

    protected float MyRand() {
        return (float)(10.0 * (Math.random() - 0.5));
    }
}

