/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2;

import com.jogamp.math.util.SyncBuffer;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.TileRendererBase;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;

public class RedSquareMappedES2
implements GLEventListener,
TileRendererBase.TileRendererListener {
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private GLArrayDataServer vertices;
    private GLArrayDataServer colors;
    private long t0;
    private int swapInterval = 0;
    private float aspect = 1.0f;
    private boolean doRotate = true;
    private boolean clearBuffers = true;
    private TileRendererBase tileRendererInUse = null;
    private boolean doRotateBeforePrinting;

    public RedSquareMappedES2(int n) {
        this.swapInterval = n;
    }

    public RedSquareMappedES2() {
        this.swapInterval = 1;
    }

    public void addTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = tileRendererBase;
        this.doRotateBeforePrinting = this.doRotate;
        this.setDoRotation(false);
    }

    public void removeTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = null;
        this.setDoRotation(this.doRotateBeforePrinting);
    }

    public void startTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("RedSquareES2.startTileRendering: " + tileRendererBase);
    }

    public void endTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("RedSquareES2.endTileRendering: " + tileRendererBase);
    }

    public void setAspect(float f) {
        this.aspect = f;
    }

    public void setDoRotation(boolean bl) {
        this.doRotate = bl;
    }

    public void setClearBuffers(boolean bl) {
        this.clearBuffers = bl;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " RedSquareES2.init: tileRendererInUse " + this.tileRendererInUse);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println("RedSquareES2 init on " + Thread.currentThread());
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL2ES2.getClass().getName());
        System.err.println(JoglVersion.getGLStrings((GL)gL2ES2, null, (boolean)false).toString());
        if (!gL2ES2.hasGLSL()) {
            System.err.println("No GLSL available, no rendering.");
            return;
        }
        this.st = new ShaderState();
        this.st.setVerbose(true);
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)"RedSquareShader", (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)"RedSquareShader", (boolean)true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(gL2ES2, shaderCode, System.err);
        shaderProgram.add(gL2ES2, shaderCode2, System.err);
        this.st.attachShaderProgram(gL2ES2, shaderProgram, true);
        this.pmvMatrix = new PMVMatrix();
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        GLArrayDataServer gLArrayDataServer = this.vertices = GLArrayDataServer.createGLSLMapped((String)"mgl_Vertex", (int)3, (int)5126, (boolean)false, (int)4, (int)35044);
        GLBufferStorage gLBufferStorage = gLArrayDataServer.mapStorage((GL)gL2ES2, 35001);
        FloatBuffer floatBuffer = gLBufferStorage.getMappedBuffer().asFloatBuffer();
        floatBuffer.put(-2.0f);
        floatBuffer.put(2.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(2.0f);
        floatBuffer.put(2.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(-2.0f);
        floatBuffer.put(-2.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(2.0f);
        floatBuffer.put(-2.0f);
        floatBuffer.put(0.0f);
        gLArrayDataServer.unmapStorage((GL)gL2ES2);
        this.vertices.seal((GL)gL2ES2, true);
        this.st.ownAttribute((GLArrayData)this.vertices, true);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        gLArrayDataServer = this.colors = GLArrayDataServer.createGLSLMapped((String)"mgl_Color", (int)4, (int)5126, (boolean)false, (int)4, (int)35044);
        gLBufferStorage = gLArrayDataServer.mapStorage((GL)gL2ES2, 35001);
        floatBuffer = gLBufferStorage.getMappedBuffer().asFloatBuffer();
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        gLArrayDataServer.unmapStorage((GL)gL2ES2);
        this.colors.seal((GL)gL2ES2, true);
        this.st.ownAttribute((GLArrayData)this.colors, true);
        this.colors.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        this.t0 = System.currentTimeMillis();
        System.err.println(Thread.currentThread() + " RedSquareES2.init FIN");
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        long l = System.currentTimeMillis();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.clearBuffers) {
            if (null != this.tileRendererInUse) {
                gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
            } else {
                gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            }
            gL2ES2.glClear(16640);
        }
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        if (this.doRotate) {
            float f = (float)(l - this.t0) * 360.0f / 4000.0f;
            this.pmvMatrix.glRotatef(f, 0.0f, 0.0f, 1.0f);
            this.pmvMatrix.glRotatef(f, 0.0f, 1.0f, 0.0f);
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.vertices.enableBuffer((GL)gL2ES2, true);
        this.colors.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        this.colors.enableBuffer((GL)gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.setSwapInterval(this.swapInterval);
        this.reshapeImpl(gL2ES2, n, n2, n3, n4, n3, n4);
    }

    public void reshapeTile(TileRendererBase tileRendererBase, int n, int n2, int n3, int n4, int n5, int n6) {
        GL2ES2 gL2ES2 = tileRendererBase.getAttachedDrawable().getGL().getGL2ES2();
        gL2ES2.setSwapInterval(0);
        this.reshapeImpl(gL2ES2, n, n2, n3, n4, n5, n6);
    }

    void reshapeImpl(GL2ES2 gL2ES2, int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println(Thread.currentThread() + " RedSquareES2.reshape " + n + "/" + n2 + " " + n3 + "x" + n4 + " of " + n5 + "x" + n6 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gL2ES2.getContext().getGLDrawable().getHandle()) + ", tileRendererInUse " + this.tileRendererInUse);
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        float f = (float)n5 / (float)n6 / this.aspect;
        float f2 = (float)Math.tan(0.3926991f) * 1.0f;
        float f3 = -1.0f * f2;
        float f4 = f * f3;
        float f5 = f * f2;
        float f6 = f5 - f4;
        float f7 = f2 - f3;
        float f8 = f4 + (float)n * f6 / (float)n5;
        float f9 = f8 + (float)n3 * f6 / (float)n5;
        float f10 = f3 + (float)n2 * f7 / (float)n6;
        float f11 = f10 + (float)n4 * f7 / (float)n6;
        this.pmvMatrix.glFrustumf(f8, f9, f10, f11, 1.0f, 100.0f);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
        System.err.println(Thread.currentThread() + " RedSquareES2.reshape FIN");
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " RedSquareES2.dispose: tileRendererInUse " + this.tileRendererInUse);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.st.destroy(gL2ES2);
        this.st = null;
        this.pmvMatrix = null;
        System.err.println(Thread.currentThread() + " RedSquareES2.dispose FIN");
    }
}

