/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2;

import com.jogamp.common.os.Platform;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.awt.Component;
import java.nio.FloatBuffer;

public class TextureSequenceCubeES2
implements GLEventListener {
    private TextureSequence texSeq;
    public ShaderState st;
    public PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private float nearPlaneNormalized;
    public float zoom = -2.3f;
    private float view_rotx = 0.0f;
    private float view_roty = 0.0f;
    private final float view_rotz = 0.0f;
    int[] vboNames = new int[4];
    boolean innerCube;
    private final MouseListener mouseAction = new MouseAdapter(){
        int lx = 0;
        int ly = 0;
        boolean first = false;

        public void mousePressed(MouseEvent mouseEvent) {
            this.first = true;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.first = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            int n;
            int n2;
            Object object2 = mouseEvent.getSource();
            Window window = null;
            if (object2 instanceof Window) {
                window = (Window)object2;
                n2 = window.getSurfaceWidth();
                n = window.getSurfaceHeight();
            } else if (object2 instanceof GLAutoDrawable) {
                object = (GLAutoDrawable)object2;
                n2 = object.getSurfaceWidth();
                n = object.getSurfaceHeight();
            } else if (GLProfile.isAWTAvailable() && object2 instanceof Component) {
                object = (Component)object2;
                n2 = ((Component)object).getWidth();
                n = ((Component)object).getHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object2);
            }
            if (mouseEvent.getPointerCount() == 2) {
                if (this.first) {
                    this.lx = Math.abs(mouseEvent.getY(0) - mouseEvent.getY(1));
                    this.first = false;
                    return;
                }
                int n3 = Math.abs(mouseEvent.getY(0) - mouseEvent.getY(1));
                int n4 = n3 - this.lx;
                float f = TextureSequenceCubeES2.this.zoom;
                float f2 = 40.0f * Math.signum(n4) / (float)n;
                TextureSequenceCubeES2.this.zoom += f2;
                System.err.println("zoom.d: " + f + " + " + f2 + " -> " + TextureSequenceCubeES2.this.zoom);
                this.lx = n3;
            } else {
                if (this.first) {
                    this.lx = mouseEvent.getX();
                    this.ly = mouseEvent.getY();
                    this.first = false;
                    return;
                }
                int n5 = mouseEvent.getX();
                int n6 = mouseEvent.getY();
                TextureSequenceCubeES2.this.view_roty += 360.0f * ((float)(n5 - this.lx) / (float)n2);
                TextureSequenceCubeES2.this.view_rotx += 360.0f * ((float)(n6 - this.ly) / (float)n);
                this.lx = n5;
                this.ly = n6;
            }
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                float f = TextureSequenceCubeES2.this.zoom;
                float f2 = mouseEvent.getRotation()[1] / 10.0f;
                TextureSequenceCubeES2.this.zoom += f2;
                System.err.println("zoom.w: " + f + " + " + f2 + " -> " + TextureSequenceCubeES2.this.zoom);
            }
        }
    };
    static final String shaderBasename = "texsequence_xxx";
    static final String myTextureLookupName = "myTexture2D";
    GLArrayDataServer interleavedVBO;
    GLArrayDataServer cubeIndicesVBO;
    static final float[] light_position = new float[]{-50.0f, 50.0f, 50.0f, 0.0f};
    static final float[] light_ambient = new float[]{0.125f, 0.125f, 0.125f, 1.0f};
    static final float[] light_diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] material_spec = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    static final float[] zero_vec4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] s_cubeVertices = new float[]{-1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] s_cubeTexCoords = new float[]{0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] s_cubeColors = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f};
    private static final short[] s_cubeIndices = new short[]{0, 3, 1, 2, 0, 1, 6, 5, 4, 5, 7, 4, 8, 11, 9, 10, 8, 9, 15, 12, 13, 12, 14, 13, 16, 19, 17, 18, 16, 17, 23, 20, 21, 20, 22, 21};

    public TextureSequenceCubeES2(TextureSequence textureSequence, boolean bl, float f, float f2, float f3) {
        this.texSeq = textureSequence;
        this.innerCube = bl;
        this.zoom = f;
        this.view_rotx = f2;
        this.view_roty = f3;
    }

    private void initShader(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        boolean bl = true;
        if (36197 == this.texSeq.getTextureTarget()) {
            if (!gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
                throw new GLException("GL_OES_EGL_image_external requested but not available");
            }
            if (Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
                bl = false;
            }
        }
        shaderCode.defaultShaderCustomization(gL2ES2, bl, true);
        int n = bl ? shaderCode2.addGLSLVersion(gL2ES2) : 0;
        n = shaderCode2.insertShaderSource(0, n, (CharSequence)this.texSeq.getRequiredExtensionsShaderStub());
        shaderCode2.addDefaultShaderPrecision(gL2ES2, n);
        String string = this.texSeq.setTextureLookupFunctionName(myTextureLookupName);
        shaderCode2.replaceInShaderSource(myTextureLookupName, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("uniform ").append(this.texSeq.getTextureSampler2DType()).append(" mgl_ActiveTexture;\n");
        stringBuilder.append(this.texSeq.getTextureLookupFragmentShaderImpl());
        shaderCode2.insertShaderSource(0, "TEXTURE-SEQUENCE-CODE-BEGIN", 0, (CharSequence)stringBuilder);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, false);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null));
        TextureSequence.TextureFrame textureFrame = this.texSeq.getLastTexture();
        if (null == textureFrame) {
            return;
        }
        Texture texture = textureFrame.getTexture();
        this.initShader(gL2ES2);
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix = new PMVMatrix();
        this.reshapePMV(gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_ActiveTexture", this.texSeq.getTextureUnit()))) {
            throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
        }
        float[] fArray = new float[s_cubeTexCoords.length];
        float f = texture.getAspectRatio();
        TextureCoords textureCoords = texture.getImageTexCoords();
        System.err.println("XXX0: aspect: " + f);
        System.err.println("XXX0: y-flip: " + texture.getMustFlipVertically());
        System.err.println("XXX0: " + textureCoords);
        float f2 = Math.max(textureCoords.left(), textureCoords.right());
        float f3 = Math.max(textureCoords.bottom(), textureCoords.top());
        float f4 = f;
        float f5 = (1.0f - f) / 2.0f;
        for (int i = 0; i < s_cubeTexCoords.length; i += 2) {
            float f6 = s_cubeTexCoords[i + 0];
            float f7 = s_cubeTexCoords[i + 1];
            if (f6 != 0.0f) {
                fArray[i + 0] = f2 * 1.0f;
            }
            fArray[i + 1] = f7 == 0.0f && !texture.getMustFlipVertically() || f7 != 0.0f && texture.getMustFlipVertically() ? 0.0f + f5 : f3 * f4 + f5;
        }
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)9, (int)5126, (boolean)false, (int)72, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 24; ++i) {
            floatBuffer.put(s_cubeVertices, i * 3, 3);
            floatBuffer.put(s_cubeColors, i * 4, 4);
            floatBuffer.put(fArray, i * 2, 2);
        }
        this.interleavedVBO.seal((GL)gL2ES2, true);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        this.cubeIndicesVBO = GLArrayDataServer.createData((int)6, (int)5123, (int)6, (int)35044, (int)34963);
        for (int i = 0; i < 36; ++i) {
            this.cubeIndicesVBO.puts(s_cubeIndices[i]);
        }
        this.cubeIndicesVBO.seal((GL)gL2ES2, true);
        this.cubeIndicesVBO.enableBuffer((GL)gL2ES2, false);
        this.st.ownAttribute((GLArrayData)this.cubeIndicesVBO, true);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.mouseAction);
        } else if (GLProfile.isAWTAvailable() && object instanceof Component) {
            Component component = (Component)object;
            new AWTMouseAdapter(this.mouseAction, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
        }
        System.out.println("iVBO: " + this.interleavedVBO);
        System.out.println(this.st);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport(0, 0, n3, n4);
        if (!this.innerCube) {
            // empty if block
        }
        if (null != this.st) {
            this.reshapePMV(n3, n4);
            this.st.useProgram(gL2ES2, true);
            this.st.uniform(gL2ES2, this.pmvMatrixUniform);
            this.st.useProgram(gL2ES2, false);
        }
    }

    private void reshapePMV(int n, int n2) {
        if (null != this.pmvMatrix) {
            this.pmvMatrix.glMatrixMode(5889);
            this.pmvMatrix.glLoadIdentity();
            if (!this.innerCube) {
                this.pmvMatrix.gluPerspective(0.7853982f, (float)n / (float)n2, 1.0f, 10.0f);
                this.nearPlaneNormalized = 0.01010101f;
            } else {
                this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 10.0f);
                this.nearPlaneNormalized = 0.0f;
            }
            System.err.println("XXX0: Perspective nearPlaneNormalized: " + this.nearPlaneNormalized);
            this.pmvMatrix.glMatrixMode(5888);
            this.pmvMatrix.glLoadIdentity();
            this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.texSeq = null;
        this.pmvMatrixUniform = null;
        this.pmvMatrix = null;
        if (null != this.st) {
            this.st.destroy(gL2ES2);
            this.st = null;
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        TextureSequence.TextureFrame textureFrame;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.innerCube) {
            gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 0.4f);
        } else {
            gL2ES2.glClearColor(0.0f, 0.0f, 1.0f, 1.0f);
        }
        gL2ES2.glClear(16640);
        if (null == this.st) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
        this.pmvMatrix.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        this.pmvMatrix.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        this.pmvMatrix.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        Texture texture = null;
        if (null != this.texSeq && null != (textureFrame = this.texSeq.getNextTexture((GL)gL2ES2))) {
            texture = textureFrame.getTexture();
            gL2ES2.glActiveTexture(33984 + this.texSeq.getTextureUnit());
            texture.enable((GL)gL2ES2);
            texture.bind((GL)gL2ES2);
        }
        this.cubeIndicesVBO.bindBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawElements(4, this.cubeIndicesVBO.getElemCount() * this.cubeIndicesVBO.getCompsPerElem(), 5123, 0L);
        this.cubeIndicesVBO.bindBuffer((GL)gL2ES2, false);
        if (null != texture) {
            texture.disable((GL)gL2ES2);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }
}

