/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareMappedES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRedSquareES2NEWT
extends UITestCase {
    static int width;
    static int height;
    static int loops;
    static boolean loop_shutdown;
    static boolean vsync;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean mainRun;
    static boolean doRotate;
    static boolean useMappedBuffers;
    static long duration;

    @BeforeClass
    public static void initClass() {
        width = 512;
        height = 512;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException {
        Object object;
        Object object2;
        System.err.println("requested: vsync " + vsync + ", " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.setSize(width, height);
        if (useMappedBuffers) {
            object2 = new RedSquareMappedES2(vsync ? 1 : -1);
            ((RedSquareMappedES2)object2).setDoRotation(doRotate);
            object = object2;
        } else {
            object2 = new RedSquareES2(vsync ? 1 : -1);
            ((RedSquareES2)object2).setDoRotation(doRotate);
            object = object2;
        }
        gLWindow.addGLEventListener((GLEventListener)object);
        object2 = new UITestCase.SnapshotGLEventListener(this);
        ((UITestCase.SnapshotGLEventListener)object2).setPostSNDetail(object.getClass().getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)object2);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    gLWindow.invokeOnNewThread(null, false, new Runnable(){

                        @Override
                        public void run() {
                            gLWindow.setFullscreen(!gLWindow.isFullscreen());
                        }
                    });
                } else if (keyEvent.getKeyChar() == 'd') {
                    gLWindow.invokeOnNewThread(null, false, new Runnable(){

                        @Override
                        public void run() {
                            gLWindow.setUndecorated(!gLWindow.isUndecorated());
                        }
                    });
                }
            }
        });
        animator.start();
        gLWindow.setVisible(true);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        animator.setUpdateFPSFrames(60, System.err);
        ((UITestCase.SnapshotGLEventListener)object2).setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        gLWindow.destroy();
        if (NativeWindowFactory.isAWTAvailable()) {
            Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
        }
    }

    @Test
    public void test01GL2ES2() throws InterruptedException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02GL3() throws InterruptedException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-norotate")) {
                doRotate = false;
                continue;
            }
            if (stringArray[i].equals("-mappedBuffers")) {
                useMappedBuffers = true;
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (!stringArray[i].equals("-loop-shutdown")) continue;
            loop_shutdown = true;
        }
        System.err.println("duration " + duration);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("mappedBuffers " + useMappedBuffers);
        JUnitCore.main((String[])new String[]{TestRedSquareES2NEWT.class.getName()});
    }

    static {
        loops = 1;
        loop_shutdown = false;
        vsync = false;
        forceES2 = false;
        forceGL3 = false;
        mainRun = false;
        doRotate = true;
        useMappedBuffers = false;
        duration = 500L;
    }
}

