/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.swt;

import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.swt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.SWTTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2SWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean fullscreen;
    static int swapInterval;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean mainRun;
    static boolean exclusiveContext;
    Display display = null;
    Shell shell = null;
    Composite composite = null;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    @Before
    public void init() {
        SWTAccessor.invokeOnOSTKThread((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestGearsES2SWT.this.display = new Display();
                Assert.assertNotNull((Object)TestGearsES2SWT.this.display);
                SWTAccessor.printInfo((PrintStream)System.err, (Display)TestGearsES2SWT.this.display);
            }
        });
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestGearsES2SWT.this.shell = new Shell(TestGearsES2SWT.this.display);
                Assert.assertNotNull((Object)TestGearsES2SWT.this.shell);
                TestGearsES2SWT.this.shell.setLayout((Layout)new FillLayout());
                TestGearsES2SWT.this.composite = new Composite((Composite)TestGearsES2SWT.this.shell, 0);
                TestGearsES2SWT.this.composite.setLayout((Layout)new FillLayout());
                Assert.assertNotNull((Object)TestGearsES2SWT.this.composite);
            }
        });
    }

    @After
    public void release() {
        Assert.assertNotNull((Object)this.display);
        Assert.assertNotNull((Object)this.shell);
        Assert.assertNotNull((Object)this.composite);
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestGearsES2SWT.this.composite.dispose();
                    TestGearsES2SWT.this.shell.dispose();
                }
            });
            SWTAccessor.invokeOnOSTKThread((boolean)true, (Runnable)new Runnable(){

                @Override
                public void run() {
                    TestGearsES2SWT.this.display.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        this.display = null;
        this.shell = null;
        this.composite = null;
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException, InvocationTargetException {
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        final GLCanvas gLCanvas = GLCanvas.create((Composite)this.composite, (int)0, (GLCapabilitiesImmutable)gLCapabilitiesImmutable, null);
        Assert.assertNotNull((Object)gLCanvas);
        GearsES2 gearsES2 = new GearsES2(swapInterval);
        gLCanvas.addGLEventListener((GLEventListener)gearsES2);
        Animator animator = new Animator(0);
        animator.setExclusiveContext(exclusiveContext);
        animator.add((GLAutoDrawable)gLCanvas);
        animator.start();
        Assert.assertTrue((boolean)animator.isStarted());
        Assert.assertTrue((boolean)animator.isAnimating());
        Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLCanvas.getExclusiveContextThread());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestGearsES2SWT.this.shell.setText(TestGearsES2SWT.this.getSimpleTestName("."));
                TestGearsES2SWT.this.shell.setSize(wsize.getWidth(), wsize.getHeight());
                if (null != wpos) {
                    TestGearsES2SWT.this.shell.setLocation(wpos.getX(), wpos.getY());
                }
                TestGearsES2SWT.this.shell.open();
            }
        });
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        SWTTestUtil.WaitAction waitAction = new SWTTestUtil.WaitAction(this.display, true, 16L);
        System.err.println("TestGearsES2SWT.test: 2.0: Exception " + (null != waitAction.getException(true)));
        Assert.assertEquals((Object)true, (Object)GLTestUtil.waitForRealized((GLAutoDrawable)gLCanvas, true, waitAction));
        System.err.println("TestGearsES2SWT.test: 2.1: Exception " + (null != waitAction.getException(true)));
        while (animator.isAnimating() && !gLCanvas.isRealized() && animator.getTotalFPSDuration() < duration) {
            waitAction.run();
        }
        System.err.println("TestGearsES2SWT.test: 3.0: Exception " + (null != waitAction.getException(true)));
        System.err.println("NW chosen: " + gLCanvas.getDelegatedDrawable().getChosenGLCapabilities());
        System.err.println("GL chosen: " + gLCanvas.getChosenGLCapabilities());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                System.err.println("window pos/siz: " + gLCanvas.getLocation() + " " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight());
            }
        });
        if (null != rwsize) {
            for (int i = 0; i < 50; ++i) {
                waitAction.run();
            }
            System.err.println("TestGearsES2SWT.test: 4.0: Exception " + (null != waitAction.getException(true)));
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestGearsES2SWT.this.shell.setSize(rwsize.getWidth(), rwsize.getHeight());
                }
            });
            System.err.println("window resize pos/siz: " + gLCanvas.getLocation() + " " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight());
        }
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            waitAction.run();
        }
        System.err.println("TestGearsES2SWT.test: 5.0: Exception " + (null != waitAction.getException(true)));
        Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLCanvas.getExclusiveContextThread());
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        Assert.assertEquals(null, (Object)gLCanvas.getExclusiveContextThread());
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                gLCanvas.dispose();
            }
        });
    }

    @Test
    public void test01GL2ES2() throws InterruptedException, InvocationTargetException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02GL3() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (!stringArray[i].equals("-loop-shutdown")) continue;
            loop_shutdown = true;
        }
        wsize = new Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        JUnitCore.main((String[])new String[]{TestGearsES2SWT.class.getName()});
    }

    static {
        rwsize = null;
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        fullscreen = false;
        swapInterval = 1;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        forceES2 = false;
        forceGL3 = false;
        mainRun = false;
        exclusiveContext = false;
    }
}

