/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.TileRendererBase;
import java.awt.Component;

public class Gears
implements GLEventListener,
TileRendererBase.TileRendererListener {
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private final float view_rotz = 0.0f;
    private int gear1 = 0;
    private int gear2 = 0;
    private int gear3 = 0;
    private Gears sharedGears = null;
    private Object syncObjects = null;
    private float angle = 0.0f;
    private boolean doRotate = true;
    private final int swapInterval;
    private final MouseListener gearsMouse = new GearsMouseAdapter();
    private final KeyListener gearsKeys = new GearsKeyAdapter();
    private TileRendererBase tileRendererInUse = null;
    private boolean doRotateBeforePrinting;
    private boolean verbose = true;
    private boolean flipVerticalInGLOrientation = false;
    private volatile boolean isInit = false;
    private int prevMouseX;
    private int prevMouseY;
    boolean enableCullFace = false;

    public Gears(int n) {
        this.swapInterval = n;
    }

    public Gears() {
        this.swapInterval = 1;
    }

    public void addTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = tileRendererBase;
        this.doRotateBeforePrinting = this.doRotate;
        this.setDoRotation(false);
    }

    public void removeTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = null;
        this.setDoRotation(this.doRotateBeforePrinting);
    }

    public void startTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("Gears.startTileRendering: " + tileRendererBase);
    }

    public void endTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("Gears.endTileRendering: " + tileRendererBase);
    }

    public void setDoRotation(boolean bl) {
        this.doRotate = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setFlipVerticalInGLOrientation(boolean bl) {
        this.flipVerticalInGLOrientation = bl;
    }

    public void setSharedGears(Gears gears) {
        this.sharedGears = gears;
    }

    public int getGear1() {
        return this.gear1;
    }

    public int getGear2() {
        return this.gear2;
    }

    public int getGear3() {
        return this.gear3;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.init(gL2)) {
            Object object = gLAutoDrawable.getUpstreamWidget();
            if (object instanceof Window) {
                Window window = (Window)object;
                window.addMouseListener(this.gearsMouse);
                window.addKeyListener(this.gearsKeys);
            } else if (GLProfile.isAWTAvailable() && object instanceof Component) {
                Component component = (Component)object;
                new AWTMouseAdapter(this.gearsMouse, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
                new AWTKeyAdapter(this.gearsKeys, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
            }
        } else {
            gLAutoDrawable.setGLEventListenerInitState((GLEventListener)this, false);
        }
    }

    private void enableStates(GL gL, boolean bl) {
        boolean bl2 = gL.getContext().getGLDrawable().getChosenGLCapabilities().getSampleBuffers();
        if (bl) {
            if (this.enableCullFace) {
                gL.glEnable(2884);
            }
            gL.glEnable(2896);
            gL.glEnable(16384);
            gL.glEnable(2929);
            gL.glDepthFunc(513);
            gL.glEnable(2977);
            if (bl2) {
                gL.glEnable(32925);
            }
        } else {
            if (this.enableCullFace) {
                gL.glDisable(2884);
            }
            gL.glDisable(2896);
            gL.glDisable(16384);
            gL.glDisable(2929);
            gL.glDisable(2977);
            if (bl2) {
                gL.glDisable(32925);
            }
        }
    }

    public boolean init(GL2 gL2) {
        if (null != this.sharedGears && !this.sharedGears.isInit()) {
            if (this.verbose) {
                System.err.println(Thread.currentThread() + " GearsES1.init.0: pending shared Gears .. re-init later XXXXX");
            }
            return false;
        }
        float[] fArray = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
        float[] fArray2 = new float[]{0.8f, 0.1f, 0.0f, 0.7f};
        float[] fArray3 = new float[]{0.0f, 0.8f, 0.2f, 0.7f};
        float[] fArray4 = new float[]{0.2f, 0.2f, 1.0f, 0.7f};
        System.err.println(Thread.currentThread() + " Gears.init: tileRendererInUse " + this.tileRendererInUse);
        if (this.verbose) {
            System.err.println("GearsES2 init on " + Thread.currentThread());
            System.err.println("Chosen GLCapabilities: " + gL2.getContext().getGLDrawable().getChosenGLCapabilities());
            System.err.println("INIT GL IS: " + gL2.getClass().getName());
            System.err.println(JoglVersion.getGLStrings((GL)gL2, null, (boolean)false).toString());
        }
        gL2.glLightfv(16384, 4611, fArray, 0);
        this.enableCullFace = !this.flipVerticalInGLOrientation || !gL2.getContext().getGLDrawable().isGLOriented();
        this.enableStates((GL)gL2, true);
        if (null != this.sharedGears) {
            this.gear1 = this.sharedGears.getGear1();
            this.gear2 = this.sharedGears.getGear2();
            this.gear3 = this.sharedGears.getGear3();
            if (this.verbose) {
                System.err.println("gear1 list reused: " + this.gear1);
                System.err.println("gear2 list reused: " + this.gear2);
                System.err.println("gear3 list reused: " + this.gear3);
            }
            if (gL2.getContext().hasRendererQuirk(20)) {
                this.syncObjects = this.sharedGears;
                if (this.verbose) {
                    System.err.println("Shared Gears: Synchronized Objects due to quirk " + GLRendererQuirks.toString((int)20));
                }
            } else {
                this.syncObjects = new Object();
                if (this.verbose) {
                    System.err.println("Shared Gears: Unsynchronized Objects");
                }
            }
        } else {
            this.gear1 = gL2.glGenLists(1);
            gL2.glNewList(this.gear1, 4864);
            gL2.glMaterialfv(1028, 5634, fArray2, 0);
            Gears.gear(gL2, 1.0f, 4.0f, 1.0f, 20, 0.7f);
            gL2.glEndList();
            if (this.verbose) {
                System.err.println("gear1 list created: " + this.gear1);
            }
            this.gear2 = gL2.glGenLists(1);
            gL2.glNewList(this.gear2, 4864);
            gL2.glMaterialfv(1028, 5634, fArray3, 0);
            Gears.gear(gL2, 0.5f, 2.0f, 2.0f, 10, 0.7f);
            gL2.glEndList();
            if (this.verbose) {
                System.err.println("gear2 list created: " + this.gear2);
            }
            this.gear3 = gL2.glGenLists(1);
            gL2.glNewList(this.gear3, 4864);
            gL2.glMaterialfv(1028, 5634, fArray4, 0);
            Gears.gear(gL2, 1.3f, 2.0f, 0.5f, 10, 0.7f);
            gL2.glEndList();
            if (this.verbose) {
                System.err.println("gear3 list created: " + this.gear3);
            }
            this.syncObjects = new Object();
        }
        this.enableStates((GL)gL2, false);
        this.isInit = true;
        return true;
    }

    public final boolean isInit() {
        return this.isInit;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (!this.isInit) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.setSwapInterval(this.swapInterval);
        this.reshape(gL2, n, n2, n3, n4, n3, n4);
    }

    public void reshapeTile(TileRendererBase tileRendererBase, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isInit) {
            return;
        }
        GL2 gL2 = tileRendererBase.getAttachedDrawable().getGL().getGL2();
        gL2.setSwapInterval(0);
        this.reshape(gL2, n, n2, n3, n4, n5, n6);
    }

    public void reshape(GL2 gL2, int n, int n2, int n3, int n4, int n5, int n6) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " Gears.reshape " + n + "/" + n2 + " " + n3 + "x" + n4 + " of " + n5 + "x" + n6 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gL2.getContext().getGLDrawable().getHandle()) + ", tileRendererInUse " + this.tileRendererInUse);
        }
        if (n6 > n5) {
            f5 = (float)n6 / (float)n5;
            f4 = -1.0f;
            f3 = 1.0f;
            f2 = -f5;
            f = f5;
        } else {
            f5 = (float)n5 / (float)n6;
            f4 = -f5;
            f3 = f5;
            f2 = -1.0f;
            f = 1.0f;
        }
        f5 = f3 - f4;
        float f6 = f - f2;
        float f7 = f4 + (float)n * f5 / (float)n5;
        float f8 = f7 + (float)n3 * f5 / (float)n5;
        float f9 = f2 + (float)n2 * f6 / (float)n6;
        float f10 = f9 + (float)n4 * f6 / (float)n6;
        float f11 = f8 - f7;
        float f12 = f10 - f9;
        if (this.verbose) {
            System.err.println(">> Gears angle " + this.angle + ", [l " + f4 + ", r " + f3 + ", b " + f2 + ", t " + f + "] " + f5 + "x" + f6 + " -> [l " + f7 + ", r " + f8 + ", b " + f9 + ", t " + f10 + "] " + f11 + "x" + f12 + ", v-flip " + this.flipVerticalInGLOrientation);
        }
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        if (this.flipVerticalInGLOrientation && gL2.getContext().getGLDrawable().isGLOriented()) {
            gL2.glScalef(1.0f, -1.0f, 1.0f);
        }
        gL2.glFrustum((double)f7, (double)f8, (double)f9, (double)f10, 5.0, 60.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(0.0f, 0.0f, -40.0f);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (!this.isInit) {
            return;
        }
        this.isInit = false;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " Gears.dispose: tileRendererInUse " + this.tileRendererInUse);
        }
        try {
            Object object = gLAutoDrawable.getUpstreamWidget();
            if (object instanceof Window) {
                Window window = (Window)object;
                window.removeMouseListener(this.gearsMouse);
                window.removeKeyListener(this.gearsKeys);
            }
        }
        catch (Exception exception) {
            System.err.println("Caught: ");
            exception.printStackTrace();
        }
        this.gear1 = 0;
        this.gear2 = 0;
        this.gear3 = 0;
        this.sharedGears = null;
        this.syncObjects = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.isInit) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.enableStates((GL)gL2, true);
        if (null == this.tileRendererInUse) {
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            gL2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof GLJPanel && !((GLJPanel)gLAutoDrawable).isOpaque() && ((GLJPanel)gLAutoDrawable).shouldPreserveColorBufferIfTranslucent()) {
            gL2.glClear(256);
        } else {
            gL2.glClear(16640);
        }
        this.displayImpl(gL2);
        this.enableStates((GL)gL2, false);
    }

    public void display(GL2 gL2) {
        if (!this.isInit) {
            return;
        }
        this.enableStates((GL)gL2, true);
        if (null == this.tileRendererInUse) {
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            gL2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        }
        gL2.glClear(16640);
        this.displayImpl(gL2);
        this.enableStates((GL)gL2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayImpl(GL2 gL2) {
        if (this.doRotate) {
            this.angle += 0.5f;
        }
        gL2.glPushMatrix();
        gL2.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        Object object = this.syncObjects;
        synchronized (object) {
            gL2.glPushMatrix();
            gL2.glTranslatef(-3.0f, -2.0f, 0.0f);
            gL2.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
            gL2.glCallList(this.gear1);
            gL2.glPopMatrix();
            gL2.glPushMatrix();
            gL2.glTranslatef(3.1f, -2.0f, 0.0f);
            gL2.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
            gL2.glCallList(this.gear2);
            gL2.glPopMatrix();
            gL2.glPushMatrix();
            gL2.glTranslatef(-3.1f, 4.2f, 0.0f);
            gL2.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
            gL2.glCallList(this.gear3);
            gL2.glPopMatrix();
        }
        gL2.glPopMatrix();
    }

    public static void gear(GL2 gL2, float f, float f2, float f3, int n, float f4) {
        float f5;
        int n2;
        float f6 = f;
        float f7 = f2 - f4 / 2.0f;
        float f8 = f2 + f4 / 2.0f;
        float f9 = (float)Math.PI * 2 / (float)n / 4.0f;
        gL2.glShadeModel(7424);
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            if (n2 >= n) continue;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            float f10 = f8 * (float)Math.cos(f5 + f9) - f7 * (float)Math.cos(f5);
            float f11 = f8 * (float)Math.sin(f5 + f9) - f7 * (float)Math.sin(f5);
            float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            gL2.glNormal3f(f11 /= f12, -(f10 /= f12), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            f10 = f7 * (float)Math.cos(f5 + 3.0f * f9) - f8 * (float)Math.cos(f5 + 2.0f * f9);
            f11 = f7 * (float)Math.sin(f5 + 3.0f * f9) - f8 * (float)Math.sin(f5 + 2.0f * f9);
            gL2.glNormal3f(f11, -f10, 0.0f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
        }
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), f3 * 0.5f);
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), -f3 * 0.5f);
        gL2.glEnd();
        gL2.glShadeModel(7425);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glNormal3f(-((float)Math.cos(f5)), -((float)Math.sin(f5)), 0.0f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
        }
        gL2.glEnd();
    }

    class GearsMouseAdapter
    extends MouseAdapter {
        GearsMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Gears.this.prevMouseX = mouseEvent.getX();
            Gears.this.prevMouseY = mouseEvent.getY();
            if ((mouseEvent.getModifiers() & 0x80) != 0) {
                // empty if block
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x80) != 0) {
                // empty if block
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            Object object2 = mouseEvent.getSource();
            if (object2 instanceof Window) {
                object = (Window)object2;
                n3 = object.getSurfaceWidth();
                n4 = object.getSurfaceHeight();
            } else if (object2 instanceof GLAutoDrawable) {
                object = (GLAutoDrawable)object2;
                n3 = object.getSurfaceWidth();
                n4 = object.getSurfaceHeight();
            } else if (GLProfile.isAWTAvailable() && object2 instanceof Component) {
                object = (Component)object2;
                n3 = ((Component)object).getWidth();
                n4 = ((Component)object).getHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object2);
            }
            float f = 360.0f * ((float)(n - Gears.this.prevMouseX) / (float)n3);
            float f2 = 360.0f * ((float)(Gears.this.prevMouseY - n2) / (float)n4);
            Gears.this.prevMouseX = n;
            Gears.this.prevMouseY = n2;
            Gears.this.view_rotx += f2;
            Gears.this.view_roty += f;
        }
    }

    class GearsKeyAdapter
    extends KeyAdapter {
        GearsKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (149 == s) {
                Gears.this.view_roty -= 1.0f;
            } else if (151 == s) {
                Gears.this.view_roty += 1.0f;
            } else if (150 == s) {
                Gears.this.view_rotx -= 1.0f;
            } else if (152 == s) {
                Gears.this.view_rotx += 1.0f;
            }
        }
    }
}

