/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2.newt;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.opengl.util.NEWTDemoListener;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsNEWT
extends UITestCase {
    static GLProfile glp;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static float[] reqSurfacePixelScale;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            if (null == wsize) {
                wsize = new Dimension(640, 480);
            }
        } else {
            TestGearsNEWT.setTestSupported((boolean)false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test");
        gLWindow.addGLEventListener((GLEventListener)new Gears());
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        NEWTDemoListener nEWTDemoListener = new NEWTDemoListener(gLWindow);
        gLWindow.addKeyListener((KeyListener)nEWTDemoListener);
        gLWindow.addMouseListener((MouseListener)nEWTDemoListener);
        gLWindow.setSize(wsize.getWidth(), wsize.getHeight());
        if (null != wpos) {
            gLWindow.setPosition(wpos.getX(), wpos.getY());
        }
        gLWindow.setSurfaceScale(reqSurfacePixelScale);
        float[] fArray = gLWindow.getRequestedSurfaceScale(new float[2]);
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        System.err.println("Window Current State   : " + gLWindow.getStateMaskString());
        System.err.println("Window Supported States: " + gLWindow.getSupportedStateMaskString());
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window insets: " + gLWindow.getInsets());
        System.err.println("window bounds (window): " + gLWindow.getBounds());
        System.err.println("window bounds (pixels): " + gLWindow.getSurfaceBounds());
        float[] fArray2 = gLWindow.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " (req) -> " + fArray[0] + "x" + fArray[1] + " (val) -> " + fArray2[0] + "x" + fArray2[1] + " (has)");
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-pixelScale")) continue;
            TestGearsNEWT.reqSurfacePixelScale[0] = f = MiscUtils.atof(stringArray[++i], reqSurfacePixelScale[0]);
            TestGearsNEWT.reqSurfacePixelScale[1] = f;
        }
        wsize = new Dimension(n3, n4);
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        JUnitCore.main((String[])new String[]{TestGearsNEWT.class.getName()});
    }

    static {
        reqSurfacePixelScale = new float[]{0.0f, 0.0f};
        duration = 500L;
    }
}

