/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2.newt;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsNewtAWTWrapper
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static boolean useAnimator;
    static boolean doResizeTest;
    static long duration;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull((Object)glp);
        width = 640;
        height = 480;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException {
        long l;
        Display display = NewtFactory.createDisplay((String)".awt", null, (boolean)false);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create((Window)window);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NewtAWTWrapper Test");
        gLWindow.addGLEventListener((GLEventListener)new GearsES2(1));
        Animator animator = useAnimator ? new Animator((GLAutoDrawable)gLWindow) : null;
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter));
        gLWindow.addWindowListener((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter));
        if (useAnimator) {
            animator.start();
        }
        int n = 3;
        gLWindow.setSize(width / n, height / n);
        gLWindow.setVisible(true);
        if (doResizeTest) {
            gLWindow.display();
            int[] nArray = gLWindow.getNativeSurface().convertToPixelUnits(new int[]{width / n, height / n});
            Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
            Thread.sleep(600L);
            n = 2;
            gLWindow.setSize(width / n, height / n);
            gLWindow.display();
            nArray[0] = width / n;
            nArray[1] = height / n;
            gLWindow.getNativeSurface().convertToPixelUnits(nArray);
            Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
            Thread.sleep(600L);
            n = 1;
            gLWindow.setSize(width / n, height / n);
            gLWindow.display();
            nArray[0] = width / n;
            nArray[1] = height / n;
            gLWindow.getNativeSurface().convertToPixelUnits(nArray);
            Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
            Thread.sleep(600L);
        }
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        if (useAnimator) {
            animator.stop();
        }
        gLWindow.destroy();
    }

    @Test
    public void test01() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (!stringArray[i].equals("-noresize")) continue;
            doResizeTest = false;
        }
        System.err.println("useAnimator " + useAnimator);
        JUnitCore.main((String[])new String[]{TestGearsNewtAWTWrapper.class.getName()});
    }

    static {
        useAnimator = true;
        doResizeTest = true;
        duration = 500L;
    }
}

