/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl4;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL4;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.FloatBuffer;

public class TessellationShader01aGLSL440CoreHardcoded
implements GLEventListener {
    private static final double ANIMATION_RATE = 950.0;
    private ShaderProgram program;
    private final int[] vertexArray = new int[1];
    private FloatBuffer vertexOffset;
    private FloatBuffer backgroundColor;

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        this.program = this.createProgram(gLAutoDrawable);
        if (null == this.program) {
            return;
        }
        double d = (double)System.currentTimeMillis() / 950.0;
        this.vertexOffset = FloatBuffer.allocate(4);
        this.vertexOffset.put(0, (float)(Math.sin(d) * 0.5));
        this.vertexOffset.put(1, (float)(Math.cos(d) * (double)0.6f));
        this.vertexOffset.put(2, 0.0f);
        this.vertexOffset.put(3, 0.0f);
        this.backgroundColor = FloatBuffer.allocate(4);
        this.backgroundColor.put(0, 0.25f);
        this.backgroundColor.put(1, 0.25f);
        this.backgroundColor.put(2, 0.25f);
        this.backgroundColor.put(3, 1.0f);
        gL4.glGenVertexArrays(this.vertexArray.length, this.vertexArray, 0);
        gL4.glBindVertexArray(this.vertexArray[0]);
        gL4.glPatchParameteri(36466, 3);
        gL4.glPolygonMode(1032, 6913);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (null == this.program) {
            return;
        }
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        double d = (double)System.currentTimeMillis() / 950.0;
        gL4.glClearBufferfv(6144, 0, this.backgroundColor);
        gL4.glUseProgram(this.program.program());
        this.vertexOffset.put(0, (float)(Math.sin(d) * 0.5));
        this.vertexOffset.put(1, (float)(Math.cos(d) * (double)0.6f));
        gL4.glVertexAttrib4fv(0, this.vertexOffset);
        gL4.glDrawArrays(14, 0, 3);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (null == this.program) {
            return;
        }
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gL4.glDeleteVertexArrays(this.vertexArray.length, this.vertexArray, 0);
        this.program.destroy((GL2ES2)gL4);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    private ShaderProgram createProgram(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        ShaderCode shaderCode = this.createShader(gL4, 35633, "#version 440 core                                          \n                                                           \nlayout (location = 0) in vec4 offset;                      \n                                                           \nvoid main(void)                                            \n{                                                          \n   const vec4 vertices[3] = vec4[3] (                      \n                           vec4( 0.25,  0.25, 0.5, 1.0),   \n                           vec4(-0.25, -0.25, 0.5, 1.0),   \n                           vec4( 0.25, -0.25, 0.5, 1.0));  \n   gl_Position = vertices[gl_VertexID] + offset;           \n}                                                          \n");
        if (null == shaderCode) {
            return null;
        }
        ShaderCode shaderCode2 = this.createShader(gL4, 36488, "#version 440 core                                          \nlayout (vertices = 3) out;                                 \n                                                           \nvoid main(void)                                            \n{                                                          \n   if (gl_InvocationID == 0)                               \n   {                                                       \n       gl_TessLevelInner[0] = 5.0;                         \n       gl_TessLevelOuter[0] = 5.0;                         \n       gl_TessLevelOuter[1] = 5.0;                         \n       gl_TessLevelOuter[2] = 5.0;                         \n   }                                                       \n   gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;\n}                                                          \n");
        if (null == shaderCode2) {
            shaderCode.destroy((GL2ES2)gL4);
            return null;
        }
        ShaderCode shaderCode3 = this.createShader(gL4, 36487, "#version 440 core                                          \n                                                           \nlayout (triangles, equal_spacing, cw) in;                  \n                                                           \nvoid main(void)                                            \n{                                                          \n   gl_Position = (gl_TessCoord.x * gl_in[0].gl_Position) + \n               (gl_TessCoord.y * gl_in[1].gl_Position)   + \n               (gl_TessCoord.z * gl_in[2].gl_Position);    \n}                                                          \n");
        if (null == shaderCode3) {
            shaderCode.destroy((GL2ES2)gL4);
            shaderCode2.destroy((GL2ES2)gL4);
            return null;
        }
        ShaderCode shaderCode4 = this.createShader(gL4, 35632, "#version 440 core                                          \n                                                           \nout vec4 color;                                            \n                                                           \nvoid main(void)                                            \n{                                                          \n   color = vec4(1.0, 1.0, 1.0, 1.0);                       \n}                                                          \n");
        if (null == shaderCode4) {
            shaderCode.destroy((GL2ES2)gL4);
            shaderCode2.destroy((GL2ES2)gL4);
            shaderCode3.destroy((GL2ES2)gL4);
            return null;
        }
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.init((GL2ES2)gL4);
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        shaderProgram.add(shaderCode3);
        shaderProgram.add(shaderCode4);
        shaderProgram.link((GL2ES2)gL4, System.err);
        if (!shaderProgram.validateProgram((GL2ES2)gL4, System.out)) {
            System.err.println("[error] Program linking failed.");
            shaderProgram.destroy((GL2ES2)gL4);
            return null;
        }
        return shaderProgram;
    }

    private ShaderCode createShader(GL4 gL4, int n, String string) {
        CharSequence[][] charSequenceArray = new String[1][1];
        charSequenceArray[0] = new String[]{string};
        ShaderCode shaderCode = new ShaderCode(n, charSequenceArray.length, charSequenceArray);
        boolean bl = shaderCode.compile((GL2ES2)gL4, System.err);
        if (!bl) {
            System.err.println("[error] Shader compilation failed.");
            shaderCode.destroy((GL2ES2)gL4);
            return null;
        }
        return shaderCode;
    }
}

