/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl4;

import com.jogamp.math.Matrix4f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.opengl.DebugGL4;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL4;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.test.junit.jogl.demos.gl4.IInstancedRenderingView;
import com.jogamp.opengl.util.GLArrayDataClient;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.PrintStream;
import java.nio.FloatBuffer;
import java.util.Random;

public class TriangleInstancedRendererWithShaderState
implements GLEventListener {
    private float aspect;
    private static final String shaderBasename = "triangles";
    private static final boolean useInterleaved = true;
    private ShaderState st;
    private PMVMatrix projectionMatrix;
    private GLUniformData projectionMatrixUniform;
    private GLUniformData transformMatrixUniform;
    private GLArrayDataServer interleavedVBO;
    private GLArrayDataClient verticesVBO;
    private GLArrayDataClient colorsVBO;
    private static final int NO_OF_INSTANCE = 30;
    private final FloatBuffer triangleTransform = FloatBuffer.allocate(480);
    private final Matrix4f[] mat = new Matrix4f[30];
    private final float[] rotationSpeed = new float[30];
    private static final boolean useTraceGL = false;
    private PrintStream stream;
    private final IInstancedRenderingView view;
    private boolean isInitialized = false;
    private static final float[] vertices = new float[]{1.0f, 0.0f, 0.0f, -0.5f, 0.866f, 0.0f, -0.5f, -0.866f, 0.0f};
    private final float[] colors = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f};

    public TriangleInstancedRendererWithShaderState(IInstancedRenderingView iInstancedRenderingView) {
        this.view = iInstancedRenderingView;
        this.initTransform();
    }

    private void initTransform() {
        Random random = new Random();
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < 30; ++i) {
            this.rotationSpeed[i] = 0.3f * random.nextFloat();
            this.mat[i] = new Matrix4f();
            this.mat[i].loadIdentity();
            float f = 1.0f + 4.0f * random.nextFloat();
            this.mat[i].scale(f, matrix4f);
            this.mat[i].translate(20.0f * random.nextFloat() - 10.0f, 10.0f * random.nextFloat() - 5.0f, 0.0f, matrix4f);
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gLAutoDrawable.setGL((GL)new DebugGL4(gL4));
        gL4.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL4.glClearDepth(1.0);
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL4.getClass().getName());
        System.err.println("GL_VENDOR: " + gL4.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL4.glGetString(7937));
        System.err.println("GL_VERSION: " + gL4.glGetString(7938));
        this.initShader(gL4);
        this.projectionMatrix = new PMVMatrix();
        this.projectionMatrixUniform = new GLUniformData("mgl_PMatrix", 4, 4, (SyncBuffer)this.projectionMatrix.getSyncP());
        this.st.ownUniform(this.projectionMatrixUniform);
        if (!this.st.uniform((GL2ES2)gL4, this.projectionMatrixUniform)) {
            throw new GLException("Error setting mgl_PMatrix in shader: " + this.st);
        }
        this.transformMatrixUniform = new GLUniformData("mgl_MVMatrix", 4, 4, this.triangleTransform);
        this.st.ownUniform(this.transformMatrixUniform);
        if (!this.st.uniform((GL2ES2)gL4, this.transformMatrixUniform)) {
            throw new GLException("Error setting mgl_MVMatrix in shader: " + this.st);
        }
        this.initVBO_interleaved(gL4);
        this.isInitialized = true;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.isInitialized) {
            return;
        }
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gL4.glClear(16640);
        this.st.useProgram((GL2ES2)gL4, true);
        this.projectionMatrix.glMatrixMode(5889);
        this.projectionMatrix.glPushMatrix();
        float f = 0.1f;
        if (this.view != null) {
            f = this.view.getScale();
        }
        this.projectionMatrix.glScalef(f, f, f);
        this.st.uniform((GL2ES2)gL4, this.projectionMatrixUniform);
        this.projectionMatrix.glPopMatrix();
        this.generateTriangleTransform();
        this.st.uniform((GL2ES2)gL4, this.transformMatrixUniform);
        this.interleavedVBO.enableBuffer((GL)gL4, true);
        gL4.glDrawArraysInstanced(4, 0, 3, 30);
        this.interleavedVBO.enableBuffer((GL)gL4, false);
        this.st.useProgram((GL2ES2)gL4, false);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gL4.glViewport(0, 0, n3, n4);
        this.aspect = (float)n3 / (float)n4;
        this.projectionMatrix.glMatrixMode(5889);
        this.projectionMatrix.glLoadIdentity();
        this.projectionMatrix.gluPerspective(0.7853982f, this.aspect, 0.001f, 20.0f);
        this.projectionMatrix.gluLookAt(new Vec3f(0.0f, 0.0f, -10.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        this.st.destroy((GL2ES2)gL4);
    }

    private void generateTriangleTransform() {
        this.triangleTransform.clear();
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < 30; ++i) {
            this.mat[i].rotate(this.rotationSpeed[i], 0.0f, 0.0f, 1.0f, matrix4f);
            this.mat[i].get(this.triangleTransform);
        }
        this.triangleTransform.rewind();
    }

    private void initVBO_nonInterleaved(GL4 gL4) {
        this.verticesVBO = GLArrayDataClient.createGLSL((String)"mgl_Vertex", (int)3, (int)5126, (boolean)false, (int)3);
        FloatBuffer floatBuffer = (FloatBuffer)this.verticesVBO.getBuffer();
        floatBuffer.put(vertices);
        this.verticesVBO.seal((GL)gL4, true);
        this.colorsVBO = GLArrayDataClient.createGLSL((String)"mgl_Color", (int)4, (int)5126, (boolean)false, (int)3);
        FloatBuffer floatBuffer2 = (FloatBuffer)this.colorsVBO.getBuffer();
        floatBuffer2.put(this.colors);
        this.colorsVBO.seal((GL)gL4, true);
        this.verticesVBO.enableBuffer((GL)gL4, false);
        this.colorsVBO.enableBuffer((GL)gL4, false);
        this.st.ownAttribute((GLArrayData)this.verticesVBO, true);
        this.st.ownAttribute((GLArrayData)this.colorsVBO, true);
        this.st.useProgram((GL2ES2)gL4, false);
    }

    private void initVBO_interleaved(GL4 gL4) {
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)7, (int)5126, (boolean)false, (int)3, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 3; ++i) {
            floatBuffer.put(vertices, i * 3, 3);
            floatBuffer.put(this.colors, i * 4, 4);
        }
        this.interleavedVBO.seal((GL)gL4, true);
        this.interleavedVBO.enableBuffer((GL)gL4, false);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        this.st.useProgram((GL2ES2)gL4, false);
    }

    private void initShader(GL4 gL4) {
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL4, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL4, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        shaderCode.replaceInShaderSource("NO_OF_INSTANCE", String.valueOf(30));
        shaderCode.defaultShaderCustomization((GL2ES2)gL4, true, true);
        shaderCode2.defaultShaderCustomization((GL2ES2)gL4, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link((GL2ES2)gL4, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram((GL2ES2)gL4, shaderProgram, true);
    }
}

