/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl4;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Vec3f;
import com.jogamp.opengl.DebugGL4;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL4;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.gl4.IInstancedRenderingView;
import com.jogamp.opengl.util.PMVMatrix;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Random;

public class TrianglesInstancedRendererHardcoded
implements GLEventListener {
    private float aspect;
    private int shaderProgram;
    private int vertShader;
    private int fragShader;
    private int projectionMatrixLocation;
    private int transformMatrixLocation;
    private static final int locPos = 1;
    private static final int locCol = 2;
    private PMVMatrix projectionMatrix;
    private static final int NO_OF_INSTANCE = 30;
    private final FloatBuffer triangleTransform = FloatBuffer.allocate(480);
    private final Matrix4f[] mat = new Matrix4f[30];
    private final float[] rotationSpeed = new float[30];
    private int[] vbo;
    private int[] vao;
    private PrintStream stream;
    private final IInstancedRenderingView view;
    private static final boolean useTraceGL = false;
    private final String vertexShaderString = "#version 410 \n\nuniform mat4 mgl_PMatrix; \nuniform mat4 mgl_MVMatrix[30]; \nin vec3  mgl_Vertex; \nin vec4  mgl_Color; \nout vec4 frontColor; \nvoid main(void) \n{ \n  frontColor = mgl_Color; \n  gl_Position = mgl_PMatrix * mgl_MVMatrix[gl_InstanceID] * vec4(mgl_Vertex, 1);} ";
    private final String fragmentShaderString = "#version 410\n\nin vec4    frontColor; \nout vec4    mgl_FragColor; \nvoid main (void) \n{ \n  mgl_FragColor = frontColor; \n} ";
    private final float[] vertices = new float[]{1.0f, 0.0f, 0.0f, -0.5f, 0.866f, 0.0f, -0.5f, -0.866f, 0.0f};
    private final float[] colors = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f};

    public TrianglesInstancedRendererHardcoded(IInstancedRenderingView iInstancedRenderingView) {
        this.view = iInstancedRenderingView;
        this.initTransform();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gLAutoDrawable.setGL((GL)new DebugGL4(gL4));
        gL4.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL4.glClearDepth(1.0);
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL4.getClass().getName());
        System.err.println("GL_VENDOR: " + gL4.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL4.glGetString(7937));
        System.err.println("GL_VERSION: " + gL4.glGetString(7938));
        try {
            this.initShaders(gL4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.initVBO(gL4);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gL4.glClear(16640);
        gL4.glUseProgram(this.shaderProgram);
        this.projectionMatrix.glMatrixMode(5889);
        this.projectionMatrix.glPushMatrix();
        float f = 0.1f;
        if (this.view != null) {
            f = this.view.getScale();
        }
        this.projectionMatrix.glScalef(f, f, f);
        gL4.glUniformMatrix4fv(this.projectionMatrixLocation, 1, false, this.projectionMatrix.getSyncP().getSyncFloats());
        this.projectionMatrix.glPopMatrix();
        this.generateTriangleTransform();
        gL4.glUniformMatrix4fv(this.transformMatrixLocation, 30, false, this.triangleTransform);
        gL4.glBindVertexArray(this.vao[0]);
        gL4.glDrawArraysInstanced(4, 0, 3, 30);
        gL4.glBindVertexArray(0);
        gL4.glUseProgram(0);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.out.println("Window resized to width=" + n3 + " height=" + n4);
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gL4.glViewport(0, 0, n3, n4);
        this.aspect = (float)n3 / (float)n4;
        this.projectionMatrix = new PMVMatrix();
        this.projectionMatrix.glMatrixMode(5889);
        this.projectionMatrix.glLoadIdentity();
        this.projectionMatrix.gluPerspective(0.7853982f, this.aspect, 0.001f, 20.0f);
        this.projectionMatrix.gluLookAt(new Vec3f(0.0f, 0.0f, -10.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f));
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        gL4.glUseProgram(0);
        gL4.glDeleteBuffers(2, this.vbo, 0);
        gL4.glDetachShader(this.shaderProgram, this.vertShader);
        gL4.glDeleteShader(this.vertShader);
        gL4.glDetachShader(this.shaderProgram, this.fragShader);
        gL4.glDeleteShader(this.fragShader);
        gL4.glDeleteProgram(this.shaderProgram);
    }

    private void initTransform() {
        Random random = new Random();
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < 30; ++i) {
            this.rotationSpeed[i] = 0.3f * random.nextFloat();
            this.mat[i] = new Matrix4f();
            this.mat[i].loadIdentity();
            float f = 1.0f + 4.0f * random.nextFloat();
            this.mat[i].scale(f, matrix4f);
            this.mat[i].translate(20.0f * random.nextFloat() - 10.0f, 10.0f * random.nextFloat() - 5.0f, 0.0f, matrix4f);
        }
    }

    private void initVBO(GL4 gL4) {
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((int)(this.vertices.length + this.colors.length));
        for (int i = 0; i < this.vertices.length / 3; ++i) {
            int n;
            for (n = 0; n < 3; ++n) {
                floatBuffer.put(this.vertices[i * 3 + n]);
            }
            for (n = 0; n < 4; ++n) {
                floatBuffer.put(this.colors[i * 4 + n]);
            }
        }
        floatBuffer.flip();
        this.vao = new int[1];
        gL4.glGenVertexArrays(1, this.vao, 0);
        gL4.glBindVertexArray(this.vao[0]);
        this.vbo = new int[1];
        gL4.glGenBuffers(1, this.vbo, 0);
        gL4.glBindBuffer(34962, this.vbo[0]);
        gL4.glBufferData(34962, (long)(floatBuffer.limit() * 4), (Buffer)floatBuffer, 35044);
        gL4.glEnableVertexAttribArray(1);
        gL4.glEnableVertexAttribArray(2);
        gL4.glVertexAttribPointer(1, 3, 5126, false, 28, 0L);
        gL4.glVertexAttribPointer(2, 4, 5126, false, 28, 12L);
    }

    private void initShaders(GL4 gL4) throws IOException {
        Object[] objectArray;
        Object[] objectArray2;
        this.vertShader = gL4.glCreateShader(35633);
        this.fragShader = gL4.glCreateShader(35632);
        String[] stringArray = new String[]{"#version 410 \n\nuniform mat4 mgl_PMatrix; \nuniform mat4 mgl_MVMatrix[30]; \nin vec3  mgl_Vertex; \nin vec4  mgl_Color; \nout vec4 frontColor; \nvoid main(void) \n{ \n  frontColor = mgl_Color; \n  gl_Position = mgl_PMatrix * mgl_MVMatrix[gl_InstanceID] * vec4(mgl_Vertex, 1);} "};
        int[] nArray = new int[]{stringArray[0].length()};
        gL4.glShaderSource(this.vertShader, stringArray.length, stringArray, nArray, 0);
        gL4.glCompileShader(this.vertShader);
        int[] nArray2 = new int[1];
        gL4.glGetShaderiv(this.vertShader, 35713, nArray2, 0);
        if (nArray2[0] != 0) {
            System.out.println("Vertex shader compiled");
        } else {
            objectArray2 = new int[1];
            gL4.glGetShaderiv(this.vertShader, 35716, objectArray2, 0);
            objectArray = new byte[objectArray2[0]];
            gL4.glGetShaderInfoLog(this.vertShader, objectArray2[0], (int[])null, 0, objectArray, 0);
            System.err.println("Error compiling the vertex shader: " + new String((byte[])objectArray));
            System.exit(1);
        }
        objectArray2 = new String[]{"#version 410\n\nin vec4    frontColor; \nout vec4    mgl_FragColor; \nvoid main (void) \n{ \n  mgl_FragColor = frontColor; \n} "};
        objectArray = new int[]{objectArray2[0].length()};
        gL4.glShaderSource(this.fragShader, objectArray2.length, (String[])objectArray2, (int[])objectArray, 0);
        gL4.glCompileShader(this.fragShader);
        gL4.glGetShaderiv(this.fragShader, 35713, nArray2, 0);
        if (nArray2[0] != 0) {
            System.out.println("Fragment shader compiled.");
        } else {
            int[] nArray3 = new int[1];
            gL4.glGetShaderiv(this.fragShader, 35716, nArray3, 0);
            byte[] byArray = new byte[nArray3[0]];
            gL4.glGetShaderInfoLog(this.fragShader, nArray3[0], (int[])null, 0, byArray, 0);
            System.err.println("Error compiling the fragment shader: " + new String(byArray));
            System.exit(1);
        }
        this.shaderProgram = gL4.glCreateProgram();
        gL4.glAttachShader(this.shaderProgram, this.vertShader);
        gL4.glAttachShader(this.shaderProgram, this.fragShader);
        gL4.glBindAttribLocation(this.shaderProgram, 1, "mgl_Vertex");
        gL4.glBindAttribLocation(this.shaderProgram, 2, "mgl_Color");
        gL4.glLinkProgram(this.shaderProgram);
        this.projectionMatrixLocation = gL4.glGetUniformLocation(this.shaderProgram, "mgl_PMatrix");
        System.out.println("projectionMatrixLocation:" + this.projectionMatrixLocation);
        this.transformMatrixLocation = gL4.glGetUniformLocation(this.shaderProgram, "mgl_MVMatrix");
        System.out.println("transformMatrixLocation:" + this.transformMatrixLocation);
    }

    private void generateTriangleTransform() {
        this.triangleTransform.clear();
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < 30; ++i) {
            this.mat[i].rotate(this.rotationSpeed[i], 0.0f, 0.0f, 1.0f, matrix4f);
            this.mat[i].get(this.triangleTransform);
        }
        this.triangleTransform.flip();
    }
}

