/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderState;
import org.junit.Assert;

public class GLSLMiscHelper {
    public static final int frames_perftest = 600;
    public static final int frames_warmup = 100;
    public static final float[] vertices0 = new float[]{-2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, -2.0f, -2.0f, 0.0f, 2.0f, -2.0f, 0.0f};
    public static final float[] vertices1 = new float[]{-2.0f, 1.0f, 0.0f, 2.0f, 1.0f, 0.0f, -2.0f, -1.0f, 0.0f, 2.0f, -1.0f, 0.0f};
    public static final float[] colors0 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    public static final float[] colors1 = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    public static void validateGLArrayDataServerState(GL2ES2 gL2ES2, ShaderState shaderState, GLArrayDataServer gLArrayDataServer) {
        int[] nArray = new int[1];
        if (null != shaderState) {
            Assert.assertEquals((Object)gLArrayDataServer, (Object)shaderState.getAttribute(gLArrayDataServer.getName()));
            if (shaderState.shaderProgram().linked()) {
                Assert.assertEquals((long)gLArrayDataServer.getLocation(), (long)shaderState.getCachedAttribLocation(gLArrayDataServer.getName()));
                Assert.assertEquals((long)gLArrayDataServer.getLocation(), (long)shaderState.getAttribLocation(gL2ES2, (GLArrayData)gLArrayDataServer));
                Assert.assertEquals((long)gLArrayDataServer.getLocation(), (long)shaderState.getAttribLocation(gL2ES2, gLArrayDataServer.getName()));
                Assert.assertEquals((long)gLArrayDataServer.getLocation(), (long)gL2ES2.glGetAttribLocation(shaderState.shaderProgram().program(), gLArrayDataServer.getName()));
            }
        }
        gL2ES2.glGetVertexAttribiv(gLArrayDataServer.getLocation(), 34338, nArray, 0);
        Assert.assertEquals((long)(gLArrayDataServer.enabled() ? 1L : 0L), (long)nArray[0]);
        gL2ES2.glGetVertexAttribiv(gLArrayDataServer.getLocation(), 34975, nArray, 0);
        Assert.assertEquals((long)gLArrayDataServer.getVBOName(), (long)nArray[0]);
        GLBufferStorage gLBufferStorage = gL2ES2.getBufferStorage(gLArrayDataServer.getVBOName());
        Assert.assertEquals((String)("GLBufferStorage size mismatch, storage " + gLBufferStorage), (long)gLArrayDataServer.getByteCount(), (long)(null != gLBufferStorage ? gLBufferStorage.getSize() : -1L));
    }

    public static void pause(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l) {
            Thread.sleep(l);
        }
    }

    public static void displayVCArrays(GLDrawable gLDrawable, GL2ES2 gL2ES2, ShaderState shaderState, boolean bl, GLArrayDataServer gLArrayDataServer, GLArrayDataServer gLArrayDataServer2, boolean bl2, int n, long l) throws InterruptedException {
        System.err.println("screen #" + n);
        if (bl) {
            gLArrayDataServer.enableBuffer((GL)gL2ES2, true);
            gLArrayDataServer2.enableBuffer((GL)gL2ES2, true);
        }
        Assert.assertTrue((boolean)gLArrayDataServer.enabled());
        Assert.assertTrue((boolean)gLArrayDataServer2.enabled());
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer);
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer2);
        gL2ES2.glClear(16640);
        gL2ES2.glDrawArrays(5, 0, 4);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        if (bl2) {
            gLArrayDataServer.enableBuffer((GL)gL2ES2, false);
            gLArrayDataServer2.enableBuffer((GL)gL2ES2, false);
            Assert.assertTrue((!gLArrayDataServer.enabled() ? 1 : 0) != 0);
            Assert.assertTrue((!gLArrayDataServer2.enabled() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        gLDrawable.swapBuffers();
        if (l > 0L) {
            GLSLMiscHelper.pause(l);
        }
    }

    public static void displayVCArraysNoChecks(GLDrawable gLDrawable, GL2ES2 gL2ES2, boolean bl, GLArrayDataServer gLArrayDataServer, GLArrayDataServer gLArrayDataServer2, boolean bl2) throws InterruptedException {
        if (bl) {
            gLArrayDataServer.enableBuffer((GL)gL2ES2, true);
            gLArrayDataServer2.enableBuffer((GL)gL2ES2, true);
        }
        gL2ES2.glClear(16640);
        gL2ES2.glDrawArrays(5, 0, 4);
        if (bl2) {
            gLArrayDataServer.enableBuffer((GL)gL2ES2, false);
            gLArrayDataServer2.enableBuffer((GL)gL2ES2, false);
        }
        gLDrawable.swapBuffers();
    }

    public static GLArrayDataServer createVertices(GL2ES2 gL2ES2, ShaderState shaderState, int n, int n2, float[] fArray) {
        if (null != shaderState && 0 != n) {
            throw new InternalError("Use either ShaderState _or_ shader-program, not both");
        }
        if (null == shaderState && 0 == n) {
            throw new InternalError("Pass a valid ShaderState _xor_ shader-program, not none");
        }
        GLArrayDataServer gLArrayDataServer = GLArrayDataServer.createGLSL((String)"mgl_Vertex", (int)3, (int)5126, (boolean)false, (int)4, (int)35044);
        if (null != shaderState) {
            shaderState.ownAttribute((GLArrayData)gLArrayDataServer, true);
            if (0 <= n2) {
                shaderState.bindAttribLocation(gL2ES2, n2, (GLArrayData)gLArrayDataServer);
            }
        } else if (0 <= n2) {
            gLArrayDataServer.setLocation(gL2ES2, n, n2);
        } else {
            gLArrayDataServer.setLocation(gL2ES2, n);
        }
        Assert.assertTrue((boolean)gLArrayDataServer.isVBO());
        Assert.assertTrue((boolean)gLArrayDataServer.isVertexAttribute());
        Assert.assertTrue((!gLArrayDataServer.isVBOWritten() ? 1 : 0) != 0);
        Assert.assertTrue((!gLArrayDataServer.sealed() ? 1 : 0) != 0);
        int n3 = 0;
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.seal((GL)gL2ES2, true);
        Assert.assertTrue((boolean)gLArrayDataServer.isVBOWritten());
        Assert.assertTrue((boolean)gLArrayDataServer.sealed());
        Assert.assertEquals((long)4L, (long)gLArrayDataServer.getElemCount());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        Assert.assertEquals((long)0L, (long)gL2ES2.getBoundBuffer(34962));
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createColors(GL2ES2 gL2ES2, ShaderState shaderState, int n, int n2, float[] fArray) {
        if (null != shaderState && 0 != n) {
            throw new InternalError("Use either ShaderState _or_ shader-program, not both");
        }
        if (null == shaderState && 0 == n) {
            throw new InternalError("Pass a valid ShaderState _xor_ shader-program, not none");
        }
        GLArrayDataServer gLArrayDataServer = GLArrayDataServer.createGLSL((String)"mgl_Color", (int)4, (int)5126, (boolean)false, (int)4, (int)35044);
        if (null != shaderState) {
            shaderState.ownAttribute((GLArrayData)gLArrayDataServer, true);
            if (0 <= n2) {
                shaderState.bindAttribLocation(gL2ES2, n2, (GLArrayData)gLArrayDataServer);
            }
        } else if (0 <= n2) {
            gLArrayDataServer.setLocation(gL2ES2, n, n2);
        } else {
            gLArrayDataServer.setLocation(gL2ES2, n);
        }
        int n3 = 0;
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.putf(fArray[n3++]);
        gLArrayDataServer.seal((GL)gL2ES2, true);
        Assert.assertTrue((boolean)gLArrayDataServer.isVBO());
        Assert.assertTrue((boolean)gLArrayDataServer.isVertexAttribute());
        Assert.assertTrue((boolean)gLArrayDataServer.isVBOWritten());
        Assert.assertTrue((boolean)gLArrayDataServer.sealed());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        Assert.assertEquals((long)0L, (long)gL2ES2.getBoundBuffer(34962));
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer);
        return gLArrayDataServer;
    }
}

