/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRulerNEWT01
extends UITestCase {
    static long durationPerTest = 500L;
    static float[] reqSurfacePixelScale = new float[]{0.0f, 0.0f};
    static boolean manualTest = false;

    private void setTitle(Window window) {
        float[] fArray = window.getPixelsPerMM(new float[2]);
        fArray[0] = fArray[0] * 25.4f;
        fArray[1] = fArray[1] * 25.4f;
        window.setTitle("GLWindow: win: " + window.getBounds() + ", pix: " + window.getSurfaceWidth() + "x" + window.getSurfaceHeight() + ", sDPI " + fArray[0] + " x " + fArray[1]);
    }

    private void runTestGL() throws InterruptedException {
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()));
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setSurfaceScale(reqSurfacePixelScale);
        float[] fArray = gLWindow.getRequestedSurfaceScale(new float[2]);
        gLWindow.setSize(640, 480);
        gLWindow.addGLEventListener(new GLEventListener(){
            final ShaderState st = new ShaderState();
            final PMVMatrix pmvMatrix = new PMVMatrix();
            final GLUniformData pmvMatrixUniform = new GLUniformData("gcu_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
            final GLArrayDataServer vertices0 = GLArrayDataServer.createGLSL((String)"gca_Vertices", (int)3, (int)5126, (boolean)false, (int)4, (int)35044);
            final GLUniformData rulerPixFreq = new GLUniformData("gcu_RulerPixFreq", 2, Buffers.newDirectFloatBuffer((int)2));

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
                ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, RedSquareES2.class, (String)"shader", (String)"shader/bin", (String)"default", (boolean)true);
                ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, RedSquareES2.class, (String)"shader", (String)"shader/bin", (String)"ruler", (boolean)true);
                shaderCode.defaultShaderCustomization(gL2ES2, true, true);
                shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
                ShaderProgram shaderProgram = new ShaderProgram();
                shaderProgram.add(gL2ES2, shaderCode, System.err);
                shaderProgram.add(gL2ES2, shaderCode2, System.err);
                Assert.assertTrue((0 != shaderProgram.program() ? 1 : 0) != 0);
                Assert.assertTrue((!shaderProgram.inUse() ? 1 : 0) != 0);
                Assert.assertTrue((!shaderProgram.linked() ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
                this.st.attachShaderProgram(gL2ES2, shaderProgram, true);
                Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
                this.st.ownUniform(this.pmvMatrixUniform);
                this.st.uniform(gL2ES2, this.pmvMatrixUniform);
                Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
                GLUniformData gLUniformData = new GLUniformData("gcu_RulerColor", 3, Buffers.newDirectFloatBuffer((int)3));
                FloatBuffer floatBuffer = (FloatBuffer)gLUniformData.getBuffer();
                floatBuffer.put(0, 0.5f);
                floatBuffer.put(1, 0.5f);
                floatBuffer.put(2, 0.5f);
                this.st.ownUniform(gLUniformData);
                this.st.uniform(gL2ES2, gLUniformData);
                Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
                this.st.ownUniform(this.rulerPixFreq);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(1.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(1.0f);
                this.vertices0.putf(1.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(1.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.putf(0.0f);
                this.vertices0.seal((GL)gL2ES2, true);
                this.st.ownAttribute((GLArrayData)this.vertices0, true);
                gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
                gL2ES2.glEnable(2929);
                Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                this.vertices0.enableBuffer((GL)gL2ES2, true);
                gL2ES2.glClear(16640);
                gL2ES2.glDrawArrays(5, 0, 4);
                this.vertices0.enableBuffer((GL)gL2ES2, false);
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                this.pmvMatrix.glMatrixMode(5889);
                this.pmvMatrix.glLoadIdentity();
                this.pmvMatrix.glOrthof(0.0f, 1.0f, 0.0f, 1.0f, -10.0f, 10.0f);
                this.pmvMatrix.glMatrixMode(5888);
                this.pmvMatrix.glLoadIdentity();
                this.st.uniform(gL2ES2, this.pmvMatrixUniform);
                float[] fArray = gLWindow.getPixelsPerMM(new float[2]);
                FloatBuffer floatBuffer = (FloatBuffer)this.rulerPixFreq.getBuffer();
                floatBuffer.put(0, fArray[0] * 10.0f);
                floatBuffer.put(1, fArray[1] * 10.0f);
                this.st.uniform(gL2ES2, this.rulerPixFreq);
                System.err.println("Screen pixel/cm " + floatBuffer.get(0) + ", " + floatBuffer.get(1));
            }
        });
        final UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener((GLEventListener)snapshotGLEventListener);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'x') {
                    float[] fArray = gLWindow.getCurrentSurfaceScale(new float[2]);
                    float[] fArray2 = fArray[0] == 1.0f ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
                    System.err.println("[set PixelScale pre]: had " + fArray[0] + "x" + fArray[1] + " -> req " + fArray2[0] + "x" + fArray2[1]);
                    snapshotGLEventListener.setMakeSnapshot();
                    gLWindow.setSurfaceScale(fArray2);
                    float[] fArray3 = gLWindow.getRequestedSurfaceScale(new float[2]);
                    float[] fArray4 = gLWindow.getCurrentSurfaceScale(new float[2]);
                    float[] fArray5 = gLWindow.getMaximumSurfaceScale(new float[2]);
                    System.err.println("[set PixelScale post]: " + fArray[0] + "x" + fArray[1] + " (had) -> " + fArray2[0] + "x" + fArray2[1] + " (req) -> " + fArray3[0] + "x" + fArray3[1] + " (val) -> " + fArray4[0] + "x" + fArray4[1] + " (has), " + fArray5[0] + "x" + fArray5[1] + " (native)");
                    TestRulerNEWT01.this.setTitle((Window)gLWindow);
                }
            }
        });
        gLWindow.setVisible(true);
        float[] fArray2 = gLWindow.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " (req) -> " + fArray[0] + "x" + fArray[1] + " (val) -> " + fArray2[0] + "x" + fArray2[1] + " (has)");
        this.setTitle((Window)gLWindow);
        snapshotGLEventListener.setMakeSnapshot();
        gLWindow.display();
        Thread.sleep(durationPerTest);
        gLWindow.destroy();
    }

    @Test
    public void test01_PSA() throws InterruptedException {
        this.runTestGL();
    }

    @Test
    public void test99_PS1() throws InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        TestRulerNEWT01.reqSurfacePixelScale[0] = 1.0f;
        TestRulerNEWT01.reqSurfacePixelScale[1] = 1.0f;
        this.runTestGL();
    }

    public static void main(String[] stringArray) throws IOException {
        System.err.println("main - start");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
                continue;
            }
            if (stringArray[i].equals("-pixelScale")) {
                float f;
                TestRulerNEWT01.reqSurfacePixelScale[0] = f = MiscUtils.atof(stringArray[++i], reqSurfacePixelScale[0]);
                TestRulerNEWT01.reqSurfacePixelScale[1] = f;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manualTest = true;
        }
        String string = TestRulerNEWT01.class.getName();
        JUnitCore.main((String[])new String[]{string});
        System.err.println("main - end");
    }
}

