/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestShaderCompilationBug459AWT
extends UITestCase {
    static int width;
    static int height;
    static long duration;
    GLException glexception;

    @BeforeClass
    public static void initClass() {
        width = 512;
        height = 512;
    }

    @AfterClass
    public static void releaseClass() {
    }

    @Test
    public void compileShader() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get((String)"GL2GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setStencilBits(8);
        final Frame frame = new Frame("Bug 459 shader compilation test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        frame.add((Component)gLCanvas);
        gLCanvas.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL2GL3 gL2GL3 = gLAutoDrawable.getGL().getGL2GL3();
                int n = gL2GL3.glCreateShader(35633);
                try {
                    gL2GL3.glShaderSource(n, 1, new String[]{"void main(void){gl_Position = vec4(0,0,0,1);}"}, (int[])null, 0);
                    gL2GL3.glCompileShader(n);
                    int[] nArray = new int[1];
                    gL2GL3.glGetShaderiv(n, 35713, nArray, 0);
                    if (nArray[0] == 0) {
                        int[] nArray2 = new int[1];
                        gL2GL3.glGetShaderiv(n, 35716, nArray2, 0);
                        byte[] byArray = new byte[nArray2[0]];
                        gL2GL3.glGetShaderInfoLog(n, nArray2[0], (int[])null, 0, byArray, 0);
                        System.err.println("Error compiling the shader: " + new String(byArray));
                        gL2GL3.glDeleteShader(n);
                    } else {
                        System.out.println("Shader compiled: id=" + n);
                    }
                }
                catch (GLException gLException) {
                    TestShaderCompilationBug459AWT.this.glexception = gLException;
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(512, 512);
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)(this.glexception != null ? this.glexception.getMessage() : ""), (this.glexception == null ? 1 : 0) != 0);
        Assert.assertNotNull((Object)frame);
        Assert.assertNotNull((Object)gLCanvas);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestShaderCompilationBug459AWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

