/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.javafx;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.nativewindow.NativeWindowHolder;
import com.jogamp.nativewindow.javafx.JFXAccessor;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.javafx.NewtCanvasJFX;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.newt.parenting.NewtJFXReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.newt.parenting.NewtReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNewtCanvasJFXGLn
extends UITestCase {
    static int duration = 5000;
    static int manualTestID = -1;
    Display jfxNewtDisplay = null;
    final WaitAction awtRobotWaitAction = new WaitAction(100L);
    final WaitAction generalWaitAction = new WaitAction(10L);
    static final int defWidth = 800;
    static final int defHeight = 600;

    @BeforeClass
    public static void startup() throws InterruptedException {
        JFXApp.startup();
    }

    @AfterClass
    public static void shutdown() {
        JFXApp.shutdown();
        Platform.exit();
    }

    @Before
    public void init() {
        this.jfxNewtDisplay = NewtFactory.createDisplay(null, (boolean)false);
    }

    @After
    public void release() {
        this.jfxNewtDisplay = null;
    }

    static void populateScene(final Scene scene, boolean bl, GLWindow gLWindow, int n, int n2, boolean bl2, NewtCanvasJFX[] newtCanvasJFXArray) {
        GraphicsContext graphicsContext;
        Canvas canvas;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Window window = scene.getWindow();
        boolean bl3 = null != window && window.isShowing();
        final Group group = new Group();
        if (bl2) {
            n8 = n / 5;
            n7 = n2 / 5;
            n6 = n8;
            n5 = n7;
            n4 = n - n8 - n8;
            n3 = n2 - n7 - n7;
        } else {
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = n;
            n3 = n2;
        }
        System.err.println("Scene " + n + "x" + n2 + ", isShowing " + bl3 + ", postAttach " + bl);
        System.err.println("Scene.canvas " + n6 + "/" + n5 + " " + n4 + "x" + n3);
        System.err.println("Scene.border " + n8 + "x" + n7);
        if (!bl) {
            if (bl3) {
                JFXAccessor.runOnJFXThread((boolean)true, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scene.setRoot((Parent)group);
                    }
                });
            } else {
                scene.setRoot((Parent)group);
            }
        }
        if (null == newtCanvasJFXArray) {
            canvas = new Canvas();
        } else {
            newtCanvasJFXArray[0] = new NewtCanvasJFX((com.jogamp.newt.Window)gLWindow);
            canvas = newtCanvasJFXArray[0];
        }
        canvas.setWidth((double)n4);
        canvas.setHeight((double)n3);
        if (null == newtCanvasJFXArray) {
            graphicsContext = canvas.getGraphicsContext2D();
            graphicsContext.setFill((Paint)Color.BLUE);
            graphicsContext.fillRect(0.0, 0.0, (double)n4, (double)n3);
        }
        canvas.relocate((double)n6, (double)n5);
        graphicsContext = new Text(0.0, 0.0, "left");
        graphicsContext.setFont(new Font(40.0));
        graphicsContext.relocate(0.0, (double)(n2 / 2));
        Text text = new Text(0.0, 0.0, "above");
        text.setFont(new Font(40.0));
        text.relocate((double)(n / 2), (double)(n7 - 40));
        Text text2 = new Text(0.0, 0.0, "right");
        text2.setFont(new Font(40.0));
        text2.relocate((double)(n - n8), (double)(n2 / 2));
        Text text3 = new Text(0.0, 0.0, "below");
        text3.setFont(new Font(40.0));
        text3.relocate((double)(n / 2), (double)(n2 - n7));
        Runnable runnable = new Runnable(){
            final /* synthetic */ Text val$text0;
            final /* synthetic */ Text val$text1;
            final /* synthetic */ Canvas val$canvas0;
            final /* synthetic */ Text val$text2;
            final /* synthetic */ Text val$text3;
            {
                this.val$text0 = text;
                this.val$text1 = text2;
                this.val$canvas0 = canvas;
                this.val$text2 = text3;
                this.val$text3 = text4;
            }

            @Override
            public void run() {
                group.getChildren().add((Object)this.val$text0);
                group.getChildren().add((Object)this.val$text1);
                group.getChildren().add((Object)this.val$canvas0);
                group.getChildren().add((Object)this.val$text2);
                group.getChildren().add((Object)this.val$text3);
            }
        };
        if (!bl && bl3) {
            JFXAccessor.runOnJFXThread((boolean)true, (Runnable)runnable);
        } else {
            runnable.run();
        }
        if (bl) {
            if (bl3) {
                JFXAccessor.runOnJFXThread((boolean)true, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scene.setRoot((Parent)group);
                    }
                });
            } else {
                scene.setRoot((Parent)group);
            }
        }
    }

    protected void runTestAGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener, boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        Object object;
        NewtCanvasJFX[] newtCanvasJFXArray;
        Screen screen;
        GLWindow gLWindow;
        if (!JFXAccessor.isJFXAvailable()) {
            System.err.println("JFX not available");
            return;
        }
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(false, false);
        if (null == gLEventListener) {
            gLWindow = null;
        } else {
            screen = NewtFactory.createScreen((Display)this.jfxNewtDisplay, (int)0);
            gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLWindow);
            Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
            Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
            Assert.assertNull((Object)gLWindow.getParent());
            gLWindow.addGLEventListener(gLEventListener);
            gLWindow.addGLEventListener(new GLEventListener(){
                int displayCount = 0;

                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }

                public void display(GLAutoDrawable gLAutoDrawable) {
                    if (this.displayCount < 3) {
                        TestNewtCanvasJFXGLn.this.snapshot(this.displayCount++, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                    }
                }

                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }
            });
        }
        if (null == gLEventListener) {
            newtCanvasJFXArray = null;
        } else {
            NewtCanvasJFX[] newtCanvasJFXArray2 = new NewtCanvasJFX[1];
            newtCanvasJFXArray = newtCanvasJFXArray2;
            newtCanvasJFXArray2[0] = null;
        }
        screen = newtCanvasJFXArray;
        final Scene scene = new Scene((Parent)new Group(), 800.0, 600.0);
        if (!bl) {
            System.err.println("Stage set.A0");
            JFXAccessor.runOnJFXThread((boolean)true, (Runnable)new Runnable(){

                @Override
                public void run() {
                    System.err.println("Stage set.A1");
                    JFXApp.stage.setScene(scene);
                    JFXApp.stage.sizeToScene();
                    System.err.println("Stage set.AX");
                }
            });
        }
        TestNewtCanvasJFXGLn.populateScene(scene, bl, bl2 ? null : gLWindow, 800, 600, true, (NewtCanvasJFX[])screen);
        if (bl) {
            System.err.println("Stage set.B0");
            JFXAccessor.runOnJFXThread((boolean)true, (Runnable)new Runnable(){

                @Override
                public void run() {
                    System.err.println("Stage set.B1");
                    JFXApp.stage.setScene(scene);
                    JFXApp.stage.sizeToScene();
                    System.err.println("Stage set.BX");
                }
            });
        }
        if (bl2 && null != gLEventListener) {
            screen[0].setNEWTChild((com.jogamp.newt.Window)gLWindow);
        }
        if (null != gLWindow) {
            Assert.assertTrue((String)"GLWindow didn't become visible natively!", (boolean)NewtTestUtil.waitForRealized((com.jogamp.newt.Window)gLWindow, true, (Runnable)this.awtRobotWaitAction));
            System.err.println("GLWindow LOS.0: " + gLWindow.getLocationOnScreen(null));
            gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

                public void windowResized(WindowEvent windowEvent) {
                    System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                }

                public void windowMoved(WindowEvent windowEvent) {
                    System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                }
            });
            object = new NewtJFXReparentingKeyAdapter(JFXApp.stage, (NativeWindowHolder)screen[0], gLWindow);
            object.quitAdapterEnable(true);
            gLWindow.addKeyListener((KeyListener)object);
            gLWindow.addMouseListener((MouseListener)object);
            gLWindow.addWindowListener((WindowListener)object);
            ChangeListener<Number> changeListener = new ChangeListener<Number>(){
                final /* synthetic */ NewtReparentingKeyAdapter val$newtDemoListener;
                {
                    this.val$newtDemoListener = newtReparentingKeyAdapter;
                }

                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    this.val$newtDemoListener.setTitle();
                }
            };
            JFXApp.stage.widthProperty().addListener((ChangeListener)changeListener);
            JFXApp.stage.heightProperty().addListener((ChangeListener)changeListener);
        }
        if (null != gLEventListener) {
            System.err.println("NewtCanvasJFX LOS.0: " + screen[0].getNativeWindow().getLocationOnScreen(null));
        }
        if (bl3 && null != gLEventListener) {
            object = new Animator((GLAutoDrawable)gLWindow);
            object.start();
        } else {
            object = null;
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)duration;
        try {
            while (System.currentTimeMillis() < l2) {
                this.generalWaitAction.run();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        if (null != object) {
            object.stop();
        }
        JFXAccessor.runOnJFXThread((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestNewtCanvasJFXGLn.populateScene(JFXApp.stage.getScene(), false, null, 800, 600, true, null);
                JFXApp.stage.sizeToScene();
            }
        });
    }

    @Test
    public void test00() throws InterruptedException {
        if (0 > manualTestID || 0 == manualTestID) {
            this.runTestAGL(null, null, false, false, false);
        }
    }

    @Test
    public void test11_preAttachNewtGL_NoAnim() throws InterruptedException {
        if (0 > manualTestID || 11 == manualTestID) {
            this.runTestAGL((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()), (GLEventListener)new GearsES2(), false, false, false);
        }
    }

    @Test
    public void test12_postAttachNewt_NoAnim() throws InterruptedException {
        if (0 > manualTestID || 12 == manualTestID) {
            this.runTestAGL((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()), (GLEventListener)new GearsES2(), true, false, false);
        }
    }

    @Test
    public void test13_postAttachGL_NoAnim() throws InterruptedException {
        if (0 > manualTestID || 13 == manualTestID) {
            this.runTestAGL((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()), (GLEventListener)new GearsES2(), false, true, false);
        }
    }

    @Test
    public void test14_postAttachNewtGL_NoAnim() throws InterruptedException {
        if (0 > manualTestID || 14 == manualTestID) {
            this.runTestAGL((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()), (GLEventListener)new GearsES2(), true, true, false);
        }
    }

    @Test
    public void test21_preAttachNewtGL_DoAnim() throws InterruptedException {
        if (0 > manualTestID || 21 == manualTestID) {
            this.runTestAGL((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()), (GLEventListener)new GearsES2(), false, false, true);
        }
    }

    @Test
    public void test22_postAttachNewt_DoAnim() throws InterruptedException {
        if (0 > manualTestID || 22 == manualTestID) {
            this.runTestAGL((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()), (GLEventListener)new GearsES2(), true, false, true);
        }
    }

    @Test
    public void test30_MultisampleAndAlpha() throws InterruptedException {
        if (0 > manualTestID || 30 == manualTestID) {
            GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(2);
            this.runTestAGL((GLCapabilitiesImmutable)gLCapabilities, new MultisampleDemoES2(true), false, false, false);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atoi(stringArray[++i], duration);
            }
            if (!stringArray[i].equals("-test")) continue;
            manualTestID = MiscUtils.atoi(stringArray[++i], -1);
        }
        System.out.println("durationPerTest: " + duration + ", test " + manualTestID);
        JUnitCore.main((String[])new String[]{TestNewtCanvasJFXGLn.class.getName()});
    }

    class WaitAction
    implements Runnable {
        private final long sleepMS;

        WaitAction(long l) {
            this.sleepMS = l;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.sleepMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class JFXApp
    extends Application {
        static Stage stage;
        static final Object sync;
        static volatile boolean isLaunched;

        public void init() throws Exception {
            System.err.println("JFX init ...: " + Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(Stage stage) {
            System.err.println("JFX start.0 ...: " + Thread.currentThread());
            Object object = sync;
            synchronized (object) {
                try {
                    Scene scene = new Scene((Parent)new Group(), 800.0, 600.0);
                    stage.setTitle(TestNewtCanvasJFXGLn.class.getSimpleName());
                    stage.setScene(scene);
                    stage.sizeToScene();
                    long l = JFXAccessor.getWindowHandle((Window)stage);
                    System.err.println("t1 - Native window: 0x" + Long.toHexString(l));
                    stage.show();
                    l = JFXAccessor.getWindowHandle((Window)stage);
                    System.err.println("t2 - Native window: 0x" + Long.toHexString(l));
                    JFXApp.stage = stage;
                }
                finally {
                    isLaunched = true;
                    sync.notifyAll();
                }
            }
            System.err.println("JFX start.X ...: " + Thread.currentThread());
        }

        public void stop() throws Exception {
            System.err.println("JFX stop ...: " + Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void startup() throws InterruptedException {
            System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
            System.err.println("JFX Available: " + JFXAccessor.isJFXAvailable());
            if (JFXAccessor.isJFXAvailable()) {
                Platform.setImplicitExit((boolean)false);
                Object object = sync;
                synchronized (object) {
                    Thread thread = Thread.currentThread();
                    RunnableTask.invokeOnNewThread((ThreadGroup)thread.getThreadGroup(), (String)(thread.getName() + "JFXLauncher"), (boolean)false, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Application.launch(JFXApp.class, (String[])new String[0]);
                        }
                    });
                    while (!isLaunched) {
                        sync.wait();
                    }
                }
                System.err.println("JFX launched ...");
            }
        }

        public static void shutdown() {
            JFXAccessor.runOnJFXThread((boolean)true, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (null != stage) {
                        stage.close();
                    }
                }
            });
        }

        static {
            sync = new Object();
            isLaunched = false;
        }
    }
}

