/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.perf;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPerf001GLJPanelInit01AWT
extends UITestCase {
    final long INIT_TIMEOUT = 10000L;
    static long duration = 0L;
    static boolean wait = false;
    static int width = 800;
    static int height = 600;
    static int rows = 5;
    static int cols = 5;
    AtomicInteger initCount = new AtomicInteger(0);

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final boolean bl, int n, int n2, int n3, int n4, final CanvasType canvasType, boolean bl2) {
        long l;
        Animator animator = bl2 ? new Animator() : null;
        final ArrayList arrayList = new ArrayList();
        JPanel jPanel = new JPanel();
        final JFrame jFrame = new JFrame(this.getSimpleTestName("."));
        jPanel.setLayout(new GridLayout(n3, n4));
        final int n5 = n3 * n4;
        Dimension dimension = new Dimension(n / n4, n2 / n3);
        final long[] lArray = new long[10];
        if (wait) {
            UITestCase.waitForKey((String)"Pre-Init");
        }
        System.err.println("INIT START");
        this.initCount.set(0);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                final /* synthetic */ GLAnimatorControl val$animator;
                final /* synthetic */ Dimension val$eSize;
                final /* synthetic */ List val$newtCanvasAWTList;
                final /* synthetic */ JPanel val$panel;
                final /* synthetic */ JFrame val$frame;
                {
                    this.val$animator = gLAnimatorControl;
                    this.val$eSize = dimension;
                    this.val$newtCanvasAWTList = list;
                    this.val$panel = jPanel;
                    this.val$frame = jFrame;
                }

                @Override
                public void run() {
                    lArray[0] = Platform.currentTimeMillis();
                    for (int i = 0; i < n5; ++i) {
                        GLADComp gLADComp;
                        switch (canvasType.ordinal()) {
                            case 0: {
                                gLADComp = TestPerf001GLJPanelInit01AWT.this.createGLCanvas(gLCapabilitiesImmutable, bl, this.val$animator, this.val$eSize);
                                break;
                            }
                            case 1: {
                                gLADComp = TestPerf001GLJPanelInit01AWT.this.createGLJPanel(gLCapabilitiesImmutable, bl, this.val$animator, this.val$eSize);
                                break;
                            }
                            case 2: {
                                gLADComp = TestPerf001GLJPanelInit01AWT.this.createNewtCanvasAWT(gLCapabilitiesImmutable, bl, this.val$animator, this.val$eSize);
                                this.val$newtCanvasAWTList.add((NewtCanvasAWT)gLADComp.comp);
                                break;
                            }
                            default: {
                                throw new InternalError("XXX");
                            }
                        }
                        gLADComp.glad.addGLEventListener(new GLEventListener(){

                            public void init(GLAutoDrawable gLAutoDrawable) {
                                TestPerf001GLJPanelInit01AWT.this.initCount.getAndIncrement();
                            }

                            public void dispose(GLAutoDrawable gLAutoDrawable) {
                            }

                            public void display(GLAutoDrawable gLAutoDrawable) {
                            }

                            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                            }
                        });
                        this.val$panel.add(gLADComp.comp);
                    }
                    lArray[1] = Platform.currentTimeMillis();
                    this.val$frame.getContentPane().add(this.val$panel);
                    this.val$frame.pack();
                    this.val$frame.setVisible(true);
                    lArray[2] = Platform.currentTimeMillis();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        long l2 = l = System.currentTimeMillis();
        while (n5 > this.initCount.get() && 10000L > l2 - l) {
            try {
                Thread.sleep(100L);
                System.err.println("Sleep initialized: " + this.initCount.get() + "/" + n5);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        lArray[3] = Platform.currentTimeMillis();
        double d = this.initCount.get();
        System.err.printf("P: %d %s:%n\tctor\t%6d/t %6.2f/1%n\tvisible\t%6d/t %6.2f/1%n\tsum-i\t%6d/t %6.2f/1%n", new Object[]{this.initCount.get(), canvasType, lArray[1] - lArray[0], (double)(lArray[1] - lArray[0]) / d, lArray[3] - lArray[1], (double)(lArray[3] - lArray[1]) / d, lArray[3] - lArray[0], (double)(lArray[3] - lArray[0]) / d});
        System.err.println("INIT END: " + this.initCount.get() + "/" + n5);
        if (wait) {
            UITestCase.waitForKey((String)"Post-Init");
        }
        if (null != animator) {
            animator.start();
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (null != animator) {
            animator.stop();
        }
        lArray[4] = Platform.currentTimeMillis();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    while (!arrayList.isEmpty()) {
                        ((NewtCanvasAWT)arrayList.remove(0)).destroy();
                    }
                    jFrame.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l3 = lArray[4] - lArray[0] - duration;
        System.err.printf("T: duration %d %d%n\ttotal-d\t%6d/t %6.2f/1%n\ttotal-i\t%6d/t %6.2f/1%n", duration, lArray[4] - lArray[3], lArray[4] - lArray[0], (double)(lArray[4] - lArray[0]) / d, l3, (double)l3 / d);
        System.err.println("Total: " + (lArray[4] - lArray[0]));
    }

    private GLADComp createNewtCanvasAWT(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        newtCanvasAWT.setSize(dimension);
        newtCanvasAWT.setPreferredSize(dimension);
        if (bl) {
            GearsES2 gearsES2 = new GearsES2(0);
            gearsES2.setVerbose(false);
            gLWindow.addGLEventListener((GLEventListener)gearsES2);
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add((GLAutoDrawable)gLWindow);
        }
        return new GLADComp((GLAutoDrawable)gLWindow, (Component)newtCanvasAWT);
    }

    private GLADComp createGLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas.setSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        if (bl) {
            gLCanvas.addGLEventListener((GLEventListener)new GearsES2(0));
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add((GLAutoDrawable)gLCanvas);
        }
        return new GLADComp((GLAutoDrawable)gLCanvas, (Component)gLCanvas);
    }

    private GLADComp createGLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLJPanel gLJPanel = new GLJPanel(gLCapabilitiesImmutable);
        gLJPanel.setSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        if (bl) {
            gLJPanel.addGLEventListener((GLEventListener)new GearsES2(0));
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add((GLAutoDrawable)gLJPanel);
        }
        return new GLADComp((GLAutoDrawable)gLJPanel, (Component)gLJPanel);
    }

    public void test01NopGLJPanel() throws InterruptedException, InvocationTargetException {
        this.test((GLCapabilitiesImmutable)new GLCapabilities(null), false, width, height, rows, cols, CanvasType.GLJPanel_T, false);
    }

    public void test02NopGLJPanelBMP() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setBitmap(true);
        this.test((GLCapabilitiesImmutable)gLCapabilities, false, width, height, rows, cols, CanvasType.GLJPanel_T, false);
    }

    public void test03NopGLCanvas() throws InterruptedException, InvocationTargetException {
        this.test((GLCapabilitiesImmutable)new GLCapabilities(null), false, width, height, rows, cols, CanvasType.GLCanvas_T, false);
    }

    public void test11GearsGLJPanel() throws InterruptedException, InvocationTargetException {
        this.test((GLCapabilitiesImmutable)new GLCapabilities(null), true, width, height, rows, cols, CanvasType.GLJPanel_T, true);
    }

    public void test13GearsGLCanvas() throws InterruptedException, InvocationTargetException {
        this.test((GLCapabilitiesImmutable)new GLCapabilities(null), true, width, height, rows, cols, CanvasType.GLCanvas_T, true);
    }

    @Test
    public void test14GearsNewtCanvasAWT() throws InterruptedException, InvocationTargetException {
        this.test((GLCapabilitiesImmutable)new GLCapabilities(null), true, width, height, rows, cols, CanvasType.NewtCanvasAWT_T, true);
    }

    public static void main(String[] stringArray) {
        CanvasType canvasType = CanvasType.GLJPanel_T;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-rows")) {
                rows = MiscUtils.atoi(stringArray[++i], rows);
                continue;
            }
            if (stringArray[i].equals("-cols")) {
                cols = MiscUtils.atoi(stringArray[++i], cols);
                continue;
            }
            if (stringArray[i].equals("-type")) {
                canvasType = CanvasType.valueOf(stringArray[++i]);
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-gears")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                wait = true;
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-waitMain")) {
                bl3 = true;
                bl2 = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            bl2 = true;
        }
        if (bl3) {
            UITestCase.waitForKey((String)"Main-Start");
        }
        if (bl2) {
            GLProfile.initSingleton();
            TestPerf001GLJPanelInit01AWT testPerf001GLJPanelInit01AWT = new TestPerf001GLJPanelInit01AWT();
            testPerf001GLJPanelInit01AWT.test(null, bl, width, height, rows, cols, canvasType, bl);
        } else {
            JUnitCore.main((String[])new String[]{TestPerf001GLJPanelInit01AWT.class.getName()});
        }
    }

    static class GLADComp {
        final GLAutoDrawable glad;
        final Component comp;

        GLADComp(GLAutoDrawable gLAutoDrawable, Component component) {
            this.glad = gLAutoDrawable;
            this.comp = component;
        }
    }

    static enum CanvasType {
        GLCanvas_T,
        GLJPanel_T,
        NewtCanvasAWT_T;

    }
}

