/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.nativewindow.awt.AWTPrintLifecycle;
import com.jogamp.nativewindow.awt.DirectDataBufferInt;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTiledPrintingNIOImageSwingAWT
extends UITestCase {
    static boolean waitForKey = false;
    static boolean allow600dpi = false;
    static GLProfile glp;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            width = 640;
            height = 480;
        } else {
            TestTiledPrintingNIOImageSwingAWT.setTestSupported((boolean)false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void printOffscreenToFile(final BufferedImage bufferedImage, final Frame frame, final GLCapabilities gLCapabilities, final int n, final String string) {
        Insets insets = frame.getInsets();
        int n2 = frame.getWidth();
        int n3 = frame.getHeight();
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        double d = (double)n4 / (double)n2;
        double d2 = (double)n5 / (double)n3;
        final double d3 = Math.min(d, d2);
        System.err.println("PRINT DPI: scaleComp72 " + d3 + ", image-size " + n4 + "x" + n5 + ", frame[border " + insets + ", size " + n2 + "x" + n3 + "]");
        System.err.println("XXX: image " + bufferedImage);
        System.err.println("XXX: cm " + bufferedImage.getColorModel());
        System.err.println("XXX: raster " + bufferedImage.getRaster());
        System.err.println("XXX: dataBuffer " + bufferedImage.getRaster().getDataBuffer());
        AWTEDTExecutor.singleton.invoke(true, new Runnable(){

            @Override
            public void run() {
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.scale(d3, d3);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                AWTPrintLifecycle.Context context = AWTPrintLifecycle.Context.setupPrint((Container)frame, (double)(1.0 / d3), (double)(1.0 / d3), (int)0, (int)-1, (int)-1);
                try {
                    frame.printAll(graphics2D);
                }
                finally {
                    context.releasePrint();
                }
                String string2 = TestTiledPrintingNIOImageSwingAWT.this.getSnapshotFilename(n, string, (GLCapabilitiesImmutable)gLCapabilities, bufferedImage.getWidth(), bufferedImage.getHeight(), false, "png", null);
                System.err.println("XXX file " + string2);
                File file = new File(string2);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException, InvocationTargetException {
        Component component;
        JComponent jComponent;
        Serializable serializable;
        int n = width / 6;
        int n2 = height / 6;
        Dimension dimension = new Dimension(bl ? width - 2 * n : width / 2, bl ? height - 2 * n2 : height);
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel);
        gLJPanel.setMinimumSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        if (bl) {
            gLJPanel.setBounds(n / 2, n2 / 2, dimension.width, dimension.height);
        } else {
            gLJPanel.setBounds(0, 0, dimension.width, dimension.height);
        }
        gLJPanel.addGLEventListener((GLEventListener)new Gears());
        GLJPanel gLJPanel2 = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel2);
        gLJPanel2.setMinimumSize(dimension);
        gLJPanel2.setPreferredSize(dimension);
        if (bl) {
            gLJPanel2.setBounds(3 * n2, 2 * n2, dimension.width, dimension.height);
        } else {
            gLJPanel2.setBounds(0, 0, dimension.width, dimension.height);
        }
        gLJPanel2.addGLEventListener((GLEventListener)new RedSquareES2());
        if (bl) {
            gLJPanel.setOpaque(true);
            gLJPanel2.setOpaque(false);
            serializable = new Dimension(width, height);
            jComponent = new JLayeredPane();
            jComponent.setMinimumSize((Dimension)serializable);
            jComponent.setPreferredSize((Dimension)serializable);
            jComponent.setBounds(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
            jComponent.setBorder(BorderFactory.createTitledBorder("Layered Pane"));
            jComponent.add((Component)gLJPanel, JLayeredPane.DEFAULT_LAYER);
            jComponent.add((Component)gLJPanel2, (Object)1);
            component = new JButton("On Top");
            component.setBounds(4 * n2, 3 * n2, 100, 50);
            jComponent.add(component, (Object)2);
        } else {
            jComponent = new JPanel();
            jComponent.add((Component)gLJPanel);
            jComponent.add((Component)gLJPanel2);
        }
        serializable = new JFrame("Swing Print");
        Assert.assertNotNull((Object)serializable);
        component = new Button("72dpi");
        Button button = new Button("300dpi");
        Button button2 = new Button("600dpi");
        JPanel jPanel = new JPanel();
        jPanel.add(component);
        jPanel.add(button);
        jPanel.add(button2);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new Label("South"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new Label("East"));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new Label("West"));
        SwingUtilities.invokeAndWait(new Runnable(){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JPanel val$printPanel;
            final /* synthetic */ JComponent val$demoPanel;
            final /* synthetic */ JPanel val$southPanel;
            final /* synthetic */ JPanel val$eastPanel;
            final /* synthetic */ JPanel val$westPanel;
            {
                this.val$frame = jFrame;
                this.val$printPanel = jPanel;
                this.val$demoPanel = jComponent;
                this.val$southPanel = jPanel2;
                this.val$eastPanel = jPanel3;
                this.val$westPanel = jPanel4;
            }

            @Override
            public void run() {
                Container container = this.val$frame.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)this.val$printPanel, "North");
                container.add((Component)this.val$demoPanel, "Center");
                container.add((Component)this.val$southPanel, "South");
                container.add((Component)this.val$eastPanel, "East");
                container.add((Component)this.val$westPanel, "West");
                container.validate();
                this.val$frame.pack();
                this.val$frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible((Component)serializable, true, null));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized((Component)gLJPanel, true, null));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized((Component)gLJPanel2, true, null));
        BufferedImage bufferedImage = new BufferedImage(((Component)serializable).getWidth(), ((Component)serializable).getHeight(), 2);
        this.printOffscreenToFile(bufferedImage, (Frame)serializable, gLCapabilities, 0, "array_072dpi_argb");
        bufferedImage = DirectDataBufferInt.createBufferedImage((int)((Component)serializable).getWidth(), (int)((Component)serializable).getHeight(), (int)2, null, null);
        this.printOffscreenToFile(bufferedImage, (Frame)serializable, gLCapabilities, 1, "newio_072dpi_argb");
        bufferedImage = DirectDataBufferInt.createBufferedImage((int)(((Component)serializable).getWidth() * 2), (int)(((Component)serializable).getHeight() * 2), (int)2, null, null);
        this.printOffscreenToFile(bufferedImage, (Frame)serializable, gLCapabilities, 2, "newio_150dpi_argb");
        bufferedImage = DirectDataBufferInt.createBufferedImage((int)(((Component)serializable).getWidth() * 2), (int)(((Component)serializable).getHeight() * 2), (int)3, null, null);
        this.printOffscreenToFile(bufferedImage, (Frame)serializable, gLCapabilities, 2, "newio_150dpi_argbp");
        bufferedImage = DirectDataBufferInt.createBufferedImage((int)(((Component)serializable).getWidth() * 2), (int)(((Component)serializable).getHeight() * 2), (int)1, null, null);
        this.printOffscreenToFile(bufferedImage, (Frame)serializable, gLCapabilities, 2, "newio_150dpi_rgb");
        bufferedImage = DirectDataBufferInt.createBufferedImage((int)(((Component)serializable).getWidth() * 2), (int)(((Component)serializable).getHeight() * 2), (int)4, null, null);
        this.printOffscreenToFile(bufferedImage, (Frame)serializable, gLCapabilities, 2, "newio_150dpi_bgr");
        Assert.assertNotNull((Object)serializable);
        Assert.assertNotNull((Object)gLJPanel);
        Assert.assertNotNull((Object)gLJPanel2);
        SwingUtilities.invokeAndWait(new Runnable(){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void run() {
                this.val$frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)((Component)serializable).isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JComponent val$demoPanel;
            {
                this.val$frame = jFrame;
                this.val$demoPanel = jComponent;
            }

            @Override
            public void run() {
                JFrame jFrame = this.val$frame;
                ((Container)jFrame).remove(this.val$demoPanel);
                jFrame.dispose();
            }
        });
    }

    @Test
    public void test01_Offscreen_aa0() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test01_Offscreen_aa0_layered() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities, true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-600dpi")) {
                allow600dpi = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestTiledPrintingNIOImageSwingAWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

