/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRenderer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTiledRendering2NEWT
extends UITestCase {
    static long duration = 500L;

    static GLProfile getGLProfile(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return GLProfile.get((String)string);
    }

    static GLProfile getGL2ES3() {
        GLProfile gLProfile = GLProfile.getMaxProgrammableCore((boolean)true);
        if (null == gLProfile || !gLProfile.isGL2ES3()) {
            System.err.println("GL2ES3 n/a, has max-core " + gLProfile);
            return null;
        }
        return gLProfile;
    }

    @Test
    public void test001_off_gl2___aa0() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGLProfile("GL2");
        if (null == gLProfile) {
            return;
        }
        this.doTest(false, new Gears(), gLProfile, 0);
    }

    @Test
    public void test002_off_gl2___aa8() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGLProfile("GL2");
        if (null == gLProfile) {
            return;
        }
        this.doTest(false, new Gears(), gLProfile, 8);
    }

    @Test
    public void test011_off_gl2es3_aa0() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGL2ES3();
        if (null == gLProfile) {
            return;
        }
        this.doTest(false, (GLEventListener)new GearsES2(), gLProfile, 0);
    }

    @Test
    public void test012_off_gl2es3_aa8() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGL2ES3();
        if (null == gLProfile) {
            return;
        }
        this.doTest(false, (GLEventListener)new GearsES2(), gLProfile, 8);
    }

    @Test
    public void test101_on__gl2___aa0() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGLProfile("GL2");
        if (null == gLProfile) {
            return;
        }
        this.doTest(true, new Gears(), gLProfile, 0);
    }

    @Test
    public void test102_on__gl2___aa8() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGLProfile("GL2");
        if (null == gLProfile) {
            return;
        }
        this.doTest(true, new Gears(), gLProfile, 8);
    }

    @Test
    public void test111_on__gl2es3_aa0() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGL2ES3();
        if (null == gLProfile) {
            return;
        }
        this.doTest(true, (GLEventListener)new GearsES2(), gLProfile, 0);
    }

    @Test
    public void test112_on__gl2es3_aa8() throws IOException {
        GLProfile gLProfile = TestTiledRendering2NEWT.getGL2ES3();
        if (null == gLProfile) {
            return;
        }
        this.doTest(true, (GLEventListener)new GearsES2(), gLProfile, 8);
    }

    void doTest(boolean bl, final GLEventListener gLEventListener, GLProfile gLProfile, int n) throws IOException {
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable;
        GLWindow gLWindow;
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(bl);
        if (n > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        if (bl) {
            gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            gLWindow.setSize(256, 256);
            gLWindow.setVisible(true);
            gLOffscreenAutoDrawable = gLWindow;
        } else {
            gLWindow = GLDrawableFactory.getFactory((GLProfile)gLProfile);
            gLOffscreenAutoDrawable = gLWindow.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 256, 256);
        }
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListener);
        final int n2 = gLOffscreenAutoDrawable.getSurfaceWidth() * 6;
        final int n3 = gLOffscreenAutoDrawable.getSurfaceHeight() * 4;
        String string = this.getSnapshotFilename(0, "-tile", gLOffscreenAutoDrawable.getChosenGLCapabilities(), n2, n3, false, "png", null);
        File file = new File(string);
        final TileRenderer tileRenderer = new TileRenderer();
        tileRenderer.setImageSize(n2, n3);
        tileRenderer.setTileSize(gLOffscreenAutoDrawable.getSurfaceWidth(), gLOffscreenAutoDrawable.getSurfaceHeight(), 0);
        tileRenderer.attachAutoDrawable((GLAutoDrawable)gLOffscreenAutoDrawable);
        final GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
        final boolean[] blArray = new boolean[]{false};
        GLEventListener gLEventListener2 = new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                PixelFormat.Composition composition = gLPixelBufferProvider.getHostPixelComp(gL.getGLProfile(), 3);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = gLPixelBufferProvider.getAttributes(gL, 3, true);
                GLPixelBuffer gLPixelBuffer = gLPixelBufferProvider.allocate(gL, composition, gLPixelAttributes, true, n2, n3, 1, 0);
                tileRenderer.setImageBuffer(gLPixelBuffer);
                blArray[0] = !gLAutoDrawable.isGLOriented();
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n22, int n32, int n4) {
            }
        };
        tileRenderer.setGLEventListener(gLEventListener2, null);
        while (!tileRenderer.eot()) {
            tileRenderer.display();
        }
        tileRenderer.detachAutoDrawable();
        gLOffscreenAutoDrawable.invoke(true, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                gLEventListener.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                return false;
            }
        });
        GLPixelBuffer gLPixelBuffer = tileRenderer.getImageBuffer();
        TextureData textureData = new TextureData(gLCapabilities.getGLProfile(), 0, n2, n3, 0, gLPixelBuffer.pixelAttributes, false, false, blArray[0], gLPixelBuffer.buffer, null);
        TextureIO.write((TextureData)textureData, (File)file);
        gLOffscreenAutoDrawable.destroy();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestTiledRendering2NEWT.class.getName()});
    }
}

