/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsES1;
import com.jogamp.opengl.test.junit.jogl.demos.es1.RedSquareES1;
import com.jogamp.opengl.test.junit.jogl.util.DemoGL2ES1ImmModeSink;
import com.jogamp.opengl.test.junit.jogl.util.DemoGL2ES1TextureImmModeSink;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestES1FixedFunctionPipelineNEWT
extends UITestCase {
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        width = 512;
        height = 512;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL0(GLCapabilities gLCapabilities, GLEventListener gLEventListener) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.addGLEventListener(gLEventListener);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        snapshotGLEventListener.setPostSNDetail(gLEventListener.getClass().getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)snapshotGLEventListener);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        gLWindow.removeGLEventListener(gLEventListener);
        animator.stop();
        gLWindow.destroy();
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException {
        RedSquareES1 redSquareES1 = new RedSquareES1();
        redSquareES1.setForceFFPEmu(bl, false, false, false);
        this.runTestGL0(gLCapabilities, redSquareES1);
        GearsES1 gearsES1 = new GearsES1();
        gearsES1.setForceFFPEmu(bl, false, false, false);
        this.runTestGL0(gLCapabilities, gearsES1);
        DemoGL2ES1ImmModeSink demoGL2ES1ImmModeSink = new DemoGL2ES1ImmModeSink(true);
        demoGL2ES1ImmModeSink.setForceFFPEmu(bl, false, false, false);
        this.runTestGL0(gLCapabilities, demoGL2ES1ImmModeSink);
        DemoGL2ES1TextureImmModeSink demoGL2ES1TextureImmModeSink = new DemoGL2ES1TextureImmModeSink();
        demoGL2ES1TextureImmModeSink.setForceFFPEmu(bl, false, false, false);
        this.runTestGL0(gLCapabilities, demoGL2ES1TextureImmModeSink);
    }

    @Test
    public void test01GL2Normal() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2")) {
            System.err.println("GL2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test02GL2FFPEmu() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2")) {
            System.err.println("GL2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        this.runTestGL(gLCapabilities, true);
    }

    @Test
    public void test03GL2ES1Normal() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2ES1")) {
            System.err.println("GL2ES1 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2ES1"));
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test04ES2FFPEmu() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GLES2"));
        this.runTestGL(gLCapabilities, false);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestES1FixedFunctionPipelineNEWT.class.getName()});
    }

    static {
        duration = 1000L;
    }
}

