/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestBug362DDSImageCreateFromData {
    File testDDSImage01Uncompressed;
    File testDDSImage02DXT1;
    File testDDSImage03DXT5;

    @Before
    public void setup() throws Throwable {
        this.testDDSImage01Uncompressed = this.initFile("test-64x32_uncompressed.dds");
        this.testDDSImage02DXT1 = this.initFile("test-64x32_DXT1.dds");
        this.testDDSImage03DXT5 = this.initFile("test-64x32_DXT5.dds");
    }

    @After
    public void teardown() {
        this.testDDSImage01Uncompressed = null;
        this.testDDSImage02DXT1 = null;
        this.testDDSImage03DXT5 = null;
    }

    private File initFile(String string) throws URISyntaxException {
        URLConnection uRLConnection = IOUtil.getResource((String)string, (ClassLoader)this.getClass().getClassLoader(), this.getClass());
        Assert.assertNotNull((Object)uRLConnection);
        URL uRL = uRLConnection.getURL();
        File file = new File(uRL.toURI());
        Assert.assertTrue((boolean)file.exists());
        return file;
    }

    private void testImpl(File file) throws IOException {
        DDSImage dDSImage = DDSImage.read((File)file);
        Assert.assertNotNull((Object)dDSImage);
        int n = dDSImage.getNumMipMaps();
        ByteBuffer[] byteBufferArray = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            DDSImage.ImageInfo imageInfo = dDSImage.getMipMap(i);
            byteBufferArray[i] = imageInfo.getData();
        }
        DDSImage dDSImage2 = DDSImage.createFromData((int)dDSImage.getPixelFormat(), (int)dDSImage.getWidth(), (int)dDSImage.getHeight(), (ByteBuffer[])byteBufferArray);
        Assert.assertNotNull((Object)dDSImage2);
    }

    @Test
    public void test00_DDSImage_CreateFromData_Uncompressed_RGB() throws IOException {
        this.testImpl(this.testDDSImage01Uncompressed);
    }

    @Test
    public void test01_DDSImage_CreateFromData_DXT1_RGB() throws IOException {
        this.testImpl(this.testDDSImage02DXT1);
    }

    @Test
    public void test02_DDSImage_CreateFromData_DXT5_RGB() throws IOException {
        this.testImpl(this.testDDSImage03DXT5);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug362DDSImageCreateFromData.class.getName()});
    }
}

