/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.Threading;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLReadBufferUtilTextureIOWrite02AWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getDefault();
        Assert.assertNotNull((Object)glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull((Object)caps);
        caps.setAlphaBits(1);
        width = 64;
        height = 64;
    }

    protected void testWritePNGWithResizeImpl(boolean bl) throws InterruptedException {
        if (!bl && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("onscreen layer n/a");
            return;
        }
        if (bl && !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("offscreen layer n/a");
            return;
        }
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        gLCanvas.setShallUseOffscreenLayer(bl);
        Dimension dimension = new Dimension(width, height);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setSize(dimension);
        final Frame frame = new Frame(this.getSimpleTestName("."));
        Assert.assertNotNull((Object)frame);
        frame.add((Component)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
        gLCanvas.addGLEventListener(new GLEventListener(){
            int i = 0;
            int fw_old = 0;
            int dw_old = 0;
            int c = 0;

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                boolean bl;
                boolean bl2;
                int n = frame.getWidth();
                int n2 = frame.getHeight();
                final int n3 = gLAutoDrawable.getSurfaceWidth();
                final int n4 = gLAutoDrawable.getSurfaceHeight();
                boolean bl3 = bl2 = this.fw_old != n && this.dw_old != n3 && n3 <= 512;
                if (bl2) {
                    ++this.c;
                    bl = this.c > 3;
                } else {
                    bl = false;
                }
                if (bl) {
                    System.err.println("XXX: [" + this.fw_old + ", " + this.dw_old + "], " + n + "x" + n2 + ", " + n3 + "x" + n4 + ", sz_changed " + bl2 + ", snap " + bl);
                    this.c = 0;
                    TestGLReadBufferUtilTextureIOWrite02AWT.this.snapshot(this.i++, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                    this.dw_old = n3;
                    this.fw_old = n;
                    Threading.invoke((boolean)true, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Dimension dimension = new Dimension(2 * n3, 2 * n4);
                            gLCanvas.setMinimumSize(dimension);
                            gLCanvas.setPreferredSize(dimension);
                            gLCanvas.setSize(dimension);
                            frame.pack();
                            frame.validate();
                        }
                    }, (Object)gLCanvas.getTreeLock());
                }
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setUpdateFPSFrames(60, null);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized((Component)gLCanvas, true, null));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible((Component)gLCanvas, true, null));
        Assert.assertEquals((Object)(JAWTUtil.isOffscreenLayerSupported() && bl ? 1 : 0), (Object)gLCanvas.isOffscreenLayerSurfaceEnabled());
        animator.start();
        while (animator.getTotalFPSFrames() < 30) {
            Thread.sleep(60L);
        }
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void testOnscreenWritePNGWithResize() throws InterruptedException {
        this.testWritePNGWithResizeImpl(false);
    }

    @Test
    public void testOffscreenWritePNGWithResize() throws InterruptedException {
        this.testWritePNGWithResizeImpl(true);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestGLReadBufferUtilTextureIOWrite02AWT.class.getName()});
    }
}

