/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.opengl.test.junit.jogl.util.texture.ImageTstFiles;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.texture.ImageType;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestImageTypeNEWT
extends UITestCase {
    ImageTstFiles imageTstFiles;

    @Before
    public void initTest() throws IOException {
        this.imageTstFiles = new ImageTstFiles();
        this.imageTstFiles.init();
    }

    @After
    public void cleanupTest() {
        this.imageTstFiles.clear();
    }

    public void testImpl(List<ImageTstFiles.NamedInputStream> list, ImageType imageType) throws InterruptedException, IOException {
        for (int i = 0; i < list.size(); ++i) {
            ImageTstFiles.NamedInputStream namedInputStream = list.get(i);
            ImageType imageType2 = new ImageType(namedInputStream.stream);
            System.err.printf("Test %3d: path %s, exp-type %s, has-type %s%n", i, namedInputStream.basePath, imageType, imageType2);
            Assert.assertEquals((Object)imageType, (Object)imageType2);
        }
    }

    @Test
    public void test01AllPNG() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.pngStreams, new ImageType("png"));
    }

    @Test
    public void test02AllJPG() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.jpgStreams, new ImageType("jpg"));
    }

    public void test03AllTGA() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.tgaStreams, new ImageType("tga"));
    }

    @Test
    public void test04AllDDS() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.ddsStreams, new ImageType("dds"));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestImageTypeNEWT.class.getName()});
    }
}

