/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.opengl.test.junit.jogl.util.texture.PNGTstFiles;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPNGPixelRect00NEWT
extends UITestCase {
    @Test
    public void testPNGRead01_All() throws InterruptedException, IOException, MalformedURLException {
        for (int i = 0; i < PNGTstFiles.allBasenames.length; ++i) {
            String string = PNGTstFiles.allBasenames[i];
            this.testPNG01Impl("", string, null, 0, false);
        }
    }

    @Test
    public void testPNGRead02_RGB888_to_RGBA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_3-01-160x90", PixelFormat.RGBA8888, 0, false);
    }

    @Test
    public void testPNGRead03_RGB888_to_RGBA8888_stride1000() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_3-01-160x90", PixelFormat.RGBA8888, 1000, false);
    }

    @Test
    public void testPNGRead04_RGB888_to_RGBA8888_stride999() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_3-01-160x90", PixelFormat.RGBA8888, 999, false);
    }

    @Test
    public void testPNGRead11_RGBA8888_to_LUMINA() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.LUMINANCE, 0, false);
    }

    @Test
    public void testPNGRead12_RGBA8888_to_RGB888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.RGB888, 0, false);
    }

    @Test
    public void testPNGRead13_RGBA8888_to_BGR888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.BGR888, 0, false);
    }

    @Test
    public void testPNGRead14_RGBA8888_to_BGRA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.BGRA8888, 0, false);
    }

    @Test
    public void testPNGRead15_RGBA8888_to_ARGB8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.ARGB8888, 0, false);
    }

    @Test
    public void testPNGRead16_RGBA8888_to_ABGR8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.ABGR8888, 0, false);
    }

    private void testPNG01Impl(String string, String string2, PixelFormat pixelFormat, int n, boolean bl) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test01: " + string + string2 + ".png, destFmt " + pixelFormat + ", destMinStrideInBytes " + n + ", destIsGLOriented " + bl);
        File file = new File(this.getSimpleTestName(".") + "-01-" + string2 + "-orig.png");
        File file2 = new File(this.getSimpleTestName(".") + "-02-" + string2 + "-flipped.png");
        File file3 = new File(this.getSimpleTestName(".") + "-03-" + string2 + "-reversed.png");
        File file4 = new File(this.getSimpleTestName(".") + "-04-" + string2 + "-reversed_flipped.png");
        URLConnection uRLConnection = IOUtil.getResource((String)(string + string2 + ".png"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        if (null == uRLConnection) {
            throw new IOException("Cannot find " + string + string2 + ".png");
        }
        PNGPixelRect pNGPixelRect = PNGPixelRect.read((InputStream)uRLConnection.getInputStream(), (PixelFormat)pixelFormat, (boolean)false, (int)n, (boolean)bl);
        System.err.println("PNGPixelRect - Orig: " + pNGPixelRect);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file, (boolean)true));
        pNGPixelRect.write((OutputStream)bufferedOutputStream, true);
        Object object = PNGPixelRect.read((InputStream)file.toURI().toURL().openStream(), (PixelFormat)pNGPixelRect.getPixelformat(), (boolean)false, (int)n, (boolean)bl);
        System.err.println("PNGPixelRect - Orig (Read Back): " + object);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)object.getPixels());
        bufferedOutputStream = new PNGPixelRect(pNGPixelRect.getPixelformat(), pNGPixelRect.getSize(), pNGPixelRect.getStride(), !pNGPixelRect.isGLOriented(), pNGPixelRect.getPixels(), pNGPixelRect.getDpi()[0], pNGPixelRect.getDpi()[1]);
        System.err.println("PNGPixelRect - Flip : " + bufferedOutputStream);
        object = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file2, (boolean)true));
        bufferedOutputStream.write((OutputStream)object, true);
        Object object2 = PNGPixelRect.read((InputStream)file2.toURI().toURL().openStream(), (PixelFormat)pNGPixelRect.getPixelformat(), (boolean)false, (int)n, (!bl ? 1 : 0) != 0);
        System.err.println("PNGPixelRect - Flip (Read Back): " + object2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)object2.getPixels());
        bufferedOutputStream = PixelFormatUtil.getReversed((PixelFormat)pNGPixelRect.getPixelformat());
        object = new PNGPixelRect((PixelFormat)bufferedOutputStream, pNGPixelRect.getSize(), pNGPixelRect.getStride(), pNGPixelRect.isGLOriented(), pNGPixelRect.getPixels(), pNGPixelRect.getDpi()[0], pNGPixelRect.getDpi()[1]);
        System.err.println("PNGPixelRect - Reversed : " + object);
        object2 = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file3, (boolean)true));
        object.write((OutputStream)object2, true);
        PNGPixelRect pNGPixelRect2 = PNGPixelRect.read((InputStream)file3.toURI().toURL().openStream(), (PixelFormat)bufferedOutputStream, (boolean)false, (int)n, (boolean)bl);
        System.err.println("PNGPixelRect - Reversed (Read Back): " + pNGPixelRect2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pNGPixelRect2.getPixels());
        object = new PNGPixelRect((PixelFormat)bufferedOutputStream, pNGPixelRect.getSize(), pNGPixelRect.getStride(), !pNGPixelRect.isGLOriented(), pNGPixelRect.getPixels(), pNGPixelRect.getDpi()[0], pNGPixelRect.getDpi()[1]);
        System.err.println("PNGPixelRect - Reversed+Flipped : " + object);
        object2 = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file4, (boolean)true));
        object.write((OutputStream)object2, true);
        pNGPixelRect2 = PNGPixelRect.read((InputStream)file4.toURI().toURL().openStream(), (PixelFormat)bufferedOutputStream, (boolean)false, (int)n, (!bl ? 1 : 0) != 0);
        System.err.println("PNGPixelRect - Reversed+FLipped (Read Back): " + pNGPixelRect2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pNGPixelRect2.getPixels());
    }

    private void testPNG02Impl(String string, String string2, PixelFormat pixelFormat, int n, boolean bl) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test02: " + string + string2 + ".png, destFmt " + pixelFormat + ", destMinStrideInBytes " + n + ", destIsGLOriented " + bl);
        File file = new File(this.getSimpleTestName(".") + "-" + string2 + "-orig.png");
        URLConnection uRLConnection = IOUtil.getResource((String)(string + string2 + ".png"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        PNGPixelRect pNGPixelRect = PNGPixelRect.read((InputStream)uRLConnection.getInputStream(), (PixelFormat)pixelFormat, (boolean)false, (int)n, (boolean)bl);
        System.err.println("PNGPixelRect - Orig: " + pNGPixelRect);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file, (boolean)true));
        pNGPixelRect.write((OutputStream)bufferedOutputStream, true);
        PNGPixelRect pNGPixelRect2 = PNGPixelRect.read((InputStream)file.toURI().toURL().openStream(), (PixelFormat)pNGPixelRect.getPixelformat(), (boolean)false, (int)n, (boolean)bl);
        System.err.println("PNGPixelRect - Orig (Read Back): " + pNGPixelRect2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pNGPixelRect2.getPixels());
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPNGPixelRect00NEWT.class.getName()});
    }
}

