/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.jogl.util.texture.PNGTstFiles;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.PNGPixelRect;
import com.jogamp.opengl.util.texture.TextureData;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.Buffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPNGPixelRect01NEWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 200L;
    static String _fname = null;

    public void testImpl(final int n, final String string, InputStream inputStream, PixelFormat pixelFormat) throws InterruptedException, IOException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        PNGPixelRect pNGPixelRect = PNGPixelRect.read((InputStream)inputStream, (PixelFormat)pixelFormat, (boolean)true, (int)0, (boolean)true);
        Assert.assertNotNull((Object)pNGPixelRect);
        System.err.println("PNGPixelRect: " + string + ", " + pNGPixelRect);
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes = new GLPixelBuffer.GLPixelAttributes(gLProfile, pNGPixelRect.getPixelformat(), false);
        boolean bl = 4 == gLPixelAttributes.pfmt.comp.bytesPerPixel();
        System.err.println("GLPixelAttributes: " + gLPixelAttributes);
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (bl) {
            gLCapabilities.setAlphaBits(1);
        }
        int n2 = gLProfile.isGL2ES3() ? (bl ? 32856 : 32849) : (bl ? 6408 : 6407);
        TextureData textureData = new TextureData(gLProfile, n2, pNGPixelRect.getSize().getWidth(), pNGPixelRect.getSize().getHeight(), 0, gLPixelAttributes, false, false, false, (Buffer)pNGPixelRect.getPixels(), null);
        System.err.println("TextureData: " + textureData);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final TextureDraw01ES2Listener textureDraw01ES2Listener = new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener((GLEventListener)textureDraw01ES2Listener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            public void init(GLAutoDrawable gLAutoDrawable) {
                System.err.println("Chosen Caps: " + gLAutoDrawable.getChosenGLCapabilities());
                System.err.println("GL ctx: " + gLAutoDrawable.getGL().getContext());
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != textureDraw01ES2Listener.getTexture() && !this.shot) {
                    this.shot = true;
                    TestPNGPixelRect01NEWT.this.snapshot(n, string, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n5, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void testRead00_Manual() throws InterruptedException, IOException, MalformedURLException {
        if (null == _fname) {
            return;
        }
        URLConnection uRLConnection = IOUtil.getResource((String)_fname, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        if (null == uRLConnection) {
            throw new IOException("Cannot find " + _fname + ".png");
        }
        this.testImpl(0, _fname, uRLConnection.getInputStream(), null);
    }

    @Test
    public void testRead01_All() throws InterruptedException, IOException, MalformedURLException {
        if (null != _fname) {
            return;
        }
        for (int i = 0; i < PNGTstFiles.allBasenames.length; ++i) {
            String string = PNGTstFiles.allBasenames[i];
            URLConnection uRLConnection = IOUtil.getResource((String)(string + ".png"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
            if (null == uRLConnection) {
                throw new IOException("Cannot find " + string + ".png");
            }
            this.testImpl(i, string, uRLConnection.getInputStream(), null);
        }
    }

    @Test
    public void testRead02_Gray2RGBA() throws InterruptedException, IOException, MalformedURLException {
        if (null != _fname) {
            return;
        }
        for (int i = 0; i < PNGTstFiles.greyBasenames.length; ++i) {
            String string = PNGTstFiles.greyBasenames[i];
            URLConnection uRLConnection = IOUtil.getResource((String)(string + ".png"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
            if (null == uRLConnection) {
                throw new IOException("Cannot find " + string + ".png");
            }
            this.testImpl(i, string, uRLConnection.getInputStream(), PixelFormat.RGBA8888);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-file")) continue;
            _fname = stringArray[++i];
        }
        JUnitCore.main((String[])new String[]{TestPNGPixelRect01NEWT.class.getName()});
    }
}

