/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.TextureDraw01GL2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPNGTextureFromFileNEWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;
    InputStream grayTextureStream;
    InputStream testTextureStreamN_3;
    InputStream testTextureStreamN_4;
    InputStream testTextureStreamNG4;
    InputStream testTextureStreamI_3;
    InputStream testTextureStreamIG3;
    InputStream testTextureStreamI_4;
    InputStream testTextureStreamIG4;
    InputStream testTextureStreamP_3;
    InputStream testTextureStreamP_4;

    @Before
    public void initTest() throws IOException {
        this.grayTextureStream = TestPNGTextureFromFileNEWT.class.getResourceAsStream("grayscale_texture.png");
        Assert.assertNotNull((Object)this.grayTextureStream);
        URLConnection uRLConnection = IOUtil.getResource((String)"test-ntscN_3-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamN_3 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamN_3);
        uRLConnection = IOUtil.getResource((String)"test-ntscN_4-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamN_4 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamN_4);
        uRLConnection = IOUtil.getResource((String)"test-ntscNG4-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamNG4 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamNG4);
        uRLConnection = IOUtil.getResource((String)"test-ntscI_3-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamI_3 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamI_3);
        uRLConnection = IOUtil.getResource((String)"test-ntscIG3-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamIG3 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamIG3);
        uRLConnection = IOUtil.getResource((String)"test-ntscI_4-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamI_4 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamI_4);
        uRLConnection = IOUtil.getResource((String)"test-ntscIG4-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamIG4 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamIG4);
        uRLConnection = IOUtil.getResource((String)"test-ntscP_3-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamP_3 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamP_3);
        uRLConnection = IOUtil.getResource((String)"test-ntscP_4-01-160x90.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStreamP_4 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStreamP_4);
    }

    @After
    public void cleanupTest() {
        this.grayTextureStream = null;
        this.testTextureStreamN_3 = null;
        this.testTextureStreamI_3 = null;
        this.testTextureStreamIG3 = null;
        this.testTextureStreamP_3 = null;
        this.testTextureStreamP_4 = null;
    }

    public void testImpl(boolean bl, InputStream inputStream) throws InterruptedException, IOException {
        GLProfile gLProfile;
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        if (bl && GLProfile.isAvailable((String)"GL2")) {
            gLProfile = GLProfile.getMaxFixedFunc((boolean)true);
        } else if (!bl && GLProfile.isAvailable((String)"GL2ES2")) {
            gLProfile = GLProfile.getGL2ES2();
        } else {
            System.err.println(this.getSimpleTestName(".") + ": GLProfile n/a, useFFP: " + bl);
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(1);
        TextureData textureData = TextureIO.newTextureData((GLProfile)gLProfile, (InputStream)inputStream, (boolean)false, (String)"png");
        System.err.println("TextureData: " + textureData);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle("TestPNGTextureGL2FromFileNEWT");
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final GLEventListener gLEventListener = bl ? new TextureDraw01GL2Listener(textureData) : new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener(gLEventListener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)gLEventListener).getTexture() && !this.shot) {
                    this.shot = true;
                    TestPNGTextureFromFileNEWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void testGray__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.grayTextureStream);
    }

    @Test
    public void testGray__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.grayTextureStream);
    }

    @Test
    public void testRGB3__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStreamN_3);
    }

    @Test
    public void testRGB3__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamN_3);
    }

    @Test
    public void testRGB4__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStreamN_4);
    }

    @Test
    public void testRGB4__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamN_4);
    }

    @Test
    public void testRGB4G_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamNG4);
    }

    @Test
    public void testInterl3__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamI_3);
    }

    @Test
    public void testInterl4__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamI_4);
    }

    @Test
    public void testInterl3G_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamIG3);
    }

    @Test
    public void testInterl4G_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamIG4);
    }

    @Test
    public void testPalette3__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamP_3);
    }

    @Test
    public void testPalette4__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStreamP_4);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestPNGTextureFromFileNEWT.class.getName()});
    }
}

