/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.Bitstream;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPixelFormatUtil00NEWT
extends UITestCase {
    static final byte undef_val = -1;
    static final PixelFormat.Composition comp_val = PixelFormat.RGBA8888.comp;
    static final float red___valF = comp_val.toFloat(48, 0, false);
    static final float green_valF = comp_val.toFloat(96, 1, false);
    static final float blue__valF = comp_val.toFloat(-112, 2, false);
    static final float alpha_valF = comp_val.toFloat(-64, 3, false);
    static final float lum___valF = (red___valF + green_valF + blue__valF) / 3.0f;

    @Test
    public void testConversion00() throws InterruptedException, IOException, MalformedURLException {
        PixelFormat pixelFormat = PixelFormat.RGBA5551;
        PixelFormat.Composition composition = pixelFormat.comp;
        System.err.printf("%s, %s:%n", pixelFormat, composition);
        int n = composition.encode4CompI8((byte)composition.fromFloat(red___valF, 0, false), (byte)composition.fromFloat(green_valF, 0, false), (byte)composition.fromFloat(blue__valF, 0, false), (byte)composition.fromFloat(alpha_valF, 0, false));
        int n2 = composition.encode4CompI8((byte)composition.fromFloat(red___valF, 0, false), (byte)composition.fromFloat(green_valF, 0, false), (byte)composition.fromFloat(blue__valF, 0, false), (byte)-1);
        System.err.printf("    u16_alpha %s%n", Bitstream.toHexBinString((boolean)true, (int)n, (int)composition.bitsPerPixel()));
        System.err.printf("    u16_undef %s%n", Bitstream.toHexBinString((boolean)true, (int)n2, (int)composition.bitsPerPixel()));
        byte by = (byte)composition.fromFloat(alpha_valF, 0, false);
        int n3 = (by & 1) << 15;
        System.err.printf("    xx_alpha %s%n", Bitstream.toHexBinString((boolean)true, (int)n3, (int)composition.bitsPerPixel()));
        System.err.printf("    xx_undef %s%n", Bitstream.toHexBinString((boolean)true, (int)32768, (int)composition.bitsPerPixel()));
        pixelFormat = PixelFormat.RGBA8888;
        composition = pixelFormat.comp;
        PixelFormat pixelFormat2 = PixelFormat.RGB565;
        PixelFormat.Composition composition2 = pixelFormat2.comp;
        PixelFormat pixelFormat3 = PixelFormat.LUMINANCE;
        PixelFormat.Composition composition3 = pixelFormat3.comp;
        System.err.printf("%s, %s -> %s %s%n", pixelFormat2, composition2, pixelFormat3, composition3);
        float f = composition.toFloat(48, 0, false);
        int n4 = composition.fromFloat(f, 0, false);
        float f2 = composition.toFloat(96, 1, false);
        int n5 = composition.fromFloat(f2, 1, false);
        float f3 = composition.toFloat(144, 2, false);
        int n6 = composition.fromFloat(f3, 2, false);
        float f4 = composition.toFloat(192, 3, false);
        int n7 = composition.fromFloat(f4, 3, false);
        System.err.printf("res00.0.r %s -> %f -> %s%n", Bitstream.toHexBinString((boolean)true, (int)48, (int)8), Float.valueOf(f), Bitstream.toHexBinString((boolean)true, (int)n4, (int)8));
        System.err.printf("res00.0.g %s -> %f -> %s%n", Bitstream.toHexBinString((boolean)true, (int)96, (int)8), Float.valueOf(f2), Bitstream.toHexBinString((boolean)true, (int)n5, (int)8));
        System.err.printf("res00.0.b %s -> %f -> %s%n", Bitstream.toHexBinString((boolean)true, (int)144, (int)8), Float.valueOf(f3), Bitstream.toHexBinString((boolean)true, (int)n6, (int)8));
        System.err.printf("res00.0.a %s -> %f -> %s%n", Bitstream.toHexBinString((boolean)true, (int)192, (int)8), Float.valueOf(f4), Bitstream.toHexBinString((boolean)true, (int)n7, (int)8));
        f = (red___valF + green_valF + blue__valF) / 3.0f;
        n4 = composition.fromFloat(f, 0, false);
        System.err.printf("res01.0  ( %f + %f + %f ) / 3f = %f -> %s%n", Float.valueOf(red___valF), Float.valueOf(green_valF), Float.valueOf(blue__valF), Float.valueOf(f), Bitstream.toHexBinString((boolean)true, (int)n4, (int)8));
        f = (red___valF + green_valF + blue__valF) / 3.0f;
        n4 = composition3.fromFloat(f, 0, false);
        System.err.printf("res02.1  ( %f + %f + %f ) / 3f = %f -> %s%n", Float.valueOf(red___valF), Float.valueOf(green_valF), Float.valueOf(blue__valF), Float.valueOf(f), Bitstream.toHexBinString((boolean)true, (int)n4, (int)8));
        int n8 = composition3.fromFloat(red___valF, 0, false);
        n4 = composition3.fromFloat(green_valF, 0, false);
        int n9 = composition3.fromFloat(blue__valF, 0, false);
        float f5 = composition3.toFloat(n8, 0, false);
        f3 = composition3.toFloat(n4, 0, false);
        float f6 = composition3.toFloat(n9, 0, false);
        System.err.printf("res20.l1  ( %s + %s + %s )%n", Bitstream.toHexBinString((boolean)true, (int)n8, (int)8), Bitstream.toHexBinString((boolean)true, (int)n4, (int)8), Bitstream.toHexBinString((boolean)true, (int)n9, (int)8));
        System.err.printf("res20.l2 ( %f + %f + %f )%n", Float.valueOf(f5), Float.valueOf(f3), Float.valueOf(f6));
        f4 = (f5 + f3 + f6) / 3.0f;
        n7 = composition3.fromFloat(f4, 0, false);
        System.err.printf("res20.l3 ( %f + %f + %f ) / 3f = %f -> %s%n", Float.valueOf(f5), Float.valueOf(f3), Float.valueOf(f6), Float.valueOf(f4), Bitstream.toHexBinString((boolean)true, (int)n7, (int)8));
        int n10 = composition2.fromFloat(f5, 0, false);
        int n11 = composition2.fromFloat(f3, 1, false);
        int n12 = composition2.fromFloat(f6, 2, false);
        float f7 = composition2.toFloat(n10, 0, false);
        float f8 = composition2.toFloat(n11, 1, false);
        float f9 = composition2.toFloat(n12, 2, false);
        System.err.printf("res20._1  ( %s + %s + %s )%n", Bitstream.toHexBinString((boolean)true, (int)n10, (int)8), Bitstream.toHexBinString((boolean)true, (int)n11, (int)8), Bitstream.toHexBinString((boolean)true, (int)n12, (int)8));
        System.err.printf("res20._2 ( %f + %f + %f )%n", Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9));
        float f10 = (f7 + f8 + f9) / 3.0f;
        int n13 = composition3.fromFloat(f10, 0, false);
        System.err.printf("res20._3 ( %f + %f + %f ) / 3f = %f -> %s%n", Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9), Float.valueOf(f10), Bitstream.toHexBinString((boolean)true, (int)n13, (int)8));
        float f11 = composition2.toFloat((int)TestPixelFormatUtil00NEWT.rescaleComp(composition3, 0, composition2, 0, red___valF), 0, false);
        float f12 = composition2.toFloat((int)TestPixelFormatUtil00NEWT.rescaleComp(composition3, 0, composition2, 1, green_valF), 1, false);
        float f13 = composition2.toFloat((int)TestPixelFormatUtil00NEWT.rescaleComp(composition3, 0, composition2, 2, blue__valF), 2, false);
        f5 = (f11 + f12 + f13) / 3.0f;
        int n14 = composition3.fromFloat(f5, 0, false);
        System.err.printf("res30.xx  ( %f + %f + %f ) / 3f = %f -> %s%n", Float.valueOf(f11), Float.valueOf(f12), Float.valueOf(f13), Float.valueOf(f5), Bitstream.toHexBinString((boolean)true, (int)n14, (int)8));
        f11 = composition2.toFloat(6, 0, false);
        f12 = composition2.toFloat(12, 1, false);
        f13 = composition2.toFloat(6, 2, false);
        f5 = (f11 + f12 + f13) / 3.0f;
        n14 = composition3.fromFloat(f5, 0, false);
        System.err.printf("res40  ( %f + %f + %f ) / 3f = %s%n", Float.valueOf(f11), Float.valueOf(f12), Float.valueOf(f13), Bitstream.toHexBinString((boolean)true, (int)n14, (int)8));
    }

    @Test
    public void testConversion01_srcS000_BE_TL_destS000_TL() throws InterruptedException, IOException, MalformedURLException {
        this.testConversionImpl(0, ByteOrder.BIG_ENDIAN, false, 0, false);
    }

    @Test
    public void testConversion02_srcS000_LE_TL_destS000_TL() throws InterruptedException, IOException, MalformedURLException {
        this.testConversionImpl(0, ByteOrder.LITTLE_ENDIAN, false, 0, false);
    }

    @Test
    public void testConversion03_srcS000_BE_TL_destS259_TL() throws InterruptedException, IOException, MalformedURLException {
        this.testConversionImpl(0, ByteOrder.BIG_ENDIAN, false, 259, false);
    }

    @Test
    public void testConversion04_srcS259_BE_TL_destS259_TL() throws InterruptedException, IOException, MalformedURLException {
        this.testConversionImpl(259, ByteOrder.BIG_ENDIAN, false, 259, false);
    }

    @Test
    public void testConversion05_srcS301_BE_TL_destS259_TL() throws InterruptedException, IOException, MalformedURLException {
        this.testConversionImpl(301, ByteOrder.BIG_ENDIAN, false, 259, false);
    }

    static final float sourceNorm(PixelFormat.Composition composition, int n, float f) {
        if (n >= 0 && n < composition.componentCount()) {
            return composition.toFloat(composition.fromFloat(f, n, false), n, false);
        }
        return 0.0f;
    }

    static final byte rescaleComp(PixelFormat.Composition composition, int n, PixelFormat.Composition composition2, int n2, float f) {
        if (n2 >= 0 && n2 < composition2.componentCount()) {
            return (byte)composition2.fromFloat(TestPixelFormatUtil00NEWT.sourceNorm(composition, n, f), n2, false);
        }
        return 0;
    }

    static final void getComponentData(PixelFormat pixelFormat, PixelFormat pixelFormat2, byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4;
        block26: {
            PixelFormat.Composition composition;
            PixelFormat.Composition composition2;
            block25: {
                composition2 = pixelFormat.comp;
                composition = pixelFormat2.comp;
                if (PixelFormat.LUMINANCE != pixelFormat) break block25;
                switch (pixelFormat2) {
                    case LUMINANCE: {
                        n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, lum___valF);
                        n3 = -1;
                        n2 = -1;
                        n = -1;
                        break block26;
                    }
                    case RGB565: 
                    case BGR565: {
                        int n5 = composition.encode3CompI8(TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, lum___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 1, lum___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 2, lum___valF));
                        n4 = (byte)(n5 & 0xFF);
                        n3 = (byte)(n5 >>> 8 & 0xFF);
                        n2 = -1;
                        n = -1;
                        break block26;
                    }
                    case RGBA5551: {
                        int n6 = composition.encode4CompI8(TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, lum___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 1, lum___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 2, lum___valF), (byte)-1);
                        n4 = (byte)(n6 & 0xFF);
                        n3 = (byte)(n6 >>> 8 & 0xFF);
                        n2 = -1;
                        n = -1;
                        break block26;
                    }
                    case ABGR1555: {
                        int n7 = composition.encode4CompI8((byte)-1, TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, lum___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 1, lum___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 2, lum___valF));
                        n4 = (byte)(n7 & 0xFF);
                        n3 = (byte)(n7 >>> 8 & 0xFF);
                        n2 = -1;
                        n = -1;
                        break block26;
                    }
                    case BGRx8888: 
                    case RGBx8888: 
                    case RGB888: 
                    case BGR888: 
                    case RGBA8888: {
                        n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, lum___valF);
                        n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 1, lum___valF);
                        n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 2, lum___valF);
                        n = -1;
                        break block26;
                    }
                    case ABGR8888: 
                    case ARGB8888: {
                        n4 = -1;
                        n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 1, lum___valF);
                        n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 2, lum___valF);
                        n = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 3, lum___valF);
                        break block26;
                    }
                    case BGRA8888: {
                        n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, lum___valF);
                        n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 1, lum___valF);
                        n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 2, lum___valF);
                        n = -1;
                        break block26;
                    }
                    default: {
                        throw new InternalError("Unhandled format " + pixelFormat2);
                    }
                }
            }
            int n8 = composition2.find(PixelFormat.CType.R);
            int n9 = composition2.find(PixelFormat.CType.G);
            int n10 = composition2.find(PixelFormat.CType.B);
            int n11 = composition2.find(PixelFormat.CType.A);
            boolean bl = 0 <= n11;
            boolean bl2 = 0 <= n8 && 0 <= n9 && 0 <= n10;
            switch (pixelFormat2) {
                case LUMINANCE: {
                    if (bl2) {
                        float f = TestPixelFormatUtil00NEWT.sourceNorm(composition2, n8, red___valF);
                        float f2 = TestPixelFormatUtil00NEWT.sourceNorm(composition2, n9, green_valF);
                        float f3 = TestPixelFormatUtil00NEWT.sourceNorm(composition2, n10, blue__valF);
                        n4 = (byte)composition.fromFloat((f + f2 + f3) / 3.0f, 0, false);
                        n3 = -1;
                        n2 = -1;
                        n = -1;
                        break;
                    }
                    n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, 0, composition, 0, red___valF);
                    n3 = -1;
                    n2 = -1;
                    n = -1;
                    break;
                }
                case RGB565: {
                    int n12 = composition.encode3CompI8(TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 0, red___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 2, blue__valF));
                    n4 = (byte)(n12 & 0xFF);
                    n3 = (byte)(n12 >>> 8 & 0xFF);
                    n2 = -1;
                    n = -1;
                    break;
                }
                case BGR565: {
                    int n13 = composition.encode3CompI8(TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 0, blue__valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 2, red___valF));
                    n4 = (byte)(n13 & 0xFF);
                    n3 = (byte)(n13 >>> 8 & 0xFF);
                    n2 = -1;
                    n = -1;
                    break;
                }
                case RGBA5551: {
                    int n14 = composition.encode4CompI8(TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 0, red___valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 2, blue__valF), bl ? TestPixelFormatUtil00NEWT.rescaleComp(composition2, n11, composition, 3, alpha_valF) : (byte)-1);
                    n4 = (byte)(n14 & 0xFF);
                    n3 = (byte)(n14 >>> 8 & 0xFF);
                    n2 = -1;
                    n = -1;
                    break;
                }
                case ABGR1555: {
                    int n15 = composition.encode4CompI8(bl ? (byte)TestPixelFormatUtil00NEWT.rescaleComp(composition2, n11, composition, 0, alpha_valF) : (byte)-1, TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 1, blue__valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 2, green_valF), TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 3, red___valF));
                    n4 = (byte)(n15 & 0xFF);
                    n3 = (byte)(n15 >>> 8 & 0xFF);
                    n2 = -1;
                    n = -1;
                    break;
                }
                case RGBx8888: 
                case RGB888: {
                    n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 0, red___valF);
                    n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF);
                    n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 2, blue__valF);
                    n = -1;
                    break;
                }
                case BGRx8888: 
                case BGR888: {
                    n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 0, blue__valF);
                    n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF);
                    n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 2, red___valF);
                    n = -1;
                    break;
                }
                case RGBA8888: {
                    n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 0, red___valF);
                    n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF);
                    n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 2, blue__valF);
                    if (bl) {
                        n = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n11, composition, 3, alpha_valF);
                        break;
                    }
                    n = -1;
                    break;
                }
                case ABGR8888: {
                    n4 = bl ? (int)TestPixelFormatUtil00NEWT.rescaleComp(composition2, n11, composition, 0, alpha_valF) : -1;
                    n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 1, blue__valF);
                    n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 2, green_valF);
                    n = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 3, red___valF);
                    break;
                }
                case BGRA8888: {
                    n4 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 0, blue__valF);
                    n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 1, green_valF);
                    n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 2, red___valF);
                    if (bl) {
                        n = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n11, composition, 3, alpha_valF);
                        break;
                    }
                    n = -1;
                    break;
                }
                case ARGB8888: {
                    n4 = bl ? (int)TestPixelFormatUtil00NEWT.rescaleComp(composition2, n11, composition, 0, alpha_valF) : -1;
                    n3 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n8, composition, 1, red___valF);
                    n2 = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n9, composition, 2, green_valF);
                    n = TestPixelFormatUtil00NEWT.rescaleComp(composition2, n10, composition, 3, blue__valF);
                    break;
                }
                default: {
                    throw new InternalError("Unhandled format " + pixelFormat2);
                }
            }
        }
        byArray[0] = n4;
        byArray[1] = n3;
        byArray[2] = n2;
        byArray[3] = n;
    }

    private void testConversionImpl(int n, ByteOrder byteOrder, boolean bl, int n2, boolean bl2) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test00: srcMinStrideInBytes " + n + ", srcByteOrder " + byteOrder + ", srcIsGLOriented " + bl + ", destMinStrideInBytes " + n2 + ", destIsGLOriented " + bl2);
        PixelFormat[] pixelFormatArray = PixelFormat.values();
        PixelFormat[] pixelFormatArray2 = PixelFormat.values();
        for (int i = 0; i < pixelFormatArray.length; ++i) {
            int n3;
            PixelFormat pixelFormat = pixelFormatArray[i];
            int n4 = pixelFormat.comp.bytesPerPixel();
            int n5 = Math.max(n, 64 * n4);
            ByteBuffer byteBuffer = ByteBuffer.allocate(64 * n5).order(byteOrder);
            byte[] byArray = new byte[4];
            TestPixelFormatUtil00NEWT.getComponentData(pixelFormat, pixelFormat, byArray);
            for (int j = 0; j < 64; ++j) {
                n3 = j * n5;
                block8: for (int k = 0; k < 64; ++k) {
                    switch (pixelFormat) {
                        case LUMINANCE: {
                            byteBuffer.put(n3++, byArray[0]);
                            continue block8;
                        }
                        case RGB565: 
                        case BGR565: 
                        case RGBA5551: 
                        case ABGR1555: {
                            byteBuffer.put(n3++, byArray[0]);
                            byteBuffer.put(n3++, byArray[1]);
                            continue block8;
                        }
                        case RGB888: 
                        case BGR888: {
                            byteBuffer.put(n3++, byArray[0]);
                            byteBuffer.put(n3++, byArray[1]);
                            byteBuffer.put(n3++, byArray[2]);
                            continue block8;
                        }
                        case BGRx8888: 
                        case RGBx8888: 
                        case RGBA8888: 
                        case ABGR8888: 
                        case ARGB8888: 
                        case BGRA8888: {
                            byteBuffer.put(n3++, byArray[0]);
                            byteBuffer.put(n3++, byArray[1]);
                            byteBuffer.put(n3++, byArray[2]);
                            byteBuffer.put(n3++, byArray[3]);
                            continue block8;
                        }
                        default: {
                            throw new InternalError("Unhandled format " + pixelFormat);
                        }
                    }
                }
            }
            PixelRectangle.GenericPixelRect genericPixelRect = new PixelRectangle.GenericPixelRect(pixelFormat, (DimensionImmutable)new Dimension(64, 64), n5, bl, byteBuffer);
            System.err.println("CONVERT[" + i + "][*]: Image0 - Orig: " + genericPixelRect);
            System.err.printf("Source %s, %s%n", pixelFormat, pixelFormat.comp);
            System.err.printf("Source Data: %s%n", Bitstream.toHexBinString((boolean)true, (byte[])byArray, (int)0, (int)pixelFormat.comp.bytesPerPixel()));
            TestPixelFormatUtil00NEWT.testComponents((PixelRectangle)genericPixelRect, 0, 0, byArray, 0);
            TestPixelFormatUtil00NEWT.testComponents((PixelRectangle)genericPixelRect, 63, 63, byArray, 0);
            for (n3 = 0; n3 < pixelFormatArray2.length; ++n3) {
                PixelFormat pixelFormat2 = pixelFormatArray2[n3];
                System.err.println("CONVERT[" + i + "][" + n3 + "]: " + pixelFormat + " -> " + pixelFormat2);
                int n6 = Math.max(n2, 64 * pixelFormat2.comp.bytesPerPixel());
                byte[] byArray2 = new byte[4];
                TestPixelFormatUtil00NEWT.getComponentData(pixelFormat, pixelFormat2, byArray2);
                System.err.printf("Source %s, %s%n", pixelFormat, pixelFormat.comp);
                System.err.printf("Source Data: %s%n", Bitstream.toHexBinString((boolean)true, (byte[])byArray, (int)0, (int)pixelFormat.comp.bytesPerPixel()));
                System.err.printf("Dest %s, %s%n", pixelFormat2, pixelFormat2.comp);
                System.err.printf("Dest Data: %s%n", Bitstream.toHexBinString((boolean)true, (byte[])byArray2, (int)0, (int)pixelFormat2.comp.bytesPerPixel()));
                PixelRectangle pixelRectangle = PixelFormatUtil.convert((PixelRectangle)genericPixelRect, (PixelFormat)pixelFormat2, (int)n6, (boolean)bl2, (boolean)false);
                System.err.println("CONVERT[" + i + "][" + n3 + "]: Conv1: " + pixelRectangle + ", maxDelta " + 12);
                System.err.printf("Conv1 Data: %s%n", Bitstream.toHexBinString((boolean)true, (ByteBuffer)pixelRectangle.getPixels(), (int)0, (int)pixelFormat2.comp.bytesPerPixel()));
                TestPixelFormatUtil00NEWT.testComponents(pixelRectangle, 0, 0, byArray2, 12);
                TestPixelFormatUtil00NEWT.testComponents(pixelRectangle, 63, 63, byArray2, 12);
                if (PixelFormat.LUMINANCE != pixelFormat && PixelFormat.LUMINANCE == pixelFormat2) {
                    System.err.println("CONVERT[" + i + "][" + n3 + "]: Conv2: Dropped due to RGB* -> LUM");
                    continue;
                }
                if (pixelFormat.comp.componentCount() > pixelFormat2.comp.componentCount()) {
                    System.err.println("CONVERT[" + i + "][" + n3 + "]: Conv2: Dropped due to src.componentCount > dest.componentCount");
                    continue;
                }
                PixelRectangle pixelRectangle2 = PixelFormatUtil.convert((PixelRectangle)pixelRectangle, (PixelFormat)genericPixelRect.getPixelformat(), (int)genericPixelRect.getStride(), (boolean)genericPixelRect.isGLOriented(), (boolean)false);
                System.err.println("CONVERT[" + i + "][" + n3 + "]: Conv2: " + pixelRectangle2 + ", maxDelta " + 12);
                System.err.printf("Conv2 Data: %s%n", Bitstream.toHexBinString((boolean)true, (ByteBuffer)pixelRectangle2.getPixels(), (int)0, (int)pixelFormat.comp.bytesPerPixel()));
                byte[] byArray3 = new byte[4];
                TestPixelFormatUtil00NEWT.getComponentData(pixelFormat2, pixelFormat, byArray3);
                System.err.printf("DestRe Data: %s%n", Bitstream.toHexBinString((boolean)true, (byte[])byArray3, (int)0, (int)pixelFormat.comp.bytesPerPixel()));
                TestPixelFormatUtil00NEWT.testComponents(pixelRectangle2, 0, 0, byArray3, 12);
                TestPixelFormatUtil00NEWT.testComponents(pixelRectangle2, 63, 63, byArray3, 12);
            }
        }
    }

    static void dumpComponents(PixelRectangle pixelRectangle, int n, int n2, int n3, int n4) {
        if (n + n3 >= pixelRectangle.getSize().getWidth()) {
            n = pixelRectangle.getSize().getWidth() - n3;
        }
        if (n2 + n4 >= pixelRectangle.getSize().getHeight()) {
            n2 = pixelRectangle.getSize().getHeight() - n4;
        }
        System.err.print("PixelsBytes " + n + "/" + n2 + " " + n3 + "x" + n4 + ":");
        ByteBuffer byteBuffer = pixelRectangle.getPixels();
        int n5 = pixelRectangle.getPixelformat().comp.bytesPerPixel();
        for (int i = n2; i < n2 + n4; ++i) {
            System.err.printf("%n[%3d][%3d] ", n, i);
            int n6 = i * pixelRectangle.getStride() + n * n5;
            block7: for (int j = n; j < n + n3; ++j) {
                switch (n5) {
                    case 1: {
                        byte by = byteBuffer.get(n6++);
                        System.err.printf(" 0x%02X", by);
                        continue block7;
                    }
                    case 2: {
                        byte by = byteBuffer.get(n6++);
                        byte by2 = byteBuffer.get(n6++);
                        System.err.printf(" 0x%02X%02X", by2, by);
                        continue block7;
                    }
                    case 3: {
                        byte by = byteBuffer.get(n6++);
                        byte by2 = byteBuffer.get(n6++);
                        byte by3 = byteBuffer.get(n6++);
                        System.err.printf(" 0x%02X%02X%02X", by3, by2, by);
                        continue block7;
                    }
                    case 4: {
                        byte by = byteBuffer.get(n6++);
                        byte by2 = byteBuffer.get(n6++);
                        byte by3 = byteBuffer.get(n6++);
                        byte by4 = byteBuffer.get(n6++);
                        System.err.printf(" 0x%02X%02X%02X%02X", by4, by3, by2, by);
                    }
                }
            }
        }
        System.err.println();
    }

    static final void assertEquals(int n, int n2, int n3) {
        int n4 = Math.abs(n - n2);
        Assert.assertTrue((String)String.format("Not equal: abs(%s - %s) = %d, > %d maxDelta", Bitstream.toHexBinString((boolean)true, (int)n, (int)8), Bitstream.toHexBinString((boolean)true, (int)n2, (int)8), n4, n3), (n4 <= n3 ? 1 : 0) != 0);
    }

    static final boolean equals(int n, int n2, int n3) {
        int n4 = Math.abs(n - n2);
        return n4 <= n3;
    }

    static void testComponents(PixelRectangle pixelRectangle, int n, int n2, byte[] byArray, int n3) {
        int n4;
        TestPixelFormatUtil00NEWT.dumpComponents(pixelRectangle, n, n2, 3, 3);
        PixelFormat.Composition composition = pixelRectangle.getPixelformat().comp;
        ByteBuffer byteBuffer = pixelRectangle.getPixels();
        int n5 = composition.bytesPerPixel();
        int n6 = composition.componentCount();
        int[] nArray = composition.componentBitCount();
        int n7 = n2 * pixelRectangle.getStride() + n * n5;
        int n8 = byteBuffer.position();
        byteBuffer.position(n8 + n7);
        long l = PixelFormatUtil.getShiftedI64((int)composition.bytesPerPixel(), (ByteBuffer)byteBuffer, (boolean)true);
        int[] nArray2 = new int[n6];
        long l2 = PixelFormatUtil.getShiftedI64((int)composition.bytesPerPixel(), (byte[])byArray, (int)0);
        int[] nArray3 = new int[n6];
        boolean bl = true;
        for (n4 = 0; n4 < n6; ++n4) {
            nArray2[n4] = composition.decodeSingleI64(l, n4);
            nArray3[n4] = composition.decodeSingleI64(l2, n4);
            bl = bl && TestPixelFormatUtil00NEWT.equals(nArray2[n4], nArray3[n4], n3);
        }
        System.err.printf("Test [%3d][%3d] exp ", n, n2);
        for (n4 = 0; n4 < n6; ++n4) {
            System.err.printf("%s ", Bitstream.toHexBinString((boolean)true, (int)nArray3[n4], (int)nArray[n4]));
        }
        System.err.printf("==%nTest [%3d][%3d] has ", n, n2);
        for (n4 = 0; n4 < n6; ++n4) {
            System.err.printf("%s ", Bitstream.toHexBinString((boolean)true, (int)nArray2[n4], (int)nArray[n4]));
        }
        System.err.printf(": equal %b%n%n", bl);
        for (n4 = 0; n4 < n6; ++n4) {
            TestPixelFormatUtil00NEWT.assertEquals(nArray2[n4], nArray3[n4], n3);
        }
        byteBuffer.position(n8);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPixelFormatUtil00NEWT.class.getName()});
    }
}

