/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.Bitstream;
import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.opengl.test.junit.jogl.util.texture.TestPixelFormatUtil00NEWT;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPixelFormatUtil01NEWT
extends UITestCase {
    @Test
    public void testPNGRead11_fromRGBA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.RGBA8888, 0, false);
    }

    @Test
    public void testPNGRead12_fromABGR8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.ABGR8888, 0, false);
    }

    @Test
    public void testPNGRead13_fromBGRA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.BGRA8888, 0, false);
    }

    @Test
    public void testPNGRead14_fromARGB8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.ARGB8888, 0, false);
    }

    private void testPNG01Impl(String string, String string2, PixelFormat pixelFormat, int n, boolean bl) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test01: " + string + string2 + ".png, srcFmt " + pixelFormat + ", destMinStrideInBytes " + n + ", destIsGLOriented " + bl);
        URLConnection uRLConnection = IOUtil.getResource((String)(string + string2 + ".png"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ((Object)((Object)this)).getClass());
        PNGPixelRect pNGPixelRect = PNGPixelRect.read((InputStream)uRLConnection.getInputStream(), (PixelFormat)pixelFormat, (boolean)false, (int)n, (boolean)false);
        System.err.println("PNGPixelRect - Orig: " + pNGPixelRect);
        System.err.printf("Image Data: %s%n", Bitstream.toHexBinString((boolean)true, (ByteBuffer)pNGPixelRect.getPixels(), (int)0, (int)pNGPixelRect.getPixelformat().comp.bytesPerPixel()));
        TestPixelFormatUtil00NEWT.dumpComponents((PixelRectangle)pNGPixelRect, 0, 0, 3, 3);
        PixelFormat[] pixelFormatArray = new PixelFormat[]{PixelFormat.RGBA8888, PixelFormat.ABGR8888, PixelFormat.BGRA8888, PixelFormat.ARGB8888};
        for (int i = 0; i < pixelFormatArray.length; ++i) {
            PixelFormat pixelFormat2 = pixelFormatArray[i];
            System.err.println("CONVERT[" + i + "]: " + pixelFormat + " -> " + pixelFormat2);
            PixelRectangle pixelRectangle = PixelFormatUtil.convert((PixelRectangle)pNGPixelRect, (PixelFormat)pixelFormat2, (int)n, (boolean)bl, (boolean)false);
            System.err.println("PNGPixelRect - Conv1: " + pixelRectangle);
            System.err.printf("Conv1 Data: %s%n", Bitstream.toHexBinString((boolean)true, (ByteBuffer)pixelRectangle.getPixels(), (int)0, (int)pixelRectangle.getPixelformat().comp.bytesPerPixel()));
            TestPixelFormatUtil00NEWT.dumpComponents(pixelRectangle, 0, 0, 3, 3);
            PixelRectangle pixelRectangle2 = PixelFormatUtil.convert((PixelRectangle)pixelRectangle, (PixelFormat)pNGPixelRect.getPixelformat(), (int)pNGPixelRect.getStride(), (boolean)pNGPixelRect.isGLOriented(), (boolean)false);
            System.err.println("PNGPixelRect - Conv2: " + pixelRectangle2);
            System.err.printf("Conv2 Data: %s%n", Bitstream.toHexBinString((boolean)true, (ByteBuffer)pixelRectangle2.getPixels(), (int)0, (int)pixelRectangle2.getPixelformat().comp.bytesPerPixel()));
            TestPixelFormatUtil00NEWT.dumpComponents(pixelRectangle2, 0, 0, 3, 3);
            Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pixelRectangle2.getPixels());
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPixelFormatUtil01NEWT.class.getName()});
    }
}

