/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureSequenceCubeES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.ImageSequence;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextureSequence01AWT
extends UITestCase {
    static boolean showFPS = false;
    static int width = 510;
    static int height = 300;
    static boolean useBuildInTexLookup = false;
    static long duration = 500L;
    static GLProfile glp;
    static GLCapabilities caps;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull((Object)glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull((Object)caps);
    }

    void testImpl() throws InterruptedException {
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        final Frame frame = new Frame("TestTextureSequence01AWT");
        Assert.assertNotNull((Object)frame);
        frame.add((Component)gLCanvas);
        final ImageSequence imageSequence = new ImageSequence(0, useBuildInTexLookup);
        gLCanvas.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                try {
                    imageSequence.addFrame(gLAutoDrawable.getGL(), TestTextureSequence01AWT.class, "test-ntscP_3-01-160x90.png", "png");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        gLCanvas.addGLEventListener((GLEventListener)new TextureSequenceCubeES2((TextureSequence)imageSequence, false, -2.3f, 0.0f, 0.0f));
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)quitAdapter, (NativeSurfaceHolder)gLCanvas).addTo((Component)gLCanvas);
        new AWTWindowAdapter((WindowListener)quitAdapter, (NativeSurfaceHolder)gLCanvas).addTo((Component)gLCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(width, height);
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void test1() throws InterruptedException {
        this.testImpl();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (!stringArray[i].equals("-shaderBuildIn")) continue;
            useBuildInTexLookup = true;
        }
        JUnitCore.main((String[])new String[]{TestTextureSequence01AWT.class.getName()});
    }
}

