/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.common.os.Platform;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.opengl.test.junit.math.Matrix4fb;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMatrix4f03InversionNOUI
extends JunitTracer {
    @Test
    public void test01Ident() {
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        FloatUtil.invertMatrix((float[])fArray4, (float[])fArray);
        TestMatrix4f03InversionNOUI.invertMatrix(fArray4, fArray2, fArray3);
        Assert.assertArrayEquals((String)"I1/I2 failure", (float[])fArray, (float[])fArray2, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I2 failure", (float[])fArray4, (float[])fArray2, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I1 failure", (float[])fArray4, (float[])fArray, (float)1.0E-5f);
        Matrix4f matrix4f = new Matrix4f(fArray4);
        Assert.assertTrue((boolean)matrix4f.invert());
        Assert.assertEquals((Object)new Matrix4f(fArray), (Object)matrix4f);
        Assert.assertEquals((Object)new Matrix4f(), (Object)matrix4f);
        Matrix4fb matrix4fb = new Matrix4fb(fArray4);
        Assert.assertTrue((boolean)matrix4fb.invert());
        Assert.assertEquals((Object)new Matrix4fb(fArray), (Object)matrix4fb);
        Assert.assertEquals((Object)new Matrix4fb(), (Object)matrix4fb);
    }

    private void testImpl(float[] fArray) {
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        float[] fArray5 = new float[16];
        float[] fArray6 = new float[16];
        float[] fArray7 = new float[16];
        float[] fArray8 = new float[16];
        TestMatrix4f03InversionNOUI.invertMatrix(fArray, fArray2, fArray8);
        TestMatrix4f03InversionNOUI.invertMatrix(fArray2, fArray5, fArray8);
        FloatUtil.invertMatrix((float[])fArray, (float[])fArray3);
        FloatUtil.invertMatrix((float[])fArray3, (float[])fArray6);
        FloatUtil.invertMatrix((float[])fArray, (float[])fArray4);
        FloatUtil.invertMatrix((float[])fArray4, (float[])fArray7);
        Assert.assertArrayEquals((String)"I1_1/I1_2 failure", (float[])fArray3, (float[])fArray4, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I2_1/I2_2 failure", (float[])fArray6, (float[])fArray7, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I1_0/I1_1 failure", (float[])fArray2, (float[])fArray4, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I2_0/I2_1 failure", (float[])fArray5, (float[])fArray7, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I1 failure", (float[])fArray, (float[])fArray5, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I2 failure", (float[])fArray, (float[])fArray7, (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I2 failure", (float[])fArray, (float[])fArray6, (float)1.0E-5f);
        Matrix4f matrix4f = new Matrix4f(fArray);
        Matrix4f matrix4f2 = new Matrix4f(matrix4f);
        Assert.assertTrue((boolean)matrix4f2.invert());
        Matrix4f matrix4f3 = new Matrix4f(matrix4f2);
        Assert.assertTrue((boolean)matrix4f3.invert());
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray4, (float[])matrix4f2.get(fArray8), (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray7, (float[])matrix4f3.get(fArray8), (float)1.0E-5f);
        Assert.assertTrue((String)("I4 failure: " + matrix4f + " != " + matrix4f3), (boolean)matrix4f.isEqual(matrix4f3, 1.0E-5f));
        Matrix4f matrix4f4 = new Matrix4f();
        Assert.assertTrue((boolean)matrix4f4.invert(matrix4f));
        Matrix4f matrix4f5 = new Matrix4f();
        Assert.assertTrue((boolean)matrix4f5.invert(matrix4f4));
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray4, (float[])matrix4f4.get(fArray8), (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray7, (float[])matrix4f5.get(fArray8), (float)1.0E-5f);
        Assert.assertTrue((String)("I4 failure: " + matrix4f + " != " + matrix4f5), (boolean)matrix4f.isEqual(matrix4f5, 1.0E-5f));
        Matrix4fb matrix4fb = new Matrix4fb(fArray);
        Matrix4fb matrix4fb2 = new Matrix4fb(matrix4fb);
        Assert.assertTrue((boolean)matrix4fb2.invert());
        Matrix4fb matrix4fb3 = new Matrix4fb(matrix4fb2);
        Assert.assertTrue((boolean)matrix4fb3.invert());
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray4, (float[])matrix4fb2.get(fArray8), (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray7, (float[])matrix4fb3.get(fArray8), (float)1.0E-5f);
        Assert.assertTrue((String)("I5 failure: " + matrix4fb + " != " + matrix4fb3), (boolean)matrix4fb.isEqual(matrix4fb3, 1.0E-5f));
        Matrix4fb matrix4fb4 = new Matrix4fb();
        Assert.assertTrue((boolean)matrix4fb4.invert(matrix4fb));
        Matrix4fb matrix4fb5 = new Matrix4fb();
        Assert.assertTrue((boolean)matrix4fb5.invert(matrix4fb4));
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray4, (float[])matrix4fb4.get(fArray8), (float)1.0E-5f);
        Assert.assertArrayEquals((String)"I5 failure", (float[])fArray7, (float[])matrix4fb5.get(fArray8), (float)1.0E-5f);
        Assert.assertTrue((String)("I5 failure: " + matrix4fb + " != " + matrix4fb5), (boolean)matrix4fb.isEqual(matrix4fb5, 1.0E-5f));
    }

    @Test
    public void test02() {
        float[] fArray = new float[]{2.3464675f, 0.0f, 0.0f, 0.0f, 0.0f, 2.4142134f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0002f, -1.0f, 0.0f, 0.0f, -20.002f, 0.0f};
        this.testImpl(fArray);
    }

    @Test
    public void test03() {
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -200.0f, 1.0f};
        this.testImpl(fArray);
    }

    @Test
    public void test04() {
        float[] fArray = new float[]{2.3464675f, 0.0f, 0.0f, 0.0f, 0.0f, 2.4142134f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0002f, -1.0f, 0.0f, 0.0f, -20.002f, 0.0f};
        this.testImpl(fArray);
    }

    @Test
    public void test05Perf01() {
        int n;
        int n2;
        float[] fArray = new float[]{2.3464675f, 0.0f, 0.0f, 0.0f, 0.0f, 2.4142134f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0002f, -1.0f, 0.0f, 0.0f, -20.002f, 0.0f};
        Matrix4f matrix4f = new Matrix4f(fArray);
        Matrix4fb matrix4fb = new Matrix4fb(fArray);
        float[] fArray2 = new float[]{26.0f, 59.0f, 143.0f, 71.0f, 59.0f, 174.0f, 730.0f, 386.0f, 143.0f, 730.0f, 9770.0f, 5370.0f, 71.0f, 386.0f, 5370.0f, 2954.0f};
        Matrix4f matrix4f2 = new Matrix4f(fArray2);
        Matrix4fb matrix4fb2 = new Matrix4fb(fArray2);
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        Matrix4f matrix4f3 = new Matrix4f();
        Matrix4fb matrix4fb3 = new Matrix4fb();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        for (int i = 0; i < 1000; ++i) {
            TestMatrix4f03InversionNOUI.invertMatrix(fArray, fArray3, fArray4);
        }
        long l7 = Platform.currentTimeMillis();
        for (n2 = 0; n2 < 10000000; ++n2) {
            TestMatrix4f03InversionNOUI.invertMatrix(fArray, fArray3, fArray4);
            TestMatrix4f03InversionNOUI.invertMatrix(fArray2, fArray3, fArray4);
        }
        l = Platform.currentTimeMillis() - l7;
        for (n2 = 0; n2 < 1000; ++n2) {
            FloatUtil.invertMatrix((float[])fArray, (float[])fArray3);
            FloatUtil.invertMatrix((float[])fArray2, (float[])fArray3);
        }
        l7 = Platform.currentTimeMillis();
        for (n2 = 0; n2 < 10000000; ++n2) {
            FloatUtil.invertMatrix((float[])fArray, (float[])fArray3);
            FloatUtil.invertMatrix((float[])fArray2, (float[])fArray3);
        }
        l2 = Platform.currentTimeMillis() - l7;
        double d = 1.0;
        for (n = 0; n < 1000; ++n) {
            matrix4f3.invert(matrix4f);
            d += (double)matrix4f3.determinant();
            matrix4f3.invert(matrix4f2);
            d += (double)matrix4f3.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 10000000; ++n) {
            matrix4f3.invert(matrix4f);
            d += (double)matrix4f3.determinant();
            matrix4f3.invert(matrix4f2);
            d += (double)matrix4f3.determinant();
        }
        l3 = Platform.currentTimeMillis() - l7;
        for (n = 0; n < 1000; ++n) {
            matrix4f3.load(matrix4f).invert();
            d += (double)matrix4f3.determinant();
            matrix4f3.load(matrix4f2).invert();
            d += (double)matrix4f3.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 10000000; ++n) {
            matrix4f3.load(matrix4f).invert();
            d += (double)matrix4f3.determinant();
            matrix4f3.load(matrix4f2).invert();
            d += (double)matrix4f3.determinant();
        }
        l4 = Platform.currentTimeMillis() - l7;
        for (n = 0; n < 1000; ++n) {
            matrix4fb3.invert(matrix4fb);
            d += (double)matrix4fb3.determinant();
            matrix4fb3.invert(matrix4fb2);
            d += (double)matrix4fb3.determinant();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 10000000; ++n) {
            matrix4fb3.invert(matrix4fb);
            d += (double)matrix4fb3.determinant();
            matrix4fb3.invert(matrix4fb2);
            d += (double)matrix4fb3.determinant();
        }
        l5 = Platform.currentTimeMillis() - l7;
        for (n = 0; n < 1000; ++n) {
            matrix4fb3.load(matrix4fb).invert();
            matrix4fb3.load(matrix4fb2).invert();
        }
        l7 = Platform.currentTimeMillis();
        for (n = 0; n < 10000000; ++n) {
            matrix4fb3.load(matrix4fb).invert();
            d += (double)matrix4fb3.determinant();
            matrix4fb3.load(matrix4fb2).invert();
            d += (double)matrix4fb3.determinant();
        }
        l6 = Platform.currentTimeMillis() - l7;
        System.err.printf("Checkmark %f%n", d);
        System.err.printf("Summary loops %6d: I0  %6d ms total, %f us/inv%n", 10000000, l, (double)l * 1000.0 / 1.0E7);
        System.err.printf("Summary loops %6d: I2  %6d ms total, %f us/inv, I2  / I0 %f%%%n", 10000000, l2, (double)l2 * 1000.0 / 2.0 / 1.0E7, (double)l2 / (double)l * 100.0);
        System.err.printf("Summary loops %6d: I4a %6d ms total, %f us/inv, I4a / I2 %f%%%n", 10000000, l3, (double)l3 * 1000.0 / 2.0 / 1.0E7, (double)l3 / (double)l2 * 100.0);
        System.err.printf("Summary loops %6d: I4b %6d ms total, %f us/inv, I4b / I2 %f%%%n", 10000000, l4, (double)l4 * 1000.0 / 2.0 / 1.0E7, (double)l4 / (double)l2 * 100.0);
        System.err.printf("Summary loops %6d: I5a %6d ms total, %f us/inv, I5a / I2 %f%%%n", 10000000, l5, (double)l5 * 1000.0 / 2.0 / 1.0E7, (double)l5 / (double)l2 * 100.0);
        System.err.printf("Summary loops %6d: I5b %6d ms total, %f us/inv, I5b / I2 %f%%%n", 10000000, l6, (double)l6 * 1000.0 / 2.0 / 1.0E7, (double)l6 / (double)l2 * 100.0);
    }

    public static float[] invertMatrix(float[] fArray, float[] fArray2, float[] fArray3) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < 4; ++n3) {
            n2 = n3 * 4;
            for (n = 0; n < 4; ++n) {
                fArray3[n2 + n] = fArray[n2 + n];
            }
        }
        FloatUtil.makeIdentity((float[])fArray2);
        for (n3 = 0; n3 < 4; ++n3) {
            float f;
            int n4;
            int n5;
            n2 = n3 * 4;
            int n6 = n3;
            for (n = n3 + 1; n < 4; ++n) {
                if (!(Math.abs(fArray3[n * 4 + n3]) > Math.abs(fArray3[n2 + n3]))) continue;
                n6 = n;
            }
            if (n6 != n3) {
                n5 = n6 * 4;
                for (n4 = 0; n4 < 4; ++n4) {
                    f = fArray3[n2 + n4];
                    fArray3[n2 + n4] = fArray3[n5 + n4];
                    fArray3[n5 + n4] = f;
                    f = fArray2[n2 + n4];
                    fArray2[n2 + n4] = fArray2[n5 + n4];
                    fArray2[n5 + n4] = f;
                }
            }
            if (fArray3[n2 + n3] == 0.0f) {
                return null;
            }
            f = fArray3[n2 + n3];
            for (n4 = 0; n4 < 4; ++n4) {
                int n7 = n2 + n4;
                fArray3[n7] = fArray3[n7] / f;
                int n8 = n2 + n4;
                fArray2[n8] = fArray2[n8] / f;
            }
            for (n = 0; n < 4; ++n) {
                if (n == n3) continue;
                n5 = n * 4;
                f = fArray3[n5 + n3];
                for (n4 = 0; n4 < 4; ++n4) {
                    int n9 = n5 + n4;
                    fArray3[n9] = fArray3[n9] - fArray3[n2 + n4] * f;
                    int n10 = n5 + n4;
                    fArray2[n10] = fArray2[n10] - fArray2[n2 + n4] * f;
                }
            }
        }
        return fArray2;
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestMatrix4f03InversionNOUI.class.getName()});
    }
}

