/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PMVMatrix;
import java.nio.FloatBuffer;
import jogamp.common.os.PlatformPropsImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPMVMatrix01NEWT
extends UITestCase {
    static final float epsilon = 1.0E-5f;
    static FloatBuffer matrix2x3R = FloatBuffer.wrap(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f});
    static FloatBuffer matrix2x3C = FloatBuffer.wrap(new float[]{1.0f, 4.0f, 2.0f, 5.0f, 3.0f, 6.0f});
    static FloatBuffer matrix3x2R = FloatBuffer.wrap(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f});
    static FloatBuffer matrix3x2C = FloatBuffer.wrap(new float[]{1.0f, 3.0f, 5.0f, 2.0f, 4.0f, 6.0f});
    static Matrix4f translated123R = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    static Matrix4f translated123C = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 2.0f, 3.0f, 1.0f});
    static Matrix4f translated123I = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, -2.0f, -3.0f, 1.0f});
    static Matrix4f translated123IT = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, -2.0f, 0.0f, 0.0f, 1.0f, -3.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    static DrawableContext dc;

    @Test
    public void test00MatrixToString() {
        String string = translated123C.toString(null, null, "%10.5f").toString();
        String string2 = translated123R.toString(null, null, "%10.5f").toString();
        System.err.println("FLU-C-O 4x4: ");
        System.err.println(string);
        System.err.println();
        System.err.println("FLU-R-O 4x4: ");
        System.err.println(string2);
        System.err.println();
        String string3 = FloatUtil.matrixToString(null, null, (String)"%10.5f", (FloatBuffer)matrix2x3R, (int)0, (int)2, (int)3, (boolean)true).toString();
        String string4 = FloatUtil.matrixToString(null, null, (String)"%10.5f", (FloatBuffer)matrix2x3C, (int)0, (int)2, (int)3, (boolean)false).toString();
        System.err.println("FLU-R-O 2x3: ");
        System.err.println(string3);
        System.err.println();
        System.err.println("FLU-C-O 2x3: ");
        System.err.println(string4);
        System.err.println();
        Assert.assertEquals((Object)string4, (Object)string3);
        String string5 = FloatUtil.matrixToString(null, null, (String)"%10.5f", (FloatBuffer)matrix3x2R, (int)0, (int)3, (int)2, (boolean)true).toString();
        String string6 = FloatUtil.matrixToString(null, null, (String)"%10.5f", (FloatBuffer)matrix3x2C, (int)0, (int)3, (int)2, (boolean)false).toString();
        System.err.println("FLU-R-O 3x2: ");
        System.err.println(string5);
        System.err.println();
        System.err.println("FLU-C-O 3x2: ");
        System.err.println(string6);
        System.err.println();
        Assert.assertEquals((Object)string6, (Object)string5);
    }

    @Test
    public void test01aTraditionalAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix();
        System.err.println("test01a.P0: " + pMVMatrix.toString());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getReqBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        Matrix4f matrix4f = pMVMatrix.getP();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((0 == pMVMatrix.getModifiedBits(false) ? 1 : 0) != 0);
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        System.err.println("test01a.P1: " + pMVMatrix.toString());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((String)"Update has been perfomed, but non requested", (Object)false, (Object)pMVMatrix.update());
        Matrix4f matrix4f2 = pMVMatrix.getP();
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        Matrix4f matrix4f3 = pMVMatrix.getMv();
        MiscUtils.assertMatrix4fEquals("Mv not translated123, " + pMVMatrix.toString(), translated123C, matrix4f3, 1.0E-5f);
        IllegalArgumentException illegalArgumentException = null;
        try {
            pMVMatrix.getMvi();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        Assert.assertNotNull((Object)illegalArgumentException);
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        Assert.assertNotNull((Object)pMVMatrix.getFrustum());
        Assert.assertNotNull((Object)pMVMatrix.getPMv());
        Assert.assertNotNull((Object)pMVMatrix.getPMvi());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        System.err.println("test01a.PX: " + pMVMatrix.toString());
    }

    @Test
    public void test01bTraditionalAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix(6);
        System.err.println("test01b.P0: " + pMVMatrix.toString());
        Assert.assertEquals((long)6L, (long)pMVMatrix.getReqBits());
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((long)62L, (long)pMVMatrix.getDirtyBits());
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)62L, (long)pMVMatrix.getDirtyBits());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        Matrix4f matrix4f = pMVMatrix.getP();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)62L, (long)pMVMatrix.getDirtyBits());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)62L, (long)pMVMatrix.getDirtyBits());
        System.err.println("test01b.P1: " + pMVMatrix.toString());
        Assert.assertEquals((long)62L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)true, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((Object)true, (Object)pMVMatrix.update());
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertNotNull((Object)pMVMatrix.getFrustum());
        Assert.assertNotNull((Object)pMVMatrix.getPMv());
        Assert.assertNotNull((Object)pMVMatrix.getPMvi());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Matrix4f matrix4f2 = pMVMatrix.getP();
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        Matrix4f matrix4f3 = pMVMatrix.getMv();
        MiscUtils.assertMatrix4fEquals("Mv not translated123, " + pMVMatrix.toString(), translated123C, matrix4f3, 1.0E-5f);
        Matrix4f matrix4f4 = pMVMatrix.getMvi();
        MiscUtils.assertMatrix4fEquals("Mvi not translated123, " + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertNotNull((Object)pMVMatrix.getFrustum());
        Assert.assertNotNull((Object)pMVMatrix.getPMv());
        Assert.assertNotNull((Object)pMVMatrix.getPMvi());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Matrix4f matrix4f5 = pMVMatrix.getMvit();
        MiscUtils.assertMatrix4fEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((long)62L, (long)pMVMatrix.getDirtyBits());
        System.err.println("test01b.P2: " + pMVMatrix.toString());
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mv not identity, " + pMVMatrix.toString(), matrix4f, matrix4f3, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvi already identity w/o update, " + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvit already identity w/o update, " + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvi not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
        Assert.assertEquals((Object)true, (Object)pMVMatrix.update());
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        MiscUtils.assertMatrix4fEquals("Mvi not identity after update, " + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not identity after update, " + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        Assert.assertNotNull((Object)pMVMatrix.getFrustum());
        Assert.assertNotNull((Object)pMVMatrix.getPMv());
        Assert.assertNotNull((Object)pMVMatrix.getPMvi());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        System.err.println("test01b.PX: " + pMVMatrix.toString());
    }

    @Test
    public void test02MviUpdateShaderAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix(6);
        Assert.assertEquals((long)6L, (long)pMVMatrix.getReqBits());
        Assert.assertTrue((0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((long)62L, (long)pMVMatrix.getDirtyBits());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        Matrix4f matrix4f = pMVMatrix.getP();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertEquals((long)62L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)true, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((Object)true, (Object)pMVMatrix.update());
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertNotNull((Object)pMVMatrix.getFrustum());
        Assert.assertNotNull((Object)pMVMatrix.getPMv());
        Assert.assertNotNull((Object)pMVMatrix.getPMvi());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Matrix4f matrix4f2 = pMVMatrix.getP();
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        Matrix4f matrix4f3 = pMVMatrix.getMv();
        MiscUtils.assertMatrix4fEquals("Mv not identity, " + pMVMatrix.toString(), matrix4f, matrix4f3, 1.0E-5f);
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Matrix4f matrix4f4 = pMVMatrix.getMvi();
        MiscUtils.assertMatrix4fEquals("Mvi not identity, " + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Matrix4f matrix4f5 = pMVMatrix.getMvit();
        MiscUtils.assertMatrix4fEquals("Mvi not identity, " + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue((String)"Modified bits zero", (0 != pMVMatrix.getModifiedBits(true) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Dirty bits clean, " + pMVMatrix.toString()), (0 != pMVMatrix.getDirtyBits() ? 1 : 0) != 0);
        Assert.assertEquals((String)("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString()), (long)62L, (long)pMVMatrix.getDirtyBits());
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mv not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123C, matrix4f3, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvi already translated123 w/o update, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvit already translated123 w/o update, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvi not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        Assert.assertEquals((long)62L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)true, (Object)pMVMatrix.isReqDirty());
        Assert.assertEquals((Object)true, (Object)pMVMatrix.update());
        Assert.assertEquals((long)56L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        Assert.assertNotNull((Object)pMVMatrix.getFrustum());
        Assert.assertNotNull((Object)pMVMatrix.getPMv());
        Assert.assertNotNull((Object)pMVMatrix.getPMvi());
        Assert.assertEquals((long)0L, (long)pMVMatrix.getDirtyBits());
        Assert.assertEquals((Object)false, (Object)pMVMatrix.isReqDirty());
        MiscUtils.assertMatrix4fEquals("Mvi not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
    }

    @Test
    public void test10MvTranslate() {
        Matrix4f matrix4f = new Matrix4f();
        Object object = new PMVMatrix();
        object.glMatrixMode(5889);
        object.glLoadIdentity();
        object.glMatrixMode(5888);
        object.glLoadIdentity();
        object.glTranslatef(5.0f, 6.0f, 7.0f);
        matrix4f.load(object.getMv());
        object = FloatBuffer.allocate(16);
        GL2ES1 gL2ES1 = TestPMVMatrix01NEWT.dc.glc.getGL().getGL2ES1();
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(5.0f, 6.0f, 7.0f);
        gL2ES1.glGetFloatv(2982, (FloatBuffer)object);
        gL2ES1 = new Matrix4f((FloatBuffer)object);
        MiscUtils.assertMatrix4fEquals("Arrays not equal, expected" + PlatformPropsImpl.NEWLINE + gL2ES1 + ", actual" + PlatformPropsImpl.NEWLINE + matrix4f, (Matrix4f)gL2ES1, matrix4f, 1.0E-5f);
    }

    @Test
    public void test11MvTranslateRotate() {
        Matrix4f matrix4f = new Matrix4f();
        Object object = new PMVMatrix();
        object.glMatrixMode(5889);
        object.glLoadIdentity();
        object.glMatrixMode(5888);
        object.glLoadIdentity();
        object.glTranslatef(5.0f, 6.0f, 7.0f);
        object.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        matrix4f.load(object.getMv());
        object = FloatBuffer.allocate(16);
        GL2ES1 gL2ES1 = TestPMVMatrix01NEWT.dc.glc.getGL().getGL2ES1();
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(5.0f, 6.0f, 7.0f);
        gL2ES1.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        gL2ES1.glGetFloatv(2982, (FloatBuffer)object);
        gL2ES1 = new Matrix4f((FloatBuffer)object);
        MiscUtils.assertMatrix4fEquals("Arrays not equal, expected" + PlatformPropsImpl.NEWLINE + gL2ES1 + ", actual" + PlatformPropsImpl.NEWLINE + matrix4f, (Matrix4f)gL2ES1, matrix4f, 1.0E-5f);
    }

    @BeforeClass
    public static void setup() throws Throwable {
        try {
            dc = TestPMVMatrix01NEWT.createOffscreenDrawableAndCurrentFFPContext();
        }
        catch (Throwable throwable) {
            TestPMVMatrix01NEWT.setTestSupported((boolean)false);
            throw throwable;
        }
    }

    @AfterClass
    public static void cleanup() {
        TestPMVMatrix01NEWT.destroyDrawableContext(dc);
    }

    private static DrawableContext createOffscreenDrawableAndCurrentFFPContext() throws Throwable {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc((boolean)true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        GLDrawable gLDrawable = gLDrawableFactory.createOffscreenDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 64, 64);
        gLDrawable.setRealized(true);
        GLContext gLContext = null;
        try {
            gLContext = gLDrawable.createContext(null);
            Assert.assertTrue((String)"Context could not be made current", (0 < gLContext.makeCurrent() ? 1 : 0) != 0);
            return new DrawableContext(gLDrawable, gLContext);
        }
        catch (Throwable throwable) {
            if (null != gLContext) {
                gLContext.destroy();
            }
            gLDrawable.setRealized(false);
            throw throwable;
        }
    }

    private static void destroyDrawableContext(DrawableContext drawableContext) {
        if (null != drawableContext.glc) {
            drawableContext.glc.destroy();
            drawableContext.glc = null;
        }
        if (null != drawableContext.d) {
            drawableContext.d.setRealized(false);
            drawableContext.d = null;
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPMVMatrix01NEWT.class.getName()});
    }

    static class DrawableContext {
        GLDrawable d;
        GLContext glc;

        DrawableContext(GLDrawable gLDrawable, GLContext gLContext) {
            this.d = gLDrawable;
            this.glc = gLContext;
        }
    }
}

