/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.VectorUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestQuaternion01NOUI
extends JunitTracer {
    static final boolean DEBUG = false;
    static final Quaternion QUAT_IDENT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    static final Vec3f ZERO = new Vec3f(0.0f, 0.0f, 0.0f);
    static final Vec3f ONE = new Vec3f(1.0f, 1.0f, 1.0f);
    static final Vec3f NEG_ONE = new Vec3f(-1.0f, -1.0f, -1.0f);
    static final Vec3f UNIT_X = new Vec3f(1.0f, 0.0f, 0.0f);
    static final Vec3f UNIT_Y = new Vec3f(0.0f, 1.0f, 0.0f);
    static final Vec3f UNIT_Z = new Vec3f(0.0f, 0.0f, 1.0f);
    static final Vec3f NEG_UNIT_X = new Vec3f(-1.0f, 0.0f, 0.0f);
    static final Vec3f NEG_UNIT_Y = new Vec3f(0.0f, -1.0f, 0.0f);
    static final Vec3f NEG_UNIT_Z = new Vec3f(0.0f, 0.0f, -1.0f);
    static final Vec4f NEG_ONE_v4 = new Vec4f(-1.0f, -1.0f, -1.0f, 0.0f);
    static final Vec4f ONE_v4 = new Vec4f(1.0f, 1.0f, 1.0f, 0.0f);
    static final float MACH_EPSILON = 1.1920929E-7f;

    @Test
    public void test01Normalize() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion).normalize();
        Assert.assertEquals((float)0.0f, (float)Math.abs(1.0f - quaternion2.magnitude()), (float)1.1920929E-7f);
    }

    @Test
    public void test02RotateZeroVector() {
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f = new Vec3f(0.0f, 0.0f, 0.0f);
        Vec3f vec3f2 = quaternion.rotateVector(vec3f, new Vec3f());
        Assert.assertEquals((Object)vec3f, (Object)vec3f2);
    }

    @Test
    public void test03InvertAndConj() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion).invert();
        Assert.assertEquals((Object)quaternion, (Object)quaternion2.invert());
        quaternion = new Quaternion(-1.0f, -2.0f, -3.0f, 4.0f);
        quaternion2 = new Quaternion(1.0f, 2.0f, 3.0f, 4.0f).conjugate();
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
    }

    @Test
    public void test04Dot() {
        Quaternion quaternion = new Quaternion(7.0f, 2.0f, 5.0f, -1.0f);
        Assert.assertTrue((35.0f == quaternion.dot(3.0f, 1.0f, 2.0f, -2.0f) ? 1 : 0) != 0);
        Assert.assertTrue((-11.0f == quaternion.dot(new Quaternion(-1.0f, 1.0f, -1.0f, 1.0f)) ? 1 : 0) != 0);
    }

    @Test
    public void test10AngleAxis() {
        Vec3f vec3f = new Vec3f();
        Quaternion quaternion = new Quaternion().setFromAngleAxis(1.5707964f, new Vec3f(2.0f, 0.0f, 0.0f), vec3f);
        Quaternion quaternion2 = new Quaternion().setFromAngleNormalAxis(1.5707964f, new Vec3f(1.0f, 0.0f, 0.0f));
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
        Assert.assertEquals((float)0.0f, (float)(1.0f - quaternion2.magnitude()), (float)1.1920929E-7f);
        Assert.assertTrue((1.0f - quaternion.magnitude() <= 1.1920929E-7f ? 1 : 0) != 0);
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        quaternion.rotateVector(Vec3f.ONE, vec3f2);
        quaternion2.rotateVector(Vec3f.ONE, vec3f3);
        Assert.assertEquals((Object)vec3f2, (Object)vec3f3);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f2.dist(vec3f3)), (float)1.1920929E-7f);
        quaternion.rotateVector(Vec3f.UNIT_Z, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(Vec3f.UNIT_Y_NEG.dist(vec3f2)), (float)1.1920929E-7f);
        quaternion2.setFromAngleAxis(1.5707964f, ZERO, vec3f);
        Assert.assertEquals((Object)QUAT_IDENT, (Object)quaternion2);
        float f = quaternion.toAngleAxis(vec3f2);
        quaternion2.setFromAngleAxis(f, vec3f2, vec3f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        f = quaternion.toAngleAxis(vec3f2);
        Assert.assertTrue((0.0f == f ? 1 : 0) != 0);
        Assert.assertEquals((Object)UNIT_X, (Object)vec3f2);
    }

    @Test
    public void test11FromVectorToVector() {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromVectors(UNIT_Z, UNIT_X, vec3f, vec3f2);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromNormalVectors(UNIT_Z, UNIT_X, vec3f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion2.setFromAngleAxis(1.5707964f, UNIT_Y, vec3f);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
        quaternion.setFromVectors(UNIT_Z, NEG_UNIT_Z, vec3f, vec3f2);
        quaternion.rotateVector(UNIT_Z, vec3f3);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_Z.dist(vec3f3)), (float)1.0E-6f);
        quaternion.setFromVectors(UNIT_X, NEG_UNIT_X, vec3f, vec3f2);
        quaternion.rotateVector(UNIT_X, vec3f3);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_X.dist(vec3f3)), (float)1.0E-6f);
        quaternion.setFromVectors(UNIT_Y, NEG_UNIT_Y, vec3f, vec3f2);
        quaternion.rotateVector(UNIT_Y, vec3f3);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_Y.dist(vec3f3)), (float)1.0E-6f);
        quaternion.setFromVectors(ONE, NEG_ONE, vec3f, vec3f2);
        quaternion.rotateVector(ONE, vec3f3);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_ONE.dist(vec3f3)), (float)1.0E-6f);
        quaternion.setFromVectors(ZERO, ZERO, vec3f, vec3f2);
        Assert.assertEquals((Object)QUAT_IDENT, (Object)quaternion);
    }

    @Test
    public void test12FromAndToEulerAngles() {
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f = new Vec3f(0.0f, 1.5707964f, 0.0f);
        quaternion.setFromEuler(vec3f);
        Assert.assertEquals((float)1.0f, (float)quaternion.magnitude(), (float)1.1920929E-7f);
        Vec3f vec3f2 = quaternion.toEuler(new Vec3f());
        Assert.assertEquals((Object)vec3f, (Object)vec3f2);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromEuler(vec3f2);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        Vec3f vec3f3 = new Vec3f(0.0f, 0.0f, -1.5707964f);
        quaternion.setFromEuler(vec3f3);
        Assert.assertEquals((float)1.0f, (float)quaternion.magnitude(), (float)1.1920929E-7f);
        Vec3f vec3f4 = quaternion.toEuler(new Vec3f());
        Assert.assertEquals((Object)vec3f3, (Object)vec3f4);
        quaternion2.setFromEuler(vec3f4);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        Vec3f vec3f5 = new Vec3f(1.5707964f, 0.0f, 0.0f);
        quaternion.setFromEuler(vec3f5);
        Assert.assertEquals((float)1.0f, (float)quaternion.magnitude(), (float)1.1920929E-7f);
        Vec3f vec3f6 = quaternion.toEuler(new Vec3f());
        Assert.assertEquals((Object)vec3f5, (Object)vec3f6);
        quaternion2.setFromEuler(vec3f6);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
    }

    @Test
    public void test13FromEulerAnglesAndRotateVector() {
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(0.0f, 1.5707964f, 0.0f);
        Assert.assertEquals((float)1.0f, (float)quaternion.magnitude(), (float)1.1920929E-7f);
        Vec3f vec3f = quaternion.rotateVector(UNIT_X, new Vec3f());
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_Z.dist(vec3f)), (float)1.1920929E-7f);
        quaternion.setFromEuler(0.0f, 0.0f, -1.5707964f);
        Assert.assertEquals((float)1.0f, (float)quaternion.magnitude(), (float)1.1920929E-7f);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_Y.dist(vec3f)), (float)1.1920929E-7f);
        quaternion.setFromEuler(1.5707964f, 0.0f, 0.0f);
        Assert.assertEquals((float)1.0f, (float)quaternion.magnitude(), (float)1.1920929E-7f);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(UNIT_Z.dist(vec3f)), (float)1.1920929E-7f);
    }

    @Test
    public void test14Matrix() {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec4f vec4f = new Vec4f();
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        matrix4f.loadIdentity();
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        float f = 1.5707964f;
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, FloatUtil.cos((float)f), FloatUtil.sin((float)f), 0.0f, 0.0f, -FloatUtil.sin((float)f), FloatUtil.cos((float)f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        matrix4f.load(fArray);
        Object object = new float[16];
        matrix4f.get(object);
        Assert.assertArrayEquals((float[])fArray, (float[])object, (float)1.1920929E-7f);
        quaternion.setFromEuler(f, 0.0f, 0.0f);
        object = new float[16];
        quaternion.toMatrix(object);
        Assert.assertArrayEquals((float[])fArray, (float[])object, (float)1.1920929E-7f);
        object = new float[16];
        quaternion.toMatrix(object);
        Assert.assertArrayEquals((float[])fArray, (float[])object, (float)1.1920929E-7f);
        matrix4f2.load(object);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(UNIT_Z.dist(vec3f)), (float)1.0E-6f);
        matrix4f.getRotation(quaternion);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(UNIT_Z.dist(vec3f)), (float)1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(NEG_ONE, vec3f);
        object = new float[3];
        vec3f.get(object);
        Object object2 = new float[16];
        quaternion.toMatrix(object2);
        Object object3 = new float[3];
        NEG_ONE.get(object3);
        Object object4 = new float[3];
        FloatUtil.multMatrixVec3((float[])object2, (float[])object3, (float[])object4);
        Assert.assertEquals((float)0.0f, (float)Math.abs(VectorUtil.distVec3((float[])object, (float[])object4)), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])object, (float[])object4, (float)1.1920929E-7f);
        matrix4f2.mulVec3f(NEG_ONE, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        Assert.assertEquals((Object)vec3f, (Object)vec3f2);
        float[] fArray2 = new float[3];
        vec3f2.get(fArray2);
        Assert.assertArrayEquals((float[])object4, (float[])fArray2, (float)1.1920929E-7f);
        object = new float[4];
        vec3f.get(object);
        object2 = new float[16];
        quaternion.toMatrix(object2);
        object3 = new float[4];
        NEG_ONE_v4.get(object3);
        object4 = new float[4];
        FloatUtil.multMatrixVec((float[])object2, (float[])object3, (float[])object4);
        Assert.assertEquals((float)0.0f, (float)Math.abs(VectorUtil.distVec3((float[])object, (float[])object4)), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])object, (float[])object4, (float)1.1920929E-7f);
        matrix4f2.mulVec4f(NEG_ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        Assert.assertEquals((Object)vec3f, (Object)vec3f2);
        fArray2 = new float[4];
        vec4f.get(fArray2);
        Assert.assertArrayEquals((float[])object4, (float[])fArray2, (float)1.1920929E-7f);
        f = (float)Math.PI;
        matrix4f.load(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, FloatUtil.cos((float)f), FloatUtil.sin((float)f), 0.0f, 0.0f, -FloatUtil.sin((float)f), FloatUtil.cos((float)f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        quaternion.setFromEuler(f, 0.0f, 0.0f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_Y.dist(vec3f)), (float)1.0E-6f);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_Y.dist(vec3f)), (float)1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(ONE, vec3f);
        matrix4f2.mulVec4f(ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        f = (float)Math.PI;
        matrix4f.load(new float[]{FloatUtil.cos((float)f), 0.0f, -FloatUtil.sin((float)f), 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, FloatUtil.sin((float)f), 0.0f, FloatUtil.cos((float)f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        quaternion.setFromEuler(0.0f, f, 0.0f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_X.dist(vec3f)), (float)1.0E-6f);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_X.dist(vec3f)), (float)1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(NEG_ONE, vec3f);
        matrix4f2.mulVec4f(NEG_ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        f = (float)Math.PI;
        matrix4f.load(new float[]{FloatUtil.cos((float)f), FloatUtil.sin((float)f), 0.0f, 0.0f, -FloatUtil.sin((float)f), FloatUtil.cos((float)f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        quaternion.setFromEuler(0.0f, 0.0f, f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_X.dist(vec3f)), (float)1.0E-6f);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_X.dist(vec3f)), (float)1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        quaternion.rotateVector(ONE, vec3f);
        matrix4f2.mulVec4f(ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        f = 0.7853982f;
        object = new Vec3f(FloatUtil.cos((float)f), FloatUtil.sin((float)f), 0.0f);
        object2 = new Vec3f(-FloatUtil.sin((float)f), FloatUtil.cos((float)f), 0.0f);
        object3 = new Vec3f(0.0f, 0.0f, 1.0f);
        object4 = new Vec3f();
        matrix4f.load(new float[]{FloatUtil.cos((float)f), FloatUtil.sin((float)f), 0.0f, 0.0f, -FloatUtil.sin((float)f), FloatUtil.cos((float)f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        matrix4f.getColumn(0, (Vec3f)object4);
        Assert.assertEquals((Object)object, (Object)object4);
        Assert.assertEquals((float)0.0f, (float)Math.abs(object.dist((Vec3f)object4)), (float)1.1920929E-7f);
        matrix4f.getColumn(1, (Vec3f)object4);
        Assert.assertEquals((Object)object2, (Object)object4);
        Assert.assertEquals((float)0.0f, (float)Math.abs(object2.dist((Vec3f)object4)), (float)1.1920929E-7f);
        matrix4f.getColumn(2, (Vec3f)object4);
        Assert.assertEquals((Object)object3, (Object)object4);
        Assert.assertEquals((float)0.0f, (float)Math.abs(object3.dist((Vec3f)object4)), (float)1.1920929E-7f);
    }

    @Test
    public void test15aAxesAndMatrix() {
        Vec3f vec3f = new Vec3f(0.0f, 1.5707964f, 0.0f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(vec3f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMat(matrix4f);
        quaternion2.toEuler(vec3f2);
        Assert.assertEquals((Object)vec3f, (Object)vec3f2);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
        Vec3f vec3f3 = new Vec3f();
        quaternion2.toEuler(vec3f3);
        quaternion.setFromEuler(vec3f3);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
    }

    @Test
    public void test15bAxesAndMatrix() {
        Vec3f vec3f = new Vec3f(1.5707964f, 0.0f, 0.0f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(vec3f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMat(matrix4f);
        quaternion2.toEuler(vec3f2);
        Assert.assertEquals((Object)vec3f, (Object)vec3f2);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
        Vec3f vec3f3 = new Vec3f();
        quaternion2.toEuler(vec3f3);
        quaternion.setFromEuler(vec3f3);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
    }

    @Test
    public void test15cAxesAndMatrix() {
        Vec3f vec3f = new Vec3f(0.7853982f, 1.5707964f, 0.0f);
        float[] fArray = new float[3];
        vec3f.get(fArray);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(vec3f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals((Object)matrix4f, (Object)matrix4f2);
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMat(matrix4f);
        quaternion2.toEuler(vec3f2);
        Object object = new float[3];
        vec3f2.get(object);
        Assert.assertArrayEquals((float[])fArray, (float[])object, (float)1.1920929E-7f);
        Assert.assertTrue((String)(vec3f + " != " + vec3f2), (boolean)vec3f.isEqual(vec3f2, 1.0E-6f));
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
        object = new Vec3f();
        quaternion2.toEuler((Vec3f)object);
        quaternion.setFromEuler((Vec3f)object);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion);
    }

    @Test
    public void test20AddSubtract() {
        Quaternion quaternion = new Quaternion(1.0f, 2.0f, 3.0f, 4.0f);
        Quaternion quaternion2 = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion3 = new Quaternion(1.0f, 1.0f, 1.0f, 1.0f);
        Quaternion quaternion4 = new Quaternion();
        quaternion4.set(quaternion2);
        quaternion4.add(quaternion3);
        Assert.assertEquals((Object)quaternion, (Object)quaternion4);
        quaternion2.set(0.0f, 1.0f, 2.0f, 3.0f);
        quaternion3.set(1.0f, 1.0f, 1.0f, 1.0f);
        quaternion4.set(quaternion2);
        quaternion4.subtract(quaternion3);
        Assert.assertEquals((Object)new Quaternion(-1.0f, 0.0f, 1.0f, 2.0f), (Object)quaternion4);
    }

    @Test
    public void test21Multiply() {
        Quaternion quaternion = new Quaternion(0.5f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.set(quaternion);
        quaternion2.scale(2.0f);
        Assert.assertEquals((Object)new Quaternion(1.0f, 2.0f, 4.0f, 6.0f), (Object)quaternion2);
        quaternion2.set(quaternion);
        quaternion2.scale(4.0f);
        Assert.assertEquals((Object)new Quaternion(2.0f, 4.0f, 8.0f, 12.0f), (Object)quaternion2);
        quaternion.setFromAngleNormalAxis(0.7853982f, UNIT_Y);
        quaternion2.set(quaternion);
        quaternion2.mult(quaternion);
        Vec3f vec3f = new Vec3f();
        quaternion2.rotateVector(UNIT_Z, vec3f);
        Assert.assertTrue((Math.abs(UNIT_X.dist(vec3f)) <= 1.0E-6f ? 1 : 0) != 0);
        quaternion2.setFromAngleNormalAxis(1.5707964f, UNIT_Y);
        quaternion.mult(quaternion);
        quaternion.mult(quaternion2);
        quaternion.rotateVector(UNIT_Z, vec3f);
        Assert.assertTrue((Math.abs(NEG_UNIT_Z.dist(vec3f)) <= 1.0E-6f ? 1 : 0) != 0);
        quaternion2.setFromEuler(0.0f, 1.5707964f, 0.0f);
        quaternion.mult(quaternion2);
        quaternion.rotateVector(UNIT_Z, vec3f);
        Assert.assertTrue((Math.abs(NEG_UNIT_X.dist(vec3f)) <= 1.0E-6f ? 1 : 0) != 0);
    }

    @Test
    public void test22InvertMultNormalAndConj() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion);
        Quaternion quaternion3 = new Quaternion(quaternion);
        quaternion2.invert();
        quaternion3.mult(quaternion2);
        Assert.assertEquals((Object)QUAT_IDENT, (Object)quaternion3);
        quaternion2.invert();
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion.setFromAngleNormalAxis(0.7853982f, UNIT_Y);
        quaternion2.set(quaternion);
        quaternion2.invert();
        quaternion3.set(quaternion);
        quaternion3.mult(quaternion2);
        Assert.assertEquals((Object)QUAT_IDENT, (Object)quaternion3);
        quaternion2.invert();
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion.set(-1.0f, -2.0f, -3.0f, 4.0f);
        quaternion2.set(1.0f, 2.0f, 3.0f, 4.0f);
        quaternion3.set(quaternion2);
        quaternion3.conjugate();
        Assert.assertEquals((Object)quaternion, (Object)quaternion3);
    }

    @Test
    public void test23RotationOrder() {
        Quaternion quaternion = new Quaternion().setFromEuler((float)(-Math.PI), 0.0f, 0.0f);
        Quaternion quaternion2 = new Quaternion().rotateByAngleX((float)(-Math.PI));
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion = new Quaternion().setFromEuler(1.5707964f, 0.0f, 0.0f);
        quaternion2 = new Quaternion().rotateByAngleX(1.5707964f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion = new Quaternion().setFromEuler(1.5707964f, 0.7853982f, 0.0f);
        quaternion2 = new Quaternion().rotateByAngleY(0.7853982f).rotateByAngleX(1.5707964f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion = new Quaternion().setFromEuler((float)Math.PI, 0.7853982f, 1.5707964f);
        quaternion2 = new Quaternion().rotateByAngleY(0.7853982f).rotateByAngleZ(1.5707964f).rotateByAngleX((float)Math.PI);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion = new Vec3f();
        quaternion2 = new Vec3f();
        Quaternion quaternion3 = new Quaternion();
        quaternion3.setFromEuler(1.5707964f, 0.7853982f, (float)Math.PI);
        quaternion2.set(1.0f, 1.0f, 1.0f);
        quaternion3.rotateVector((Vec3f)quaternion2, (Vec3f)quaternion2);
        quaternion.set(1.0f, 1.0f, 1.0f);
        Quaternion quaternion4 = new Quaternion();
        quaternion4.rotateByAngleY(0.7853982f).rotateByAngleZ((float)Math.PI).rotateByAngleX(1.5707964f);
        quaternion3.rotateVector((Vec3f)quaternion, (Vec3f)quaternion);
        Assert.assertEquals((float)0.0f, (float)quaternion.dist((Vec3f)quaternion2), (float)1.1920929E-7f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion.set(1.0f, 1.0f, 1.0f);
        quaternion2.set(1.0f, 1.0f, 1.0f);
        quaternion4.setIdentity().rotateByAngleX(0.7853982f).rotateVector((Vec3f)quaternion, (Vec3f)quaternion);
        quaternion4.setIdentity().rotateByAngleNormalAxis(0.7853982f, 1.0f, 0.0f, 0.0f).rotateVector((Vec3f)quaternion2, (Vec3f)quaternion2);
        Assert.assertEquals((float)0.0f, (float)quaternion.dist((Vec3f)quaternion2), (float)1.1920929E-7f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion.set(1.0f, 1.0f, 1.0f);
        quaternion2.set(1.0f, 1.0f, 1.0f);
        quaternion4.setIdentity().rotateByAngleY(0.7853982f).rotateVector((Vec3f)quaternion, (Vec3f)quaternion);
        quaternion4.setIdentity().rotateByAngleNormalAxis(0.7853982f, 0.0f, 1.0f, 0.0f).rotateVector((Vec3f)quaternion2, (Vec3f)quaternion2);
        Assert.assertEquals((float)0.0f, (float)quaternion.dist((Vec3f)quaternion2), (float)1.1920929E-7f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion.set(1.0f, 1.0f, 1.0f);
        quaternion2.set(1.0f, 1.0f, 1.0f);
        quaternion4.setIdentity().rotateByAngleZ(0.7853982f).rotateVector((Vec3f)quaternion, (Vec3f)quaternion);
        quaternion4.setIdentity().rotateByAngleNormalAxis(0.7853982f, 0.0f, 0.0f, 1.0f).rotateVector((Vec3f)quaternion2, (Vec3f)quaternion2);
        Assert.assertEquals((float)0.0f, (float)quaternion.dist((Vec3f)quaternion2), (float)1.1920929E-7f);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        quaternion3.set(quaternion4);
        quaternion4.rotateByAngleNormalAxis(0.0f, 0.0f, 0.0f, 0.0f);
        Assert.assertEquals((Object)quaternion3, (Object)quaternion4);
    }

    @Test
    public void test24Axes() {
        Quaternion quaternion = new Quaternion().rotateByAngleX(0.7853982f).rotateByAngleY(1.5707964f);
        Matrix4f matrix4f = new Matrix4f();
        quaternion.toMatrix(matrix4f);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        matrix4f.getColumn(0, vec3f);
        matrix4f.getColumn(1, vec3f2);
        matrix4f.getColumn(2, vec3f3);
        Quaternion quaternion2 = new Quaternion().setFromAxes(vec3f, vec3f2, vec3f3);
        Assert.assertEquals((Object)quaternion, (Object)quaternion2);
        Quaternion quaternion3 = new Quaternion().setFromMat(matrix4f);
        Assert.assertEquals((Object)quaternion3, (Object)quaternion2);
        quaternion2.toAxes(vec3f, vec3f2, vec3f3, matrix4f);
        quaternion3.setFromAxes(vec3f, vec3f2, vec3f3);
        Assert.assertEquals((Object)quaternion, (Object)quaternion3);
        Assert.assertEquals((Object)quaternion2, (Object)quaternion3);
    }

    @Test
    public void test25Slerp() {
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion().rotateByAngleY(1.5707964f);
        Vec3f vec3f = new Vec3f(FloatUtil.sin((float)0.7853982f), 0.0f, FloatUtil.sin((float)0.7853982f));
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion3 = new Quaternion();
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(UNIT_Z, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        if (!vec3f.equals((Object)vec3f2)) {
            System.err.println("Deviance: " + vec3f + ", " + vec3f2 + ": " + vec3f.minus(vec3f2) + ", dist " + vec3f.dist(vec3f2));
        }
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 1.0f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(NEG_UNIT_X.dist(vec3f2)), (float)1.0E-6f);
        Assert.assertEquals((Object)NEG_UNIT_X, (Object)vec3f2);
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(UNIT_Y.dist(vec3f2)), (float)1.0E-6f);
        if (!UNIT_Y.equals((Object)vec3f2)) {
            System.err.println("Deviance: " + UNIT_Y + ", " + vec3f2 + ": " + UNIT_Y.minus(vec3f2) + ", dist " + UNIT_Y.dist(vec3f2));
        }
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 0.0f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(UNIT_X.dist(vec3f2)), (float)1.0E-6f);
        Assert.assertEquals((Object)UNIT_X, (Object)vec3f2);
        quaternion2.setIdentity();
        quaternion3.setSlerp(quaternion, quaternion2, 0.25f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(UNIT_X.dist(vec3f2)), (float)1.0E-6f);
        Assert.assertEquals((Object)UNIT_X, (Object)vec3f2);
        vec3f.set(0.0f, -FloatUtil.sin((float)0.7853982f), FloatUtil.sin((float)0.7853982f));
        quaternion.setIdentity().rotateByAngleX((float)(-Math.PI));
        quaternion2.setIdentity().rotateByAngleX(1.5707964f);
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(UNIT_Y, vec3f2);
        Assert.assertEquals((float)0.0f, (float)Math.abs(vec3f.dist(vec3f2)), (float)1.0E-6f);
        if (!vec3f.equals((Object)vec3f2)) {
            System.err.println("Deviance: " + vec3f + ", " + vec3f2 + ": " + vec3f.minus(vec3f2) + ", dist " + vec3f.dist(vec3f2));
        }
    }

    @Test
    public void test26LookAt() {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        Vec3f vec3f4 = new Vec3f();
        Vec3f vec3f5 = new Vec3f();
        vec3f.set(NEG_UNIT_X);
        Quaternion quaternion = new Quaternion().setLookAt(vec3f, UNIT_Y, vec3f2, vec3f3, vec3f4);
        Assert.assertEquals((float)0.0f, (float)vec3f.dist(quaternion.rotateVector(UNIT_Z, vec3f5)), (float)1.0E-6f);
        Assert.assertEquals((Object)vec3f, (Object)vec3f5);
        vec3f.set(ONE).normalize();
        quaternion.setLookAt(vec3f, UNIT_Y, vec3f2, vec3f3, vec3f4);
        quaternion.rotateVector(UNIT_Z, vec3f5);
        Assert.assertEquals((float)0.0f, (float)vec3f.dist(vec3f5), (float)1.0E-6f);
        Assert.assertEquals((Object)vec3f, (Object)vec3f5);
        vec3f.set(-1.0f, 2.0f, -1.0f).normalize();
        quaternion.setLookAt(vec3f, UNIT_Y, vec3f2, vec3f3, vec3f4);
        quaternion.rotateVector(UNIT_Z, vec3f5);
        Assert.assertEquals((float)0.0f, (float)vec3f.dist(vec3f5), (float)1.0E-6f);
        if (!vec3f.equals((Object)vec3f5)) {
            System.err.println("Deviance: " + vec3f + ", " + vec3f5 + ": " + vec3f.minus(vec3f5) + ", dist " + vec3f.dist(vec3f5));
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestQuaternion01NOUI.class.getName()});
    }
}

