/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec3f;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestVec3f01NOUI
extends JunitTracer {
    static final boolean DEBUG = false;
    static final Quaternion QUAT_IDENT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    static final Vec3f ZERO = new Vec3f();
    static final Vec3f ONE = Vec3f.ONE;
    static final Vec3f NEG_ONE = new Vec3f(-1.0f, -1.0f, -1.0f);
    static final Vec3f UNIT_X = Vec3f.UNIT_X;
    static final Vec3f UNIT_X_NEG = Vec3f.UNIT_X_NEG;
    static final Vec3f UNIT_Y = Vec3f.UNIT_Y;
    static final Vec3f UNIT_Z = Vec3f.UNIT_Z;
    static final float MACH_EPSILON = 1.1920929E-7f;

    @Test
    public void test01Normalize() {
        Vec3f vec3f = UNIT_X;
        Vec3f vec3f2 = new Vec3f(1.0f, 2.0f, 3.0f);
        Assert.assertEquals((float)1.0f, (float)vec3f.length(), (float)1.1920929E-7f);
        Assert.assertEquals((float)1.0f, (float)vec3f2.normalize().length(), (float)1.1920929E-7f);
    }

    @Test
    public void test02Angle() {
        System.err.println("Test 0-deg, UNIT_X vecs");
        Vec3f vec3f = UNIT_X;
        Vec3f vec3f2 = UNIT_X;
        System.err.println("v0 " + vec3f);
        System.err.println("v1 " + vec3f2);
        float f = vec3f.angle(vec3f2);
        System.err.println("a0(v0, v1) = " + f + " rad, " + FloatUtil.radToADeg((float)f) + " deg, via dot, acos");
        Assert.assertEquals((float)0.0f, (float)f, (float)1.1920929E-7f);
        System.err.println("Test 0-deg, free vecs");
        vec3f = new Vec3f(0.14f, 0.07f, 0.0f);
        vec3f2 = new Vec3f(0.33f, 0.07f, 0.0f);
        Vec3f vec3f3 = vec3f2.minus(vec3f);
        System.err.println("v0 " + vec3f);
        System.err.println("v1 " + vec3f2);
        System.err.println("v0_1 " + vec3f3);
        float f2 = UNIT_X.angle(vec3f3);
        System.err.println("a0(X, v0_1) = " + f2 + " rad, " + FloatUtil.radToADeg((float)f2) + " deg, via dot, acos");
        Assert.assertEquals((float)0.0f, (float)f2, (float)1.1920929E-7f);
        System.err.println("Test 180-deg, free vecs");
        vec3f = new Vec3f(0.33f, 0.07f, 0.0f);
        vec3f2 = new Vec3f(0.14f, 0.07f, 0.0f);
        vec3f3 = vec3f2.minus(vec3f);
        System.err.println("v0 " + vec3f);
        System.err.println("v1 " + vec3f2);
        System.err.println("v0_1 " + vec3f3);
        f2 = UNIT_X.angle(vec3f3);
        System.err.println("a0(X, v0_1) = " + f2 + " rad, " + FloatUtil.radToADeg((float)f2) + " deg, via dot, acos");
        Assert.assertEquals((float)((float)Math.PI), (float)f2, (float)1.1920929E-7f);
        System.err.println("Test 90-deg, UNIT_X, UNIT_Y vecs");
        vec3f = UNIT_X;
        vec3f2 = UNIT_Y;
        System.err.println("v0 " + vec3f);
        System.err.println("v1 " + vec3f2);
        float f3 = vec3f.angle(vec3f2);
        System.err.println("a0(v0, v1) = " + f3 + " rad, " + FloatUtil.radToADeg((float)f3) + " deg, via dot, acos");
        Assert.assertEquals((float)1.5707964f, (float)f3, (float)1.1920929E-7f);
        System.err.println("Test 180-deg, UNIT_X, UNIT_X_NEG vecs");
        vec3f = UNIT_X;
        vec3f2 = UNIT_X_NEG;
        System.err.println("v0 " + vec3f);
        System.err.println("v1 " + vec3f2);
        f3 = vec3f.angle(vec3f2);
        System.err.println("a0(v0, v1) = " + f3 + " rad, " + FloatUtil.radToADeg((float)f3) + " deg, via dot, acos");
        Assert.assertEquals((float)((float)Math.PI), (float)f3, (float)1.1920929E-7f);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestVec3f01NOUI.class.getName()});
    }
}

