/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindows02NEWTAnimated
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        GLWindow gLWindow;
        Object object;
        Assert.assertNotNull((Object)gLCapabilities);
        gLCapabilities.setOnscreen(bl);
        if (null != screen) {
            object = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)object);
            gLWindow = GLWindow.create((Window)object);
        } else {
            gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setUndecorated(bl && bl2);
        object = new GearsES2(bl3 ? 1 : 0);
        TestGLWindows02NEWTAnimated.setDemoFields((GLEventListener)object, gLWindow);
        gLWindow.addGLEventListener((GLEventListener)object);
        gLWindow.addWindowListener((WindowListener)new TraceWindowAdapter());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        gLWindow.setSize(n, n2);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLWindow.getChosenGLCapabilities();
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        Assert.assertTrue((gLCapabilitiesImmutable.getGreenBits() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable.getBlueBits() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable.getRedBits() >= 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable.isOnscreen(), (Object)bl);
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    @Test
    public void testWindowDecor01Simple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(null, gLCapabilities, width, height, true, false, true);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(1, null);
        Assert.assertTrue((boolean)animator.start());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        animator.remove((GLAutoDrawable)gLWindow);
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertTrue((boolean)animator.stop());
    }

    @Test
    public void testWindowDecor02DestroyWinTwiceA() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(null, gLCapabilities, width, height, true, false, true);
        Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(1, null);
        Assert.assertTrue((boolean)animator.start());
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        animator.add((GLAutoDrawable)gLWindow);
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        animator.remove((GLAutoDrawable)gLWindow);
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertTrue((boolean)animator.stop());
    }

    @Test
    public void testWindowDecor03TwoWinOneDisplay() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setPosition(0, 0);
        GLWindow gLWindow2 = TestGLWindows02NEWTAnimated.createWindow(screen, gLCapabilities, width - 10, height - 10, true, false, true);
        Assert.assertNotNull((Object)gLWindow2);
        RectangleImmutable rectangleImmutable = screen.getViewportInWindowUnits();
        gLWindow2.setPosition(rectangleImmutable.getWidth() - width, 0);
        Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(1, null);
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertTrue((boolean)animator.start());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        animator.add((GLAutoDrawable)gLWindow);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        animator.add((GLAutoDrawable)gLWindow2);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        gLWindow.destroy();
        animator.remove((GLAutoDrawable)gLWindow);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest + durationPerTest / 10L) {
            Thread.sleep(100L);
        }
        gLWindow2.destroy();
        animator.remove((GLAutoDrawable)gLWindow2);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertTrue((boolean)animator.stop());
    }

    @Test
    public void testWindowDecor03TwoWinTwoDisplays() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null, (boolean)false);
        Assert.assertNotNull((Object)display);
        Display display2 = NewtFactory.createDisplay(null, (boolean)false);
        Assert.assertNotNull((Object)display2);
        Assert.assertNotSame((Object)display, (Object)display2);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setPosition(0, 0);
        Screen screen2 = NewtFactory.createScreen((Display)display2, (int)0);
        Assert.assertNotNull((Object)screen2);
        GLWindow gLWindow2 = TestGLWindows02NEWTAnimated.createWindow(screen2, gLCapabilities, width - 10, height - 10, true, false, true);
        Assert.assertNotNull((Object)gLWindow2);
        RectangleImmutable rectangleImmutable = screen2.getViewportInWindowUnits();
        gLWindow2.setPosition(rectangleImmutable.getWidth() - width, 0);
        Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(1, null);
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertTrue((boolean)animator.start());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        animator.add((GLAutoDrawable)gLWindow);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        animator.add((GLAutoDrawable)gLWindow2);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        animator.remove((GLAutoDrawable)gLWindow);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest + durationPerTest / 10L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.pause());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.resume());
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow2);
        animator.remove((GLAutoDrawable)gLWindow2);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertTrue((boolean)animator.stop());
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull((Object)gLEventListener);
        Assert.assertNotNull((Object)gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestGLWindows02NEWTAnimated.atoi(stringArray[++i]);
        }
        String string = TestGLWindows02NEWTAnimated.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
    }
}

