/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestWindows02NEWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        NativeWindowFactory.initSingleton();
        width = 800;
        height = 600;
    }

    static Window createWindow(Capabilities capabilities, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws InterruptedException {
        boolean bl3 = n >= 0 && n2 >= 0;
        Assert.assertNotNull((Object)capabilities);
        capabilities.setOnscreen(bl);
        Window window = NewtFactory.createWindow((CapabilitiesImmutable)capabilities);
        Assert.assertNotNull((Object)window);
        Screen screen = window.getScreen();
        Display display = screen.getDisplay();
        window.setUndecorated(bl && bl2);
        if (bl3) {
            window.setPosition(n, n2);
        }
        window.setSize(n3, n4);
        Assert.assertEquals((Object)false, (Object)window.isNativeValid());
        Assert.assertEquals((Object)false, (Object)window.isVisible());
        window.setVisible(true);
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        Assert.assertEquals((long)n3, (long)window.getWidth());
        Assert.assertEquals((long)n4, (long)window.getHeight());
        CapabilitiesImmutable capabilitiesImmutable = window.getGraphicsConfiguration().getChosenCapabilities();
        Assert.assertNotNull((Object)capabilitiesImmutable);
        Assert.assertTrue((capabilitiesImmutable.getGreenBits() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((capabilitiesImmutable.getBlueBits() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((capabilitiesImmutable.getRedBits() >= 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)capabilitiesImmutable.isOnscreen(), (Object)bl);
        return window;
    }

    static void destroyWindow(Window window, boolean bl) {
        if (null == window) {
            return;
        }
        Screen screen = window.getScreen();
        Display display = screen.getDisplay();
        window.destroy();
        if (bl) {
            Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
            Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        } else {
            Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
            Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        }
        Assert.assertEquals((Object)false, (Object)window.isNativeValid());
        Assert.assertEquals((Object)false, (Object)window.isVisible());
    }

    @Test
    public void test01WindowDefault() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull((Object)capabilities);
        Window window = TestWindows02NEWT.createWindow(capabilities, -1, -1, width, height, true, false);
        CapabilitiesImmutable capabilitiesImmutable = window.getGraphicsConfiguration().getChosenCapabilities();
        System.err.println("XXX: " + capabilitiesImmutable);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        TestWindows02NEWT.destroyWindow(window, true);
    }

    @Test
    public void test02WindowDefault() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull((Object)capabilities);
        capabilities.setBackgroundOpaque(false);
        Window window = TestWindows02NEWT.createWindow(capabilities, -1, -1, width, height, true, false);
        CapabilitiesImmutable capabilitiesImmutable = window.getGraphicsConfiguration().getChosenCapabilities();
        System.err.println("XXX: " + capabilitiesImmutable);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        TestWindows02NEWT.destroyWindow(window, true);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestWindows02NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
    }
}

