/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Robot;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class BaseNewtEventModifiers
extends UITestCase {
    protected static final int TEST_FRAME_X = 100;
    protected static final int TEST_FRAME_Y = 100;
    protected static final int TEST_FRAME_WIDTH = 400;
    protected static final int TEST_FRAME_HEIGHT = 400;
    protected static final int INITIAL_MOUSE_X = 300;
    protected static final int INITIAL_MOUSE_Y = 300;
    protected static final int MS_ROBOT_KEY_PRESS_DELAY = 50;
    protected static final int MS_ROBOT_KEY_RELEASE_DELAY = 50;
    protected static final int MS_ROBOT_MOUSE_MOVE_DELAY = 200;
    protected static final int MS_ROBOT_AUTO_DELAY = 50;
    protected static final int MS_ROBOT_POST_TEST_DELAY = 100;
    protected static final boolean _debug = true;
    protected static final PrintStream _debugPrintStream = System.err;
    private static int _numButtonsToTest;
    private static int[] _awtButtonMasks;
    protected static Robot _robot;
    protected static TestMouseListener _testMouseListener;

    public static int getAWTButtonMask(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 8;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only buttons 1-3 have a MASK value, requested button " + n);
            }
        }
        return n2;
    }

    public static void baseBeforeClass() throws Exception {
        _numButtonsToTest = 3;
        _numButtonsToTest = 3;
        if (_numButtonsToTest > 16) {
            _numButtonsToTest = 16;
        }
        _awtButtonMasks = new int[_numButtonsToTest];
        for (int i = 0; i < _awtButtonMasks.length; ++i) {
            BaseNewtEventModifiers._awtButtonMasks[i] = BaseNewtEventModifiers.getAWTButtonMask(i + 1);
        }
        _robot = new Robot();
        _robot.setAutoWaitForIdle(true);
        _testMouseListener = new TestMouseListener();
    }

    protected void eventDispatch() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execOffThreadWithOnThreadEventDispatch(Runnable runnable) throws Exception {
        _testMouseListener.setModifierCheckEnabled(false);
        _robot.setAutoDelay(50);
        this.clearKeyboadAndMouse();
        _testMouseListener.setModifierCheckEnabled(true);
        RunnableTask runnableTask = new RunnableTask(runnable, null, true, System.err);
        try {
            new InterruptSource.Thread(null, (Runnable)runnableTask, "Test-Thread").start();
            int n = 0;
            while (runnableTask.isInQueue()) {
                System.err.println("WAIT-till-done: eventDispatch() #" + n++);
                this.eventDispatch();
            }
            Throwable throwable = runnableTask.getThrowable();
            if (null != throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            System.err.println("WAIT-till-done: DONE");
            _testMouseListener.setModifierCheckEnabled(false);
            this.clearKeyboadAndMouse();
        }
    }

    @Test(timeout=180000L)
    public void test01SingleButtonPressAndRelease() throws Exception {
        this.execOffThreadWithOnThreadEventDispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseNewtEventModifiers.this._doSingleButtonPressAndRelease(0, 0);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Test(timeout=180000L)
    public void test02SingleButtonPressAndReleaseWithShift() throws Exception {
        this.execOffThreadWithOnThreadEventDispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseNewtEventModifiers.this._doSingleButtonPressAndRelease(16, 64);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Test(timeout=180000L)
    public void test03SingleButtonPressAndReleaseWithCtrl() throws Exception {
        this.execOffThreadWithOnThreadEventDispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseNewtEventModifiers.this._doSingleButtonPressAndRelease(17, 128);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Test(timeout=180000L)
    public void test10HoldOneButtonAndPressAnother() throws Exception {
        this.execOffThreadWithOnThreadEventDispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseNewtEventModifiers.this._doHoldOneButtonAndPressAnother(0, 0);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Test(timeout=180000L)
    public void test20PressAllButtonsInSequence() throws Exception {
        this.execOffThreadWithOnThreadEventDispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseNewtEventModifiers.this._doPressAllButtonsInSequence(0, 0);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Test(timeout=180000L)
    public void test30SingleButtonClickAndDrag() throws Exception {
        this.execOffThreadWithOnThreadEventDispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseNewtEventModifiers.this._doSingleButtonClickAndDrag(0, 0);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    private void _doSingleButtonPressAndRelease(int n, int n2) throws Exception {
        _debugPrintStream.println("\n>>>> _doSingleButtonPressAndRelease");
        this._doKeyPress(n);
        for (int i = 0; i < _numButtonsToTest; ++i) {
            int n3 = _awtButtonMasks[i];
            _debugPrintStream.println("*** pressing button " + (i + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3));
            _robot.mousePress(n3);
            this._checkFailures("mouse-press(" + (i + 1) + ")", 1);
            _debugPrintStream.println("*** releasing button " + (i + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3));
            _robot.mouseRelease(n3);
            this._checkFailures("mouse-release(" + (i + 1) + ")", 1);
        }
        this._doKeyRelease(n);
    }

    private void _doHoldOneButtonAndPressAnother(int n, int n2) throws Exception {
        _debugPrintStream.println("\n>>>> _doHoldOneButtonAndPressAnother");
        this._doKeyPress(n);
        for (int i = 0; i < _numButtonsToTest; ++i) {
            int n3 = _awtButtonMasks[i];
            _debugPrintStream.println("*** pressing button " + (i + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3));
            _robot.mousePress(n3);
            this._checkFailures("mouse-press(" + (i + 1) + ")", 1);
            for (int j = 0; j < _numButtonsToTest; ++j) {
                if (i == j) continue;
                _debugPrintStream.println("*** pressing additional button " + (j + 1));
                _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3 | _awtButtonMasks[j]));
                _robot.mousePress(_awtButtonMasks[j]);
                this._checkFailures("mouse-press(" + (i + 1) + ", " + (j + 1) + ")", 1);
                _debugPrintStream.println("*** releasing additional button " + (j + 1));
                _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3 | _awtButtonMasks[j]));
                _robot.mouseRelease(_awtButtonMasks[j]);
                this._checkFailures("mouse-release(" + (i + 1) + ", " + (j + 1) + ")", 1);
            }
            _debugPrintStream.println("*** releasing button " + (i + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3));
            _robot.mouseRelease(n3);
            this._checkFailures("mouse-release(" + (i + 1) + ")", 1);
        }
        this._doKeyRelease(n);
    }

    private void _doPressAllButtonsInSequence(int n, int n2) throws Exception {
        int n3;
        _debugPrintStream.println("\n>>>> _doPressAllButtonsInSequence");
        this._doKeyPress(n);
        int n4 = 0;
        for (n3 = 0; n3 < _numButtonsToTest; ++n3) {
            _debugPrintStream.println("*** pressing button " + (n3 + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | (n4 |= _awtButtonMasks[n3])));
            _robot.mousePress(_awtButtonMasks[n3]);
            this._checkFailures("mouse-press(" + (n3 + 1) + ")", 1);
        }
        for (n3 = _numButtonsToTest - 1; n3 >= 0; --n3) {
            _debugPrintStream.println("*** releasing button " + (n3 + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n4));
            _robot.mouseRelease(_awtButtonMasks[n3]);
            this._checkFailures("mouse-release(" + (n3 + 1) + ")", 1);
            n4 &= ~_awtButtonMasks[n3];
        }
        this._doKeyRelease(n);
    }

    private void _doSingleButtonClickAndDrag(int n, int n2) throws Exception {
        _debugPrintStream.println("\n>>>> _doSingleButtonClickAndDrag");
        this._doKeyPress(n);
        _testMouseListener.setModifierCheckEnabled(true);
        for (int i = 0; i < _numButtonsToTest; ++i) {
            int n3 = _awtButtonMasks[i];
            _debugPrintStream.println("*** pressing button " + (i + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3));
            _robot.mousePress(n3);
            this._checkFailures("mouse-press(" + (i + 1) + ")", 1);
            _debugPrintStream.println("*** moving mouse");
            _robot.mouseMove(308, 308);
            _robot.delay(200);
            this._checkFailures("mouse-move(308, 308)", 1);
            _debugPrintStream.println("*** releasing button " + (i + 1));
            _testMouseListener.setExpectedModifiers(this._getNewtModifiersForAwtExtendedModifiers(n2 | n3));
            _robot.mouseRelease(n3);
            this._checkFailures("mouse-release(" + (i + 1) + ")", 1);
            _testMouseListener.setModifierCheckEnabled(false);
            _robot.mouseMove(300, 300);
            _robot.delay(200);
            _testMouseListener.setModifierCheckEnabled(true);
        }
        this._doKeyRelease(n);
    }

    private void _doKeyPress(int n) {
        AWTRobotUtil.validateAWTEDTIsAlive();
        if (n != 0) {
            boolean bl = _testMouseListener.modifierCheckEnabled();
            _testMouseListener.setModifierCheckEnabled(false);
            _robot.keyPress(n);
            _robot.delay(50);
            _testMouseListener.setModifierCheckEnabled(bl);
        }
    }

    private void _doKeyRelease(int n) {
        AWTRobotUtil.validateAWTEDTIsAlive();
        if (n != 0) {
            boolean bl = _testMouseListener.modifierCheckEnabled();
            _testMouseListener.setModifierCheckEnabled(false);
            _robot.keyRelease(n);
            _robot.delay(50);
            _testMouseListener.setModifierCheckEnabled(bl);
        }
    }

    private void _checkFailures(String string, int n) {
        ArrayList<String> arrayList = _testMouseListener.getFailures(n);
        _debugPrintStream.print(this.getSimpleTestName(".") + " - " + string + ": ");
        int n2 = arrayList.size();
        if (n2 == 0) {
            _debugPrintStream.println(" PASSED");
        } else {
            _debugPrintStream.println(" FAILED");
            for (int i = 0; i < n2; ++i) {
                _debugPrintStream.print("         ");
                _debugPrintStream.println(arrayList.get(i));
            }
        }
        Assert.assertTrue((arrayList.size() == 0 ? 1 : 0) != 0);
    }

    public void eventDispatchedPostTestDelay() throws Exception {
        this.eventDispatch();
        this.eventDispatch();
        this.eventDispatch();
        Thread.sleep(100L);
        this.eventDispatch();
        this.eventDispatch();
        this.eventDispatch();
        _testMouseListener.clear();
    }

    public void clearKeyboadAndMouse() throws Exception {
        this._releaseModifiers();
        this._escape();
        this.eventDispatchedPostTestDelay();
    }

    private void _releaseModifiers() {
        if (_robot != null) {
            AWTRobotUtil.validateAWTEDTIsAlive();
            _robot.setAutoDelay(50);
            boolean bl = _testMouseListener.modifierCheckEnabled();
            _testMouseListener.setModifierCheckEnabled(false);
            _robot.keyRelease(16);
            _robot.keyRelease(17);
            for (int i = 0; i < _awtButtonMasks.length; ++i) {
                _robot.mouseRelease(_awtButtonMasks[i]);
            }
            _testMouseListener.setModifierCheckEnabled(bl);
        }
    }

    private void _escape() {
        if (_robot != null) {
            AWTRobotUtil.validateAWTEDTIsAlive();
            _robot.keyPress(27);
            _robot.keyRelease(27);
        }
    }

    private int _getNewtModifiersForAwtExtendedModifiers(int n) {
        int n2 = 0;
        if ((n & 0x40) != 0) {
            n2 |= 1;
        }
        if ((n & 0x80) != 0) {
            n2 |= 2;
        }
        if ((n & 0x100) != 0) {
            n2 |= 4;
        }
        if ((n & 0x200) != 0) {
            n2 |= 8;
        }
        if ((n & 0x2000) != 0) {
            n2 |= 0x10;
        }
        for (int i = 0; i < _numButtonsToTest; ++i) {
            if ((n & BaseNewtEventModifiers.getAWTButtonMask(i + 1)) == 0) continue;
            n2 |= InputEvent.getButtonMask((int)(i + 1));
        }
        return n2;
    }

    static {
        GLProfile.initSingleton();
    }

    private static class TestMouseListener
    implements MouseListener {
        private static final String NO_EVENT_DELIVERY = "no event delivery";
        private boolean _modifierCheckEnabled;
        private int _expectedModifiers;
        private final AtomicInteger _eventCount = new AtomicInteger(0);
        private ArrayList<String> _failures = new ArrayList();

        private TestMouseListener() {
        }

        public synchronized void setModifierCheckEnabled(boolean bl) {
            this._modifierCheckEnabled = bl;
        }

        public synchronized boolean modifierCheckEnabled() {
            return this._modifierCheckEnabled;
        }

        public synchronized void setExpectedModifiers(int n) {
            this._expectedModifiers = n;
            this.clear();
        }

        public synchronized ArrayList<String> clear() {
            ArrayList<String> arrayList = this._failures;
            this._eventCount.set(0);
            this._failures = new ArrayList();
            this._failures.add(NO_EVENT_DELIVERY);
            return arrayList;
        }

        public ArrayList<String> getFailures(int n) {
            int n2;
            for (n2 = 0; n2 < 20 && this._eventCount.get() < n; ++n2) {
                _robot.delay(50);
            }
            if (0 == this._eventCount.get()) {
                _debugPrintStream.println("**** No Event. Waited " + n2 + " * " + 50 + "ms, eventCount " + this._eventCount);
            }
            return this.clear();
        }

        private synchronized void _checkModifiers(MouseEvent mouseEvent) {
            if (this._modifierCheckEnabled) {
                MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getEventType(), mouseEvent.getSource(), mouseEvent.getWhen(), this._expectedModifiers, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.getButton(), mouseEvent.getRotation(), mouseEvent.getRotationScale());
                this._checkModifierMask(mouseEvent2, mouseEvent, 1, "shift");
                this._checkModifierMask(mouseEvent2, mouseEvent, 2, "ctrl");
                this._checkModifierMask(mouseEvent2, mouseEvent, 4, "meta");
                this._checkModifierMask(mouseEvent2, mouseEvent, 8, "alt");
                this._checkModifierMask(mouseEvent2, mouseEvent, 16, "graph");
                for (int i = 0; i < _numButtonsToTest; ++i) {
                    this._checkModifierMask(mouseEvent2, mouseEvent, InputEvent.getButtonMask((int)(i + 1)), "button" + (i + 1));
                }
            }
        }

        private synchronized void _checkModifierMask(MouseEvent mouseEvent, MouseEvent mouseEvent2, int n, String string) {
            if (this._failures.size() == 1 && this._failures.get(0).equals(NO_EVENT_DELIVERY)) {
                this._failures.clear();
            }
            if ((mouseEvent2.getModifiers() & n) != (mouseEvent.getModifiers() & n)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(MouseEvent.getEventTypeString((short)mouseEvent2.getEventType())).append(": mask ").append(string).append(" 0x").append(Integer.toHexString(n));
                stringBuilder.append(", eventCount ").append(this._eventCount).append(", expected:");
                mouseEvent.getModifiersString(stringBuilder);
                stringBuilder.append(", have: ");
                mouseEvent2.getModifiersString(stringBuilder);
                stringBuilder.append(" - full event: ");
                mouseEvent2.toString(stringBuilder);
                this._failures.add(stringBuilder.toString());
            }
        }

        public synchronized void mousePressed(MouseEvent mouseEvent) {
            this._eventCount.incrementAndGet();
            _debugPrintStream.println("MousePressed     " + this._eventCount + ": " + mouseEvent);
            this._checkModifiers(mouseEvent);
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            this._eventCount.incrementAndGet();
            _debugPrintStream.println("MouseReleased    " + this._eventCount + ": " + mouseEvent);
            this._checkModifiers(mouseEvent);
        }

        public synchronized void mouseDragged(MouseEvent mouseEvent) {
            this._eventCount.incrementAndGet();
            _debugPrintStream.println("MouseDragged     " + this._eventCount + ": " + mouseEvent);
            this._checkModifiers(mouseEvent);
        }

        public synchronized void mouseMoved(MouseEvent mouseEvent) {
            _debugPrintStream.println("MouseMoved        ignored: " + mouseEvent);
        }

        public synchronized void mouseClicked(MouseEvent mouseEvent) {
            _debugPrintStream.println("MouseClicked      ignored: " + mouseEvent);
        }

        public synchronized void mouseWheelMoved(MouseEvent mouseEvent) {
            _debugPrintStream.println("MouseWheeleMoved  ignored: " + mouseEvent);
        }

        public synchronized void mouseEntered(MouseEvent mouseEvent) {
            _debugPrintStream.println("MouseEntered      ignored: " + mouseEvent);
        }

        public synchronized void mouseExited(MouseEvent mouseEvent) {
            _debugPrintStream.println("MouseExited       ignored: " + mouseEvent);
        }
    }
}

