/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNewtKeyEventAutoRepeatAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    @Before
    public void initTest() {
    }

    @After
    public void releaseTest() {
    }

    @Test(timeout=180000L)
    public void test01NEWT() throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)glCaps);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        this.testImpl(gLWindow);
        gLWindow.destroy();
    }

    @Test(timeout=180000L)
    public void test02NewtCanvasAWT() throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)glCaps);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        final JFrame jFrame = new JFrame("Swing AWT Parent Frame: " + gLWindow.getTitle());
        jFrame.getContentPane().add((Component)newtCanvasAWT, "Center");
        jFrame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true, null));
        this.testImpl(gLWindow);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLWindow.destroy();
    }

    static void testKeyEventAutoRepeat(Robot robot, NEWTKeyAdapter nEWTKeyAdapter, int n, int n2) {
        int n3;
        int n4;
        int n5;
        System.err.println("KEY Event Auto-Repeat Test: " + n);
        EventObject[][] eventObjectArray = new EventObject[n][2];
        EventObject[][] eventObjectArray2 = new EventObject[n][2];
        nEWTKeyAdapter.reset();
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            System.err.println("+++ KEY Event Auto-Repeat START Input Loop: " + i);
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.keyPress(0, robot, true, 65, n2);
            AWTRobotUtil.keyPress(0, robot, false, 65, 500);
            AWTRobotUtil.waitForIdle(robot);
            n5 = n6 + 2;
            n4 = n6 + 4;
            for (int j = 0; j < 20 && nEWTKeyAdapter.getQueueSize() < n4; ++j) {
                robot.delay(100);
            }
            List<EventObject> list = nEWTKeyAdapter.copyQueue();
            Assert.assertTrue((String)("AR Test didn't collect enough key events: required min " + n5 + ", received " + (nEWTKeyAdapter.getQueueSize() - n6) + ", " + list), (nEWTKeyAdapter.getQueueSize() >= n5 ? 1 : 0) != 0);
            eventObjectArray[i][0] = list.get(n6 + 0);
            eventObjectArray[i][1] = list.get(n6 + 1);
            n6 = list.size() - 2;
            eventObjectArray2[i][0] = list.get(n6 + 0);
            eventObjectArray2[i][1] = list.get(n6 + 1);
            System.err.println("+++ KEY Event Auto-Repeat END   Input Loop: " + i);
            n6 = list.size();
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.keyPress(0, robot, true, 66, 10);
            AWTRobotUtil.keyPress(0, robot, false, 66, 250);
            AWTRobotUtil.waitForIdle(robot);
            for (int j = 0; j < 20 && nEWTKeyAdapter.getQueueSize() < n6 + 2; ++j) {
                robot.delay(100);
            }
            n6 = nEWTKeyAdapter.getQueueSize();
        }
        List<EventObject> list = nEWTKeyAdapter.copyQueue();
        NEWTKeyUtil.validateKeyEventOrder(list);
        int n7 = n5 = 0 < nEWTKeyAdapter.getKeyPressedCount(true) ? 1 : 0;
        if (n5 != 0) {
            n4 = 2 * n;
            n3 = (list.size() - n4 * 2) / 2;
        } else {
            n4 = list.size() / 2;
            n3 = 0;
        }
        NEWTKeyUtil.validateKeyAdapterStats(nEWTKeyAdapter, n4, n4, n3, n3);
        if (n5 == 0) {
            System.err.println("No AUTO-REPEAT triggered by AWT Robot .. aborting test analysis");
            return;
        }
        for (n4 = 0; n4 < n; ++n4) {
            System.err.println("Auto-Repeat Loop " + n4 + " - Head:");
            NEWTKeyUtil.dumpKeyEvents(Arrays.asList(eventObjectArray[n4]));
            System.err.println("Auto-Repeat Loop " + n4 + " - Tail:");
            NEWTKeyUtil.dumpKeyEvents(Arrays.asList(eventObjectArray2[n4]));
        }
        for (n4 = 0; n4 < n; ++n4) {
            KeyEvent keyEvent = (KeyEvent)eventObjectArray[n4][0];
            Assert.assertTrue((String)("1st Shall be A, but is " + keyEvent), (65 == keyEvent.getKeyCode() ? 1 : 0) != 0);
            Assert.assertTrue((String)("1st Shall be PRESSED, but is " + keyEvent), (300 == keyEvent.getEventType() ? 1 : 0) != 0);
            Assert.assertTrue((String)("1st Shall not be AR, but is " + keyEvent), (0 == (0x20000000 & keyEvent.getModifiers()) ? 1 : 0) != 0);
            keyEvent = (KeyEvent)eventObjectArray[n4][1];
            Assert.assertTrue((String)("2nd Shall be A, but is " + keyEvent), (65 == keyEvent.getKeyCode() ? 1 : 0) != 0);
            Assert.assertTrue((String)("2nd Shall be RELEASED, but is " + keyEvent), (301 == keyEvent.getEventType() ? 1 : 0) != 0);
            Assert.assertTrue((String)("2nd Shall be AR, but is " + keyEvent), (0 != (0x20000000 & keyEvent.getModifiers()) ? 1 : 0) != 0);
            keyEvent = (KeyEvent)eventObjectArray2[n4][0];
            Assert.assertTrue((String)("last-1 Shall be A, but is " + keyEvent), (65 == keyEvent.getKeyCode() ? 1 : 0) != 0);
            Assert.assertTrue((String)("last-1 Shall be PRESSED, but is " + keyEvent), (300 == keyEvent.getEventType() ? 1 : 0) != 0);
            Assert.assertTrue((String)("last-1 Shall be AR, but is " + keyEvent), (0 != (0x20000000 & keyEvent.getModifiers()) ? 1 : 0) != 0);
            keyEvent = (KeyEvent)eventObjectArray2[n4][1];
            Assert.assertTrue((String)("last-0 Shall be A, but is " + keyEvent), (65 == keyEvent.getKeyCode() ? 1 : 0) != 0);
            Assert.assertTrue((String)("last-2 Shall be RELEASED, but is " + keyEvent), (301 == keyEvent.getEventType() ? 1 : 0) != 0);
            Assert.assertTrue((String)("last-0 Shall not be AR, but is " + keyEvent), (0 == (0x20000000 & keyEvent.getModifiers()) ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testImpl(GLWindow gLWindow) throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener((GLEventListener)redSquareES2);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        nEWTKeyAdapter.setVerbose(false);
        gLWindow.addKeyListener((KeyListener)nEWTKeyAdapter);
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        Thread.sleep(durationPerTest);
        AWTRobotUtil.assertRequestFocusAndWait(null, gLWindow, gLWindow, null, null);
        AWTRobotUtil.requestFocus(robot, gLWindow, false);
        nEWTKeyAdapter.reset();
        int n = robot.getAutoDelay();
        robot.setAutoDelay(10);
        try {
            TestNewtKeyEventAutoRepeatAWT.testKeyEventAutoRepeat(robot, nEWTKeyAdapter, 3, 1000);
        }
        finally {
            robot.setAutoDelay(n);
        }
        gLWindow.removeKeyListener((KeyListener)nEWTKeyAdapter);
        animator.stop();
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestNewtKeyEventAutoRepeatAWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestNewtKeyEventAutoRepeatAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
        awtWaitTimeout = 1000L;
    }
}

