/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.newt.TestListenerCom01AWT;
import com.jogamp.opengl.test.junit.util.AWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.AWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTMouseAdapter;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.EventCountAdapterUtil;
import com.jogamp.opengl.test.junit.util.InputEventCountAdapter;
import com.jogamp.opengl.test.junit.util.NEWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.TestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Component;
import java.awt.Robot;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParentingFocus01SwingAWTRobot
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    @Test
    public void testFocus01ProgrFocus() throws AWTException, InterruptedException, InvocationTargetException {
        this.testFocus01ProgrFocusImpl(null);
    }

    @Test
    public void testFocus02RobotFocus() throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        this.testFocus01ProgrFocusImpl(robot);
    }

    private void testFocus01ProgrFocusImpl(Robot robot) throws AWTException, InvocationTargetException, InterruptedException {
        ArrayList<InputEventCountAdapter> arrayList = new ArrayList<InputEventCountAdapter>();
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)glCaps);
        gLWindow.setTitle("testNewtChildFocus");
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestListenerCom01AWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener((GLEventListener)redSquareES2);
        NEWTFocusAdapter nEWTFocusAdapter = new NEWTFocusAdapter("GLWindow1");
        gLWindow.addWindowListener((WindowListener)nEWTFocusAdapter);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        arrayList.add(nEWTKeyAdapter);
        gLWindow.addKeyListener((KeyListener)nEWTKeyAdapter);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        AWTKeyAdapter aWTKeyAdapter = new AWTKeyAdapter("NewtCanvasAWT");
        newtCanvasAWT.addKeyListener((java.awt.event.KeyListener)aWTKeyAdapter);
        arrayList.add(aWTKeyAdapter);
        AWTFocusAdapter aWTFocusAdapter = new AWTFocusAdapter("NewtCanvasAWT");
        newtCanvasAWT.addFocusListener((FocusListener)aWTFocusAdapter);
        final JFrame jFrame = new JFrame("Swing AWT Parent Frame: " + gLWindow.getTitle());
        jFrame.getContentPane().add((Component)newtCanvasAWT, "Center");
        Button button = new Button("Click me ..");
        AWTFocusAdapter aWTFocusAdapter2 = new AWTFocusAdapter("Button");
        button.addFocusListener(aWTFocusAdapter2);
        AWTKeyAdapter aWTKeyAdapter2 = new AWTKeyAdapter("Button");
        button.addKeyListener(aWTKeyAdapter2);
        arrayList.add(aWTKeyAdapter2);
        AWTMouseAdapter aWTMouseAdapter = new AWTMouseAdapter("Button");
        button.addMouseListener(aWTMouseAdapter);
        arrayList.add(aWTMouseAdapter);
        jFrame.getContentPane().add((Component)button, "North");
        jFrame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true, null));
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        AWTRobotUtil.clearAWTFocus(robot);
        Assert.assertTrue((boolean)AWTRobotUtil.toFrontAndRequestFocus(robot, jFrame));
        Thread.sleep(durationPerTest);
        int n = 0;
        while ((long)n < awtWaitTimeout / 100L && gLWindow.getTotalFPSFrames() < 1) {
            Thread.sleep(awtWaitTimeout / 10L);
            ++n;
        }
        System.err.println("Frames for initial setVisible(true): " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue((boolean)gLWindow.isVisible());
        Assert.assertTrue((0 < gLWindow.getTotalFPSFrames() ? 1 : 0) != 0);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        Thread.sleep(200L);
        System.err.println("FOCUS AWT  Button request");
        EventCountAdapterUtil.reset(arrayList);
        AWTRobotUtil.assertRequestFocusAndWait(robot, button, button, aWTFocusAdapter2, null);
        Assert.assertEquals((Object)false, (Object)nEWTFocusAdapter.focusGained());
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter.focusGained());
        System.err.println("FOCUS AWT  Button sync");
        AWTRobotUtil.assertKeyType(robot, 65, 2, button, aWTKeyAdapter2);
        AWTRobotUtil.assertMouseClick(robot, 16, 1, button, aWTMouseAdapter);
        AWTRobotUtil.assertMouseClick(robot, 16, 2, button, aWTMouseAdapter);
        Thread.sleep(100L);
        System.err.println("FOCUS NEWT Canvas/GLWindow request");
        EventCountAdapterUtil.reset(arrayList);
        AWTRobotUtil.assertRequestFocusAndWait(robot, newtCanvasAWT, newtCanvasAWT.getNEWTChild(), nEWTFocusAdapter, aWTFocusAdapter2);
        if (!TestUtil.waitForFocus(nEWTFocusAdapter, aWTFocusAdapter, null)) {
            System.err.println("Info: Focus prev. gained, but NewtCanvasAWT didn't loose it. Gainer: " + nEWTFocusAdapter + "; Looser " + aWTFocusAdapter);
        }
        System.err.println("FOCUS NEWT Canvas/GLWindow sync");
        AWTRobotUtil.assertKeyType(robot, 65, 2, gLWindow, nEWTKeyAdapter);
        Assert.assertEquals((String)"AWT parent canvas received non consumed keyboard events", (long)aWTKeyAdapter.getConsumedCount(), (long)aWTKeyAdapter.getCount());
        if (!newtCanvasAWT.isAWTEventPassThrough()) {
            Assert.assertEquals((String)"AWT parent canvas received consumed keyboard events", (long)0L, (long)aWTKeyAdapter.getConsumedCount());
        }
        gLWindow.removeKeyListener((KeyListener)nEWTKeyAdapter);
        gLWindow.removeWindowListener((WindowListener)nEWTFocusAdapter);
        newtCanvasAWT.removeKeyListener((java.awt.event.KeyListener)aWTKeyAdapter);
        newtCanvasAWT.removeFocusListener((FocusListener)aWTFocusAdapter);
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLWindow.destroy();
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestParentingFocus01SwingAWTRobot.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestParentingFocus01SwingAWTRobot.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 10L;
        awtWaitTimeout = 1000L;
    }
}

