/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.AWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTMouseAdapter;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.EventCountAdapterUtil;
import com.jogamp.opengl.test.junit.util.InputEventCountAdapter;
import com.jogamp.opengl.test.junit.util.NEWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.NEWTMouseAdapter;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.TestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Robot;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParentingFocus02SwingAWTRobot
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() throws AWTException, InterruptedException, InvocationTargetException {
        width = 640;
        height = 480;
        final JFrame jFrame = new JFrame();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setSize(100, 100);
                jFrame.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.dispose();
            }
        });
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    private void testFocus01ProgrFocusImpl(Robot robot) throws AWTException, InterruptedException, InvocationTargetException {
        ArrayList<InputEventCountAdapter> arrayList = new ArrayList<InputEventCountAdapter>();
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)glCaps);
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        GearsES2 gearsES2 = new GearsES2();
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        NEWTFocusAdapter nEWTFocusAdapter = new NEWTFocusAdapter("GLWindow1");
        gLWindow.addWindowListener((WindowListener)nEWTFocusAdapter);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        gLWindow.addKeyListener((KeyListener)nEWTKeyAdapter);
        arrayList.add(nEWTKeyAdapter);
        NEWTMouseAdapter nEWTMouseAdapter = new NEWTMouseAdapter("GLWindow1");
        gLWindow.addMouseListener((MouseListener)nEWTMouseAdapter);
        arrayList.add(nEWTMouseAdapter);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        AWTFocusAdapter aWTFocusAdapter = new AWTFocusAdapter("NewtCanvasAWT");
        newtCanvasAWT.addFocusListener((FocusListener)aWTFocusAdapter);
        AWTKeyAdapter aWTKeyAdapter = new AWTKeyAdapter("NewtCanvasAWT");
        newtCanvasAWT.addKeyListener((java.awt.event.KeyListener)aWTKeyAdapter);
        arrayList.add(aWTKeyAdapter);
        AWTMouseAdapter aWTMouseAdapter = new AWTMouseAdapter("NewtCanvasAWT");
        newtCanvasAWT.addMouseListener((java.awt.event.MouseListener)aWTMouseAdapter);
        arrayList.add(aWTMouseAdapter);
        Button button = new Button("north");
        AWTFocusAdapter aWTFocusAdapter2 = new AWTFocusAdapter("ButtonNorthInner");
        button.addFocusListener(aWTFocusAdapter2);
        AWTKeyAdapter aWTKeyAdapter2 = new AWTKeyAdapter("ButtonNorthInner");
        button.addKeyListener(aWTKeyAdapter2);
        arrayList.add(aWTKeyAdapter2);
        AWTMouseAdapter aWTMouseAdapter2 = new AWTMouseAdapter("ButtonNorthInner");
        button.addMouseListener(aWTMouseAdapter2);
        arrayList.add(aWTMouseAdapter2);
        final Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)button, "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        Button button2 = new Button("north");
        AWTFocusAdapter aWTFocusAdapter3 = new AWTFocusAdapter("ButtonNorthOuter");
        button2.addFocusListener(aWTFocusAdapter3);
        AWTKeyAdapter aWTKeyAdapter3 = new AWTKeyAdapter("ButtonNorthOuter");
        button2.addKeyListener(aWTKeyAdapter3);
        arrayList.add(aWTKeyAdapter3);
        AWTMouseAdapter aWTMouseAdapter3 = new AWTMouseAdapter("ButtonNorthOuter");
        button2.addMouseListener(aWTMouseAdapter3);
        arrayList.add(aWTMouseAdapter3);
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)button2, "North");
        jPanel.add((Component)new Button("south"), "South");
        jPanel.add((Component)new Button("east"), "East");
        jPanel.add((Component)new Button("west"), "West");
        jPanel.add((Component)container, "Center");
        final JFrame jFrame = new JFrame("Swing Parent JFrame");
        jFrame.setDefaultCloseOperation(0);
        jFrame.setContentPane(jPanel);
        jFrame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true, null));
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        AWTRobotUtil.clearAWTFocus(robot);
        Assert.assertTrue((boolean)AWTRobotUtil.toFrontAndRequestFocus(robot, jFrame));
        int n = 0;
        while ((long)n < awtWaitTimeout / 10L && gLWindow.getTotalFPSFrames() < 1) {
            Thread.sleep(awtWaitTimeout / 100L);
            ++n;
        }
        System.err.println("Frames for initial setVisible(true): " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue((boolean)gLWindow.isVisible());
        Assert.assertTrue((0 < gLWindow.getTotalFPSFrames() ? 1 : 0) != 0);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        Thread.sleep(durationPerTest);
        Thread.sleep(100L);
        System.err.println("FOCUS AWT  Button Outer request.1");
        EventCountAdapterUtil.reset(arrayList);
        AWTRobotUtil.assertRequestFocusAndWait(robot, button2, button2, aWTFocusAdapter3, null);
        Assert.assertEquals((Object)false, (Object)nEWTFocusAdapter.focusGained());
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter.focusGained());
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter2.focusGained());
        System.err.println("FOCUS AWT  Button Outer sync.1");
        AWTRobotUtil.assertKeyType(robot, 65, 2, button2, aWTKeyAdapter3);
        AWTRobotUtil.assertMouseClick(robot, 16, 1, button2, aWTMouseAdapter3);
        AWTRobotUtil.assertMouseClick(robot, 16, 2, button2, aWTMouseAdapter3);
        Thread.sleep(100L);
        System.err.println("FOCUS NEWT Canvas/GLWindow request.2");
        EventCountAdapterUtil.reset(arrayList);
        AWTRobotUtil.assertRequestFocusAndWait(robot, newtCanvasAWT, newtCanvasAWT.getNEWTChild(), nEWTFocusAdapter, aWTFocusAdapter3);
        if (!TestUtil.waitForFocus(nEWTFocusAdapter, aWTFocusAdapter, null)) {
            System.err.println("Info: Focus prev. gained, but NewtCanvasAWT didn't loose it. Gainer: " + nEWTFocusAdapter + "; Looser " + aWTFocusAdapter);
        }
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter2.focusGained());
        System.err.println("FOCUS NEWT Canvas/GLWindow sync.2");
        AWTRobotUtil.assertKeyType(robot, 65, 2, gLWindow, nEWTKeyAdapter);
        Assert.assertEquals((String)"AWT parent canvas received non consumed keyboard events", (long)aWTKeyAdapter.getConsumedCount(), (long)aWTKeyAdapter.getCount());
        System.err.println("FOCUS NEWT Canvas/GLWindow sync.2.2");
        AWTRobotUtil.assertMouseClick(robot, 16, 1, gLWindow, nEWTMouseAdapter);
        System.err.println("FOCUS NEWT Canvas/GLWindow sync.2.3");
        AWTRobotUtil.assertMouseClick(robot, 16, 2, gLWindow, nEWTMouseAdapter);
        System.err.println("FOCUS NEWT Canvas/GLWindow sync.2.4");
        if (!newtCanvasAWT.isAWTEventPassThrough()) {
            Assert.assertEquals((String)"AWT parent canvas received consumed keyboard events", (long)0L, (long)aWTKeyAdapter.getConsumedCount());
            Assert.assertEquals((String)"AWT parent canvas received mouse events", (long)0L, (long)aWTMouseAdapter.getCount());
        }
        Thread.sleep(100L);
        System.err.println("FOCUS AWT  Button request.3");
        EventCountAdapterUtil.reset(arrayList);
        AWTRobotUtil.assertRequestFocusAndWait(robot, button, button, aWTFocusAdapter2, nEWTFocusAdapter);
        Assert.assertEquals((Object)false, (Object)nEWTFocusAdapter.focusGained());
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter.focusGained());
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter3.focusGained());
        System.err.println("FOCUS AWT  Button sync.3");
        AWTRobotUtil.assertKeyType(robot, 65, 2, button, aWTKeyAdapter2);
        AWTRobotUtil.assertMouseClick(robot, 16, 1, button, aWTMouseAdapter2);
        AWTRobotUtil.assertMouseClick(robot, 16, 2, button, aWTMouseAdapter2);
        Thread.sleep(100L);
        System.err.println("FOCUS NEWT Canvas/GLWindow request.4");
        EventCountAdapterUtil.reset(arrayList);
        AWTRobotUtil.assertRequestFocusAndWait(robot, newtCanvasAWT, newtCanvasAWT.getNEWTChild(), nEWTFocusAdapter, aWTFocusAdapter2);
        if (!TestUtil.waitForFocus(nEWTFocusAdapter, aWTFocusAdapter, null)) {
            System.err.println("Info: Focus prev. gained, but NewtCanvasAWT didn't loose it. Gainer: " + nEWTFocusAdapter + "; Looser " + aWTFocusAdapter);
        }
        Assert.assertEquals((Object)false, (Object)aWTFocusAdapter3.focusGained());
        System.err.println("FOCUS NEWT Canvas/GLWindow sync.4");
        AWTRobotUtil.assertKeyType(robot, 65, 2, gLWindow, nEWTKeyAdapter);
        Assert.assertEquals((String)"AWT parent canvas received non consumed keyboard events", (long)aWTKeyAdapter.getConsumedCount(), (long)aWTKeyAdapter.getCount());
        AWTRobotUtil.assertMouseClick(robot, 16, 1, gLWindow, nEWTMouseAdapter);
        AWTRobotUtil.assertMouseClick(robot, 16, 2, gLWindow, nEWTMouseAdapter);
        if (!newtCanvasAWT.isAWTEventPassThrough()) {
            Assert.assertEquals((String)"AWT parent canvas received consumed keyboard events", (long)0L, (long)aWTKeyAdapter.getConsumedCount());
            Assert.assertEquals((String)"AWT parent canvas received mouse events", (long)0L, (long)aWTMouseAdapter.getCount());
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
                jPanel.remove(container);
                jFrame.dispose();
            }
        });
        gLWindow.destroy();
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
    }

    @Test
    public void testFocus01ProgrFocus() throws AWTException, InterruptedException, InvocationTargetException {
        this.testFocus01ProgrFocusImpl(null);
    }

    @Test
    public void testFocus02RobotFocus() throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        this.testFocus01ProgrFocusImpl(robot);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException, AWTException, InterruptedException, InvocationTargetException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestParentingFocus02SwingAWTRobot.atoi(stringArray[++i]);
        }
        String string = TestParentingFocus02SwingAWTRobot.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 10L;
        awtWaitTimeout = 1000L;
    }
}

