/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01aNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long waitTimeShort;
    static long duration;
    static int mm_width;
    static int mm_height;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01aNEWT.setResetXRandRIfX11AfterClass();
        width = 100;
        height = 100;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static Window createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) {
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener((GLEventListener)new GearsES2());
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue((boolean)NewtTestUtil.waitForRealized(window, false, null));
        }
    }

    @Test
    public void testScreenModeChange01() throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = TestScreenMode01aNEWT.createWindow(screen, gLCapabilities, "win0", 0, 0, width, height);
        Assert.assertNotNull((Object)window);
        MonitorDevice monitorDevice = (MonitorDevice)screen.getMonitorDevices().get(0);
        Rectangle rectangle = window.getBounds();
        Dimension dimension = new Dimension(window.getSurfaceWidth(), window.getSurfaceHeight());
        System.err.println("Test.0: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.0: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.0: Screen viewport  : " + screen.getViewport() + " [pixels], " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.0: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        List list = screen.getMonitorModes();
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode01aNEWT.destroyWindow(window);
            return;
        }
        List list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode01aNEWT.destroyWindow(window);
            return;
        }
        Assert.assertTrue((boolean)list.containsAll(list2));
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull((Object)monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull((Object)monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorMode2);
        list2 = MonitorModeUtil.filterByFlags((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRotation((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByResolution((List)list2, (DimensionImmutable)new Dimension(mm_width + 1, mm_height + 1));
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRate((List)list2, (float)monitorMode2.getRefreshRate());
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp((List)list2);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        MonitorMode monitorMode3 = (MonitorMode)list2.get(0);
        System.err.println("[1] set current: " + monitorMode3);
        boolean bl = monitorDevice.setCurrentMode(monitorMode3);
        MonitorMode monitorMode4 = monitorDevice.getCurrentMode();
        MonitorMode monitorMode5 = monitorDevice.queryCurrentMode();
        boolean bl2 = monitorMode5.equals((Object)monitorMode4);
        System.err.println("[1] changeOK             : " + bl);
        System.err.println("[1] has current cached   : " + monitorMode4);
        System.err.println("[1] has current queried  : " + monitorMode5 + ", equal " + bl2);
        rectangle = window.getBounds();
        dimension = new Dimension(window.getSurfaceWidth(), window.getSurfaceHeight());
        System.err.println("Test.1: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.1: Screen viewport  : " + screen.getViewport() + " [pixels], " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        Assert.assertTrue((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode3, (Object)monitorMode4);
        Assert.assertNotSame((Object)monitorMode2, (Object)monitorMode4);
        Assert.assertEquals((Object)monitorMode4, (Object)monitorDevice.queryCurrentMode());
        Assert.assertTrue((boolean)bl);
        Thread.sleep(duration);
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        TestScreenMode01aNEWT.destroyWindow(window);
        Assert.assertEquals((Object)false, (Object)window.isVisible());
        Assert.assertEquals((Object)false, (Object)window.isNativeValid());
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized(screen, false, null));
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Thread.sleep(waitTimeShort);
        this.validateScreenModeReset(monitorMode2, 0);
    }

    void validateScreenModeReset(MonitorMode monitorMode, int n) {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        screen.addReference();
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        MonitorDevice monitorDevice = (MonitorDevice)screen.getMonitorDevices().get(0);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.getCurrentMode());
        screen.removeReference();
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-mwidth")) {
                mm_width = MiscUtils.atoi(stringArray[++i], mm_width);
                continue;
            }
            if (!stringArray[i].equals("-mheight")) continue;
            mm_height = MiscUtils.atoi(stringArray[++i], mm_height);
        }
        System.err.println("Desired mode w/ resolution " + mm_width + "x" + mm_height);
        String string = TestScreenMode01aNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        waitTimeShort = 2000L;
        duration = 4000L;
        mm_width = 800;
        mm_height = 600;
    }
}

