/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.test.junit.util.AWTWindowFocusAdapter;
import com.jogamp.opengl.test.junit.util.FocusEventCountAdapter;
import com.jogamp.opengl.test.junit.util.InputEventCountAdapter;
import com.jogamp.opengl.test.junit.util.KeyEventCountAdapter;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.TestUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import jogamp.newt.awt.event.AWTNewtEventFactory;
import org.junit.Assert;

public class AWTRobotUtil
extends TestUtil {
    static final boolean DEBUG = false;
    public static final int ROBOT_DELAY = 100;
    public static Integer AWT_CLICK_TO = null;
    private static Runnable aliveRun;
    private static Object awtEDTAliveSync;
    private static volatile boolean awtEDTAliveFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAWTEDTAlive() {
        if (EventQueue.isDispatchThread()) {
            return true;
        }
        Object object = awtEDTAliveSync;
        synchronized (object) {
            awtEDTAliveFlag = false;
            EventQueue.invokeLater(aliveRun);
            for (int i = 0; i < 20 && !awtEDTAliveFlag; ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return awtEDTAliveFlag;
        }
    }

    public static void validateAWTEDTIsAlive() {
        if (!AWTRobotUtil.isAWTEDTAlive()) {
            throw new Error("AWT EDT not alive");
        }
    }

    public static void waitForIdle(Robot robot) {
        AWTRobotUtil.validateAWTEDTIsAlive();
        robot.waitForIdle();
    }

    public static void clearAWTFocus(Robot robot) throws InterruptedException, InvocationTargetException, AWTException {
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("******** clearAWTFocus.0");
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
        });
        robot.delay(100);
        System.err.println("******** clearAWTFocus.X");
    }

    public static int[] getCenterLocation(Object object, boolean bl) throws InterruptedException, InvocationTargetException {
        if (object instanceof com.jogamp.newt.Window) {
            return AWTRobotUtil.getCenterLocationNEWT((com.jogamp.newt.Window)object, bl);
        }
        if (NativeWindowFactory.isAWTAvailable() && object instanceof Component) {
            return AWTRobotUtil.getCenterLocationAWT((Component)object, bl);
        }
        throw new RuntimeException("Neither AWT nor NEWT: " + object);
    }

    private static int[] getCenterLocationNEWT(com.jogamp.newt.Window window, boolean bl) throws InterruptedException, InvocationTargetException {
        Point point = window.getLocationOnScreen(null);
        if (bl) {
            InsetsImmutable insetsImmutable = window.getInsets();
            point.translate(window.getWidth() / 2, insetsImmutable.getTopHeight() / 2);
        } else {
            point.translate(window.getWidth() / 2, window.getHeight() / 2);
        }
        return new int[]{point.getX(), point.getY()};
    }

    private static int[] getCenterLocationAWT(Component component, boolean bl) throws InterruptedException, InvocationTargetException {
        int n;
        java.awt.Point point = component.getLocationOnScreen();
        Rectangle rectangle = component.getBounds();
        if (bl && component instanceof Window) {
            Window window = (Window)component;
            Insets insets = window.getInsets();
            n = (int)(point.getY() + (double)insets.top / 2.0 + 0.5);
        } else {
            n = (int)(point.getY() + rectangle.getHeight() / 2.0 + 0.5);
        }
        int n2 = (int)(point.getX() + rectangle.getWidth() / 2.0 + 0.5);
        return new int[]{n2, n};
    }

    public static int[] getClientLocation(Object object, int n, int n2) throws InterruptedException, InvocationTargetException {
        if (object instanceof com.jogamp.newt.Window) {
            return AWTRobotUtil.getClientLocationNEWT((com.jogamp.newt.Window)object, n, n2);
        }
        if (NativeWindowFactory.isAWTAvailable() && object instanceof Component) {
            return AWTRobotUtil.getClientLocationAWT((Component)object, n, n2);
        }
        throw new RuntimeException("Neither AWT nor NEWT: " + object);
    }

    private static int[] getClientLocationNEWT(com.jogamp.newt.Window window, int n, int n2) throws InterruptedException, InvocationTargetException {
        Point point = window.getLocationOnScreen(null);
        return new int[]{point.getX(), point.getY()};
    }

    private static int[] getClientLocationAWT(Component component, int n, int n2) throws InterruptedException, InvocationTargetException {
        java.awt.Point point = component.getLocationOnScreen();
        return new int[]{(int)point.getX(), (int)point.getY()};
    }

    public static void awtRobotMouseMove(Robot robot, int n, int n2) {
        robot.mouseMove(n, n2);
        robot.delay(100);
    }

    public static boolean toFrontAndRequestFocus(Robot robot, final Window window) throws AWTException, InterruptedException, InvocationTargetException {
        int n;
        AWTWindowFocusAdapter aWTWindowFocusAdapter = new AWTWindowFocusAdapter("window");
        window.addWindowFocusListener(aWTWindowFocusAdapter);
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        int[] nArray = AWTRobotUtil.getCenterLocation(window, false);
        System.err.println("toFront: robot pos: " + nArray[0] + "/" + nArray[1]);
        AWTRobotUtil.awtRobotMouseMove(robot, nArray[0], nArray[1]);
        int n2 = 0;
        do {
            n = n2++;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (0 == n) {
                        window.setVisible(true);
                        window.toFront();
                    }
                    window.requestFocus();
                }
            });
            Thread.sleep(100L);
        } while (n2 < 20 && !window.hasFocus());
        n = n2 < 20 ? 1 : 0;
        window.removeWindowFocusListener(aWTWindowFocusAdapter);
        if (n == 0) {
            System.err.println("*** AWTRobotUtil.toFrontAndRequestFocus() UI failure");
            System.err.println("*** window: " + window);
            System.err.println("*** window.hasFocus(): " + window.hasFocus());
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        return n != 0;
    }

    public static void centerMouse(Robot robot, Object object, boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        int[] nArray = AWTRobotUtil.getCenterLocation(object, bl);
        System.err.println("centerMouse: robot pos: " + nArray[0] + "x" + nArray[1] + ", onTitleBarIfWindow: " + bl);
        AWTRobotUtil.awtRobotMouseMove(robot, nArray[0], nArray[1]);
    }

    public static void setMouseToClientLocation(Robot robot, Object object, int n, int n2) throws AWTException, InterruptedException, InvocationTargetException {
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        int[] nArray = AWTRobotUtil.getClientLocation(object, n, n2);
        AWTRobotUtil.awtRobotMouseMove(robot, nArray[0], nArray[1]);
    }

    private static int getAWTClickTimeout() {
        if (null == AWT_CLICK_TO && null == (AWT_CLICK_TO = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval"))) {
            AWT_CLICK_TO = new Integer(500);
        }
        return AWT_CLICK_TO;
    }

    public static int getClickTimeout(Object object) {
        if (object instanceof com.jogamp.newt.Window) {
            short s = MouseEvent.getClickTimeout();
            int n = AWTRobotUtil.getAWTClickTimeout();
            return Math.max(n, s);
        }
        if (NativeWindowFactory.isAWTAvailable() && object instanceof Component) {
            return AWTRobotUtil.getAWTClickTimeout();
        }
        throw new RuntimeException("Neither AWT nor NEWT: " + object);
    }

    public static void requestFocus(Robot robot, Object object) throws AWTException, InterruptedException, InvocationTargetException {
        AWTRobotUtil.requestFocus(robot, object, true);
    }

    public static void requestFocus(Robot robot, Object object, boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        if (null != robot) {
            AWTRobotUtil.centerMouse(robot, object, bl);
            AWTRobotUtil.waitForIdle(robot);
            robot.mousePress(16);
            robot.mouseRelease(16);
            int n = AWTRobotUtil.getClickTimeout(object) + 1;
            robot.delay(n);
            System.err.println("requestFocus: click, d: " + n + " ms");
        } else if (object instanceof com.jogamp.newt.Window) {
            AWTRobotUtil.requestFocusNEWT((com.jogamp.newt.Window)object, bl);
        } else if (NativeWindowFactory.isAWTAvailable() && object instanceof Component) {
            AWTRobotUtil.requestFocusAWT((Component)object, bl);
        } else {
            throw new RuntimeException("Neither AWT nor NEWT: " + object);
        }
    }

    private static void requestFocusNEWT(com.jogamp.newt.Window window, boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        window.requestFocus();
        System.err.println("requestFocus: NEWT Component");
    }

    private static void requestFocusAWT(final Component component, boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
                System.err.println("requestFocus: AWT Component");
            }
        });
    }

    public static void requestFocus(Robot robot, Object object, int n, int n2) throws AWTException, InterruptedException, InvocationTargetException {
        AWTRobotUtil.validateAWTEDTIsAlive();
        boolean bl = robot.isAutoWaitForIdle();
        robot.mouseMove(n, n2);
        if (bl) {
            robot.waitForIdle();
        } else {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        robot.mousePress(16);
        robot.mouseRelease(16);
        int n3 = AWTRobotUtil.getClickTimeout(object) + 1;
        robot.delay(n3);
    }

    public static boolean hasFocus(Object object) {
        if (object instanceof com.jogamp.newt.Window) {
            return ((com.jogamp.newt.Window)object).hasFocus();
        }
        if (NativeWindowFactory.isAWTAvailable() && object instanceof Component) {
            Component component = (Component)object;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return component == keyboardFocusManager.getPermanentFocusOwner();
        }
        throw new RuntimeException("Neither AWT nor NEWT: " + object);
    }

    public static boolean waitForFocus(Component component, Runnable runnable) throws InterruptedException {
        int n;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        for (n = 0; n < 20 && component != keyboardFocusManager.getPermanentFocusOwner(); ++n) {
            if (null != runnable) {
                runnable.run();
                continue;
            }
            Thread.sleep(100L);
        }
        return n < 20;
    }

    public static boolean waitForFocus(Component component, FocusEventCountAdapter focusEventCountAdapter, FocusEventCountAdapter focusEventCountAdapter2, Runnable runnable) throws InterruptedException {
        if (!AWTRobotUtil.waitForFocus(component, runnable)) {
            return false;
        }
        return TestUtil.waitForFocus(focusEventCountAdapter, focusEventCountAdapter2, runnable);
    }

    public static void assertRequestFocusAndWait(Robot robot, Object object, Object object2, FocusEventCountAdapter focusEventCountAdapter, FocusEventCountAdapter focusEventCountAdapter2) throws AWTException, InterruptedException, InvocationTargetException {
        int n = 0;
        boolean bl = false;
        for (n = 0; n < 5 && !bl; ++n) {
            AWTRobotUtil.requestFocus(robot, object);
            if (object2 instanceof com.jogamp.newt.Window) {
                bl = NewtTestUtil.waitForFocus((com.jogamp.newt.Window)object2, focusEventCountAdapter, focusEventCountAdapter2, null);
                continue;
            }
            if (NativeWindowFactory.isAWTAvailable() && object2 instanceof Component) {
                bl = AWTRobotUtil.waitForFocus((Component)object2, focusEventCountAdapter, focusEventCountAdapter2, null);
                continue;
            }
            throw new RuntimeException("Neither AWT nor NEWT: " + object2);
        }
        if (!bl) {
            System.err.print("*** AWTRobotUtil.assertRequestFocusAndWait() ");
            if (!(null != focusEventCountAdapter && !focusEventCountAdapter.focusGained() || null != focusEventCountAdapter2 && focusEventCountAdapter2.focusLost())) {
                System.err.println("minor UI failure");
                bl = true;
            } else {
                System.err.println("major UI failure");
            }
            if (object instanceof NativeWindow) {
                System.err.println("*** requestFocus.hasFocus() -  NW: " + ((NativeWindow)object).hasFocus());
            } else if (NativeWindowFactory.isAWTAvailable() && object instanceof Component) {
                System.err.println("*** requestFocus.hasFocus() - AWT: " + ((Component)object).hasFocus());
            }
            if (object2 instanceof NativeWindow) {
                System.err.println("*** waitForFocus.hasFocus() -  NW: " + ((NativeWindow)object2).hasFocus());
            } else if (NativeWindowFactory.isAWTAvailable() && object2 instanceof Component) {
                System.err.println("*** waitForFocus.hasFocus() - AWT: " + ((Component)object2).hasFocus());
            }
            System.err.println("*** gain: " + focusEventCountAdapter);
            System.err.println("*** lost: " + focusEventCountAdapter2);
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        Assert.assertTrue((String)"Did not gain focus", (boolean)bl);
    }

    private static void awtRobotKeyPress(Robot robot, int n, int n2) {
        robot.keyPress(n);
        robot.delay(n2);
    }

    private static void awtRobotKeyRelease(Robot robot, int n, int n2) {
        robot.keyRelease(n);
        robot.delay(n2);
    }

    public static int keyType(int n, Robot robot, int n2, Object object, KeyEventCountAdapter keyEventCountAdapter) throws InterruptedException, AWTException, InvocationTargetException {
        int n3;
        int n4 = 0;
        long l = System.currentTimeMillis();
        int n5 = null != keyEventCountAdapter ? keyEventCountAdapter.getCount() : 0;
        for (n3 = 0; 1 > n4 && n3 < 5; ++n3) {
            if (!AWTRobotUtil.hasFocus(object)) {
                AWTRobotUtil.requestFocus(null, object);
            }
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.awtRobotKeyPress(robot, n2, 50);
            AWTRobotUtil.awtRobotKeyRelease(robot, n2, 100);
            AWTRobotUtil.waitForIdle(robot);
            n4 = (null != keyEventCountAdapter ? keyEventCountAdapter.getCount() : 1) - n5;
            for (int i = 0; i < 20 && 1 > n4; ++i) {
                robot.delay(100);
                n4 = keyEventCountAdapter.getCount() - n5;
            }
        }
        Assert.assertEquals((String)("Key (" + n + ":" + n3 + ") not typed one time on thread " + Thread.currentThread().getName()), (long)1L, (long)n4);
        return (int)(System.currentTimeMillis() - l);
    }

    public static int keyPress(int n, Robot robot, boolean bl, int n2, int n3) {
        long l = System.currentTimeMillis();
        if (bl) {
            AWTRobotUtil.awtRobotKeyPress(robot, n2, n3);
        } else {
            AWTRobotUtil.awtRobotKeyRelease(robot, n2, n3);
        }
        return (int)(System.currentTimeMillis() - l);
    }

    public static int newtKeyPress(int n, Robot robot, boolean bl, short s, int n2) {
        int n3 = AWTNewtEventFactory.newtKeyCode2AWTKeyCode((short)s);
        long l = System.currentTimeMillis();
        if (bl) {
            AWTRobotUtil.awtRobotKeyPress(robot, n3, n2);
        } else {
            AWTRobotUtil.awtRobotKeyRelease(robot, n3, n2);
        }
        return (int)(System.currentTimeMillis() - l);
    }

    public static void assertKeyType(Robot robot, int n, int n2, Object object, KeyEventCountAdapter keyEventCountAdapter) throws AWTException, InterruptedException, InvocationTargetException {
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        AWTRobotUtil.centerMouse(robot, object, false);
        Assert.assertEquals((String)"Key already pressed", (Object)false, (Object)keyEventCountAdapter.isPressed());
        int n3 = keyEventCountAdapter.getCount();
        for (int i = 0; i < n2; ++i) {
            AWTRobotUtil.keyType(i, robot, n, object, keyEventCountAdapter);
        }
        Assert.assertEquals((String)"Wrong key count", (long)n2, (long)(keyEventCountAdapter.getCount() - n3));
    }

    public static void assertKeyPress(Robot robot, int n, int n2, Object object, KeyEventCountAdapter keyEventCountAdapter) throws AWTException, InterruptedException, InvocationTargetException {
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        AWTRobotUtil.centerMouse(robot, object, false);
        Assert.assertEquals((String)"Key already pressed", (Object)false, (Object)keyEventCountAdapter.isPressed());
        int n3 = keyEventCountAdapter.getCount();
        for (int i = 0; i < n2; ++i) {
            AWTRobotUtil.keyType(i, robot, n, object, keyEventCountAdapter);
        }
        Assert.assertEquals((String)"Wrong key count", (long)n2, (long)(keyEventCountAdapter.getCount() - n3));
    }

    public static void mouseMove(Robot robot, java.awt.Point point, int n, int n2) {
        java.awt.Point point2 = MouseInfo.getPointerInfo().getLocation();
        for (int i = 1; i <= n; ++i) {
            float f = (float)i / (float)n;
            robot.mouseMove((int)((float)point2.x * (1.0f - f) + (float)point.x * f), (int)((float)point2.y * (1.0f - f) + (float)point.y * f));
            robot.delay(n2);
        }
    }

    public static void mouseClick(Robot robot, java.awt.Point point, int n, int n2, int n3) {
        robot.delay(n3);
        AWTRobotUtil.mouseMove(robot, point, n, n2);
        robot.delay(n3);
        robot.mousePress(16);
        robot.mouseRelease(16);
        robot.delay(n3);
    }

    static int mouseClick(int n, Robot robot, int n2, Object object, InputEventCountAdapter inputEventCountAdapter) throws InterruptedException, AWTException, InvocationTargetException {
        int n3;
        int n4 = 0;
        long l = System.currentTimeMillis();
        for (n3 = 0; 1 > n4 && n3 < 5; ++n3) {
            if (!AWTRobotUtil.hasFocus(object)) {
                AWTRobotUtil.requestFocus(null, object);
            }
            int n5 = null != inputEventCountAdapter ? inputEventCountAdapter.getCount() : 0;
            AWTRobotUtil.waitForIdle(robot);
            robot.mousePress(n2);
            robot.mouseRelease(n2);
            n4 = (null != inputEventCountAdapter ? inputEventCountAdapter.getCount() : 1) - n5;
            for (int i = 0; i < 20 && 1 > n4; ++i) {
                robot.delay(100);
                n4 = inputEventCountAdapter.getCount() - n5;
            }
        }
        Assert.assertEquals((String)("Mouse (" + n + ":" + n3 + ") not clicked one time"), (long)1L, (long)n4);
        return (int)(System.currentTimeMillis() - l);
    }

    public static void assertMouseClick(Robot robot, int n, int n2, Object object, InputEventCountAdapter inputEventCountAdapter) throws AWTException, InterruptedException, InvocationTargetException {
        if (null == robot) {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        int n3 = AWTRobotUtil.getClickTimeout(object);
        AWTRobotUtil.centerMouse(robot, object, false);
        Assert.assertEquals((String)"Mouse already pressed", (Object)false, (Object)inputEventCountAdapter.isPressed());
        int n4 = inputEventCountAdapter.getCount();
        for (int i = 0; i < n2; ++i) {
            int n5 = AWTRobotUtil.mouseClick(i, robot, n, object, inputEventCountAdapter);
            robot.delay(n3 + 1);
        }
        Assert.assertEquals((String)"Wrong mouse click count", (long)n2, (long)(inputEventCountAdapter.getCount() - n4));
    }

    public static boolean waitForVisible(Component component, boolean bl, Runnable runnable) throws InterruptedException {
        int n;
        for (n = 0; n < 20 && bl != component.isShowing(); ++n) {
            if (null != runnable) {
                runnable.run();
                continue;
            }
            Thread.sleep(100L);
        }
        return n < 20;
    }

    public static boolean waitForRealized(Component component, boolean bl, Runnable runnable) throws InterruptedException {
        long l;
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < 2000L && bl != component.isShowing()) {
            if (null != runnable) {
                runnable.run();
            } else {
                Thread.sleep(100L);
            }
            l2 = System.currentTimeMillis();
        }
        if (l2 - l < 2000L && component instanceof GLAutoDrawable) {
            GLAutoDrawable gLAutoDrawable = (GLAutoDrawable)component;
            l = System.currentTimeMillis();
            while (l2 - l < 2000L && bl != gLAutoDrawable.isRealized()) {
                if (null != runnable) {
                    runnable.run();
                } else {
                    Thread.sleep(100L);
                }
                l2 = System.currentTimeMillis();
            }
            if (l2 - l >= 2000L) {
                System.err.println("XXX: FORCE REPAINT PRE - glad: " + gLAutoDrawable);
                component.repaint();
                l = System.currentTimeMillis();
                while (l2 - l < 2000L && bl != gLAutoDrawable.isRealized()) {
                    if (null != runnable) {
                        runnable.run();
                    } else {
                        Thread.sleep(100L);
                    }
                    l2 = System.currentTimeMillis();
                }
                System.err.println("XXX: FORCE REPAINT POST - glad: " + gLAutoDrawable);
            }
        }
        return l2 - l < 2000L;
    }

    public static boolean closeWindow(final Window window, boolean bl, TestUtil.WindowClosingListener windowClosingListener, Runnable runnable) throws InterruptedException {
        windowClosingListener.reset();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        final EventQueue eventQueue = toolkit.getSystemEventQueue();
        AWTEDTExecutor.singleton.invoke(true, new Runnable(){

            @Override
            public void run() {
                eventQueue.postEvent(new WindowEvent(window, 201));
            }
        });
        return AWTRobotUtil.waitUntilClosed(bl, windowClosingListener, runnable);
    }

    public static TestUtil.WindowClosingListener addClosingListener(final Window window) {
        final AWTWindowClosingAdapter aWTWindowClosingAdapter = new AWTWindowClosingAdapter();
        AWTEDTExecutor.singleton.invoke(true, new Runnable(){

            @Override
            public void run() {
                window.addWindowListener(aWTWindowClosingAdapter);
            }
        });
        return aWTWindowClosingAdapter;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(new OurUncaughtExceptionHandler());
        aliveRun = new Runnable(){

            @Override
            public void run() {
                awtEDTAliveFlag = true;
            }
        };
        awtEDTAliveSync = new Object();
        awtEDTAliveFlag = false;
    }

    static class AWTWindowClosingAdapter
    extends WindowAdapter
    implements TestUtil.WindowClosingListener {
        AtomicInteger closing = new AtomicInteger(0);
        AtomicInteger closed = new AtomicInteger(0);

        AWTWindowClosingAdapter() {
        }

        @Override
        public void reset() {
            this.closing.set(0);
            this.closed.set(0);
        }

        @Override
        public int getWindowClosingCount() {
            return this.closing.get();
        }

        @Override
        public int getWindowClosedCount() {
            return this.closed.get();
        }

        @Override
        public boolean isWindowClosing() {
            return 0 < this.closing.get();
        }

        @Override
        public boolean isWindowClosed() {
            return 0 < this.closed.get();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.closing.incrementAndGet();
            System.err.println("AWTWindowClosingAdapter.windowClosing: " + this);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.closed.incrementAndGet();
            System.err.println("AWTWindowClosingAdapter.windowClosed: " + this);
        }

        public String toString() {
            return "AWTWindowClosingAdapter[closing " + this.closing + ", closed " + this.closed + "]";
        }
    }

    static class OurUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        OurUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            System.err.println("*** AWTRobotUtil: UncaughtException (this Thread " + Thread.currentThread().getName() + ") : Thread <" + thread.getName() + ">, " + throwable.getClass().getName() + ": " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }
}

