/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.opengl.test.junit.util.FocusEventCountAdapter;
import com.jogamp.opengl.test.junit.util.TestUtil;
import java.util.concurrent.atomic.AtomicInteger;
import jogamp.newt.WindowImplAccess;

public class NewtTestUtil
extends TestUtil {
    public static boolean waitForFocus(Window window, Runnable runnable) throws InterruptedException {
        int n;
        for (n = 0; n < 20 && !window.hasFocus(); ++n) {
            if (null != runnable) {
                runnable.run();
                continue;
            }
            Thread.sleep(100L);
        }
        return n < 20;
    }

    public static boolean waitForFocus(Window window, FocusEventCountAdapter focusEventCountAdapter, FocusEventCountAdapter focusEventCountAdapter2, Runnable runnable) throws InterruptedException {
        if (!NewtTestUtil.waitForFocus(window, runnable)) {
            return false;
        }
        return TestUtil.waitForFocus(focusEventCountAdapter, focusEventCountAdapter2, runnable);
    }

    public static boolean waitForSize(Window window, int n, int n2, Runnable runnable) throws InterruptedException {
        int n3;
        for (n3 = 0; n3 < 20 && (n != window.getSurfaceWidth() || n2 != window.getSurfaceHeight()); ++n3) {
            if (null != runnable) {
                runnable.run();
                continue;
            }
            Thread.sleep(100L);
        }
        return n3 < 20;
    }

    public static boolean waitForVisible(Window window, boolean bl, Runnable runnable) throws InterruptedException {
        int n;
        for (n = 0; n < 20 && bl != window.isVisible(); ++n) {
            if (null != runnable) {
                runnable.run();
                continue;
            }
            Thread.sleep(100L);
        }
        return n < 20;
    }

    public static boolean waitForRealized(Screen screen, boolean bl, Runnable runnable) throws InterruptedException {
        long l;
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < 2000L && bl != screen.isNativeValid()) {
            if (null != runnable) {
                runnable.run();
            } else {
                Thread.sleep(100L);
            }
            l2 = System.currentTimeMillis();
        }
        return l2 - l < 2000L;
    }

    public static boolean waitForRealized(Window window, boolean bl, Runnable runnable) throws InterruptedException {
        long l;
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < 2000L && bl != window.isNativeValid()) {
            if (null != runnable) {
                runnable.run();
            } else {
                Thread.sleep(100L);
            }
            l2 = System.currentTimeMillis();
        }
        return l2 - l < 2000L;
    }

    public static TestUtil.WindowClosingListener addClosingListener(Window window) {
        NEWTWindowClosingAdapter nEWTWindowClosingAdapter = new NEWTWindowClosingAdapter();
        window.addWindowListener((WindowListener)nEWTWindowClosingAdapter);
        return nEWTWindowClosingAdapter;
    }

    public static boolean closeWindow(Window window, boolean bl, TestUtil.WindowClosingListener windowClosingListener, Runnable runnable) throws InterruptedException {
        windowClosingListener.reset();
        WindowImplAccess.windowDestroyNotify(window);
        return NewtTestUtil.waitUntilClosed(bl, windowClosingListener, runnable);
    }

    public static boolean hasPositionMax2xInsetsOr64Pix(Window window, int n, int n2) {
        InsetsImmutable insetsImmutable = window.getInsets();
        int n3 = Math.max(64, insetsImmutable.getLeftWidth() * 2);
        int n4 = Math.max(64, insetsImmutable.getTopHeight() * 2);
        return NewtTestUtil.hasPosition(window, n, n2, n3, n4);
    }

    public static boolean hasPosition(Window window, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = Math.abs(n - window.getX());
        int n6 = Math.abs(n2 - window.getY());
        boolean bl2 = bl = n5 <= n3 && n6 <= n4;
        if (!bl) {
            System.err.println("Position OFF: abs( exp " + n + "/" + n2 + " - has " + window.getX() + "/" + window.getY() + " ) = " + n5 + "/" + n6 + " > " + n3 + "/" + n4);
        } else {
            System.err.println("Position OK : abs( exp " + n + "/" + n2 + " - has " + window.getX() + "/" + window.getY() + " ) = " + n5 + "/" + n6 + " <= " + n3 + "/" + n4);
        }
        return bl;
    }

    public static class NEWTWindowClosingAdapter
    extends WindowAdapter
    implements TestUtil.WindowClosingListener {
        AtomicInteger closing = new AtomicInteger(0);
        AtomicInteger closed = new AtomicInteger(0);

        @Override
        public void reset() {
            this.closing.set(0);
            this.closed.set(0);
        }

        @Override
        public int getWindowClosingCount() {
            return this.closing.get();
        }

        @Override
        public int getWindowClosedCount() {
            return this.closed.get();
        }

        @Override
        public boolean isWindowClosing() {
            return 0 < this.closing.get();
        }

        @Override
        public boolean isWindowClosed() {
            return 0 < this.closed.get();
        }

        public void windowDestroyNotify(WindowEvent windowEvent) {
            this.closing.incrementAndGet();
            System.err.println("NEWTWindowClosingAdapter.windowDestroyNotify: " + this);
        }

        public void windowDestroyed(WindowEvent windowEvent) {
            this.closed.incrementAndGet();
            System.err.println("NEWTWindowClosingAdapter.windowDestroyed: " + this);
        }

        public String toString() {
            return "NEWTWindowClosingAdapter[closing " + this.closing + ", closed " + this.closed + "]";
        }
    }
}

