/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.junit.util.SingletonJunitCase;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class UITestCase
extends SingletonJunitCase {
    private static volatile boolean resetXRandRIfX11AfterClass = false;
    private static volatile int maxMethodNameLen = 0;

    public static void setResetXRandRIfX11AfterClass() {
        resetXRandRIfX11AfterClass = true;
    }

    public static int resetXRandRIfX11() {
        int n;
        block6: {
            n = 0;
            if (NativeWindowFactory.isInitialized() && ".x11" == NativeWindowFactory.getNativeWindowType((boolean)true)) {
                try {
                    String string;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringBuilder stringBuilder = new StringBuilder();
                    String[] stringArray = new String[]{"xrandr", "-q"};
                    n = UITestCase.processCommand(stringArray, null, stringBuilder, "xrandr-query> ");
                    if (0 != n) {
                        System.err.println("XRandR Query Error Code " + n);
                        System.err.println(stringBuilder.toString());
                        break block6;
                    }
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuilder.toString()));
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String string3 = string2.toLowerCase();
                        if (!string3.contains("connected") || string3.contains("disconnected") || null == (string = UITestCase.getFirst(string2))) continue;
                        arrayList.add(string);
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        string = (String)arrayList.get(i);
                        Object var8_10 = null;
                        String[] stringArray2 = null != var8_10 ? new String[]{"xrandr", "--output", string, "--mode", var8_10, "--rotate", "normal"} : new String[]{"xrandr", "--output", string, "--preferred", "--rotate", "normal"};
                        System.err.println("XRandR 1.2 Reset: " + Arrays.asList(stringArray2));
                        n = UITestCase.processCommand(stringArray2, System.err, null, "xrandr-1.2-reset> ");
                        if (0 == n) continue;
                        System.err.println("XRandR 1.2 Reset Error Code " + n);
                        break;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Caught " + exception.getClass().getName() + ": " + exception.getMessage());
                    exception.printStackTrace();
                    n = -1;
                }
            }
        }
        return n;
    }

    private static String getFirst(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken().trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int processCommand(String[] stringArray, OutputStream outputStream, StringBuilder stringBuilder, String string) {
        int n = 0;
        Object object = new Object();
        try {
            Object object2 = object;
            synchronized (object2) {
                MiscUtils.StreamDump streamDump;
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                if (null != outputStream) {
                    streamDump = new MiscUtils.StreamDump(outputStream, string, process.getInputStream(), object);
                } else if (null != stringBuilder) {
                    streamDump = new MiscUtils.StreamDump(stringBuilder, string, process.getInputStream(), object);
                } else {
                    throw new IllegalArgumentException("Output stream and string are null");
                }
                streamDump.start();
                while (!streamDump.eos()) {
                    object.wait();
                }
                process.waitFor();
                n = process.exitValue();
            }
        }
        catch (Exception exception) {
            System.err.println("Caught " + exception.getClass().getName() + ": " + exception.getMessage());
            exception.printStackTrace();
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    public int getMaxTestNameLen() {
        if (0 == maxMethodNameLen) {
            int n = 0;
            TestClass testClass = new TestClass(((Object)((Object)this)).getClass());
            List list = testClass.getAnnotatedMethods(Test.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n2 = ((FrameworkMethod)iterator.next()).getName().length();
                if (n >= n2) continue;
                n = n2;
            }
            maxMethodNameLen = n;
        }
        return maxMethodNameLen;
    }

    @BeforeClass
    public static final void oneTimeSetUpUITest() {
    }

    @AfterClass
    public static final void oneTimeTearDownUITest() {
        if (resetXRandRIfX11AfterClass) {
            UITestCase.resetXRandRIfX11();
        }
    }

    public String getSnapshotFilename(int n, String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2, int n3, boolean bl, String string2, String string3) {
        String string4;
        if (null == string2) {
            string2 = "png";
        }
        int n4 = this.getMaxTestNameLen() + ((Object)((Object)this)).getClass().getSimpleName().length() + 1;
        String string5 = this.getSimpleTestName(".");
        String string6 = string4 = gLCapabilitiesImmutable.getHardwareAccelerated() ? "hw" : "sw";
        String string7 = gLCapabilitiesImmutable.isOnscreen() ? "onscreen" : (gLCapabilitiesImmutable.isFBO() ? "fbobject" : (gLCapabilitiesImmutable.isPBuffer() ? "pbuffer_" : (gLCapabilitiesImmutable.isBitmap() ? "bitmap__" : "unknown_")));
        String string8 = gLCapabilitiesImmutable.getDoubleBuffered() ? "dbl" : "one";
        String string9 = bl ? "rgba" : "rgb_";
        String string10 = "rgba" + gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits() + gLCapabilitiesImmutable.getAlphaBits();
        int n5 = gLCapabilitiesImmutable.getDepthBits();
        int n6 = gLCapabilitiesImmutable.getStencilBits();
        int n7 = gLCapabilitiesImmutable.getNumSamples();
        String string11 = gLCapabilitiesImmutable.getSampleExtension();
        string = null != string ? "-" + string : "";
        String string12 = String.format((Locale)null, "%-" + n4 + "s-n%04d%s-%-6s-%s-%s-B%s-F%s_I%s-D%02d-St%02d-Sa%02d_%s-%04dx%04d.%s", string5, n, string, gLCapabilitiesImmutable.getGLProfile().getName(), string4, string7, string8, string9, string10, n5, n6, n7, string11, n2, n3, string2).replace(' ', '_');
        return null != string3 ? string3 + File.separator + string12 : string12;
    }

    public void snapshot(int n, String string, GL gL, GLReadBufferUtil gLReadBufferUtil, String string2, String string3) {
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        String string4 = this.getSnapshotFilename(n, string, gLDrawable.getChosenGLCapabilities(), gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), gLReadBufferUtil.hasAlpha(), string2, string3);
        System.err.println(Thread.currentThread().getName() + ": ** screenshot: " + string4);
        gL.glFinish();
        try {
            this.snapshot(gL, gLReadBufferUtil, string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Caught ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("Caught NoClassDefFoundError: " + noClassDefFoundError.getMessage());
        }
    }

    private void snapshot(GL gL, GLReadBufferUtil gLReadBufferUtil, String string) throws ClassNotFoundException, NoClassDefFoundError {
        if (gLReadBufferUtil.readPixels(gL, false)) {
            gLReadBufferUtil.write(new File(string));
        }
    }

    public class SnapshotGLEventListener
    implements GLEventListener {
        private final GLReadBufferUtil screenshot;
        private volatile boolean makeShot = false;
        private volatile boolean makeShotAlways = false;
        private volatile boolean verbose = false;
        private final AtomicInteger displayCount = new AtomicInteger(0);
        private final AtomicInteger reshapeCount = new AtomicInteger(0);
        private volatile String postSNDetail = null;

        public SnapshotGLEventListener(GLReadBufferUtil gLReadBufferUtil) {
            this.screenshot = gLReadBufferUtil;
        }

        public SnapshotGLEventListener() {
            this.screenshot = new GLReadBufferUtil(false, false);
        }

        public int getDisplayCount() {
            return this.displayCount.get();
        }

        public int getReshapeCount() {
            return this.reshapeCount.get();
        }

        public GLReadBufferUtil getGLReadBufferUtil() {
            return this.screenshot;
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            boolean bl;
            GL gL = gLAutoDrawable.getGL();
            boolean bl2 = bl = this.makeShot || this.makeShotAlways;
            if (this.verbose) {
                System.err.println(Thread.currentThread().getName() + ": ** display: " + this.displayCount + ": " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceHeight() + ", makeShot " + bl);
            }
            if (bl) {
                this.makeShot = false;
                UITestCase.this.snapshot(this.displayCount.get(), this.postSNDetail, gL, this.screenshot, "png", null);
            }
            this.displayCount.incrementAndGet();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            if (this.verbose) {
                System.err.println(Thread.currentThread().getName() + ": ** reshape: " + this.reshapeCount + ": " + n3 + "x" + n4 + " - " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceHeight());
            }
            this.reshapeCount.incrementAndGet();
        }

        public void setMakeSnapshot() {
            this.makeShot = true;
        }

        public void setMakeSnapshotAlways(boolean bl) {
            this.makeShotAlways = bl;
        }

        public void setVerbose(boolean bl) {
            this.verbose = bl;
        }

        public void setPostSNDetail(String string) {
            this.postSNDetail = string;
        }
    }
}

