/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import jogamp.nativewindow.windows.BITMAPINFO;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsBitmapWGLDrawable
extends WindowsWGLDrawable {
    private long origbitmap;
    private long hbitmap;

    private WindowsBitmapWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    protected static WindowsBitmapWGLDrawable create(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        GLCapabilitiesImmutable gLCapabilitiesImmutable2;
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        if (!GLProfile.isAvailable((AbstractGraphicsDevice)abstractGraphicsDevice, (String)"GL2")) {
            throw new GLException("GLProfile GL2 n/a on " + abstractGraphicsDevice + " but required for Windows BITMAP");
        }
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable3 != (gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLProfile((GLCapabilitiesImmutable)(gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.clipRGBAGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable3, (boolean)false, (boolean)false)), (GLProfile)gLProfile))) {
            windowsWGLGraphicsConfiguration.setChosenCapabilities((CapabilitiesImmutable)gLCapabilitiesImmutable2);
            if (DEBUG) {
                System.err.println("WindowsBitmapWGLDrawable: " + gLCapabilitiesImmutable3 + " -> " + gLCapabilitiesImmutable2);
            }
        }
        return new WindowsBitmapWGLDrawable(gLDrawableFactory, nativeSurface);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createBitmap();
        } else {
            this.destroyBitmap();
        }
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsWGLContext(this, gLContext);
    }

    public boolean isGLOriented() {
        return false;
    }

    private void createBitmap() {
        long l;
        NativeSurface nativeSurface = this.getNativeSurface();
        if (DEBUG) {
            System.err.println(WindowsBitmapWGLDrawable.getThreadName() + ": WindowsBitmapWGLDrawable (1): " + nativeSurface);
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        int n = this.getSurfaceWidth();
        int n2 = this.getSurfaceHeight();
        BITMAPINFO bITMAPINFO = BITMAPINFO.create();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.getBmiHeader();
        int n3 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        int n4 = 24;
        bITMAPINFOHEADER.setBiSize(BITMAPINFOHEADER.size());
        bITMAPINFOHEADER.setBiWidth(n);
        bITMAPINFOHEADER.setBiHeight(-1 * n2);
        bITMAPINFOHEADER.setBiPlanes((short)1);
        bITMAPINFOHEADER.setBiBitCount((short)n4);
        bITMAPINFOHEADER.setBiXPelsPerMeter(0);
        bITMAPINFOHEADER.setBiYPelsPerMeter(0);
        bITMAPINFOHEADER.setBiClrUsed(0);
        bITMAPINFOHEADER.setBiClrImportant(0);
        bITMAPINFOHEADER.setBiCompression(0);
        int n5 = n * n2 * (n4 >> 3);
        bITMAPINFOHEADER.setBiSizeImage(n5);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
        this.hbitmap = GDI.CreateDIBSection((long)0L, (BITMAPINFO)bITMAPINFO, (int)0, (PointerBuffer)pointerBuffer, (long)0L, (int)0);
        int n6 = GDI.GetLastError();
        if (DEBUG) {
            l = pointerBuffer.capacity() > 0 ? pointerBuffer.get(0) : 0L;
            System.err.println("WindowsBitmapWGLDrawable: pb sz/ptr " + pointerBuffer.capacity() + ", " + WindowsBitmapWGLDrawable.toHexString((long)l));
            System.err.println("WindowsBitmapWGLDrawable: " + n + "x" + n2 + ", bpp " + n3 + " -> " + n4 + ", bytes " + n5 + ", header sz " + BITMAPINFOHEADER.size() + ", DIB ptr num " + pointerBuffer.capacity() + ", " + gLCapabilitiesImmutable + ", werr " + n6);
        }
        if (this.hbitmap == 0L) {
            throw new GLException("Error creating offscreen bitmap of " + nativeSurface + ", werr " + n6);
        }
        l = GDI.CreateCompatibleDC((long)0L);
        n6 = GDI.GetLastError();
        if (l == 0L) {
            GDI.DeleteObject((long)this.hbitmap);
            this.hbitmap = 0L;
            throw new GLException("Error creating device context for offscreen OpenGL context, werr " + n6);
        }
        ((MutableSurface)nativeSurface).setSurfaceHandle(l);
        if (DEBUG) {
            System.err.println(WindowsBitmapWGLDrawable.getThreadName() + ": WindowsBitmapWGLDrawable (2): " + nativeSurface);
        }
        if ((this.origbitmap = GDI.SelectObject((long)l, (long)this.hbitmap)) == 0L) {
            GDI.DeleteObject((long)this.hbitmap);
            this.hbitmap = 0L;
            GDI.DeleteDC((long)l);
            l = 0L;
            throw new GLException("Error selecting bitmap into new device context");
        }
        windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeSurface, null);
    }

    protected void destroyBitmap() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GDI.SelectObject((long)nativeSurface.getSurfaceHandle(), (long)this.origbitmap);
            GDI.DeleteObject((long)this.hbitmap);
            GDI.DeleteDC((long)nativeSurface.getSurfaceHandle());
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            ((MutableSurface)nativeSurface).setSurfaceHandle(0L);
        }
    }
}

