/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.av.AudioSink;
import com.jogamp.common.av.PTS;
import com.jogamp.common.net.Uri;
import com.jogamp.common.net.UriQueryProps;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.LFRingbuffer;
import com.jogamp.common.util.Ringbuffer;
import com.jogamp.common.util.TSPrinter;
import com.jogamp.common.util.WorkerThread;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2i;
import com.jogamp.math.Vec4f;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.av.CodecID;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.SubBitmapEvent;
import com.jogamp.opengl.util.av.SubEmptyEvent;
import com.jogamp.opengl.util.av.SubTextEvent;
import com.jogamp.opengl.util.av.SubtitleEventListener;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jogamp.opengl.Debug;
import jogamp.opengl.util.av.NullGLMediaPlayer;

public abstract class GLMediaPlayerImpl
implements GLMediaPlayer {
    private static final int STREAM_WORKER_DELAY = Debug.getIntProperty((String)"jogl.debug.GLMediaPlayer.StreamWorker.delay", (boolean)false, (int)0);
    private static final TSPrinter logout = DEBUG || DEBUG_AVSYNC || DEBUG_NATIVE ? TSPrinter.stderr() : null;
    private static final String unknown = "unknown";
    private volatile GLMediaPlayer.State state;
    private final Object stateLock = new Object();
    private final AtomicBoolean oneVideoFrameAtPause = new AtomicBoolean(false);
    private int textureCount = 0;
    private int textureTarget = 3553;
    private int textureFormat = 6408;
    private int textureInternalFormat = 6408;
    private int textureType = 5121;
    private int texUnit = 0;
    private int userMaxChannels = -1;
    private int textureFragmentShaderHashCode = 0;
    private final int[] texMinMagFilter = new int[]{9728, 9728};
    private final int[] texWrapST = new int[]{33071, 33071};
    private boolean aRatioLbox = false;
    private final Vec4f aRatioLboxBackColor = new Vec4f();
    private Uri streamLoc;
    protected Uri.Encoded cameraPath = null;
    protected Map<String, String> cameraProps = null;
    private volatile float playSpeed = 1.0f;
    private float audioVolume = 1.0f;
    private String title = "undef";
    private int[] v_streams = new int[0];
    private String[] v_langs = new String[0];
    private int vid = -2;
    private int[] a_streams = new int[0];
    private String[] a_langs = new String[0];
    private int aid = -2;
    private int[] s_streams = new int[0];
    private String[] s_langs = new String[0];
    private int sid = -2;
    private int width = 0;
    private int height = 0;
    private float fps = 0.0f;
    private float frame_duration = 0.0f;
    private int bps_stream = 0;
    private int bps_video = 0;
    private int bps_audio = 0;
    private int videoFrames = 0;
    private int audioFrames = 0;
    private int duration = 0;
    private CodecID acodecID = CodecID.NONE;
    private CodecID vcodecID = CodecID.NONE;
    private CodecID scodecID = CodecID.NONE;
    private String acodec = "unknown";
    private String vcodec = "unknown";
    private String scodec = "unknown";
    private volatile int decodedFrameCount = 0;
    private int presentedFrameCount = 0;
    private int displayedFrameCount = 0;
    private int nullFrameCount = 0;
    private int maxNullFrameCountUntilEOS = 0;
    private static final int MAX_FRAMELESS_MS_UNTIL_EOS = 5000;
    private static final int MAX_FRAMELESS_UNTIL_EOS_DEFAULT = 166;
    protected AudioSink audioSink = null;
    protected boolean audioSinkPlaySpeedSet = false;
    protected volatile SubtitleEventListener subEventListener = null;
    private final PTS av_scr = new PTS(() -> GLMediaPlayer.State.Playing == this.state ? this.playSpeed : 0.0f);
    private final PTS av_scr_cpy = new PTS(this.av_scr);
    private boolean video_scr_reset = false;
    private boolean audio_scr_reset = false;
    private final PTS video_pts_last = new PTS(() -> GLMediaPlayer.State.Playing == this.state ? this.playSpeed : 0.0f);
    private float video_dpts_cum = 0.0f;
    private int video_dpts_count = 0;
    private float audio_dpts_cum = 0.0f;
    private int audio_dpts_count = 0;
    private int audio_queued_last_ms = 0;
    private int audio_dequeued_last = 0;
    private static final int AV_DPTS_NUM = 20;
    private static final float AV_DPTS_COEFF = 0.7943282f;
    private static final int AV_DPTS_MAX = 5000;
    private TextureSequence.TextureFrame[] videoFramesOrig = null;
    private Ringbuffer<TextureSequence.TextureFrame> videoFramesFree = null;
    private Ringbuffer<TextureSequence.TextureFrame> videoFramesDecoded = null;
    private volatile TextureSequence.TextureFrame lastFrame = null;
    private Texture[] subTexOrig = null;
    private Ringbuffer<Texture> subTexFree = null;
    private static final int SUB_TEX_IMAGES_MIN = 2;
    private static final boolean subDEBUG = false;
    private boolean isInGLOrientation = false;
    private final ArrayList<GLMediaPlayer.GLMediaEventListener> eventListener = new ArrayList();
    private final ArrayList<GLMediaPlayer.GLMediaFrameListener> frameListener = new ArrayList();
    protected String textureLookupFunctionName = "texture2D";
    private final PTS dummy_audio_pts = new PTS(() -> GLMediaPlayer.State.Playing == this.state ? this.playSpeed : 0.0f);
    protected int pending_seek = -1;
    private TextureSequence.TextureFrame cachedFrame = null;
    private long lastMillis = 0L;
    private int repeatedFrame = 0;
    private final boolean[] stGotVFrame = new boolean[]{false};
    private volatile StreamWorker streamWorker = null;
    private GLMediaPlayer.StreamException streamErr = null;
    private static final boolean singleDEBUG = false;
    private static final Object singleLock = new Object();
    private static DefaultGraphicsDevice singleDevice = null;
    private static DefaultGraphicsDevice singleOwner = null;
    private static int singleCount = 0;
    private final SubBitmapEvent.TextureOwner subTexRelease = new SubBitmapEvent.TextureOwner(){

        @Override
        public void release(Texture texture) {
            if (null != GLMediaPlayerImpl.this.subTexFree && null != texture) {
                try {
                    GLMediaPlayerImpl.this.subTexFree.putBlocking((Object)texture);
                }
                catch (InterruptedException interruptedException) {
                    throw new InternalError("GLMediaPlayer.SubTexRelease: Release failed, all full: sid " + GLMediaPlayerImpl.this.sid + ", free " + GLMediaPlayerImpl.this.subTexFree + ", subTex " + texture + ", " + GLMediaPlayerImpl.this, interruptedException);
                }
            }
        }
    };
    private final Object eventListenerLock = new Object();
    private final Object frameListenerLock = new Object();
    private final HashMap<String, Object> attachedObjects = new HashMap();

    protected GLMediaPlayerImpl() {
        this.state = GLMediaPlayer.State.Uninitialized;
        try {
            this.streamLoc = Uri.cast((String)"https://no/stream/");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public final void setTextureUnit(int n) {
        this.texUnit = n;
    }

    @Override
    public final int getTextureUnit() {
        return this.texUnit;
    }

    @Override
    public final int getTextureTarget() {
        return this.textureTarget;
    }

    protected final int getTextureFormat() {
        return this.textureFormat;
    }

    protected final int getTextureType() {
        return this.textureType;
    }

    @Override
    public final int getTextureCount() {
        return this.textureCount;
    }

    protected final void setTextureTarget(int n) {
        this.textureTarget = n;
    }

    protected final void setTextureFormat(int n, int n2) {
        this.textureInternalFormat = n;
        this.textureFormat = n2;
    }

    protected final void setTextureType(int n) {
        this.textureType = n;
    }

    @Override
    public final void setTextureMinMagFilter(int[] nArray) {
        this.texMinMagFilter[0] = nArray[0];
        this.texMinMagFilter[1] = nArray[1];
    }

    @Override
    public final int[] getTextureMinMagFilter() {
        return this.texMinMagFilter;
    }

    @Override
    public final void setTextureWrapST(int[] nArray) {
        this.texWrapST[0] = nArray[0];
        this.texWrapST[1] = nArray[1];
    }

    @Override
    public final int[] getTextureWrapST() {
        return this.texWrapST;
    }

    @Override
    public final void setAudioChannelLimit(int n) {
        this.userMaxChannels = Math.min(8, Math.max(1, n));
    }

    protected int getAudioChannelLimit() {
        return this.userMaxChannels;
    }

    @Override
    public final String getRequiredExtensionsShaderStub() {
        if (36197 == this.textureTarget) {
            return ShaderCode.createExtensionDirective((String)"GL_OES_EGL_image_external", (String)"enable");
        }
        return "";
    }

    @Override
    public final String getTextureSampler2DType() {
        switch (this.textureTarget) {
            case 3553: 
            case 34037: {
                return "sampler2D";
            }
            case 36197: {
                return "samplerExternalOES";
            }
        }
        throw new GLException("Unsuported texture target: " + GLMediaPlayerImpl.toHexString(this.textureTarget));
    }

    @Override
    public String setTextureLookupFunctionName(String string) throws IllegalStateException {
        this.textureLookupFunctionName = "texture2D";
        this.resetTextureFragmentShaderHashCode();
        return this.textureLookupFunctionName;
    }

    @Override
    public final String getTextureLookupFunctionName() {
        return this.textureLookupFunctionName;
    }

    @Override
    public String getTextureLookupFragmentShaderImpl() {
        return "";
    }

    @Override
    public String getTextureFragmentShaderHashID() {
        return this.getTextureSampler2DType() + ";" + this.getTextureLookupFunctionName();
    }

    @Override
    public final int getTextureFragmentShaderHashCode() {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            this.resetTextureFragmentShaderHashCode();
            return 0;
        }
        if (0 == this.textureFragmentShaderHashCode) {
            int n;
            this.textureFragmentShaderHashCode = n = this.getTextureFragmentShaderHashID().hashCode();
        }
        return this.textureFragmentShaderHashCode;
    }

    protected final void resetTextureFragmentShaderHashCode() {
        this.textureFragmentShaderHashCode = 0;
    }

    @Override
    public final int getDecodedFrameCount() {
        return this.decodedFrameCount;
    }

    @Override
    public final int getPresentedFrameCount() {
        return this.presentedFrameCount;
    }

    @Override
    public final PTS getPTS() {
        return this.av_scr_cpy;
    }

    @Override
    public final int getVideoPTS() {
        return this.video_pts_last.getCurrent();
    }

    @Override
    public final int getAudioPTS() {
        if (GLMediaPlayer.State.Uninitialized != this.state && null != this.audioSink) {
            return this.audioSink.getPTS().getCurrent();
        }
        return 0;
    }

    protected PTS getAudioPTSImpl() {
        if (null != this.audioSink) {
            return this.audioSink.getPTS();
        }
        return this.dummy_audio_pts;
    }

    protected PTS getUpdatedAudioPTS() {
        if (null != this.audioSink) {
            return this.audioSink.updateQueue();
        }
        return this.dummy_audio_pts;
    }

    protected int getAudioQueuedDuration() {
        if (null != this.audioSink) {
            return (int)(this.audioSink.getQueuedDuration() * 1000.0f);
        }
        return 0;
    }

    protected int getLastBufferedAudioPTS() {
        if (null != this.audioSink) {
            return this.audioSink.getLastBufferedPTS();
        }
        return 0;
    }

    @Override
    public final GLMediaPlayer.State getState() {
        return this.state;
    }

    protected final void setState(GLMediaPlayer.State state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.State resume() {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            if (GLMediaPlayer.State.Paused == this.state && this.resumeImpl()) {
                if (null != this.audioSink) {
                    this.audioSink.play();
                }
                if (null != this.streamWorker) {
                    this.streamWorker.resume();
                }
                this.changeState(new GLMediaPlayer.EventMask(), GLMediaPlayer.State.Playing);
                int n = this.pending_seek;
                this.pending_seek = -1;
                if (0 <= n) {
                    this.seek(n);
                }
            }
            if (DEBUG) {
                logout.println("Play: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract boolean resumeImpl();

    @Override
    public final GLMediaPlayer.State pause(boolean bl) {
        return this.pauseImpl(bl, new GLMediaPlayer.EventMask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GLMediaPlayer.State pauseImpl(boolean bl, GLMediaPlayer.EventMask eventMask) {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            if (GLMediaPlayer.State.Playing == this.state) {
                eventMask = this.addStateEventMask(eventMask, GLMediaPlayer.State.Paused);
                this.setState(GLMediaPlayer.State.Paused);
                if (null != this.streamWorker) {
                    this.streamWorker.pause(true);
                }
                if (bl) {
                    this.resetAVPTSAndFlush(false);
                } else if (null != this.audioSink) {
                    this.audioSink.pause();
                }
                this.attributesUpdated(eventMask);
                if (!this.pauseImpl()) {
                    this.resume();
                }
            }
            if (DEBUG) {
                logout.println("Pause: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract boolean pauseImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.State stop() {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            if (null != this.streamWorker) {
                this.streamWorker.stop(true);
                this.streamWorker = null;
            }
            this.resetAVPTSAndFlush(true);
            this.stopImpl();
            this.changeState(new GLMediaPlayer.EventMask(), GLMediaPlayer.State.Uninitialized);
            if (DEBUG) {
                logout.println("Stop: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract void stopImpl();

    @Override
    public final GLMediaPlayer.State destroy(GL gL) {
        return this.destroyImpl(gL, new GLMediaPlayer.EventMask(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GLMediaPlayer.State destroyImpl(GL gL, GLMediaPlayer.EventMask eventMask, boolean bl) {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                this.streamWorker.stop(bl);
                this.streamWorker = null;
            }
            this.resetAVPTSAndFlush(true);
            this.destroyImpl();
            this.removeAllTextureFrames(gL);
            this.lastFrame = null;
            this.textureCount = 0;
            this.changeState(eventMask, GLMediaPlayer.State.Uninitialized);
            this.attachedObjects.clear();
            return this.state;
        }
    }

    protected abstract void destroyImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int seek(int n) {
        int n2;
        GLMediaPlayer.State state;
        Object object = this.stateLock;
        synchronized (object) {
            state = this.state;
            switch (this.state) {
                case Playing: 
                case Paused: {
                    GLMediaPlayer.State state2 = this.state;
                    this.setState(GLMediaPlayer.State.Paused);
                    if (n >= this.duration) {
                        n = this.duration - (int)Math.floor(this.frame_duration);
                    } else if (n < 0) {
                        n = 0;
                    }
                    if (null != this.streamWorker) {
                        this.streamWorker.pause(true);
                    }
                    n2 = this.seekImpl(n);
                    this.resetAVPTSAndFlush(false);
                    if (null != this.audioSink && GLMediaPlayer.State.Playing == state2) {
                        this.audioSink.play();
                    }
                    if (DEBUG) {
                        logout.println("Seek(" + n + "): " + this.getPerfString());
                    }
                    if (null != this.streamWorker) {
                        this.streamWorker.resume();
                    }
                    this.setState(state2);
                    this.attributesUpdated(new GLMediaPlayer.EventMask(GLMediaPlayer.EventMask.Bit.Seek));
                    break;
                }
                default: {
                    this.pending_seek = n;
                    n2 = 0;
                }
            }
        }
        this.oneVideoFrameAtPause.set(true);
        if (DEBUG) {
            logout.println("Seek(" + n + "): " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
        }
        return n2;
    }

    protected abstract int seekImpl(int var1);

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    private static final float clipZeroOneAllowMax(float f) {
        if (f < 0.01f) {
            return 0.0f;
        }
        if (Math.abs(1.0f - f) < 0.01f) {
            return 1.0f;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setPlaySpeed(float f) {
        Object object = this.stateLock;
        synchronized (object) {
            float f2 = this.playSpeed;
            boolean bl = false;
            f = GLMediaPlayerImpl.clipZeroOneAllowMax(f);
            if (f > 0.1f) {
                if (GLMediaPlayer.State.Uninitialized != this.state) {
                    if (this.setPlaySpeedImpl(f)) {
                        this.resetAVPTS();
                        this.playSpeed = f;
                        bl = true;
                    }
                } else {
                    this.playSpeed = f;
                    bl = true;
                }
            }
            if (DEBUG) {
                logout.println("setPlaySpeed(" + f + "): " + (Object)((Object)this.state) + ", " + f2 + " -> " + this.playSpeed + ", " + this.toString());
            }
            return bl;
        }
    }

    protected boolean setPlaySpeedImpl(float f) {
        if (null != this.audioSink) {
            this.audioSinkPlaySpeedSet = this.audioSink.setPlaySpeed(f);
        }
        return true;
    }

    @Override
    public final float getAudioVolume() {
        this.getAudioVolumeImpl();
        return this.audioVolume;
    }

    @Override
    public boolean isAudioMuted() {
        return FloatUtil.isZero((float)this.audioVolume);
    }

    protected void getAudioVolumeImpl() {
        if (null != this.audioSink) {
            this.audioVolume = this.audioSink.getVolume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAudioVolume(float f) {
        Object object = this.stateLock;
        synchronized (object) {
            float f2 = this.audioVolume;
            boolean bl = false;
            f = GLMediaPlayerImpl.clipZeroOneAllowMax(f);
            if (GLMediaPlayer.State.Uninitialized != this.state) {
                if (this.setAudioVolumeImpl(f)) {
                    this.audioVolume = f;
                    bl = true;
                }
            } else {
                this.audioVolume = f;
                bl = true;
            }
            if (DEBUG) {
                logout.println("setAudioVolume(" + f + "): " + (Object)((Object)this.state) + ", " + f2 + " -> " + this.audioVolume + ", " + this.toString());
            }
            return bl;
        }
    }

    protected boolean setAudioVolumeImpl(float f) {
        if (null != this.audioSink) {
            boolean bl = this.audioSink.setVolume(f);
            if (GLMediaPlayer.State.Playing == this.state) {
                if (FloatUtil.isZero((float)f)) {
                    this.audioSink.flush();
                } else {
                    this.audioSink.play();
                }
            }
            return bl;
        }
        return true;
    }

    @Override
    public void playStream(Uri uri, int n, int n2, int n3, int n4) throws IllegalStateException, IllegalArgumentException {
        this.playStream(uri, n, null, n2, null, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playStream(Uri uri, final int n, final String string, int n2, final String string2, int n3, int n4) throws IllegalStateException, IllegalArgumentException {
        Object object = this.stateLock;
        synchronized (object) {
            if (GLMediaPlayer.State.Uninitialized != this.state) {
                throw new IllegalStateException("Instance not in state unintialized: " + this);
            }
            if (null == uri) {
                this.initTestStream();
                return;
            }
            if (-2 != n) {
                this.textureCount = this.validateTextureCount(n4);
                if (this.textureCount < 1) {
                    throw new InternalError("Validated texture count < 1: " + this.textureCount);
                }
            } else {
                this.textureCount = 0;
            }
            this.decodedFrameCount = 0;
            this.presentedFrameCount = 0;
            this.displayedFrameCount = 0;
            this.nullFrameCount = 0;
            this.maxNullFrameCountUntilEOS = 166;
            this.streamLoc = uri;
            this.cameraPath = null;
            this.cameraProps = null;
            Uri.Encoded encoded = uri.scheme;
            if (null != encoded && encoded.equals((Object)CameraInputScheme)) {
                Uri.Encoded encoded2 = uri.path;
                if (null != encoded2 && encoded2.length() > 0) {
                    this.cameraPath = encoded2.substring(1);
                    UriQueryProps uriQueryProps = UriQueryProps.create((Uri)uri, (char)';');
                    this.cameraProps = uriQueryProps.getProperties();
                } else {
                    throw new IllegalArgumentException("Camera path is empty: " + uri.toString());
                }
            }
            final int n5 = string != null && string.length() > 0 ? -1 : n2;
            final int n6 = string2 != null && string2.length() > 0 ? -1 : n3;
            this.vid = n;
            this.aid = n5;
            this.sid = n6;
            new InterruptSource.Thread(){

                public void run() {
                    try {
                        GLMediaPlayerImpl.this.initStreamImpl(n, string, n5, string2, n6);
                    }
                    catch (Throwable throwable) {
                        GLMediaPlayerImpl.this.streamErr = new GLMediaPlayer.StreamException(throwable.getClass().getSimpleName() + " while initializing: " + GLMediaPlayerImpl.this.toString(), throwable);
                        GLMediaPlayerImpl.this.changeState(new GLMediaPlayer.EventMask(GLMediaPlayer.EventMask.Bit.Error), GLMediaPlayer.State.Uninitialized);
                    }
                }
            }.start();
        }
    }

    protected abstract void initStreamImpl(int var1, String var2, int var3, String var4, int var5) throws Exception;

    @Override
    public void switchStream(int n, int n2, int n3) throws IllegalStateException, IllegalArgumentException {
        int n4 = this.getVideoPTS();
        this.stop();
        this.seek(n4);
        this.playStream(this.getUri(), n, n2, n3, this.getTextureCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.StreamException getStreamException() {
        GLMediaPlayer.StreamException streamException = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                streamException = this.streamWorker.getStreamException();
            }
            if (null == streamException) {
                streamException = this.streamErr;
            }
            this.streamErr = null;
        }
        return streamException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initGL(GL gL) throws IllegalStateException, GLMediaPlayer.StreamException, GLException {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.StreamException streamException;
            if (null != this.streamWorker && null != (streamException = this.getStreamException())) {
                this.streamWorker = null;
                this.destroy(null);
                throw streamException;
            }
            if (DEBUG) {
                logout.println("GLMediaPlayer.initGL: " + this);
            }
            try {
                this.resetAVPTSAndFlush(true);
                this.removeAllTextureFrames(gL);
                if (GLMediaPlayer.State.Uninitialized != this.state) {
                    this.initGLImpl(gL);
                    this.setAudioVolume(this.audioVolume);
                    this.setPlaySpeed(this.playSpeed);
                    if (DEBUG) {
                        logout.println("initGLImpl.X " + this);
                    }
                    if (null != gL) {
                        this.videoFramesOrig = this.createTexFrames(gL, this.textureCount);
                        if (1 == this.textureCount) {
                            this.videoFramesFree = null;
                            this.videoFramesDecoded = null;
                            this.lastFrame = this.videoFramesOrig[0];
                        } else {
                            this.videoFramesFree = new LFRingbuffer((Object[])this.videoFramesOrig);
                            this.videoFramesDecoded = new LFRingbuffer(TextureSequence.TextureFrame[].class, this.textureCount);
                            this.lastFrame = (TextureSequence.TextureFrame)((Object)this.videoFramesFree.getBlocking());
                        }
                        if (-2 != this.sid) {
                            this.subTexOrig = this.createSubTextures(gL, Math.max(2, this.textureCount));
                            this.subTexFree = new LFRingbuffer((Object[])this.subTexOrig);
                        } else {
                            this.subTexOrig = null;
                            this.subTexFree = null;
                        }
                    } else {
                        this.videoFramesOrig = null;
                        this.videoFramesFree = null;
                        this.videoFramesDecoded = null;
                        this.lastFrame = null;
                        this.subTexOrig = null;
                        this.subTexFree = null;
                    }
                    if (null == this.streamWorker && (1 < this.textureCount || -2 == this.vid)) {
                        this.streamWorker = new StreamWorker();
                    }
                    if (null != this.streamWorker) {
                        this.streamWorker.initGL(gL);
                        this.streamWorker.resume();
                    }
                    this.changeState(new GLMediaPlayer.EventMask(), GLMediaPlayer.State.Paused);
                    this.resume();
                } else if (null == gL) {
                    this.width = 0;
                    this.height = 0;
                    this.setTextureFormat(6408, 6408);
                    this.setTextureType(5121);
                    this.textureCount = 0;
                    this.videoFramesOrig = null;
                    this.videoFramesFree = null;
                    this.videoFramesDecoded = null;
                    this.lastFrame = null;
                    this.subTexOrig = null;
                    this.subTexFree = null;
                } else {
                    this.width = TestTexture.singleton.getWidth();
                    this.height = TestTexture.singleton.getHeight();
                    this.setTextureFormat(6408, 6408);
                    this.setTextureType(5121);
                    this.textureCount = Math.max(1, this.textureCount);
                    this.videoFramesOrig = this.createTestTexFrames(gL, this.textureCount);
                    if (1 == this.textureCount) {
                        this.videoFramesFree = null;
                        this.videoFramesDecoded = null;
                        this.lastFrame = this.videoFramesOrig[0];
                    } else {
                        this.videoFramesFree = new LFRingbuffer((Object[])this.videoFramesOrig);
                        this.videoFramesDecoded = new LFRingbuffer(TextureSequence.TextureFrame[].class, this.textureCount);
                        this.lastFrame = (TextureSequence.TextureFrame)((Object)this.videoFramesFree.getBlocking());
                    }
                    this.subTexOrig = null;
                    this.subTexFree = null;
                }
            }
            catch (Throwable throwable) {
                this.destroyImpl(gL, new GLMediaPlayer.EventMask(GLMediaPlayer.EventMask.Bit.Error), false);
                throw new GLException("Error initializing GL resources", throwable);
            }
        }
    }

    protected abstract void initGLImpl(GL var1) throws IOException, GLException;

    protected int validateTextureCount(int n) {
        return n < 1 ? 1 : n;
    }

    protected TextureSequence.TextureFrame[] createTexFrames(GL gL, int n) {
        int[] nArray = new int[n];
        gL.glGenTextures(n, nArray, 0);
        int n2 = gL.glGetError();
        if (0 != n2) {
            throw new RuntimeException("TextureNames creation failed (num: " + n + "): err " + GLMediaPlayerImpl.toHexString(n2));
        }
        TextureSequence.TextureFrame[] textureFrameArray = new TextureSequence.TextureFrame[n];
        for (int i = 0; i < n; ++i) {
            textureFrameArray[i] = this.createTexImage(gL, nArray[i]);
        }
        return textureFrameArray;
    }

    protected TextureSequence.TextureFrame[] createTestTexFrames(GL gL, int n) {
        int[] nArray = new int[n];
        gL.glGenTextures(n, nArray, 0);
        int n2 = gL.glGetError();
        if (0 != n2) {
            throw new RuntimeException("TextureNames creation failed (num: " + n + "): err " + GLMediaPlayerImpl.toHexString(n2));
        }
        TextureSequence.TextureFrame[] textureFrameArray = new TextureSequence.TextureFrame[n];
        for (int i = 0; i < n; ++i) {
            textureFrameArray[i] = this.createTestTexImage(gL, nArray[i]);
        }
        return textureFrameArray;
    }

    protected Texture[] createSubTextures(GL gL, int n) {
        int[] nArray = new int[n];
        gL.glGenTextures(n, nArray, 0);
        int n2 = gL.glGetError();
        if (0 != n2) {
            throw new RuntimeException("TextureNames creation failed (num: " + n + "): err " + GLMediaPlayerImpl.toHexString(n2));
        }
        Texture[] textureArray = new Texture[n];
        for (int i = 0; i < n; ++i) {
            textureArray[i] = new Texture(nArray[i], true, this.textureTarget, 1, 1, 1, 1, true);
        }
        return textureArray;
    }

    private final TextureSequence.TextureFrame createTestTexImage(GL gL, int n) {
        Texture texture = this.createTexImageImpl(gL, n, TestTexture.singleton.getWidth(), TestTexture.singleton.getHeight());
        texture.updateImage(gL, TestTexture.singleton);
        return new TextureSequence.TextureFrame(texture);
    }

    private void initTestStream() {
        this.textureCount = 1;
        this.updateAttributes("test", new int[0], new String[0], -2, new int[0], new String[0], -2, new int[0], new String[0], -2, TestTexture.singleton.getWidth(), TestTexture.singleton.getHeight(), 0, 0, 0, 24.0f, 14400, 0, 600000, "png-static", null, null, CodecID.toFFmpeg(CodecID.PNG), -1, -1);
    }

    protected abstract TextureSequence.TextureFrame createTexImage(GL var1, int var2);

    protected final Texture createTexImageImpl(GL gL, int n, int n2, int n3) {
        if (0 > n) {
            throw new RuntimeException("TextureName " + GLMediaPlayerImpl.toHexString(n) + " invalid.");
        }
        gL.glActiveTexture(33984 + this.getTextureUnit());
        gL.glBindTexture(this.textureTarget, n);
        int n4 = gL.glGetError();
        if (0 != n4) {
            throw new RuntimeException("Couldn't bind textureName " + GLMediaPlayerImpl.toHexString(n) + " to 2D target, err " + GLMediaPlayerImpl.toHexString(n4));
        }
        if (36197 != this.textureTarget) {
            gL.glTexImage2D(this.textureTarget, 0, this.textureInternalFormat, n2, n3, 0, this.textureFormat, this.textureType, null);
            n4 = gL.glGetError();
            if (0 != n4) {
                throw new RuntimeException("Couldn't create TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + ", err " + GLMediaPlayerImpl.toHexString(n4));
            }
            if (DEBUG) {
                logout.println("Created TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType));
            }
        }
        gL.glTexParameteri(this.textureTarget, 10241, this.texMinMagFilter[0]);
        gL.glTexParameteri(this.textureTarget, 10240, this.texMinMagFilter[1]);
        gL.glTexParameteri(this.textureTarget, 10242, this.texWrapST[0]);
        gL.glTexParameteri(this.textureTarget, 10243, this.texWrapST[1]);
        return new Texture(n, true, this.textureTarget, n2, n3, this.width, this.height, !this.isInGLOrientation);
    }

    protected void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        textureFrame.getTexture().destroy(gL);
    }

    @Override
    public final boolean useARatioAdjustment() {
        return true;
    }

    @Override
    public void setARatioAdjustment(boolean bl) {
    }

    @Override
    public final boolean useARatioLetterbox() {
        return this.aRatioLbox;
    }

    @Override
    public Vec4f getARatioLetterboxBackColor() {
        return this.aRatioLboxBackColor;
    }

    @Override
    public void setARatioLetterbox(boolean bl, Vec4f vec4f) {
        this.aRatioLbox = bl;
        if (null != vec4f) {
            this.aRatioLboxBackColor.set(vec4f);
        }
    }

    @Override
    public final boolean isTextureAvailable() {
        return null != this.lastFrame;
    }

    @Override
    public final TextureSequence.TextureFrame getLastTexture() throws IllegalStateException {
        return this.lastFrame;
    }

    private final void destroyTexFrames(GL gL, TextureSequence.TextureFrame[] textureFrameArray) {
        if (null != textureFrameArray) {
            for (int i = 0; i < textureFrameArray.length; ++i) {
                TextureSequence.TextureFrame textureFrame = textureFrameArray[i];
                if (null != textureFrame) {
                    if (null != gL) {
                        this.destroyTexFrame(gL, textureFrame);
                    }
                    textureFrameArray[i] = null;
                }
                if (!DEBUG) continue;
                logout.println(Thread.currentThread().getName() + "> Clear TexFrame[" + i + "]: " + (Object)((Object)textureFrame) + " -> null");
            }
        }
    }

    private final void destroyTextures(GL gL, Texture[] textureArray) {
        if (null != textureArray) {
            for (int i = 0; i < textureArray.length; ++i) {
                Texture texture = textureArray[i];
                if (null != texture) {
                    if (null != gL) {
                        texture.destroy(gL);
                    }
                    textureArray[i] = null;
                }
                if (!DEBUG) continue;
                logout.println(Thread.currentThread().getName() + "> Clear Texture[" + i + "]: " + texture + " -> null");
            }
        }
    }

    private final void removeAllTextureFrames(GL gL) {
        this.destroyTexFrames(gL, this.videoFramesOrig);
        this.videoFramesOrig = null;
        this.videoFramesFree = null;
        this.videoFramesDecoded = null;
        this.lastFrame = null;
        this.cachedFrame = null;
        this.destroyTextures(gL, this.subTexOrig);
        this.subTexOrig = null;
        this.subTexFree = null;
    }

    protected boolean audioStreamEnabled() {
        return -2 != this.aid && !this.isAudioMuted() && (1.0f == this.getPlaySpeed() || this.audioSinkPlaySpeedSet);
    }

    private int getAudioDequeued(int n) {
        int n2 = this.audio_queued_last_ms > n ? this.audio_queued_last_ms - n : this.audio_dequeued_last;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TextureSequence.TextureFrame getNextTexture(GL gL) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = GLMediaPlayer.State.Paused == this.state && this.oneVideoFrameAtPause.compareAndSet(true, false);
            if (bl || GLMediaPlayer.State.Playing == this.state) {
                boolean bl3 = false;
                try {
                    do {
                        int n;
                        boolean bl4;
                        TextureSequence.TextureFrame textureFrame;
                        boolean bl5;
                        int n2;
                        boolean bl6;
                        int n3;
                        long l = Clock.currentMillis();
                        boolean bl7 = this.audioStreamEnabled();
                        int n4 = bl7 && !this.audio_scr_reset ? this.getAudioQueuedDuration() : 100;
                        this.audio_dequeued_last = n3 = this.getAudioDequeued(n4);
                        int n5 = Math.max(n3, 22);
                        int n6 = Math.max(2 * n3, 44);
                        int n7 = Math.max(4 * n3, 88);
                        char c = '_';
                        char c2 = '_';
                        char c3 = '_';
                        char c4 = '_';
                        PTS pTS = new PTS(() -> GLMediaPlayer.State.Playing == this.state ? this.playSpeed : 0.0f);
                        if (bl7) {
                            PTS pTS2 = this.getUpdatedAudioPTS();
                            if (!pTS2.isValid()) {
                                pTS.set(l, 0);
                                bl6 = false;
                            } else {
                                pTS.set(pTS2);
                                bl6 = true;
                                if (this.audio_scr_reset) {
                                    this.audio_scr_reset = false;
                                    this.resetSCR(pTS2);
                                    c3 = 'A';
                                }
                            }
                            n2 = this.getLastBufferedAudioPTS();
                        } else {
                            pTS.set(l, 0);
                            n2 = 0;
                            bl6 = false;
                        }
                        if (bl3) {
                            --this.presentedFrameCount;
                            bl3 = false;
                            bl5 = true;
                        } else {
                            bl5 = false;
                        }
                        PTS pTS3 = new PTS(() -> GLMediaPlayer.State.Playing == this.state ? this.playSpeed : 0.0f);
                        if (!(null == this.cachedFrame || n4 <= n5 && bl6)) {
                            textureFrame = this.cachedFrame;
                            this.cachedFrame = null;
                            --this.presentedFrameCount;
                            pTS3.set(l, textureFrame.getPTS());
                            bl4 = true;
                            ++this.repeatedFrame;
                            c = 'r';
                        } else {
                            if (null != this.cachedFrame && null != this.videoFramesFree) {
                                this.videoFramesFree.putBlocking((Object)this.cachedFrame);
                                c = 'z';
                            }
                            this.cachedFrame = null;
                            this.repeatedFrame = 0;
                            if (null != this.videoFramesDecoded) {
                                textureFrame = (TextureSequence.TextureFrame)((Object)this.videoFramesDecoded.get());
                                if (null != textureFrame) {
                                    pTS3.set(l, textureFrame.getPTS());
                                    bl4 = true;
                                } else {
                                    pTS3.set(l, 0);
                                    bl4 = false;
                                    c = 'e';
                                }
                            } else {
                                pTS3.set(l, this.getNextSingleThreaded(gL, this.lastFrame, this.stGotVFrame));
                                textureFrame = this.lastFrame;
                                bl4 = this.stGotVFrame[0];
                            }
                        }
                        if (!bl4 && bl) {
                            this.oneVideoFrameAtPause.set(true);
                        }
                        if (bl4 && pTS3.isValid()) {
                            n = pTS3.diffLast(this.video_pts_last);
                            if (this.video_scr_reset || (float)n > this.frame_duration * 10.0f) {
                                this.video_scr_reset = false;
                                this.resetSCR(bl6 ? pTS : pTS3);
                                c4 = 'V';
                            }
                        }
                        if (pTS3.isEOS() || this.duration > 0 && this.duration <= pTS3.get(l) || this.maxNullFrameCountUntilEOS <= this.nullFrameCount) {
                            if (DEBUG || DEBUG_AVSYNC) {
                                logout.println(l, "AV-EOS (getNextTexture): EOS_PTS " + pTS3.isEOS() + ", " + this);
                            }
                            this.pauseImpl(true, new GLMediaPlayer.EventMask(GLMediaPlayer.EventMask.Bit.EOS));
                        } else if (!bl4 || !pTS3.isValid()) {
                            if (null == this.videoFramesDecoded || !this.videoFramesDecoded.isEmpty()) {
                                ++this.nullFrameCount;
                            }
                            if (DEBUG_AVSYNC) {
                                c2 = '?';
                                String string = this.nullFrameCount > 0 ? ", nullFrames " + this.nullFrameCount + ", " : ", ";
                                logout.println(l, "AV" + c + c2 + ":" + c3 + c4 + ": dT " + (l - this.lastMillis) + string + this.getPerfStringImpl(l, pTS3, bl6, pTS, n4, n2) + ", droppedFrame " + bl5);
                            }
                        } else {
                            boolean bl8;
                            this.nullFrameCount = 0;
                            ++this.presentedFrameCount;
                            n = bl6 && pTS.isValid() ? this.av_scr.diff(l, pTS) : 0;
                            int n8 = pTS3.diff(l, this.av_scr);
                            boolean bl9 = -5000 > n || n > 5000;
                            boolean bl10 = bl8 = -5000 > n8 || n8 > 5000;
                            if (bl9 || bl8) {
                                this.resetSCR(bl6 ? pTS : pTS3);
                                c3 = bl9 ? (char)'A' : 'a';
                                char c5 = c4 = bl8 ? (char)'V' : 'v';
                                if (DEBUG_AVSYNC) {
                                    c2 = '*';
                                    logout.println(l, "AV" + c + c2 + ":" + c3 + c4 + ": dT " + (l - this.lastMillis) + ", " + this.getPerfStringImpl(l, pTS3, bl6, pTS, n4, n2));
                                }
                            } else {
                                boolean bl11;
                                int n9;
                                if (bl6) {
                                    ++this.audio_dpts_count;
                                    this.audio_dpts_cum = bl5 ? (float)n * 0.7943282f + this.audio_dpts_cum : (float)n + 0.7943282f * this.audio_dpts_cum;
                                    n9 = (int)((float)GLMediaPlayerImpl.getDPTSAvg(this.audio_dpts_cum, this.audio_dpts_count) / this.playSpeed + 0.5f);
                                    if (n9 < -22 && n < 0 || n9 > n7 && n > 0) {
                                        bl11 = true;
                                        c2 = '*';
                                        this.av_scr.set(pTS);
                                        this.audio_dpts_cum = (float)n * 0.7943282f + (float)n;
                                        this.audio_dpts_count = 15;
                                        n8 = pTS3.diff(l, this.av_scr);
                                        c3 = 'A';
                                    } else {
                                        bl11 = false;
                                    }
                                } else {
                                    n9 = 0;
                                    bl11 = false;
                                }
                                int n10 = this.displayedFrameCount > 0 ? this.displayedFrameCount : 1;
                                int n11 = (int)((float)(l - this.av_scr.getSCR()) * this.playSpeed + 0.5f) / n10;
                                int n12 = Math.min(Math.max(n11, 11), 22);
                                ++this.video_dpts_count;
                                this.video_dpts_cum = bl5 || bl11 ? (float)n8 * 0.7943282f + this.video_dpts_cum : (float)n8 + 0.7943282f * this.video_dpts_cum;
                                n10 = (int)((float)GLMediaPlayerImpl.getDPTSAvg(this.video_dpts_cum, this.video_dpts_count) + 0.5f);
                                if (!(n10 <= n12 || n8 < 0 || n4 <= n6 && bl6)) {
                                    this.cachedFrame = textureFrame;
                                    textureFrame = null;
                                    c2 = 'c';
                                } else if (n10 < -n12 && n8 < 0 && (null != this.videoFramesDecoded && this.videoFramesDecoded.size() > 0 || this.playSpeed > 2.0f)) {
                                    bl3 = true;
                                    c2 = 'd';
                                } else {
                                    c2 = this.repeatedFrame > 0 ? (char)'r' : '_';
                                }
                                this.video_pts_last.set(pTS3);
                                if (DEBUG_AVSYNC) {
                                    logout.println(l, "AV" + c + c2 + ":" + c3 + c4 + ": dT " + (l - this.lastMillis) + ", dt[v " + n10 + ", a " + n9 + "]/" + n12 + ", " + this.getPerfStringImpl(l, pTS3, bl6, pTS, n4, n2) + ", avg dpy-fps " + n11 + " ms/f");
                                }
                            }
                        }
                        if (null != this.videoFramesFree && null != textureFrame) {
                            TextureSequence.TextureFrame textureFrame2 = this.lastFrame;
                            this.lastFrame = textureFrame;
                            if (null != textureFrame2) {
                                this.videoFramesFree.putBlocking((Object)textureFrame2);
                            }
                        }
                        this.lastMillis = l;
                        this.audio_queued_last_ms = n4;
                    } while (bl3);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            ++this.displayedFrameCount;
            this.av_scr_cpy.set(this.av_scr);
            return this.lastFrame;
        }
    }

    protected void preNextTextureImpl(GL gL) {
    }

    protected void postNextTextureImpl(GL gL) {
    }

    protected abstract int getNextTextureImpl(GL var1, TextureSequence.TextureFrame var2, Texture var3, boolean[] var4) throws InterruptedException;

    protected final int getNextSingleThreaded(GL gL, TextureSequence.TextureFrame textureFrame, boolean[] blArray) throws InterruptedException {
        int n;
        if (-2 != this.vid) {
            this.preNextTextureImpl(gL);
            boolean[] blArray2 = new boolean[]{false};
            Texture texture = null != this.subTexFree && -2 != this.sid ? (Texture)this.subTexFree.get() : null;
            n = this.getNextTextureImpl(gL, textureFrame, texture, blArray2);
            this.postNextTextureImpl(gL);
            if (null != texture && !blArray2[0]) {
                this.subTexFree.putBlocking((Object)texture);
            }
            if (Integer.MIN_VALUE != n) {
                this.newVideoFrameAvailable(textureFrame, Clock.currentMillis());
                blArray[0] = true;
            } else {
                blArray[0] = false;
            }
        } else {
            n = this.getNextTextureImpl(null, null, null, null);
            blArray[0] = false;
        }
        return n;
    }

    @Override
    public final AudioSink getAudioSink() {
        return this.audioSink;
    }

    private void flushAllVideoFrames() {
        if (null != this.videoFramesFree) {
            this.videoFramesFree.resetFull((Object[])this.videoFramesOrig);
            this.lastFrame = (TextureSequence.TextureFrame)((Object)this.videoFramesFree.get());
            if (null == this.lastFrame) {
                throw new InternalError("XXX");
            }
            this.videoFramesDecoded.clear();
        }
        this.cachedFrame = null;
    }

    private void resetAVPTSAndFlush(boolean bl) {
        this.resetSCR(this.av_scr);
        if (bl) {
            this.av_scr_cpy.set(this.av_scr);
        }
        this.audio_queued_last_ms = 0;
        this.audio_dequeued_last = 0;
        this.resetAVPTS();
        this.flushAllVideoFrames();
        if (null != this.audioSink) {
            this.audioSink.flush();
        }
    }

    private void resetSCR(PTS pTS) {
        this.av_scr.set(pTS);
        this.audio_dpts_cum = 0.0f;
        this.audio_dpts_count = 0;
        this.video_dpts_cum = 0.0f;
        this.video_dpts_count = 0;
    }

    private void resetAVPTS() {
        this.nullFrameCount = 0;
        this.presentedFrameCount = 0;
        this.displayedFrameCount = 0;
        this.decodedFrameCount = 0;
        this.video_scr_reset = true;
        this.audio_scr_reset = true;
    }

    private static final int getDPTSAvg(float f, int n) {
        int n2 = (int)(f * 0.20567179f + 0.5f);
        int n3 = n >= 20 ? n2 : 0;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void newVideoFrameAvailable(TextureSequence.TextureFrame textureFrame, long l) {
        ++this.decodedFrameCount;
        if (0 == textureFrame.getDuration()) {
            textureFrame.setDuration((int)this.frame_duration);
        }
        Object object = this.frameListenerLock;
        synchronized (object) {
            int n = this.frameListener.size();
            for (int i = 0; i < n; ++i) {
                this.frameListener.get(i).newFrameAvailable(this, textureFrame, l);
            }
        }
    }

    protected final void pushSound(ByteBuffer byteBuffer, int n, int n2) {
        if (this.audioStreamEnabled()) {
            this.audioSink.enqueueData(n2, byteBuffer, n);
        }
    }

    protected final void pushSubtitleEmpty(int n, int n2) {
        if (null != this.subEventListener) {
            this.subEventListener.run(new SubEmptyEvent(n, n2));
        }
    }

    protected final void pushSubtitleText(String string, int n, int n2) {
        if (null != this.subEventListener) {
            this.subEventListener.run(new SubTextEvent(this.scodecID, this.getLang(this.getSID()), SubTextEvent.TextFormat.TEXT, string, n, n2));
        }
    }

    protected final void pushSubtitleASS(String string, int n, int n2) {
        if (null != this.subEventListener) {
            this.subEventListener.run(new SubTextEvent(this.scodecID, this.getLang(this.getSID()), SubTextEvent.TextFormat.ASS, string, n, n2));
        }
    }

    protected final void pushSubtitleTex(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Texture texture = (Texture)object;
        if (null != texture) {
            texture.set(n2, n3, n6, n7);
        }
        if (null != this.subEventListener) {
            this.subEventListener.run(new SubBitmapEvent(this.scodecID, this.getLang(this.getSID()), new Vec2i(n4, n5), new Vec2i(n6, n7), texture, n8, n9, this.subTexRelease));
        } else {
            this.subTexRelease.release(texture);
        }
    }

    protected final GLMediaPlayer.EventMask addStateEventMask(GLMediaPlayer.EventMask eventMask, GLMediaPlayer.State state) {
        if (this.state != state) {
            switch (state) {
                case Uninitialized: {
                    eventMask.setBit(GLMediaPlayer.EventMask.Bit.Uninit);
                    break;
                }
                case Initialized: {
                    eventMask.setBit(GLMediaPlayer.EventMask.Bit.Init);
                    break;
                }
                case Playing: {
                    eventMask.setBit(GLMediaPlayer.EventMask.Bit.Play);
                    break;
                }
                case Paused: {
                    eventMask.setBit(GLMediaPlayer.EventMask.Bit.Pause);
                }
            }
        }
        return eventMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void attributesUpdated(GLMediaPlayer.EventMask eventMask) {
        if (!eventMask.isZero()) {
            long l = Clock.currentMillis();
            if (DEBUG) {
                logout.println("GLMediaPlayer.AttributesChanged: " + eventMask + ", state " + (Object)((Object)this.state) + ", when " + l);
            }
            Object object = this.eventListenerLock;
            synchronized (object) {
                int n = this.eventListener.size();
                for (int i = 0; i < n; ++i) {
                    this.eventListener.get(i).attributesChanged(this, eventMask, l);
                }
            }
        }
    }

    protected final void changeState(GLMediaPlayer.EventMask eventMask, GLMediaPlayer.State state) {
        if (!(eventMask = this.addStateEventMask(eventMask, state)).isZero()) {
            this.setState(state);
            if (GLMediaPlayer.State.Uninitialized == this.state) {
                this.textureLookupFunctionName = "texture2D";
                this.textureFragmentShaderHashCode = 0;
            }
            this.attributesUpdated(eventMask);
        }
    }

    protected final void updateAttributes(String string, int[] nArray, String[] stringArray, int n, int[] nArray2, String[] stringArray2, int n2, int[] nArray3, String[] stringArray3, int n3, int n4, int n5, int n6, int n7, int n8, float f, int n9, int n10, int n11, String string2, String string3, String string4, int n12, int n13, int n14) {
        Object object;
        int n15;
        String string5;
        int n16;
        boolean bl;
        GLMediaPlayer.EventMask eventMask = new GLMediaPlayer.EventMask();
        boolean bl2 = bl = this.state == GLMediaPlayer.State.Uninitialized;
        if (bl) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Init);
            this.setState(GLMediaPlayer.State.Initialized);
        }
        this.title = null == string ? (0 < (n16 = (string5 = 0 < (n15 = (object = this.getUri().path.decode()).lastIndexOf(47)) ? object.substring(n15 + 1) : object).lastIndexOf(46)) ? string5.substring(0, n16) : string5) : string;
        this.v_streams = nArray;
        this.v_langs = stringArray;
        this.a_streams = nArray2;
        this.a_langs = stringArray2;
        this.s_streams = nArray3;
        this.s_langs = stringArray3;
        if (-1 == n || 0 == nArray.length) {
            n = -2;
        }
        if (this.vid != n) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.VID);
            this.vid = n;
        }
        if (-1 == n2 || 0 == nArray2.length) {
            n2 = -2;
        }
        if (this.aid != n2) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.AID);
            this.aid = n2;
        }
        if (-1 == n3 || 0 == nArray3.length) {
            n3 = -2;
        }
        if (this.sid != n3) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.SID);
            this.sid = n3;
        }
        if (this.width != n4 || this.height != n5) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Size);
            this.width = n4;
            this.height = n5;
        }
        if (this.fps != f) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.FPS);
            this.fps = f;
            if (0.0f != f) {
                this.frame_duration = 1000.0f / f;
                int n17 = (int)this.frame_duration;
                this.maxNullFrameCountUntilEOS = 0 < n17 ? 5000 / n17 : 166;
            } else {
                this.frame_duration = 0.0f;
                this.maxNullFrameCountUntilEOS = 166;
            }
        }
        if (this.bps_stream != n6 || this.bps_video != n7 || this.bps_audio != n8) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.BPS);
            this.bps_stream = n6;
            this.bps_video = n7;
            this.bps_audio = n8;
        }
        if (this.videoFrames != n9 || this.audioFrames != n10 || this.duration != n11) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Length);
            this.videoFrames = n9;
            this.audioFrames = n10;
            this.duration = n11;
        }
        if (null != string3 && string3.length() > 0 && !this.acodec.equals(string3)) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Codec);
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.ACodec);
            this.acodec = string3;
        }
        if (null != string2 && string2.length() > 0 && !this.vcodec.equals(string2)) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Codec);
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.VCodec);
            this.vcodec = string2;
        }
        if (null != string4 && string4.length() > 0 && !this.scodec.equals(string4)) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Codec);
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.SCodec);
            this.scodec = string4;
        }
        CodecID codecID = CodecID.fromFFmpeg(n13);
        object = CodecID.fromFFmpeg(n12);
        CodecID codecID2 = CodecID.fromFFmpeg(n14);
        if (0 < n13 && CodecID.isAudioCodec(codecID, true) && this.acodecID != codecID) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Codec);
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.ACodec);
            this.acodecID = codecID;
        }
        if (0 < n12 && CodecID.isVideoCodec((CodecID)((Object)object)) && this.vcodecID != object) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Codec);
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.VCodec);
            this.vcodecID = object;
        }
        if (0 < n14 && CodecID.isSubtitleCodec(codecID2) && this.scodecID != codecID2) {
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.Codec);
            eventMask.setBit(GLMediaPlayer.EventMask.Bit.SCodec);
            this.scodecID = codecID2;
        }
        if (eventMask.isZero()) {
            return;
        }
        if (bl) {
            this.updateMetadata();
            if (DEBUG) {
                logout.println("XXX Initialize @ updateAttributes: " + this);
            }
        }
        this.attributesUpdated(eventMask);
    }

    protected void setIsGLOriented(boolean bl) {
        if (this.isInGLOrientation != bl) {
            if (DEBUG) {
                logout.println("XXX gl-orient " + this.isInGLOrientation + " -> " + bl);
            }
            this.isInGLOrientation = bl;
            if (null != this.videoFramesOrig) {
                for (int i = 0; i < this.videoFramesOrig.length; ++i) {
                    this.videoFramesOrig[i].getTexture().setMustFlipVertically(!bl);
                }
                this.attributesUpdated(new GLMediaPlayer.EventMask(GLMediaPlayer.EventMask.Bit.Size));
            }
        }
    }

    @Override
    public final Uri getUri() {
        return this.streamLoc;
    }

    private static int getNextImpl(int[] nArray, int n, boolean bl) {
        int n2;
        int n3 = n2 = nArray.length > 0 ? nArray[0] : -2;
        if (-2 == n) {
            return n2;
        }
        if (nArray.length > 1) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                if (i + 1 < nArray.length) {
                    return nArray[i + 1];
                }
                return bl ? -2 : nArray[0];
            }
        }
        return n2;
    }

    @Override
    public final int[] getVStreams() {
        return this.v_streams;
    }

    @Override
    public String[] getVLangs() {
        return this.v_langs;
    }

    @Override
    public final int getVID() {
        return this.vid;
    }

    @Override
    public int getNextVID() {
        return GLMediaPlayerImpl.getNextImpl(this.v_streams, this.vid, false);
    }

    @Override
    public final int[] getAStreams() {
        return this.a_streams;
    }

    @Override
    public String[] getALangs() {
        return this.a_langs;
    }

    @Override
    public final int getAID() {
        return this.aid;
    }

    @Override
    public final int getNextAID() {
        return GLMediaPlayerImpl.getNextImpl(this.a_streams, this.aid, false);
    }

    @Override
    public final int[] getSStreams() {
        return this.s_streams;
    }

    @Override
    public String[] getSLangs() {
        return this.s_langs;
    }

    @Override
    public final int getSID() {
        return this.sid;
    }

    @Override
    public int getNextSID() {
        return GLMediaPlayerImpl.getNextImpl(this.s_streams, this.sid, true);
    }

    @Override
    public final boolean hasStreamID(int n) {
        int n2;
        for (n2 = this.v_streams.length - 1; n2 >= 0; --n2) {
            if (this.v_streams[n2] != n) continue;
            return true;
        }
        for (n2 = this.a_streams.length - 1; n2 >= 0; --n2) {
            if (this.a_streams[n2] != n) continue;
            return true;
        }
        for (n2 = this.s_streams.length - 1; n2 >= 0; --n2) {
            if (this.s_streams[n2] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getLang(int n) {
        int n2;
        for (n2 = this.v_streams.length - 1; n2 >= 0; --n2) {
            if (this.v_streams[n2] != n) continue;
            return this.v_langs[n2];
        }
        for (n2 = this.a_streams.length - 1; n2 >= 0; --n2) {
            if (this.a_streams[n2] != n) continue;
            return this.a_langs[n2];
        }
        for (n2 = this.s_streams.length - 1; n2 >= 0; --n2) {
            if (this.s_streams[n2] != n) continue;
            return this.s_langs[n2];
        }
        return "undef";
    }

    @Override
    public final CodecID getVideoCodecID() {
        return this.vcodecID;
    }

    @Override
    public final CodecID getAudioCodecID() {
        return this.acodecID;
    }

    @Override
    public CodecID getSubtitleCodecID() {
        return this.scodecID;
    }

    @Override
    public final String getVideoCodec() {
        return this.vcodec;
    }

    @Override
    public final String getAudioCodec() {
        return this.acodec;
    }

    @Override
    public String getSubtitleCodec() {
        return this.scodec;
    }

    @Override
    public final int getVideoFrames() {
        return this.videoFrames;
    }

    @Override
    public final int getAudioFrames() {
        return this.audioFrames;
    }

    @Override
    public final int getDuration() {
        return this.duration;
    }

    @Override
    public final long getStreamBitrate() {
        return this.bps_stream;
    }

    @Override
    public final int getVideoBitrate() {
        return this.bps_video;
    }

    @Override
    public final int getAudioBitrate() {
        return this.bps_audio;
    }

    @Override
    public final float getFramerate() {
        return this.fps;
    }

    @Override
    public final boolean isGLOriented() {
        return this.isInGLOrientation;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    protected void updateMetadata() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public GLMediaPlayer.Chapter[] getChapters() {
        return new GLMediaPlayer.Chapter[0];
    }

    @Override
    public final GLMediaPlayer.Chapter getChapter(int n) {
        for (GLMediaPlayer.Chapter chapter : this.getChapters()) {
            if (chapter.start > n || n > chapter.end) continue;
            return chapter;
        }
        return null;
    }

    @Override
    public final String toString() {
        String string = PTS.toTimeStr((long)this.getDuration());
        String string2 = null != this.streamLoc ? this.streamLoc.toString() : "<undefined stream>";
        int n = null != this.videoFramesFree ? this.videoFramesFree.size() : 0;
        int n2 = null != this.videoFramesDecoded ? this.videoFramesDecoded.size() : 0;
        int n3 = this.av_scr.getCurrent();
        String string3 = null != this.cameraPath ? ", camera: " + this.cameraPath : "";
        return this.getClass().getSimpleName() + "[" + (Object)((Object)this.state) + ", vSCR " + n3 + ", " + this.getChapters().length + " chapters, duration " + string + ", frames[p " + this.presentedFrameCount + ", d " + this.decodedFrameCount + ", t " + this.videoFrames + ", z " + this.nullFrameCount + " / " + this.maxNullFrameCountUntilEOS + "], speed " + this.playSpeed + ", " + this.bps_stream + " bps, hasSW " + (null != this.streamWorker) + ", Texture[count " + this.textureCount + ", free " + n + ", dec " + n2 + ", tagt " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + "], Video[id " + this.vid + "/" + Arrays.toString(this.v_streams) + "/" + Arrays.toString(this.v_langs) + ", " + (Object)((Object)this.vcodecID) + "/'" + this.vcodec + "', " + this.width + "x" + this.height + ", glOrient " + this.isInGLOrientation + ", " + this.fps + " fps, " + this.frame_duration + " fdur, " + this.bps_video + " bps], Audio[id " + this.aid + "/" + Arrays.toString(this.a_streams) + "/" + Arrays.toString(this.a_langs) + ", " + (Object)((Object)this.acodecID) + "/'" + this.acodec + "', " + this.bps_audio + " bps, " + this.audioFrames + " frames], Subs[id " + this.sid + "/" + Arrays.toString(this.s_streams) + "/" + Arrays.toString(this.s_langs) + ", " + (Object)((Object)this.scodecID) + "/'" + this.scodec + "'], uri " + string2 + string3 + "]";
    }

    @Override
    public final String getPerfString() {
        long l = Clock.currentMillis();
        PTS pTS = this.getAudioPTSImpl();
        int n = this.getAudioQueuedDuration();
        int n2 = this.getLastBufferedAudioPTS();
        return this.getPerfStringImpl(l, this.video_pts_last, this.audioStreamEnabled(), pTS, n, n2);
    }

    private final String getPerfStringImpl(long l, PTS pTS, boolean bl, PTS pTS2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.getAudioDequeued(n);
        int n10 = pTS.getLast() - this.av_scr.get(l);
        int n11 = GLMediaPlayerImpl.getDPTSAvg(this.video_dpts_cum, this.video_dpts_count);
        if (bl && pTS2.isValid()) {
            n8 = this.av_scr.diff(l, pTS2);
            n7 = GLMediaPlayerImpl.getDPTSAvg(this.audio_dpts_cum, this.audio_dpts_count);
            n6 = pTS.diff(l, pTS2);
            n5 = n11 - n7;
        } else {
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
        }
        if (null != this.videoFramesDecoded) {
            n4 = this.videoFramesDecoded.size();
            n3 = this.videoFramesFree.size();
        } else {
            n4 = 0;
            n3 = 1;
        }
        return "frames[p" + this.presentedFrameCount + " d" + this.decodedFrameCount + " q" + n4 + " r" + this.repeatedFrame + " f" + n3 + "/" + this.videoFramesOrig.length + "], dAV[v-a " + n6 + ", avg " + n5 + "], SCR " + this.av_scr.get(l) + ", vpts " + pTS.getLast() + ", dSCR[" + n10 + ", avg " + n11 + "], apts " + pTS2.get(l) + " dSCR[" + n8 + ", avg " + n7 + "] (deq " + n9 + "ms, left " + n + "ms, lb " + n2 + ")]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenerLock;
        synchronized (object) {
            this.eventListener.add(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenerLock;
        synchronized (object) {
            this.eventListener.remove(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.GLMediaEventListener[] getEventListeners() {
        Object object = this.eventListenerLock;
        synchronized (object) {
            return this.eventListener.toArray(new GLMediaPlayer.GLMediaEventListener[this.eventListener.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addFrameListener(GLMediaPlayer.GLMediaFrameListener gLMediaFrameListener) {
        if (gLMediaFrameListener == null) {
            return;
        }
        Object object = this.frameListenerLock;
        synchronized (object) {
            this.frameListener.add(gLMediaFrameListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeFrameListener(GLMediaPlayer.GLMediaFrameListener gLMediaFrameListener) {
        if (gLMediaFrameListener == null) {
            return;
        }
        Object object = this.frameListenerLock;
        synchronized (object) {
            this.frameListener.remove(gLMediaFrameListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.GLMediaFrameListener[] getFrameListeners() {
        Object object = this.frameListenerLock;
        synchronized (object) {
            return this.frameListener.toArray(new GLMediaPlayer.GLMediaFrameListener[this.frameListener.size()]);
        }
    }

    @Override
    public final void setSubtitleEventListener(SubtitleEventListener subtitleEventListener) {
        this.subEventListener = subtitleEventListener;
    }

    @Override
    public final SubtitleEventListener getSubtitleEventListener() {
        return this.subEventListener;
    }

    @Override
    public final Object getAttachedObject(String string) {
        return this.attachedObjects.get(string);
    }

    @Override
    public final Object attachObject(String string, Object object) {
        return this.attachedObjects.put(string, object);
    }

    @Override
    public final Object detachObject(String string) {
        return this.attachedObjects.remove(string);
    }

    protected static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected static final int getPropIntVal(Map<String, String> map, String string) {
        String string2 = map.get(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (DEBUG) {
                logout.println("Not a valid integer for <" + string + ">: <" + string2 + ">");
            }
            return 0;
        }
    }

    private final class StreamWorker {
        private volatile GLContext sharedGLCtx = null;
        private boolean hasSharedGLCtx = false;
        private GLDrawable dummyDrawable = null;
        private final WorkerThread.StateCallback stateCB = (workerThread, state) -> {
            switch (state) {
                case INIT: {
                    break;
                }
                case PAUSED: {
                    if (!this.hasSharedGLCtx) break;
                    GLMediaPlayerImpl.this.postNextTextureImpl(this.sharedGLCtx.getGL());
                    this.sharedGLCtx.release();
                    break;
                }
                case RESUMED: {
                    if (this.hasSharedGLCtx) {
                        this.makeCurrent(this.sharedGLCtx);
                        GLMediaPlayerImpl.this.preNextTextureImpl(this.sharedGLCtx.getGL());
                    }
                    if (null != GLMediaPlayerImpl.this.videoFramesFree || -2 == GLMediaPlayerImpl.this.vid) break;
                    throw new InternalError("XXX videoFramesFree is null");
                }
                case END: {
                    if (this.hasSharedGLCtx) {
                        GLMediaPlayerImpl.this.postNextTextureImpl(this.sharedGLCtx.getGL());
                    }
                    this.destroySharedGL();
                    break;
                }
            }
        };
        private final WorkerThread.Callback action = workerThread -> {
            TextureSequence.TextureFrame textureFrame = null;
            boolean[] blArray = new boolean[]{false};
            Texture texture = null;
            try {
                GL gL;
                if (-2 != GLMediaPlayerImpl.this.vid) {
                    textureFrame = (TextureSequence.TextureFrame)((Object)((Object)GLMediaPlayerImpl.this.videoFramesFree.getBlocking()));
                    textureFrame.setPTS(Integer.MIN_VALUE);
                    gL = this.sharedGLCtx.getGL();
                } else {
                    gL = null;
                }
                if (null != gL && -2 != GLMediaPlayerImpl.this.sid && null != GLMediaPlayerImpl.this.subTexFree) {
                    texture = (Texture)GLMediaPlayerImpl.this.subTexFree.getBlocking();
                }
                int n = GLMediaPlayerImpl.this.getNextTextureImpl(gL, textureFrame, texture, blArray);
                if (null != texture && !blArray[0]) {
                    GLMediaPlayerImpl.this.subTexFree.putBlocking((Object)texture);
                }
                boolean bl = false;
                if (Integer.MIN_VALUE != n) {
                    if (null != textureFrame) {
                        if (STREAM_WORKER_DELAY > 0) {
                            Thread.sleep(STREAM_WORKER_DELAY);
                        }
                        if (!GLMediaPlayerImpl.this.videoFramesDecoded.put((Object)textureFrame)) {
                            throw new InternalError("XXX: free " + GLMediaPlayerImpl.this.videoFramesFree + ", decoded " + GLMediaPlayerImpl.this.videoFramesDecoded + ", " + GLMediaPlayerImpl.this);
                        }
                        GLMediaPlayerImpl.this.newVideoFrameAvailable(textureFrame, Clock.currentMillis());
                        textureFrame = null;
                    } else if (Integer.MAX_VALUE == n || GLMediaPlayerImpl.this.duration > 0 && GLMediaPlayerImpl.this.duration < n) {
                        bl = true;
                    } else {
                        GLMediaPlayerImpl.this.nullFrameCount = 0;
                    }
                } else if (null == textureFrame) {
                    boolean bl2 = bl = GLMediaPlayerImpl.this.maxNullFrameCountUntilEOS <= GLMediaPlayerImpl.this.nullFrameCount;
                    if (null == GLMediaPlayerImpl.this.audioSink || 0 == GLMediaPlayerImpl.this.audioSink.getEnqueuedFrameCount()) {
                        GLMediaPlayerImpl.this.nullFrameCount++;
                    }
                }
                if (bl) {
                    workerThread.pause(false);
                    if (GLMediaPlayer.DEBUG || GLMediaPlayer.DEBUG_AVSYNC) {
                        logout.println("AV-EOS (StreamWorker): EOS_PTS " + (Integer.MAX_VALUE == n) + ", " + GLMediaPlayerImpl.this);
                    }
                    GLMediaPlayerImpl.this.pauseImpl(true, new GLMediaPlayer.EventMask(GLMediaPlayer.EventMask.Bit.EOS));
                }
                if (null == textureFrame) return;
            }
            catch (Throwable throwable) {
                if (null == textureFrame) throw throwable;
                GLMediaPlayerImpl.this.videoFramesFree.putBlocking(textureFrame);
                throw throwable;
            }
            GLMediaPlayerImpl.this.videoFramesFree.putBlocking((Object)textureFrame);
        };
        final WorkerThread wt = new WorkerThread(null, null, true, this.action, this.stateCB);

        private void makeCurrent(GLContext gLContext) {
            if (0 >= gLContext.makeCurrent()) {
                throw new GLException("Couldn't make ctx current: " + gLContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroySharedGL() {
            if (null != this.sharedGLCtx) {
                if (this.sharedGLCtx.isCreated()) {
                    try {
                        this.sharedGLCtx.destroy();
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                }
                this.sharedGLCtx = null;
                this.hasSharedGLCtx = false;
            }
            if (null != this.dummyDrawable) {
                AbstractGraphicsDevice abstractGraphicsDevice = this.dummyDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                this.dummyDrawable.setRealized(false);
                this.dummyDrawable = null;
                Object object = singleLock;
                synchronized (object) {
                    if (abstractGraphicsDevice == singleDevice && 0 == --singleCount) {
                        DefaultGraphicsDevice.swapHandleAndOwnership((DefaultGraphicsDevice)singleOwner, (DefaultGraphicsDevice)singleDevice);
                        abstractGraphicsDevice.close();
                        singleOwner = null;
                        singleDevice = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void initGL(GL gL) {
            if (null == gL) {
                return;
            }
            GLContext gLContext = gL.getContext();
            boolean bl = gLContext.isCurrent();
            GLProfile gLProfile = gL.getGLProfile();
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
            boolean bl2 = true;
            AbstractGraphicsDevice abstractGraphicsDevice = gLContext.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            Object object = singleLock;
            synchronized (object) {
                if (null == singleOwner || singleOwner.getUniqueID().equals(abstractGraphicsDevice.getUniqueID())) {
                    if (null == singleOwner) {
                        singleDevice = (DefaultGraphicsDevice)NativeWindowFactory.createDevice((String)abstractGraphicsDevice.getType(), (String)abstractGraphicsDevice.getConnection(), (int)abstractGraphicsDevice.getUnitID(), (boolean)true);
                        singleOwner = new DefaultGraphicsDevice(singleDevice.getType(), singleDevice.getConnection(), singleDevice.getUnitID(), singleDevice.getHandle(), null);
                        DefaultGraphicsDevice.swapHandleAndOwnership((DefaultGraphicsDevice)singleOwner, (DefaultGraphicsDevice)singleDevice);
                    }
                    bl2 = false;
                    abstractGraphicsDevice = singleDevice;
                    ++singleCount;
                }
            }
            this.dummyDrawable = gLDrawableFactory.createDummyDrawable(abstractGraphicsDevice, bl2, gLContext.getGLDrawable().getChosenGLCapabilities(), null);
            this.dummyDrawable.setRealized(true);
            this.sharedGLCtx = this.dummyDrawable.createContext(gLContext);
            this.hasSharedGLCtx = null != this.sharedGLCtx;
            this.makeCurrent(this.sharedGLCtx);
            if (bl) {
                this.makeCurrent(gLContext);
            } else {
                this.sharedGLCtx.release();
            }
        }

        public final synchronized void pause(boolean bl) {
            this.wt.pause(bl);
        }

        public final synchronized void resume() {
            this.wt.resume();
        }

        private final synchronized void stop(boolean bl) {
            this.wt.stop(bl);
        }

        private final synchronized GLMediaPlayer.StreamException getStreamException() {
            Exception exception = this.wt.getError(true);
            if (null != exception) {
                return new GLMediaPlayer.StreamException(exception);
            }
            return null;
        }

        StreamWorker() {
            this.wt.start(true);
        }
    }

    private static class TestTexture {
        private static final TextureData singleton;

        private TestTexture() {
        }

        static {
            Object object;
            TextureData textureData = null;
            try {
                object = IOUtil.getResource((String)"jogamp/opengl/assets/test-ntsc01-28x16.png", (ClassLoader)NullGLMediaPlayer.class.getClassLoader());
                if (null != object) {
                    textureData = TextureIO.newTextureData(GLProfile.getGL2ES2(), ((URLConnection)object).getInputStream(), false, "png");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (null == textureData) {
                object = Buffers.newDirectByteBuffer((int)1792);
                while (((Buffer)object).hasRemaining()) {
                    ((ByteBuffer)object).put((byte)-22);
                    ((ByteBuffer)object).put((byte)-22);
                    ((ByteBuffer)object).put((byte)-22);
                    ((ByteBuffer)object).put((byte)-22);
                }
                ((ByteBuffer)object).rewind();
                textureData = new TextureData(GLProfile.getGL2ES2(), 6408, 28, 16, 0, 6408, 5121, false, false, false, (Buffer)object, null);
            }
            singleton = textureData;
        }
    }
}

