/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import com.jogamp.common.ExceptionUtils;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import jogamp.common.os.android.StaticContext;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.android.DisplayDriver;
import jogamp.newt.driver.android.event.AndroidNewtEventFactory;
import jogamp.newt.driver.android.event.AndroidNewtEventTranslator;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLSurface;

public class WindowDriver
extends WindowImpl
implements SurfaceHolder.Callback2 {
    public static final int NATIVE_WINDOW_FORMAT_RGBA_8888 = 1;
    public static final int NATIVE_WINDOW_FORMAT_RGBX_8888 = 2;
    public static final int NATIVE_WINDOW_FORMAT_RGB_565 = 4;
    protected Activity activity = null;
    private final KeyboardVisibleReceiver keyboardVisibleReceiver = new KeyboardVisibleReceiver();
    private boolean added2StaticViewGroup;
    private MSurfaceView androidView;
    private int nativeFormat;
    private int androidFormat;
    private GLCapabilitiesImmutable capsByFormat;
    private Surface surface;
    private volatile long surfaceHandle;
    private long eglSurface;

    public static final int getSurfaceHolderFormat(CapabilitiesImmutable capabilitiesImmutable) {
        int n = 0;
        n = !capabilitiesImmutable.isBackgroundOpaque() ? -3 : (capabilitiesImmutable.getRedBits() <= 5 && capabilitiesImmutable.getGreenBits() <= 6 && capabilitiesImmutable.getBlueBits() <= 5 && capabilitiesImmutable.getAlphaBits() == 0 ? 4 : (capabilitiesImmutable.getAlphaBits() == 0 ? 3 : 1));
        Log.d((String)"JogAmp.NEWT", (String)("getSurfaceHolderFormat: requested: " + capabilitiesImmutable));
        Log.d((String)"JogAmp.NEWT", (String)("getSurfaceHolderFormat:  returned: " + n));
        return n;
    }

    public static final int getANativeWindowFormat(int n) {
        int n2;
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                n2 = 1;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
            case 4: 
            case 11: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        Log.d((String)"JogAmp.NEWT", (String)("getANativeWindowFormat: android: " + n + " -> native " + n2));
        return n2;
    }

    public static final CapabilitiesImmutable fixCaps(boolean bl, int n, CapabilitiesImmutable capabilitiesImmutable) {
        CapabilitiesImmutable capabilitiesImmutable2;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        int n5;
        PixelFormat pixelFormat = new PixelFormat();
        PixelFormat.getPixelFormatInfo((int)n, (PixelFormat)pixelFormat);
        switch (n) {
            case 1: {
                n5 = 8;
                n4 = 8;
                n3 = 8;
                n2 = 8;
                break;
            }
            case 2: {
                n5 = 8;
                n4 = 8;
                n3 = 8;
                n2 = 0;
                break;
            }
            case 3: {
                n5 = 8;
                n4 = 8;
                n3 = 8;
                n2 = 0;
                break;
            }
            case 4: {
                n5 = 5;
                n4 = 6;
                n3 = 5;
                n2 = 0;
                break;
            }
            case 6: {
                n5 = 5;
                n4 = 5;
                n3 = 5;
                n2 = 1;
                break;
            }
            case 7: {
                n5 = 4;
                n4 = 4;
                n3 = 4;
                n2 = 4;
                break;
            }
            case 11: {
                n5 = 3;
                n4 = 3;
                n3 = 2;
                n2 = 0;
                break;
            }
            default: {
                throw new InternalError("Unhandled pixelformat: " + n);
            }
        }
        boolean bl3 = bl2 = bl || capabilitiesImmutable.getRedBits() > n5 && capabilitiesImmutable.getGreenBits() > n4 && capabilitiesImmutable.getBlueBits() > n3 && capabilitiesImmutable.getAlphaBits() > n2;
        if (bl2) {
            Capabilities capabilities = (Capabilities)capabilitiesImmutable.cloneMutable();
            capabilities.setRedBits(n5);
            capabilities.setGreenBits(n4);
            capabilities.setBlueBits(n3);
            capabilities.setAlphaBits(n2);
            capabilitiesImmutable2 = capabilities;
        } else {
            capabilitiesImmutable2 = capabilitiesImmutable;
        }
        Log.d((String)"JogAmp.NEWT", (String)("fixCaps:    format: " + n));
        Log.d((String)"JogAmp.NEWT", (String)("fixCaps: requested: " + capabilitiesImmutable));
        Log.d((String)"JogAmp.NEWT", (String)("fixCaps:    chosen: " + capabilitiesImmutable2));
        return capabilitiesImmutable2;
    }

    public static final boolean isAndroidFormatTransparent(int n) {
        switch (n) {
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static Class<?>[] getCustomConstructorArgumentTypes() {
        return new Class[]{Context.class};
    }

    public WindowDriver() {
        this.reset();
    }

    public void registerActivity(Activity activity) {
        this.activity = activity;
    }

    private final void reset() {
        this.added2StaticViewGroup = false;
        this.androidView = null;
        this.nativeFormat = 0;
        this.androidFormat = 0;
        this.capsByFormat = null;
        this.surface = null;
        this.surfaceHandle = 0L;
        this.eglSurface = 0L;
        this.defineWindowPosition(0, 0);
        this.defineWindowSize(0, 0);
        this.setBrokenFocusChange(true);
    }

    private final void setupInputListener(boolean bl) {
        Log.d((String)"JogAmp.NEWT", (String)("setupInputListener(enable " + bl + ") - " + Thread.currentThread().getName()));
        AndroidNewtEventTranslator androidNewtEventTranslator = bl ? new AndroidNewtEventTranslator(this, this.androidView.getContext(), this.androidView.getHandler()) : null;
        this.androidView.setOnTouchListener(androidNewtEventTranslator);
        this.androidView.setOnKeyListener(androidNewtEventTranslator);
        this.androidView.setOnFocusChangeListener(androidNewtEventTranslator);
        this.androidView.setOnGenericMotionListener(androidNewtEventTranslator);
        if (bl) {
            this.androidView.post(new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.androidView.setClickable(false);
                    WindowDriver.this.androidView.setFocusable(true);
                    WindowDriver.this.androidView.setFocusableInTouchMode(true);
                }
            });
        }
    }

    private final void setupAndroidView(Context context) {
        this.androidView = new MSurfaceView(context);
        SurfaceHolder surfaceHolder = this.androidView.getHolder();
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        surfaceHolder.setFormat(WindowDriver.getSurfaceHolderFormat(this.getRequestedCapabilities()));
    }

    public final SurfaceView getAndroidView() {
        return this.androidView;
    }

    protected final void instantiationFinishedImpl() {
        Log.d((String)"JogAmp.NEWT", (String)("instantiationFinishedImpl() - " + Thread.currentThread().getName()));
        Context context = StaticContext.getContext();
        if (null == context) {
            throw new NativeWindowException("No static [Application] Context has been set. Call StaticContext.setContext(Context) first.");
        }
        if (null != Looper.myLooper()) {
            this.setupAndroidView(context);
        }
    }

    protected final boolean canCreateNativeImpl() {
        boolean bl;
        RectangleImmutable rectangleImmutable;
        Log.d((String)"JogAmp.NEWT", (String)("canCreateNativeImpl.0: surfaceHandle ready " + (0L != this.surfaceHandle) + " - on thread " + Thread.currentThread().getName()));
        if (Window.DEBUG_IMPLEMENTATION) {
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        if (this.isFullscreen()) {
            MonitorDevice monitorDevice = this.getMainMonitor();
            rectangleImmutable = monitorDevice.getViewportInWindowUnits();
            this.defineWindowPosition(rectangleImmutable.getX(), rectangleImmutable.getY());
            this.defineWindowSize(rectangleImmutable.getWidth(), rectangleImmutable.getHeight());
        }
        if (0L == this.surfaceHandle) {
            rectangleImmutable = StaticContext.getContentViewGroup();
            Log.d((String)"JogAmp.NEWT", (String)("canCreateNativeImpl: viewGroup " + rectangleImmutable));
            if (null != rectangleImmutable && !this.added2StaticViewGroup) {
                this.added2StaticViewGroup = true;
                rectangleImmutable.post(new Runnable(){
                    final /* synthetic */ ViewGroup val$viewGroup;
                    {
                        this.val$viewGroup = viewGroup;
                    }

                    @Override
                    public void run() {
                        if (null == WindowDriver.this.androidView) {
                            WindowDriver.this.setupAndroidView(StaticContext.getContext());
                        }
                        this.val$viewGroup.addView((View)WindowDriver.this.androidView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(WindowDriver.this.getWidth(), WindowDriver.this.getHeight(), 85));
                        Log.d((String)"JogAmp.NEWT", (String)("canCreateNativeImpl: added to static ViewGroup - on thread " + Thread.currentThread().getName()));
                    }
                });
                for (long i = 1000L; 0L < i && 0L == this.surfaceHandle; i -= 10L) {
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                bl = 0L != this.surfaceHandle;
                Log.d((String)"JogAmp.NEWT", (String)("canCreateNativeImpl: surfaceHandle ready(2) " + bl + " - on thread " + Thread.currentThread().getName()));
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected final void createNativeImpl(boolean[] blArray) {
        AbstractGraphicsScreen abstractGraphicsScreen = this.getScreen().getGraphicsScreen();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsScreen.getDevice();
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice((long)eGLGraphicsDevice.getNativeDisplayID(), (String)eGLGraphicsDevice.getConnection(), (int)eGLGraphicsDevice.getUnitID());
        eGLGraphicsDevice2.open();
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)eGLGraphicsDevice2, abstractGraphicsScreen.getIndex());
        Log.d((String)"JogAmp.NEWT", (String)("createNativeImpl 0 - eglDevice 0x" + Integer.toHexString(eGLGraphicsDevice2.hashCode()) + ", " + eGLGraphicsDevice2 + ", surfaceHandle 0x" + Long.toHexString(this.surfaceHandle) + ", format [a " + this.androidFormat + ", n " + this.nativeFormat + "], win[" + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + "], pixel[" + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "] - on thread " + Thread.currentThread().getName()));
        if (0L != this.getParentWindowHandle()) {
            throw new NativeWindowException("Window parenting not supported (yet)");
        }
        if (0L == this.surfaceHandle) {
            throw new InternalError("surfaceHandle null");
        }
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)this.capsByFormat, (GLCapabilitiesImmutable)((GLCapabilitiesImmutable)this.getRequestedCapabilities()), (GLCapabilitiesChooser)((GLCapabilitiesChooser)this.capabilitiesChooser), (AbstractGraphicsScreen)defaultGraphicsScreen, (int)this.nativeFormat, (boolean)WindowDriver.isAndroidFormatTransparent(this.androidFormat));
        if (eGLGraphicsConfiguration == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + (Object)((Object)this));
        }
        int n = eGLGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        Log.d((String)"JogAmp.NEWT", (String)("nativeVisualID 0x" + Integer.toHexString(n)));
        Log.d((String)"JogAmp.NEWT", (String)("requestedCaps: " + eGLGraphicsConfiguration.getRequestedCapabilities()));
        Log.d((String)"JogAmp.NEWT", (String)("chosenCaps   : " + eGLGraphicsConfiguration.getChosenCapabilities()));
        if (0 != n) {
            WindowDriver.setSurfaceVisualID0(this.surfaceHandle, n);
        }
        this.eglSurface = EGLSurface.eglCreateWindowSurface((long)eGLGraphicsDevice2.getHandle(), (long)eGLGraphicsConfiguration.getNativeConfig(), (long)this.surfaceHandle);
        if (0L == this.eglSurface) {
            throw new NativeWindowException("Creation of eglSurface failed: " + eGLGraphicsConfiguration + ", surfaceHandle 0x" + Long.toHexString(this.surfaceHandle) + ", error " + WindowDriver.toHexString((int)EGL.eglGetError()));
        }
        this.setGraphicsConfiguration((AbstractGraphicsConfiguration)eGLGraphicsConfiguration);
        this.setWindowHandle(this.surfaceHandle);
        this.visibleChanged(true);
        this.focusChanged(false, true);
        this.setupInputListener(true);
        Log.d((String)"JogAmp.NEWT", (String)("createNativeImpl X: eglDevice 0x" + Integer.toHexString(eGLGraphicsDevice2.hashCode()) + ", " + eGLGraphicsDevice2 + ", eglSurfaceHandle 0x" + Long.toHexString(this.eglSurface)));
    }

    protected final void closeNativeImpl() {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)this.getGraphicsConfiguration().getScreen().getDevice();
        Log.d((String)"JogAmp.NEWT", (String)("closeNativeImpl 0 - eglDevice 0x" + Integer.toHexString(eGLGraphicsDevice.hashCode()) + ", " + eGLGraphicsDevice + ", surfaceHandle 0x" + Long.toHexString(this.surfaceHandle) + ", eglSurfaceHandle 0x" + Long.toHexString(this.eglSurface) + ", format [a " + this.androidFormat + ", n " + this.nativeFormat + "], win[" + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + "], pixel[" + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "], - on thread " + Thread.currentThread().getName()));
        if (Window.DEBUG_IMPLEMENTATION) {
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        this.setupInputListener(false);
        if (0L != this.eglSurface) {
            try {
                if (!EGL.eglDestroySurface((long)eGLGraphicsDevice.getHandle(), (long)this.eglSurface)) {
                    throw new GLException("Error destroying window surface (eglDestroySurface)");
                }
            }
            catch (Throwable throwable) {
                Log.d((String)"JogAmp.NEWT", (String)("closeNativeImpl: Catch exception " + throwable.getMessage()));
                throwable.printStackTrace();
            }
            finally {
                this.eglSurface = 0L;
            }
        }
        WindowDriver.release0(this.surfaceHandle);
        eGLGraphicsDevice.close();
        if (null != this.androidView && this.added2StaticViewGroup) {
            this.added2StaticViewGroup = false;
            final ViewGroup viewGroup = StaticContext.getContentViewGroup();
            if (null != viewGroup) {
                viewGroup.post(new Runnable(){

                    @Override
                    public void run() {
                        viewGroup.removeView((View)WindowDriver.this.androidView);
                        Log.d((String)"JogAmp.NEWT", (String)("closeNativeImpl: removed from static ViewGroup - on thread " + Thread.currentThread().getName()));
                    }
                });
            }
        }
        this.surface = null;
        this.surfaceHandle = 0L;
    }

    public final long getSurfaceHandle() {
        return this.eglSurface;
    }

    public final boolean focusChanged(boolean bl, boolean bl2) {
        return super.focusChanged(bl, bl2);
    }

    protected final void requestFocusImpl(boolean bl) {
        if (null != this.androidView) {
            Log.d((String)"JogAmp.NEWT", (String)("requestFocusImpl: reparented " + bl));
            this.androidView.post(new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.androidView.requestFocus();
                    WindowDriver.this.androidView.bringToFront();
                }
            });
        }
    }

    protected final int getSupportedReconfigMaskImpl() {
        return 18697;
    }

    protected final boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        boolean bl = true;
        if (0 != (0x200000 & n5)) {
            Log.d((String)"JogAmp.NEWT", (String)"reconfigureWindowImpl.setFullscreen post creation (setContentView()) n/a");
            return false;
        }
        if (this.getWidth() != n3 || this.getHeight() != n4) {
            if (0L != this.getWindowHandle()) {
                Log.d((String)"JogAmp.NEWT", (String)"reconfigureWindowImpl.setSize n/a");
                bl = false;
            } else {
                this.defineWindowSize(n3, n4);
            }
        }
        if (this.getX() != n || this.getY() != n2) {
            if (0L != this.getWindowHandle()) {
                Log.d((String)"JogAmp.NEWT", (String)"reconfigureWindowImpl.setPos n/a");
                bl = false;
            } else {
                this.defineWindowPosition(n, n2);
            }
        }
        if (0 != (Integer.MIN_VALUE & n5)) {
            this.visibleChanged(0 != (1 & n5));
        }
        return bl;
    }

    protected final Point getLocationOnScreenImpl(int n, int n2) {
        return new Point(n, n2);
    }

    protected final boolean setKeyboardVisibleImpl(boolean bl) {
        if (null != this.androidView) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getAndroidView().getContext().getSystemService("input_method");
            IBinder iBinder = this.getAndroidView().getWindowToken();
            boolean bl2 = bl ? inputMethodManager.showSoftInput((View)this.androidView, 0, (ResultReceiver)this.keyboardVisibleReceiver) : inputMethodManager.hideSoftInputFromWindow(iBinder, 0, (ResultReceiver)this.keyboardVisibleReceiver);
            return bl2;
        }
        return false;
    }

    public final void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.d((String)"JogAmp.NEWT", (String)("surfaceCreated: win[" + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + "], pixels[ " + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "] - on thread " + Thread.currentThread().getName()));
    }

    public final void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.d((String)"JogAmp.NEWT", (String)("surfaceChanged: f " + this.nativeFormat + " -> " + n + ", " + n2 + "x" + n3 + ", current surfaceHandle: 0x" + Long.toHexString(this.surfaceHandle) + " - on thread " + Thread.currentThread().getName()));
        if (Window.DEBUG_IMPLEMENTATION) {
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        if (0L != this.surfaceHandle && this.androidFormat != n) {
            Log.d((String)"JogAmp.NEWT", (String)"surfaceChanged (destroy old)");
            if (!this.windowDestroyNotify(true)) {
                this.destroy();
            }
            this.surfaceHandle = 0L;
            this.surface = null;
        }
        if (this.getScreen().isNativeValid()) {
            MonitorDevice monitorDevice = this.getMainMonitor();
            monitorDevice.queryCurrentMode();
        }
        if (0 > this.getX() || 0 > this.getY()) {
            this.positionChanged(false, true, 0, 0);
        }
        if (0L == this.surfaceHandle) {
            this.androidFormat = n;
            this.surface = surfaceHolder.getSurface();
            this.surfaceHandle = WindowDriver.getSurfaceHandle0(this.surface);
            WindowDriver.acquire0(this.surfaceHandle);
            int n4 = WindowDriver.getANativeWindowFormat(this.androidFormat);
            WindowDriver.setSurfaceVisualID0(this.surfaceHandle, n4);
            this.nativeFormat = WindowDriver.getSurfaceVisualID0(this.surfaceHandle);
            Log.d((String)"JogAmp.NEWT", (String)("surfaceChanged: androidFormat " + this.androidFormat + " -- (set-native " + n4 + ") --> nativeFormat " + this.nativeFormat));
            int[] nArray = new int[]{WindowDriver.getWidth0(this.surfaceHandle), WindowDriver.getHeight0(this.surfaceHandle)};
            int[] nArray2 = this.convertToWindowUnits(new int[]{nArray[0], nArray[1]});
            this.capsByFormat = (GLCapabilitiesImmutable)WindowDriver.fixCaps(true, this.nativeFormat, this.getRequestedCapabilities());
            this.sizeChanged(false, false, nArray2[0], nArray2[1], false);
            Log.d((String)"JogAmp.NEWT", (String)("surfaceRealized: isValid: " + this.surface.isValid() + ", new surfaceHandle 0x" + Long.toHexString(this.surfaceHandle) + ", format [a " + this.androidFormat + "/n " + this.nativeFormat + "], win[" + this.getX() + "/" + this.getY() + " " + nArray2[0] + "x" + nArray2[1] + "], pixel[" + nArray[0] + "x" + nArray[1] + "], visible: " + this.isVisible()));
            if (this.isVisible()) {
                this.setVisible(false, true);
            }
        }
        this.sizeChanged(false, false, n2, n3, false);
        this.windowRepaint(0, 0, n2, n3);
        Log.d((String)"JogAmp.NEWT", (String)"surfaceChanged: X");
    }

    public final void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.d((String)"JogAmp.NEWT", (String)("surfaceDestroyed - on thread " + Thread.currentThread().getName()));
        this.windowDestroyNotify(true);
        ExceptionUtils.dumpStack((PrintStream)System.err);
    }

    public final void surfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
        Log.d((String)"JogAmp.NEWT", (String)("surfaceRedrawNeeded  - on thread " + Thread.currentThread().getName()));
        this.windowRepaint(0, 0, this.getSurfaceWidth(), this.getSurfaceHeight());
    }

    protected boolean handleKeyCodeBack(KeyEvent.DispatcherState dispatcherState, KeyEvent keyEvent) {
        if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
            Log.d((String)"JogAmp.NEWT", (String)("handleKeyCodeBack.0 : " + keyEvent));
            dispatcherState.startTracking(keyEvent, (Object)this);
        } else if (keyEvent.getAction() == 1 && !keyEvent.isCanceled() && dispatcherState.isTracking(keyEvent)) {
            boolean bl = this.setKeyboardVisibleImpl(false);
            Log.d((String)"JogAmp.NEWT", (String)("handleKeyCodeBack.1 : wasVisible " + bl + ": " + keyEvent));
            this.keyboardVisibilityChanged(false);
            if (bl) {
                this.enqueueAKey2NKeyUpDown(keyEvent, (short)-1793);
                return true;
            }
            if (null != this.activity) {
                this.enqueueAKey2NKeyUpDown(keyEvent, (short)27);
                return true;
            }
            Log.d((String)"JogAmp.NEWT", (String)("handleKeyCodeBack.X1 : " + keyEvent));
            this.windowDestroyNotify(true);
        }
        return false;
    }

    private void enqueueAKey2NKeyUpDown(KeyEvent keyEvent, short s) {
        com.jogamp.newt.event.KeyEvent keyEvent2 = AndroidNewtEventFactory.createKeyEvent(keyEvent, s, (short)300, (Window)this);
        com.jogamp.newt.event.KeyEvent keyEvent3 = AndroidNewtEventFactory.createKeyEvent(keyEvent, s, (short)301, (Window)this);
        this.enqueueEvent(false, (NEWTEvent)keyEvent2);
        this.enqueueEvent(false, (NEWTEvent)keyEvent3);
    }

    protected void consumeKeyEvent(com.jogamp.newt.event.KeyEvent keyEvent) {
        super.consumeKeyEvent(keyEvent);
        if (301 == keyEvent.getEventType() && !keyEvent.isConsumed()) {
            if (27 == keyEvent.getKeyCode()) {
                Log.d((String)"JogAmp.NEWT", (String)("handleKeyCodeBack.X2 : " + keyEvent));
                this.activity.finish();
            } else if (2 == keyEvent.getKeyCode()) {
                Log.d((String)"JogAmp.NEWT", (String)("handleKeyCodeHome.X2 : " + keyEvent));
                this.triggerHome();
            }
        }
    }

    private void triggerHome() {
        Context context = StaticContext.getContext();
        if (null == context) {
            throw new NativeWindowException("No static [Application] Context has been set. Call StaticContext.setContext(Context) first.");
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        context.startActivity(intent);
    }

    protected static native boolean initIDs0();

    protected static native long getSurfaceHandle0(Surface var0);

    protected static native int getSurfaceVisualID0(long var0);

    protected static native void setSurfaceVisualID0(long var0, int var2);

    protected static native int getWidth0(long var0);

    protected static native int getHeight0(long var0);

    protected static native void acquire0(long var0);

    protected static native void release0(long var0);

    static {
        DisplayDriver.initSingleton();
    }

    class MSurfaceView
    extends SurfaceView {
        public MSurfaceView(Context context) {
            super(context);
            this.setBackground(null);
        }

        public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
            KeyEvent.DispatcherState dispatcherState;
            Log.d((String)"JogAmp.NEWT", (String)("onKeyPreIme : " + keyEvent));
            if (keyEvent.getKeyCode() == 4 && (dispatcherState = this.getKeyDispatcherState()) != null) {
                return WindowDriver.this.handleKeyCodeBack(dispatcherState, keyEvent);
            }
            return false;
        }
    }

    private class KeyboardVisibleReceiver
    extends ResultReceiver {
        public KeyboardVisibleReceiver() {
            super(null);
        }

        public void onReceiveResult(int n, Bundle bundle) {
            boolean bl = false;
            switch (n) {
                case 0: 
                case 2: {
                    bl = true;
                    break;
                }
                case 1: 
                case 3: {
                    bl = false;
                }
            }
            Log.d((String)"JogAmp.NEWT", (String)("keyboardVisible: " + bl));
            WindowDriver.this.keyboardVisibilityChanged(bl);
        }
    }
}

