/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLErrorHandler;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImage3d;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.CLSampler;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CLContext
extends CLObjectResource {
    protected CLDevice[] devices;
    protected final Set<CLProgram> programs;
    protected final Set<CLSampler> samplers;
    protected final Set<CLMemory<? extends Buffer>> memoryObjects;
    protected final Map<CLDevice, List<CLCommandQueue>> queuesMap;
    protected final CLPlatform platform;
    private final ErrorDispatcher errorHandler;

    protected CLContext(CLPlatform cLPlatform, long l, ErrorDispatcher errorDispatcher) {
        super(l);
        this.platform = cLPlatform;
        this.programs = Collections.synchronizedSet(new HashSet());
        this.samplers = Collections.synchronizedSet(new HashSet());
        this.memoryObjects = Collections.synchronizedSet(new HashSet());
        this.queuesMap = new HashMap<CLDevice, List<CLCommandQueue>>();
        this.errorHandler = errorDispatcher;
    }

    private synchronized void initDevices(CL cL) {
        if (this.devices == null) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
            int n = cL.clGetContextInfo(this.ID, 4225, 0L, null, pointerBuffer);
            CLException.checkForError(n, "can not enumerate devices");
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)((int)pointerBuffer.get()));
            n = cL.clGetContextInfo(this.ID, 4225, byteBuffer.capacity(), byteBuffer, null);
            CLException.checkForError(n, "can not enumerate devices");
            this.devices = new CLDevice[byteBuffer.capacity() / (Platform.is32Bit() ? 4 : 8)];
            for (int i = 0; i < this.devices.length; ++i) {
                this.devices[i] = new CLDevice(this, Platform.is32Bit() ? (long)byteBuffer.getInt() : byteBuffer.getLong());
            }
        }
    }

    public static CLContext create() {
        return CLContext.create((CLPlatform)null, CLDevice.Type.ALL);
    }

    public static CLContext create(CLDevice.Type ... typeArray) {
        return CLContext.create(null, typeArray);
    }

    public static CLContext create(CLPlatform cLPlatform) {
        return CLContext.create(cLPlatform, CLDevice.Type.ALL);
    }

    public static CLContext create(CLPlatform cLPlatform, CLDevice.Type ... typeArray) {
        if (cLPlatform == null) {
            cLPlatform = CLPlatform.getDefault();
        }
        long l = CLContext.toDeviceBitmap(typeArray);
        PointerBuffer pointerBuffer = CLContext.setupContextProperties(cLPlatform);
        ErrorDispatcher errorDispatcher = new ErrorDispatcher();
        return new CLContext(cLPlatform, CLContext.createContextFromType(cLPlatform, errorDispatcher, pointerBuffer, l), errorDispatcher);
    }

    public static CLContext create(CLDevice ... cLDeviceArray) {
        if (cLDeviceArray == null) {
            throw new IllegalArgumentException("no devices specified");
        }
        if (cLDeviceArray[0] == null) {
            throw new IllegalArgumentException("first device was null");
        }
        CLPlatform cLPlatform = cLDeviceArray[0].getPlatform();
        PointerBuffer pointerBuffer = CLContext.setupContextProperties(cLPlatform);
        ErrorDispatcher errorDispatcher = new ErrorDispatcher();
        CLContext cLContext = new CLContext(cLPlatform, CLContext.createContext(cLPlatform, errorDispatcher, pointerBuffer, cLDeviceArray), errorDispatcher);
        if (cLDeviceArray != null) {
            for (int i = 0; i < cLDeviceArray.length; ++i) {
                cLDeviceArray[i].setContext(cLContext);
            }
        }
        return cLContext;
    }

    protected static long createContextFromType(CLPlatform cLPlatform, CLErrorHandler cLErrorHandler, PointerBuffer pointerBuffer, long l) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        CL cL = cLPlatform.getCLBinding();
        long l2 = cL.clCreateContextFromType(pointerBuffer, l, cLErrorHandler, intBuffer);
        CLException.checkForError(intBuffer.get(), "can not create CL context");
        return l2;
    }

    protected static long createContext(CLPlatform cLPlatform, CLErrorHandler cLErrorHandler, PointerBuffer pointerBuffer, CLDevice ... cLDeviceArray) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        PointerBuffer pointerBuffer2 = null;
        if (cLDeviceArray != null && cLDeviceArray.length != 0) {
            pointerBuffer2 = PointerBuffer.allocateDirect((int)cLDeviceArray.length);
            for (int i = 0; i < cLDeviceArray.length; ++i) {
                CLDevice cLDevice = cLDeviceArray[i];
                if (cLDevice == null) {
                    throw new IllegalArgumentException("device at index " + i + " was null.");
                }
                pointerBuffer2.put(i, cLDevice.ID);
            }
        }
        CL cL = cLPlatform.getCLBinding();
        long l = cL.clCreateContext(pointerBuffer, pointerBuffer2, cLErrorHandler, intBuffer);
        CLException.checkForError(intBuffer.get(), "can not create CL context");
        return l;
    }

    private static PointerBuffer setupContextProperties(CLPlatform cLPlatform) {
        if (cLPlatform == null) {
            throw new RuntimeException("no OpenCL installation found");
        }
        return (PointerBuffer)PointerBuffer.allocateDirect((int)3).put(4228L).put(cLPlatform.ID).put(0L).rewind();
    }

    public CLProgram createProgram(String string) {
        CLProgram cLProgram = CLProgram.create(this, string);
        this.programs.add(cLProgram);
        return cLProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLProgram createProgram(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("input stream for program source must not be null");
        }
        StringBuilder stringBuilder = new StringBuilder(2048);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        return this.createProgram(stringBuilder.toString());
    }

    public CLProgram createProgram(Map<CLDevice, byte[]> map) {
        CLProgram cLProgram = CLProgram.create(this, map);
        cLProgram.setNoSource();
        this.programs.add(cLProgram);
        return cLProgram;
    }

    public final CLBuffer<ShortBuffer> createShortBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createBuffer(Buffers.newDirectShortBuffer((int)n), memArray);
    }

    public final CLBuffer<IntBuffer> createIntBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createBuffer(Buffers.newDirectIntBuffer((int)n), memArray);
    }

    public final CLBuffer<LongBuffer> createLongBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createBuffer(Buffers.newDirectLongBuffer((int)n), memArray);
    }

    public final CLBuffer<FloatBuffer> createFloatBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createBuffer(Buffers.newDirectFloatBuffer((int)n), memArray);
    }

    public final CLBuffer<DoubleBuffer> createDoubleBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createBuffer(Buffers.newDirectDoubleBuffer((int)n), memArray);
    }

    public final CLBuffer<ByteBuffer> createByteBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createByteBuffer(n, CLMemory.Mem.flagsToInt(memArray));
    }

    public final CLBuffer<ByteBuffer> createByteBuffer(int n, int n2) {
        return this.createBuffer(Buffers.newDirectByteBuffer((int)n), n2);
    }

    public final CLBuffer<?> createBuffer(int n, CLMemory.Mem ... memArray) {
        return this.createBuffer((Buffer)n, CLMemory.Mem.flagsToInt(memArray));
    }

    public final CLBuffer<?> createBuffer(int n, int n2) {
        CLBuffer<int> cLBuffer = CLBuffer.create(this, n, n2);
        this.memoryObjects.add(cLBuffer);
        return cLBuffer;
    }

    public final <B extends Buffer> CLBuffer<B> createBuffer(B b, CLMemory.Mem ... memArray) {
        return this.createBuffer(b, CLMemory.Mem.flagsToInt(memArray));
    }

    public final <B extends Buffer> CLBuffer<B> createBuffer(B b, int n) {
        CLBuffer<B> cLBuffer = CLBuffer.create(this, b, n);
        this.memoryObjects.add(cLBuffer);
        return cLBuffer;
    }

    public final CLImage2d<?> createImage2d(int n, int n2, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        return this.createImage2d(null, n, n2, 0, cLImageFormat, memArray);
    }

    public final CLImage2d<?> createImage2d(int n, int n2, int n3, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        return this.createImage2d(null, n, n2, n3, cLImageFormat, memArray);
    }

    public final <B extends Buffer> CLImage2d<B> createImage2d(B b, int n, int n2, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        return this.createImage2d(b, n, n2, 0, cLImageFormat, memArray);
    }

    public final <B extends Buffer> CLImage2d<B> createImage2d(B b, int n, int n2, int n3, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        CLImage2d<B> cLImage2d = CLImage2d.createImage(this, b, n, n2, n3, cLImageFormat, CLMemory.Mem.flagsToInt(memArray));
        this.memoryObjects.add(cLImage2d);
        return cLImage2d;
    }

    public final CLImage3d<?> createImage3d(int n, int n2, int n3, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        return this.createImage3d(null, n, n2, n3, cLImageFormat, memArray);
    }

    public final CLImage3d<?> createImage3d(int n, int n2, int n3, int n4, int n5, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        return this.createImage3d(null, n, n2, n3, n4, n5, cLImageFormat, memArray);
    }

    public final <B extends Buffer> CLImage3d<B> createImage3d(B b, int n, int n2, int n3, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        return this.createImage3d(b, n, n2, n3, 0, 0, cLImageFormat, memArray);
    }

    public final <B extends Buffer> CLImage3d<B> createImage3d(B b, int n, int n2, int n3, int n4, int n5, CLImageFormat cLImageFormat, CLMemory.Mem ... memArray) {
        CLImage3d<B> cLImage3d = CLImage3d.createImage(this, b, n, n2, n3, n4, n5, cLImageFormat, CLMemory.Mem.flagsToInt(memArray));
        this.memoryObjects.add(cLImage3d);
        return cLImage3d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CLCommandQueue createCommandQueue(CLDevice cLDevice, long l) {
        CLCommandQueue cLCommandQueue = CLCommandQueue.create(this, cLDevice, l);
        Map<CLDevice, List<CLCommandQueue>> map = this.queuesMap;
        synchronized (map) {
            List<CLCommandQueue> list = this.queuesMap.get(cLDevice);
            if (list == null) {
                list = new ArrayList<CLCommandQueue>();
                this.queuesMap.put(cLDevice, list);
            }
            list.add(cLCommandQueue);
        }
        return cLCommandQueue;
    }

    public CLSampler createSampler(CLSampler.AddressingMode addressingMode, CLSampler.FilteringMode filteringMode, boolean bl) {
        CLSampler cLSampler = CLSampler.create(this, addressingMode, filteringMode, bl);
        this.samplers.add(cLSampler);
        return cLSampler;
    }

    void onProgramReleased(CLProgram cLProgram) {
        this.programs.remove(cLProgram);
    }

    void onMemoryReleased(CLMemory<?> cLMemory) {
        this.memoryObjects.remove(cLMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCommandQueueReleased(CLDevice cLDevice, CLCommandQueue cLCommandQueue) {
        Map<CLDevice, List<CLCommandQueue>> map = this.queuesMap;
        synchronized (map) {
            List<CLCommandQueue> list = this.queuesMap.get(cLDevice);
            list.remove(cLCommandQueue);
            if (list.isEmpty()) {
                this.queuesMap.remove(cLDevice);
            }
        }
    }

    void onSamplerReleased(CLSampler cLSampler) {
        this.samplers.remove(cLSampler);
    }

    public void addCLErrorHandler(CLErrorHandler cLErrorHandler) {
        this.errorHandler.addHandler(cLErrorHandler);
    }

    public void removeCLErrorHandler(CLErrorHandler cLErrorHandler) {
        this.errorHandler.removeHandler(cLErrorHandler);
    }

    private void release(Collection<? extends CLResource> collection) {
        while (!collection.isEmpty()) {
            collection.iterator().next().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() {
        super.release();
        try {
            this.release(this.programs);
            this.release(this.memoryObjects);
            this.release(this.samplers);
            Map<CLDevice, List<CLCommandQueue>> map = this.queuesMap;
            synchronized (map) {
                Collection<List<CLCommandQueue>> collection = this.queuesMap.values();
                while (!collection.isEmpty()) {
                    this.release((Collection<? extends CLResource>)collection.iterator().next());
                }
            }
        }
        finally {
            int n = this.platform.getCLBinding().clReleaseContext(this.ID);
            CLException.checkForError(n, "error releasing context");
        }
    }

    protected void overrideContext(CLDevice cLDevice) {
        cLDevice.setContext(this);
    }

    private CLImageFormat[] getSupportedImageFormats(int n, int n2) {
        int[] nArray;
        CL cL = this.platform.getCLBinding();
        int n3 = cL.clGetSupportedImageFormats(this.ID, n, n2, 0, null, nArray = new int[1], 0);
        if (n3 != 0) {
            throw CLException.newException(n3, "error calling clGetSupportedImageFormats");
        }
        int n4 = nArray[0];
        if (n4 == 0) {
            return new CLImageFormat[0];
        }
        CLImageFormat[] cLImageFormatArray = new CLImageFormat[n4];
        CLImageFormatImpl cLImageFormatImpl = CLImageFormatImpl.create(Buffers.newDirectByteBuffer((int)(n4 * CLImageFormatImpl.size())));
        n3 = cL.clGetSupportedImageFormats(this.ID, n, n2, n4, cLImageFormatImpl, null);
        if (n3 != 0) {
            throw CLException.newException(n3, "error calling clGetSupportedImageFormats");
        }
        ByteBuffer byteBuffer = cLImageFormatImpl.getBuffer();
        for (int i = 0; i < cLImageFormatArray.length; ++i) {
            cLImageFormatArray[i] = new CLImageFormat(CLImageFormatImpl.create(byteBuffer.slice()));
            byteBuffer.position(i * CLImageFormatImpl.size());
        }
        return cLImageFormatArray;
    }

    public CLImageFormat[] getSupportedImage2dFormats(CLMemory.Mem ... memArray) {
        return this.getSupportedImageFormats(memArray == null ? 0 : CLMemory.Mem.flagsToInt(memArray), 4337);
    }

    public CLImageFormat[] getSupportedImage3dFormats(CLMemory.Mem ... memArray) {
        return this.getSupportedImageFormats(memArray == null ? 0 : CLMemory.Mem.flagsToInt(memArray), 4338);
    }

    @Override
    public CLPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public CLContext getContext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLProgram> getPrograms() {
        Set<CLProgram> set = this.programs;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<CLProgram>(this.programs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLMemory<? extends Buffer>> getMemoryObjects() {
        Set<CLMemory<? extends Buffer>> set = this.memoryObjects;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<CLMemory<? extends Buffer>>(this.memoryObjects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLSampler> getSamplers() {
        Set<CLSampler> set = this.samplers;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<CLSampler>(this.samplers));
        }
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.getDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type type) {
        return CLPlatform.findMaxFlopsDevice(this.getDevices(), type);
    }

    public long getMaxMemBaseAddrAlign() {
        long l = 0L;
        for (CLDevice cLDevice : this.getDevices()) {
            l = Math.max(l, cLDevice.getMemBaseAddrAlign());
        }
        return l;
    }

    public CLDevice[] getDevices() {
        this.initDevices(this.platform.getCLBinding());
        return this.devices;
    }

    public CL getCL() {
        return this.getPlatform().getCLBinding();
    }

    CLDevice getDevice(long l) {
        CLDevice[] cLDeviceArray = this.getDevices();
        for (int i = 0; i < cLDeviceArray.length; ++i) {
            if (l != cLDeviceArray[i].ID) continue;
            return cLDeviceArray[i];
        }
        return null;
    }

    protected static long toDeviceBitmap(CLDevice.Type[] typeArray) {
        long l = 0L;
        if (typeArray != null) {
            for (int i = 0; i < typeArray.length; ++i) {
                CLDevice.Type type = typeArray[i];
                if (type == null) {
                    throw new IllegalArgumentException("Device type at index " + i + " was null.");
                }
                l |= type.TYPE;
            }
        }
        return l;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + ", platform: " + this.getPlatform().getName() + ", profile: " + this.getPlatform().getProfile() + ", devices: " + this.getDevices().length + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLContext cLContext = (CLContext)object;
        return this.ID == cLContext.ID;
    }

    public int hashCode() {
        int n = 7;
        n = 23 * n + (int)(this.ID ^ this.ID >>> 32);
        return n;
    }

    protected static ErrorDispatcher createErrorHandler() {
        return new ErrorDispatcher();
    }

    protected static class ErrorDispatcher
    implements CLErrorHandler {
        private CLErrorHandler[] clientHandlers = new CLErrorHandler[0];

        protected ErrorDispatcher() {
        }

        @Override
        public synchronized void onError(String string, ByteBuffer byteBuffer, long l) {
            CLErrorHandler[] cLErrorHandlerArray = this.clientHandlers;
            for (int i = 0; i < cLErrorHandlerArray.length; ++i) {
                cLErrorHandlerArray[i].onError(string, byteBuffer, l);
            }
        }

        private synchronized void addHandler(CLErrorHandler cLErrorHandler) {
            if (cLErrorHandler == null) {
                throw new IllegalArgumentException("handler was null.");
            }
            CLErrorHandler[] cLErrorHandlerArray = new CLErrorHandler[this.clientHandlers.length + 1];
            System.arraycopy(this.clientHandlers, 0, cLErrorHandlerArray, 0, this.clientHandlers.length);
            cLErrorHandlerArray[cLErrorHandlerArray.length - 1] = cLErrorHandler;
            this.clientHandlers = cLErrorHandlerArray;
        }

        private synchronized void removeHandler(CLErrorHandler cLErrorHandler) {
            if (cLErrorHandler == null) {
                throw new IllegalArgumentException("handler was null.");
            }
            for (int i = 0; i < this.clientHandlers.length; ++i) {
                if (!cLErrorHandler.equals(this.clientHandlers[i])) continue;
                CLErrorHandler[] cLErrorHandlerArray = new CLErrorHandler[this.clientHandlers.length - 1];
                System.arraycopy(this.clientHandlers, 0, cLErrorHandlerArray, 0, i);
                System.arraycopy(this.clientHandlers, i, cLErrorHandlerArray, 0, cLErrorHandlerArray.length - i);
                this.clientHandlers = cLErrorHandlerArray;
                return;
            }
        }
    }
}

