/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLImage2d;
import com.jogamp.opencl.gl.CLGLTexture2d;
import com.jogamp.opencl.gl.CLGLTexture3d;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opengl.GLContext;
import java.nio.Buffer;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.x11.glx.X11GLXContext;

public final class CLGLContext
extends CLContext {
    final long glID;
    private final GLContext glContext;

    private CLGLContext(CLPlatform cLPlatform, GLContext gLContext, long l, long l2, CLContext.ErrorDispatcher errorDispatcher) {
        super(cLPlatform, l, errorDispatcher);
        this.glID = l2;
        this.glContext = gLContext;
    }

    public static CLGLContext create(GLContext gLContext) {
        return CLGLContext.create(gLContext, (CLPlatform)null, CLDevice.Type.ALL);
    }

    public static CLGLContext create(GLContext gLContext, CLPlatform cLPlatform) {
        return CLGLContext.create(gLContext, cLPlatform, CLDevice.Type.ALL);
    }

    public static CLGLContext create(GLContext gLContext, CLDevice.Type ... typeArray) {
        return CLGLContext.create(gLContext, null, typeArray);
    }

    public static CLGLContext create(GLContext gLContext, CLPlatform cLPlatform, CLDevice.Type ... typeArray) {
        if (cLPlatform == null) {
            cLPlatform = CLPlatform.getDefault();
        }
        long[] lArray = new long[1];
        PointerBuffer pointerBuffer = CLGLContext.setupContextProperties(cLPlatform, gLContext, lArray);
        CLContext.ErrorDispatcher errorDispatcher = CLGLContext.createErrorHandler();
        long l = CLGLContext.createContextFromType(cLPlatform, errorDispatcher, pointerBuffer, CLGLContext.toDeviceBitmap(typeArray));
        return new CLGLContext(cLPlatform, gLContext, l, lArray[0], errorDispatcher);
    }

    public static CLGLContext create(GLContext gLContext, CLDevice ... cLDeviceArray) {
        if (cLDeviceArray == null) {
            throw new IllegalArgumentException("no devices specified");
        }
        if (cLDeviceArray[0] == null) {
            throw new IllegalArgumentException("first device was null");
        }
        CLPlatform cLPlatform = cLDeviceArray[0].getPlatform();
        long[] lArray = new long[1];
        PointerBuffer pointerBuffer = CLGLContext.setupContextProperties(cLPlatform, gLContext, lArray);
        CLContext.ErrorDispatcher errorDispatcher = CLGLContext.createErrorHandler();
        long l = CLGLContext.createContext(cLPlatform, errorDispatcher, pointerBuffer, cLDeviceArray);
        CLGLContext cLGLContext = new CLGLContext(cLPlatform, gLContext, l, lArray[0], errorDispatcher);
        if (cLDeviceArray != null) {
            for (int i = 0; i < cLDeviceArray.length; ++i) {
                cLGLContext.overrideContext(cLDeviceArray[i]);
            }
        }
        return cLGLContext;
    }

    private static PointerBuffer setupContextProperties(CLPlatform cLPlatform, GLContext gLContext, long[] lArray) {
        PointerBuffer pointerBuffer;
        if (cLPlatform == null) {
            throw new RuntimeException("no OpenCL installation found");
        }
        if (gLContext == null) {
            throw new IllegalArgumentException("GLContext was null.");
        }
        if (!gLContext.isCurrent()) {
            throw new IllegalArgumentException("OpenGL context is not current,\n creating a OpenCL context for context sharing is not allowed in this situation.");
        }
        GLContextImpl gLContextImpl = (GLContextImpl)gLContext;
        lArray[0] = gLContext.getHandle();
        if (gLContext instanceof X11GLXContext) {
            pointerBuffer = PointerBuffer.allocateDirect((int)7);
            long l = gLContextImpl.getDrawableImpl().getNativeSurface().getDisplayHandle();
            pointerBuffer.put(8200L).put(lArray[0]).put(8202L).put(l).put(4228L).put(cLPlatform.ID);
        } else if (gLContext instanceof WindowsWGLContext) {
            pointerBuffer = PointerBuffer.allocateDirect((int)7);
            long l = gLContextImpl.getDrawableImpl().getNativeSurface().getSurfaceHandle();
            pointerBuffer.put(8200L).put(lArray[0]).put(8203L).put(l).put(4228L).put(cLPlatform.ID);
        } else if (gLContext instanceof MacOSXCGLContext) {
            long l = CGL.getCGLContext((long)lArray[0]);
            long l2 = CGL.CGLGetShareGroup((long)l);
            pointerBuffer = PointerBuffer.allocateDirect((int)5);
            pointerBuffer.put(0x10000000L).put(l2).put(4228L).put(cLPlatform.ID);
        } else if (gLContext instanceof EGLContext) {
            pointerBuffer = PointerBuffer.allocateDirect((int)7);
            long l = gLContextImpl.getDrawableImpl().getNativeSurface().getDisplayHandle();
            pointerBuffer.put(8200L).put(lArray[0]).put(8201L).put(l).put(4228L).put(cLPlatform.ID);
        } else {
            throw new RuntimeException("unsupported GLContext: " + gLContext);
        }
        return (PointerBuffer)pointerBuffer.put(0L).rewind();
    }

    public final CLGLBuffer<?> createFromGLBuffer(int n, long l, CLMemory.Mem ... memArray) {
        return this.createFromGLBuffer(null, n, l, CLMemory.Mem.flagsToInt(memArray));
    }

    public final CLGLBuffer<?> createFromGLBuffer(int n, long l, int n2) {
        return this.createFromGLBuffer(null, n, l, n2);
    }

    public final <B extends Buffer> CLGLBuffer<B> createFromGLBuffer(B b, int n, long l, CLMemory.Mem ... memArray) {
        return this.createFromGLBuffer(b, n, l, CLMemory.Mem.flagsToInt(memArray));
    }

    public final <B extends Buffer> CLGLBuffer<B> createFromGLBuffer(B b, int n, long l, int n2) {
        CLGLBuffer<B> cLGLBuffer = CLGLBuffer.create(this, b, l, n2, n);
        this.memoryObjects.add(cLGLBuffer);
        return cLGLBuffer;
    }

    public final CLGLImage2d<?> createFromGLRenderbuffer(int n, CLMemory.Mem ... memArray) {
        return this.createFromGLRenderbuffer(null, n, CLMemory.Mem.flagsToInt(memArray));
    }

    public final CLGLImage2d<?> createFromGLRenderbuffer(int n, int n2) {
        return this.createFromGLRenderbuffer(null, n, n2);
    }

    public final <B extends Buffer> CLGLImage2d<B> createFromGLRenderbuffer(B b, int n, CLMemory.Mem ... memArray) {
        return this.createFromGLRenderbuffer(b, n, CLMemory.Mem.flagsToInt(memArray));
    }

    public final <B extends Buffer> CLGLImage2d<B> createFromGLRenderbuffer(B b, int n, int n2) {
        CLGLImage2d<B> cLGLImage2d = CLGLImage2d.createFromGLRenderbuffer(this, b, n2, n);
        this.memoryObjects.add(cLGLImage2d);
        return cLGLImage2d;
    }

    public final CLGLTexture2d<?> createFromGLTexture2d(int n, int n2, int n3, CLMemory.Mem ... memArray) {
        return this.createFromGLTexture2d(null, n, n2, n3, CLMemory.Mem.flagsToInt(memArray));
    }

    public final CLGLTexture2d<?> createFromGLTexture2d(int n, int n2, int n3, int n4) {
        return this.createFromGLTexture2d(null, n, n2, n3, n4);
    }

    public final <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(B b, int n, int n2, int n3, CLMemory.Mem ... memArray) {
        return this.createFromGLTexture2d(b, n, n2, n3, CLMemory.Mem.flagsToInt(memArray));
    }

    public final <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(B b, int n, int n2, int n3, int n4) {
        CLGLTexture2d<B> cLGLTexture2d = CLGLTexture2d.createFromGLTexture2d(this, b, n, n2, n3, n4);
        this.memoryObjects.add(cLGLTexture2d);
        return cLGLTexture2d;
    }

    public final CLGLTexture3d<?> createFromGLTexture3d(int n, int n2, int n3, CLMemory.Mem ... memArray) {
        return this.createFromGLTexture3d(null, n, n2, n3, CLMemory.Mem.flagsToInt(memArray));
    }

    public final CLGLTexture3d<?> createFromGLTexture3d(int n, int n2, int n3, int n4) {
        return this.createFromGLTexture3d(null, n, n2, n3, n4);
    }

    public final <B extends Buffer> CLGLTexture3d<B> createFromGLTexture3d(B b, int n, int n2, int n3, CLMemory.Mem ... memArray) {
        return this.createFromGLTexture3d(b, n, n2, n3, CLMemory.Mem.flagsToInt(memArray));
    }

    public final <B extends Buffer> CLGLTexture3d<B> createFromGLTexture3d(B b, int n, int n2, int n3, int n4) {
        CLGLTexture3d<B> cLGLTexture3d = CLGLTexture3d.createFromGLTexture3d(this, b, n4, n, n3, n2);
        this.memoryObjects.add(cLGLTexture3d);
        return cLGLTexture3d;
    }

    @Override
    public CL getCL() {
        return super.getCL();
    }

    public GLContext getGLContext() {
        return this.glContext;
    }

    @Override
    public CLGLContext getContext() {
        return this;
    }
}

